/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.EmptyStatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogFileWriter;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.StatisticsFileEventLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0015\u001a\u00020\u000bH\u0002J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\b\u0010\u0019\u001a\u00020\u001aH&J\b\u0010\u001b\u001a\u00020\u001aH&R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/internal/statistic/eventLog/StatisticsEventLoggerProvider;", "", "recorderId", "", "version", "", "sendFrequencyMs", "", "maxFileSize", "(Ljava/lang/String;IJLjava/lang/String;)V", "logger", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getLogger", "()Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getMaxFileSize", "()Ljava/lang/String;", "getRecorderId", "getSendFrequencyMs", "()J", "getVersion", "()I", "createLogger", "getLogFiles", "", "Ljava/io/File;", "isRecordEnabled", "", "isSendEnabled", "intellij.platform.ide.impl"})
public abstract class StatisticsEventLoggerProvider {
    @NotNull
    private final StatisticsEventLogger logger;
    @NotNull
    private final String recorderId;
    private final int version;
    private final long sendFrequencyMs;
    @NotNull
    private final String maxFileSize;

    @NotNull
    public StatisticsEventLogger getLogger() {
        return this.logger;
    }

    public abstract boolean isRecordEnabled();

    public abstract boolean isSendEnabled();

    @NotNull
    public final List<File> getLogFiles() {
        return this.getLogger().getLogFiles();
    }

    private final StatisticsEventLogger createLogger() {
        if (!this.isRecordEnabled()) {
            return new EmptyStatisticsEventLogger();
        }
        EventLogConfiguration config2 = EventLogConfiguration.INSTANCE;
        StatisticsEventLogFileWriter writer = new StatisticsEventLogFileWriter(this.recorderId, this.maxFileSize);
        StatisticsFileEventLogger logger = new StatisticsFileEventLogger(this.recorderId, config2.getSessionId(), config2.getBuild(), String.valueOf(config2.getBucket()), String.valueOf(this.version), writer);
        Disposer.register((Disposable)((Disposable)ApplicationManager.getApplication()), (Disposable)logger);
        return logger;
    }

    @NotNull
    public final String getRecorderId() {
        return this.recorderId;
    }

    public final int getVersion() {
        return this.version;
    }

    public final long getSendFrequencyMs() {
        return this.sendFrequencyMs;
    }

    @NotNull
    public final String getMaxFileSize() {
        return this.maxFileSize;
    }

    public StatisticsEventLoggerProvider(@NotNull String recorderId, int version2, long sendFrequencyMs, @NotNull String maxFileSize) {
        Intrinsics.checkParameterIsNotNull((Object)recorderId, (String)"recorderId");
        Intrinsics.checkParameterIsNotNull((Object)maxFileSize, (String)"maxFileSize");
        this.recorderId = recorderId;
        this.version = version2;
        this.sendFrequencyMs = sendFrequencyMs;
        this.maxFileSize = maxFileSize;
        this.logger = this.createLogger();
    }

    public /* synthetic */ StatisticsEventLoggerProvider(String string, int n, long l, String string2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l = TimeUnit.HOURS.toMillis(1L);
        }
        if ((n2 & 8) != 0) {
            string2 = "200KB";
        }
        this(string, n, l, string2);
    }
}

