/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class CloseEditorAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseEditorAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FileEditorManagerEx editorManager = CloseEditorAction.getEditorManager(project);
        EditorWindow window = (EditorWindow)e.getData(EditorWindow.DATA_KEY);
        VirtualFile file2 = null;
        if (window == null) {
            window = editorManager.getCurrentWindow();
            if (window != null) {
                file2 = window.getSelectedFile();
            }
        } else {
            file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        }
        if (file2 != null) {
            editorManager.closeFile(file2, window);
        }
    }

    private static FileEditorManagerEx getEditorManager(Project project) {
        return (FileEditorManagerEx)FileEditorManager.getInstance((Project)project);
    }

    public void update(@NotNull AnActionEvent event) {
        EditorWindow window;
        if (event == null) {
            CloseEditorAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        if ("EditorPopup".equals(event.getPlace()) || "EditorTabPopup".equals(event.getPlace())) {
            presentation.setText(IdeBundle.message((String)"action.close", (Object[])new Object[0]));
        }
        if ((window = (EditorWindow)event.getData(EditorWindow.DATA_KEY)) == null) {
            window = CloseEditorAction.getEditorManager(project).getCurrentWindow();
        }
        presentation.setEnabled(window != null && window.getTabCount() > 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CloseEditorAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

