/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.SmartList;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StopAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    private WeakReference<JBPopup> myActivePopupRef = null;

    private static boolean isPlaceGlobal(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(0);
        }
        return ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()) || "TouchBarGeneral".equals(e.getPlace());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(1);
        }
        boolean enable = false;
        Icon icon = this.getTemplatePresentation().getIcon();
        String description = this.getTemplatePresentation().getDescription();
        Presentation presentation = e.getPresentation();
        if (StopAction.isPlaceGlobal(e)) {
            List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(e.getDataContext());
            int stopCount = stoppableDescriptors.size();
            boolean bl = enable = stopCount >= 1;
            if (stopCount > 1) {
                presentation.setText(this.getTemplatePresentation().getText() + "...");
                icon = IconUtil.addText((Icon)icon, (String)String.valueOf(stopCount));
            } else if (stopCount == 1) {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)StringUtil.notNullize((String)stoppableDescriptors.get(0).getDisplayName()))}));
            }
        } else {
            RunProfile runProfile;
            ProcessHandler processHandler2;
            RunContentDescriptor contentDescriptor = (RunContentDescriptor)e.getData(LangDataKeys.RUN_CONTENT_DESCRIPTOR);
            ProcessHandler processHandler3 = processHandler2 = contentDescriptor == null ? null : contentDescriptor.getProcessHandler();
            if (processHandler2 != null && !processHandler2.isProcessTerminated()) {
                if (!processHandler2.isProcessTerminating()) {
                    enable = true;
                } else if (processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess()) {
                    enable = true;
                    icon = AllIcons.Debugger.KillProcess;
                    description = "Kill process";
                }
            }
            if ((runProfile = (RunProfile)e.getData(LangDataKeys.RUN_PROFILE)) == null && contentDescriptor == null) {
                presentation.setText(this.getTemplatePresentation().getText());
            } else {
                presentation.setText(ExecutionBundle.message((String)"stop.configuration.action.name", (Object[])new Object[]{StringUtil.escapeMnemonics((String)(runProfile == null ? StringUtil.notNullize((String)contentDescriptor.getDisplayName()) : runProfile.getName()))}));
            }
        }
        presentation.setEnabled(enable);
        presentation.setIcon(icon);
        presentation.setDescription(description);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            StopAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        Project project = e.getProject();
        List<RunContentDescriptor> stoppableDescriptors = StopAction.getActiveStoppableDescriptors(dataContext);
        int stopCount = stoppableDescriptors.size();
        if (StopAction.isPlaceGlobal(e)) {
            Component component;
            if (stopCount == 1) {
                ExecutionManagerImpl.stopProcess(stoppableDescriptors.get(0));
                return;
            }
            if (e.getPlace().equals("TouchBarGeneral") && !stoppableDescriptors.isEmpty()) {
                StopAction._showStopRunningBar(stoppableDescriptors);
                return;
            }
            final Pair<List<HandlerItem>, HandlerItem> handlerItems = StopAction.getItemsList(stoppableDescriptors, StopAction.getRecentlyStartedContentDescriptor(dataContext));
            if (handlerItems == null || ((List)handlerItems.first).isEmpty()) {
                return;
            }
            HandlerItem stopAllItem = new HandlerItem(ExecutionBundle.message((String)"stop.all", (Object[])new Object[]{KeymapUtil.getFirstKeyboardShortcutText((String)"Stop")}), AllIcons.Actions.Suspend, true){

                @Override
                void stop() {
                    for (HandlerItem item : (List)handlerItems.first) {
                        if (item == this) continue;
                        item.stop();
                    }
                }
            };
            JBPopup activePopup = (JBPopup)SoftReference.dereference(this.myActivePopupRef);
            if (activePopup != null) {
                stopAllItem.stop();
                activePopup.cancel();
                return;
            }
            List items = (List)handlerItems.first;
            if (stopCount > 1) {
                items.add(stopAllItem);
            }
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer(new GroupedItemsListRenderer(new ListItemDescriptorAdapter<HandlerItem>(){

                @Nullable
                public String getTextFor(HandlerItem item) {
                    return item.displayName;
                }

                @Nullable
                public Icon getIconFor(HandlerItem item) {
                    return item.icon;
                }

                public boolean hasSeparatorAboveOf(HandlerItem item) {
                    return item.hasSeparator;
                }
            })).setMovable(true).setTitle(items.size() == 1 ? "Confirm process stop" : "Stop process").setNamerForFiltering(o -> o.displayName).setItemsChosenCallback(valuesList -> {
                for (HandlerItem item : valuesList) {
                    item.stop();
                }
            }).addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    StopAction.this.myActivePopupRef = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/actions/StopAction$2", "onClosed"));
                }
            }).setRequestFocus(true);
            if (handlerItems.second != null) {
                builder2.setSelectedValue(handlerItems.second, true);
            }
            JBPopup popup2 = builder2.createPopup();
            this.myActivePopupRef = new WeakReference<JBPopup>(popup2);
            InputEvent inputEvent = e.getInputEvent();
            Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
            if (component != null && ("MainToolbar".equals(e.getPlace()) || "NavBarToolbar".equals(e.getPlace()))) {
                popup2.showUnderneathOf(component);
            } else if (project == null) {
                popup2.showInBestPositionFor(dataContext);
            } else {
                popup2.showCenteredInCurrentWindow(project);
            }
        } else {
            ExecutionManagerImpl.stopProcess(StopAction.getRecentlyStartedContentDescriptor(dataContext));
        }
    }

    @Nullable
    private static Pair<List<HandlerItem>, HandlerItem> getItemsList(List<? extends RunContentDescriptor> descriptors, RunContentDescriptor toSelect2) {
        if (descriptors.isEmpty()) {
            return null;
        }
        ArrayList<4> items = new ArrayList<4>(descriptors.size());
        HandlerItem selected2 = null;
        for (final RunContentDescriptor runContentDescriptor : descriptors) {
            ProcessHandler handler2 = runContentDescriptor.getProcessHandler();
            if (handler2 == null) continue;
            HandlerItem item = new HandlerItem(runContentDescriptor.getDisplayName(), runContentDescriptor.getIcon(), false){

                @Override
                void stop() {
                    ExecutionManagerImpl.stopProcess(runContentDescriptor);
                }
            };
            items.add(item);
            if (runContentDescriptor != toSelect2) continue;
            selected2 = item;
        }
        return Pair.create(items, selected2);
    }

    @Nullable
    static RunContentDescriptor getRecentlyStartedContentDescriptor(@NotNull DataContext dataContext) {
        RunContentDescriptor contentDescriptor;
        if (dataContext == null) {
            StopAction.$$$reportNull$$$0(3);
        }
        if ((contentDescriptor = (RunContentDescriptor)LangDataKeys.RUN_CONTENT_DESCRIPTOR.getData(dataContext)) != null) {
            return contentDescriptor;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        return project == null ? null : ExecutionManager.getInstance((Project)project).getContentManager().getSelectedContent();
    }

    @NotNull
    private static List<RunContentDescriptor> getActiveStoppableDescriptors(DataContext dataContext) {
        List<Object> runningProcesses;
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        List<Object> list2 = runningProcesses = project == null ? Collections.emptyList() : ExecutionManagerImpl.getAllDescriptors(project);
        if (runningProcesses.isEmpty()) {
            List<RunContentDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                StopAction.$$$reportNull$$$0(4);
            }
            return list3;
        }
        SmartList activeDescriptors = new SmartList();
        for (RunContentDescriptor runContentDescriptor : runningProcesses) {
            if (!StopAction.canBeStopped(runContentDescriptor)) continue;
            activeDescriptors.add(runContentDescriptor);
        }
        SmartList smartList = activeDescriptors;
        if (smartList == null) {
            StopAction.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static boolean canBeStopped(@Nullable RunContentDescriptor descriptor2) {
        ProcessHandler processHandler2 = descriptor2 != null ? descriptor2.getProcessHandler() : null;
        return processHandler2 != null && !processHandler2.isProcessTerminated() && (!processHandler2.isProcessTerminating() || processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess());
    }

    private static void _showStopRunningBar(@NotNull List<? extends RunContentDescriptor> stoppableDescriptors) {
        if (stoppableDescriptors == null) {
            StopAction.$$$reportNull$$$0(6);
        }
        if (!TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        ArrayList<Pair> descriptors = new ArrayList<Pair>(stoppableDescriptors.size());
        for (RunContentDescriptor runContentDescriptor : stoppableDescriptors) {
            descriptors.add(Pair.create((Object)runContentDescriptor, () -> ApplicationManager.getApplication().invokeLater(() -> ExecutionManagerImpl.stopProcess(sd))));
        }
        TouchBarsManager.showStopRunningBar(descriptors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/StopAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stoppableDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/StopAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveStoppableDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceGlobal";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRecentlyStartedContentDescriptor";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "_showStopRunningBar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static abstract class HandlerItem {
        final String displayName;
        final Icon icon;
        final boolean hasSeparator;

        HandlerItem(String displayName, Icon icon, boolean hasSeparator) {
            this.displayName = displayName;
            this.icon = icon;
            this.hasSeparator = hasSeparator;
        }

        public String toString() {
            return this.displayName;
        }

        abstract void stop();
    }
}

