/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonTooltipRenderer;
import com.intellij.codeInsight.daemon.impl.DaemonTooltipWithActionRenderer;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficTooltipRendererImpl;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.TooltipAction;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    private final Project myProject;

    DaemonTooltipRendererProvider(Project project) {
        this.myProject = project;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<? extends RangeHighlighter> highlighters) {
        if (highlighters == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(0);
        }
        LineTooltipRenderer bigRenderer = null;
        SmartList infos = new SmartList();
        THashSet tooltips = new THashSet();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            Object tooltipObject = rangeHighlighter.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info = (HighlightInfo)tooltipObject;
                if (info.getToolTip() == null || !tooltips.add(info.getToolTip())) continue;
                infos.add(info);
                continue;
            }
            String text2 = tooltipObject.toString();
            if (!tooltips.add(text2)) continue;
            if (bigRenderer == null) {
                bigRenderer = new DaemonTooltipRenderer(text2, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text2);
        }
        if (!infos.isEmpty()) {
            ContainerUtil.quickSort((List)infos, (o1, o2) -> {
                int i = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i != 0) {
                    return i;
                }
                return o1.getToolTip().compareTo(o2.getToolTip());
            });
            HighlightInfoComposite composite = HighlightInfoComposite.create((List<? extends HighlightInfo>)infos);
            String string = composite.getToolTip();
            DaemonTooltipRenderer myRenderer = new DaemonTooltipRenderer(string, new Object[]{highlighters});
            if (bigRenderer != null) {
                myRenderer.addBelow(bigRenderer.getText());
            }
            bigRenderer = myRenderer;
        }
        return bigRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(1);
        }
        DaemonTooltipRenderer daemonTooltipRenderer = new DaemonTooltipRenderer(text2, new Object[]{text2});
        if (daemonTooltipRenderer == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(2);
        }
        return daemonTooltipRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, int width) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(3);
        }
        DaemonTooltipRenderer daemonTooltipRenderer = new DaemonTooltipRenderer(text2, width, new Object[]{text2});
        if (daemonTooltipRenderer == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(4);
        }
        return daemonTooltipRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text2, @Nullable TooltipAction action2, int width) {
        if (text2 == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(5);
        }
        if (action2 != null || Registry.is((String)"ide.tooltip.show.with.actions")) {
            Object[] objectArray;
            if (action2 == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = text2;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = text2;
                objectArray = objectArray3;
                objectArray3[1] = action2;
            }
            DaemonTooltipWithActionRenderer daemonTooltipWithActionRenderer = new DaemonTooltipWithActionRenderer(text2, action2, width, objectArray);
            if (daemonTooltipWithActionRenderer == null) {
                DaemonTooltipRendererProvider.$$$reportNull$$$0(6);
            }
            return daemonTooltipWithActionRenderer;
        }
        TooltipRenderer tooltipRenderer = ErrorStripTooltipRendererProvider.super.calcTooltipRenderer(text2, action2, width);
        if (tooltipRenderer == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(7);
        }
        return tooltipRenderer;
    }

    @Override
    @NotNull
    public TrafficTooltipRenderer createTrafficTooltipRenderer(@NotNull Runnable onHide, @NotNull Editor editor) {
        if (onHide == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(9);
        }
        TrafficTooltipRendererImpl trafficTooltipRendererImpl = new TrafficTooltipRendererImpl(onHide, editor);
        if (trafficTooltipRendererImpl == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(10);
        }
        return trafficTooltipRendererImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onHide";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTooltipRenderer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrafficTooltipRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcTooltipRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTrafficTooltipRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

