/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ignore;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.Ignored;
import com.intellij.openapi.vcs.IgnoredCheckResult;
import com.intellij.openapi.vcs.NotIgnored;
import com.intellij.openapi.vcs.VcsIgnoreChecker;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitVcs;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitExecutableManager;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J.\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lgit4idea/ignore/GitIgnoreChecker;", "Lcom/intellij/openapi/vcs/VcsIgnoreChecker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSupportedVcs", "Lcom/intellij/openapi/vcs/VcsKey;", "isFilePatternIgnored", "Lcom/intellij/openapi/vcs/IgnoredCheckResult;", "vcsRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePattern", "", "isIgnored", "file", "Ljava/io/File;", "checkForIgnore", "isPattern", "", "parseOutput", "checkForIgnorePath", "output", "", "intellij.vcs.git"})
public final class GitIgnoreChecker
implements VcsIgnoreChecker {
    @NotNull
    private final Project project;

    @NotNull
    public VcsKey getSupportedVcs() {
        VcsKey vcsKey = GitVcs.getKey();
        Intrinsics.checkExpressionValueIsNotNull((Object)vcsKey, (String)"GitVcs.getKey()");
        return vcsKey;
    }

    @NotNull
    public IgnoredCheckResult isIgnored(@NotNull VirtualFile vcsRoot, @NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = FileUtil.toSystemIndependentName((String)file.getAbsolutePath());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toSystemIndepen\u2026ntName(file.absolutePath)");
        return this.isIgnored(vcsRoot, string, false);
    }

    @NotNull
    public IgnoredCheckResult isFilePatternIgnored(@NotNull VirtualFile vcsRoot, @NotNull String filePattern) {
        Intrinsics.checkParameterIsNotNull((Object)vcsRoot, (String)"vcsRoot");
        Intrinsics.checkParameterIsNotNull((Object)filePattern, (String)"filePattern");
        return this.isIgnored(vcsRoot, filePattern, true);
    }

    private final IgnoredCheckResult isIgnored(VirtualFile vcsRoot, String checkForIgnore, boolean isPattern) {
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)vcsRoot);
        GitExecutableManager gitExecutableManager = GitExecutableManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)gitExecutableManager, (String)"GitExecutableManager.getInstance()");
        GitLineHandler handler = new GitLineHandler(null, file, gitExecutableManager.getPathToGit(), GitCommand.CHECK_IGNORE, CollectionsKt.emptyList());
        handler.addParameters("--verbose");
        handler.endOptions();
        handler.addParameters(checkForIgnore);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkExpressionValueIsNotNull((Object)gitCommandResult, (String)"Git.getInstance().runCommand(handler)");
        GitCommandResult commandResult = gitCommandResult;
        List<String> list = commandResult.getOutput();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"commandResult.output");
        return this.parseOutput(vcsRoot, checkForIgnore, list, isPattern);
    }

    /*
     * WARNING - void declaration
     */
    private final IgnoredCheckResult parseOutput(VirtualFile vcsRoot, String checkForIgnorePath, List<String> output, boolean isPattern) {
        if (output.isEmpty()) {
            return (IgnoredCheckResult)NotIgnored.INSTANCE;
        }
        for (String line : output) {
            VirtualFile gitIgnoreFile;
            String[] stringArray;
            void thisCollection$iv;
            void $this$toTypedArray$iv;
            List lineElements = StringsKt.split$default((CharSequence)line, (String[])new String[]{"\t"}, (boolean)false, (int)0, (int)6, null);
            if (lineElements.size() != 2) continue;
            String path = (String)lineElements.get(1);
            List prefixParts = StringsKt.split$default((CharSequence)((CharSequence)lineElements.get(0)), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (prefixParts.size() != 3) continue;
            String gitIgnoreRelPath = (String)prefixParts.get(0);
            String matchedPattern = (String)prefixParts.get(2);
            if (StringsKt.startsWith$default((String)matchedPattern, (String)"!", (boolean)false, (int)2, null)) continue;
            Collection collection = StringsKt.split$default((CharSequence)gitIgnoreRelPath, (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null);
            VirtualFile virtualFile = vcsRoot;
            boolean $i$f$toTypedArray = false;
            if ($this$toTypedArray$iv == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            if (VfsUtil.findRelativeFile((VirtualFile)virtualFile, (String[])Arrays.copyOf(stringArray, stringArray.length)) == null) {
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)gitIgnoreFile, (String)"VfsUtil.findRelativeFile\u2026TypedArray()) ?: continue");
            if (isPattern && StringsKt.equals((String)path, (String)checkForIgnorePath, (!SystemInfo.isFileSystemCaseSensitive ? 1 : 0) != 0)) {
                File file = VfsUtil.virtualToIoFile((VirtualFile)gitIgnoreFile);
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"virtualToIoFile(gitIgnoreFile)");
                return (IgnoredCheckResult)new Ignored(file, matchedPattern);
            }
            if (isPattern) continue;
            File file = VfsUtil.virtualToIoFile((VirtualFile)gitIgnoreFile);
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"virtualToIoFile(gitIgnoreFile)");
            return (IgnoredCheckResult)new Ignored(file, matchedPattern);
        }
        return (IgnoredCheckResult)NotIgnored.INSTANCE;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public GitIgnoreChecker(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
    }
}

