/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.BranchConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.IndexDiff;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ObjectStream;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.AuthenticationException;
import org.jetbrains.settingsRepository.IcsCredentialsStore;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.NoRemoteRepositoryException;
import org.jetbrains.settingsRepository.git.InputStreamWrapper;
import org.jetbrains.settingsRepository.git.JGitCredentialsProvider;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u00ae\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a2\u0010\b\u001a\u00020\u00022\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\f\u001a\u00020\u000b\u001a2\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00072\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u0014\u001a\u000e\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0007\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u00012\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002\u001a\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u001a:\u0010!\u001a\u00020\"*\u00020\u00022\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010&\u001a\n\u0010(\u001a\u00020)*\u00020\u0002\u001a\n\u0010*\u001a\u00020\u0002*\u00020\u0002\u001a,\u0010+\u001a\u0004\u0018\u00010\u0019*\u00020\u00022\u0006\u0010,\u001a\u00020-2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a\n\u0010/\u001a\u000200*\u00020\u0002\u001a\n\u00101\u001a\u00020\u0001*\u000202\u001aq\u00103\u001a\u00020\u001e*\u00020\u00022\u0006\u00104\u001a\u00020\u00012%\b\u0002\u00105\u001a\u001f\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020\u000b\u0018\u00010626\u00109\u001a2\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(8\u0012\u0013\u0012\u00110;\u00a2\u0006\f\b7\u0012\b\b8\u0012\u0004\b\b(<\u0012\u0004\u0012\u00020\u000b0:\u001a\u0014\u0010=\u001a\u0004\u0018\u00010;*\u00020\u00022\u0006\u00104\u001a\u00020\u0001\u001a\n\u0010>\u001a\u00020?*\u00020\u0002\u001a\u001c\u0010@\u001a\u00020A*\u00020\u00022\b\u0010B\u001a\u0004\u0018\u00010\u00012\u0006\u0010C\u001a\u00020\u0001\u001a6\u0010D\u001a\u0002HE\"\b\b\u0000\u0010F*\u00020G\"\u0004\b\u0001\u0010E*\u0002HF2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u0002HF\u0012\u0004\u0012\u0002HE06H\u0086\b\u00a2\u0006\u0002\u0010I\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006J"}, d2={"upstream", "", "Lorg/eclipse/jgit/lib/Repository;", "getUpstream", "(Lorg/eclipse/jgit/lib/Repository;)Ljava/lang/String;", "buildBareRepository", "gitDir", "Ljava/nio/file/Path;", "buildRepository", "workTree", "bare", "", "mustExists", "cloneBare", "uri", "dir", "credentialsStore", "Lkotlin/Lazy;", "Lorg/jetbrains/settingsRepository/IcsCredentialsStore;", "progressMonitor", "Lorg/eclipse/jgit/lib/ProgressMonitor;", "createBareRepository", "findBranchToCheckout", "Lorg/eclipse/jgit/lib/Ref;", "result", "Lorg/eclipse/jgit/transport/FetchResult;", "getDefaultBranch", "credentialsProvider", "Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "wrapIfNeedAndReThrow", "", "e", "Lorg/eclipse/jgit/errors/TransportException;", "commit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "message", "reflogComment", "author", "Lorg/eclipse/jgit/lib/PersonIdent;", "committer", "computeIndexDiff", "Lorg/eclipse/jgit/lib/IndexDiff;", "disableAutoCrLf", "fetch", "remoteConfig", "Lorg/eclipse/jgit/transport/RemoteConfig;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "getAheadCommitsCount", "", "getRemoteBranchFullName", "Lorg/eclipse/jgit/lib/Config;", "processChildren", "path", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "processor", "Lkotlin/Function2;", "Ljava/io/InputStream;", "inputStream", "read", "resetHard", "Lorg/eclipse/jgit/dircache/DirCacheCheckout;", "setUpstream", "Lorg/eclipse/jgit/lib/StoredConfig;", "url", "remoteBranchName", "use", "R", "T", "Ljava/lang/AutoCloseable;", "block", "(Ljava/lang/AutoCloseable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.settingsRepository"})
public final class GitExKt {
    public static final void wrapIfNeedAndReThrow(@NotNull TransportException e) {
        String message;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                if (e instanceof org.eclipse.jgit.errors.NoRemoteRepositoryException || e.getStatus() == TransportException.Status.CANNOT_RESOLVE_REPO) {
                    throw (Throwable)new NoRemoteRepositoryException(e);
                }
                String string = e.getMessage();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                message = string;
                if (e.getStatus() == TransportException.Status.NOT_AUTHORIZED || e.getStatus() == TransportException.Status.NOT_PERMITTED) break block6;
                CharSequence charSequence = message;
                String string2 = JGitText.get().notAuthorized;
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JGitText.get().notAuthorized");
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth cancel", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)message, (CharSequence)"Auth fail", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)message, (CharSequence)": reject HostKey:", (boolean)false, (int)2, null)) break block7;
            }
            throw (Throwable)new AuthenticationException(e);
        }
        if (e.getStatus() == TransportException.Status.CANCELLED || Intrinsics.areEqual((Object)message, (Object)"Download cancelled")) {
            throw (Throwable)new ProcessCanceledException();
        }
        throw (Throwable)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final FetchResult fetch(@NotNull Repository $this$fetch, @NotNull RemoteConfig remoteConfig, @Nullable CredentialsProvider credentialsProvider2, @Nullable ProgressMonitor progressMonitor) {
        Intrinsics.checkParameterIsNotNull((Object)$this$fetch, (String)"$this$fetch");
        Intrinsics.checkParameterIsNotNull((Object)remoteConfig, (String)"remoteConfig");
        try {
            FetchResult fetchResult;
            AutoCloseable $this$use$iv = (AutoCloseable)Transport.open((Repository)$this$fetch, (RemoteConfig)remoteConfig);
            boolean $i$f$use = false;
            boolean closed$iv = false;
            try {
                Transport transport = (Transport)$this$use$iv;
                boolean bl = false;
                Transport transport2 = transport;
                Intrinsics.checkExpressionValueIsNotNull((Object)transport2, (String)"transport");
                transport2.setCredentialsProvider(credentialsProvider2);
                transport.setRemoveDeletedRefs(true);
                ProgressMonitor progressMonitor2 = progressMonitor;
                if (progressMonitor2 == null) {
                    progressMonitor2 = (ProgressMonitor)NullProgressMonitor.INSTANCE;
                }
                fetchResult = transport.fetch(progressMonitor2, null);
            }
            catch (Exception e$iv) {
                try {
                    closed$iv = true;
                    try {
                        $this$use$iv.close();
                    }
                    catch (Exception closeException$iv) {
                        Exception exception = e$iv;
                        if (exception == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                        }
                        ((Throwable)exception).addSuppressed(closeException$iv);
                    }
                    throw (Throwable)e$iv;
                }
                catch (Throwable throwable) {
                    if (!closed$iv) {
                        $this$use$iv.close();
                    }
                    throw throwable;
                }
            }
            $this$use$iv.close();
            return fetchResult;
        }
        catch (TransportException e) {
            String message;
            String string = e.getMessage();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            if (StringsKt.startsWith$default((String)(message = string), (String)"Remote does not have ", (boolean)false, (int)2, null)) {
                IcsManagerKt.getLOG().warn(message);
                return null;
            }
            GitExKt.wrapIfNeedAndReThrow(e);
            return null;
        }
    }

    public static /* synthetic */ FetchResult fetch$default(Repository repository2, RemoteConfig remoteConfig, CredentialsProvider credentialsProvider2, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 2) != 0) {
            credentialsProvider2 = null;
        }
        if ((n & 4) != 0) {
            progressMonitor = null;
        }
        return GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
    }

    @NotNull
    public static final Repository disableAutoCrLf(@NotNull Repository $this$disableAutoCrLf) {
        Intrinsics.checkParameterIsNotNull((Object)$this$disableAutoCrLf, (String)"$this$disableAutoCrLf");
        StoredConfig config = $this$disableAutoCrLf.getConfig();
        config.setString("core", null, "autocrlf", "false");
        config.save();
        return $this$disableAutoCrLf;
    }

    @NotNull
    public static final RevCommit commit(@NotNull Repository $this$commit, @Nullable String message, @Nullable String reflogComment, @Nullable PersonIdent author, @Nullable PersonIdent committer) {
        Intrinsics.checkParameterIsNotNull((Object)$this$commit, (String)"$this$commit");
        CommitCommand commitCommand = new CommitCommand($this$commit).setAuthor(author).setCommitter(committer);
        if (message != null) {
            commitCommand.setMessage(message);
        }
        if (reflogComment != null) {
            commitCommand.setReflogComment(reflogComment);
        }
        RevCommit revCommit = commitCommand.call();
        Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"commitCommand.call()");
        return revCommit;
    }

    public static /* synthetic */ RevCommit commit$default(Repository repository2, String string, String string2, PersonIdent personIdent, PersonIdent personIdent2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            personIdent = null;
        }
        if ((n & 8) != 0) {
            personIdent2 = null;
        }
        return GitExKt.commit(repository2, string, string2, personIdent, personIdent2);
    }

    @NotNull
    public static final DirCacheCheckout resetHard(@NotNull Repository $this$resetHard) {
        Intrinsics.checkParameterIsNotNull((Object)$this$resetHard, (String)"$this$resetHard");
        ResetCommand resetCommand = new ResetCommand($this$resetHard).setMode(ResetCommand.ResetType.HARD);
        resetCommand.call();
        ResetCommand resetCommand2 = resetCommand;
        Intrinsics.checkExpressionValueIsNotNull((Object)resetCommand2, (String)"resetCommand");
        DirCacheCheckout dirCacheCheckout = resetCommand2.getDirCacheCheckout();
        if (dirCacheCheckout == null) {
            Intrinsics.throwNpe();
        }
        return dirCacheCheckout;
    }

    @NotNull
    public static final String getRemoteBranchFullName(@NotNull Config $this$getRemoteBranchFullName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getRemoteBranchFullName, (String)"$this$getRemoteBranchFullName");
        String name = $this$getRemoteBranchFullName.getString("branch", "master", "merge");
        if (StringUtil.isEmpty((String)name)) {
            throw (Throwable)new IllegalStateException("branch.master.merge refspec must be specified");
        }
        String string = name;
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    @Nullable
    public static final String getUpstream(@NotNull Repository $this$upstream) {
        Intrinsics.checkParameterIsNotNull((Object)$this$upstream, (String)"$this$upstream");
        return StringKt.nullize$default((String)$this$upstream.getConfig().getString("remote", "origin", "url"), (boolean)false, (int)1, null);
    }

    @NotNull
    public static final StoredConfig setUpstream(@NotNull Repository $this$setUpstream, @Nullable String url, @NotNull String remoteBranchName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setUpstream, (String)"$this$setUpstream");
        Intrinsics.checkParameterIsNotNull((Object)remoteBranchName, (String)"remoteBranchName");
        String localBranchName = "master";
        StoredConfig config = $this$setUpstream.getConfig();
        String remoteName = "origin";
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            IcsManagerKt.getLOG().debug("Unset remote");
            config.unsetSection("remote", remoteName);
            config.unsetSection("branch", localBranchName);
        } else {
            IcsManagerKt.getLOG().debug("Set remote " + url);
            config.setString("remote", remoteName, "url", url);
            char c = '+';
            String string = "refs/heads/";
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = "fetch";
            String string3 = remoteName;
            String string4 = "remote";
            StoredConfig storedConfig = config;
            bl2 = false;
            String string5 = String.valueOf(c) + string;
            storedConfig.setString(string4, string3, string2, stringBuilder.append(string5).append(remoteBranchName).append(':').append("refs/remotes/").append(remoteName).append('/').append(remoteBranchName).toString());
            config.setString("branch", localBranchName, "remote", remoteName);
            config.setString("branch", localBranchName, "merge", "refs/heads/" + remoteBranchName);
        }
        config.save();
        StoredConfig storedConfig = config;
        Intrinsics.checkExpressionValueIsNotNull((Object)storedConfig, (String)"config");
        return storedConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final IndexDiff computeIndexDiff(@NotNull Repository $this$computeIndexDiff) {
        Intrinsics.checkParameterIsNotNull((Object)$this$computeIndexDiff, (String)"$this$computeIndexDiff");
        FileTreeIterator workingTreeIterator = new FileTreeIterator($this$computeIndexDiff);
        try {
            IndexDiff indexDiff = new IndexDiff($this$computeIndexDiff, "HEAD", (WorkingTreeIterator)workingTreeIterator);
            return indexDiff;
        }
        finally {
            workingTreeIterator.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final Repository cloneBare(@NotNull String uri, @NotNull Path dir, @Nullable Lazy<IcsCredentialsStore> credentialsStore2, @NotNull ProgressMonitor progressMonitor) {
        RevWalk it;
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)progressMonitor, (String)"progressMonitor");
        Repository repository2 = GitExKt.createBareRepository(dir);
        JGitCredentialsProvider credentialsProvider2 = credentialsStore2 == null ? null : new JGitCredentialsProvider(credentialsStore2, repository2);
        String string = GitExKt.getDefaultBranch(uri, credentialsProvider2);
        if (string == null) {
            string = "master";
        }
        StoredConfig config = GitExKt.setUpstream(repository2, uri, string);
        RemoteConfig remoteConfig = new RemoteConfig((Config)config, "origin");
        FetchResult fetchResult = GitExKt.fetch(repository2, remoteConfig, credentialsProvider2, progressMonitor);
        if (fetchResult == null) {
            return repository2;
        }
        FetchResult result = fetchResult;
        Ref head = GitExKt.findBranchToCheckout(result);
        if (head == null) {
            Ref ref;
            String branch = "HEAD";
            Ref ref2 = result.getAdvertisedRef(branch);
            if (ref2 == null) {
                ref2 = ref = result.getAdvertisedRef("refs/heads/" + branch);
            }
            if (ref2 == null) {
                ref = head = result.getAdvertisedRef("refs/tags/" + branch);
            }
        }
        if (head == null || head.getObjectId() == null) {
            return repository2;
        }
        String string2 = head.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"head.name");
        if (StringsKt.startsWith$default((String)string2, (String)"refs/heads/", (boolean)false, (int)2, null)) {
            RefUpdate newHead = repository2.updateRef("HEAD");
            newHead.disableRefLog();
            newHead.link(head.getName());
            String branchName = Repository.shortenRefName((String)head.getName());
            config.setString("branch", branchName, "remote", "origin");
            config.setString("branch", branchName, "merge", head.getName());
            String autoSetupRebase = config.getString("branch", null, "autosetuprebase");
            if (Intrinsics.areEqual((Object)"always", (Object)autoSetupRebase) || Intrinsics.areEqual((Object)"remote", (Object)autoSetupRebase)) {
                config.setBoolean("branch", branchName, "rebase", true);
            }
            config.save();
        }
        AutoCloseable $this$use$iv = (AutoCloseable)new RevWalk(repository2);
        boolean $i$f$use = false;
        boolean closed$iv = false;
        try {
            it = (RevWalk)$this$use$iv;
            boolean bl = false;
            it = it.parseCommit((AnyObjectId)head.getObjectId());
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception closeException$iv) {
                    Exception exception = e$iv;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException$iv);
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
        RevWalk commit2 = it;
        String string3 = head.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"head.name");
        RefUpdate u = repository2.updateRef("HEAD", !StringsKt.startsWith$default((String)string3, (String)"refs/heads/", (boolean)false, (int)2, null));
        RevWalk revWalk = commit2;
        Intrinsics.checkExpressionValueIsNotNull((Object)revWalk, (String)"commit");
        u.setNewObjectId((AnyObjectId)revWalk.getId());
        u.forceUpdate();
        return repository2;
    }

    public static /* synthetic */ Repository cloneBare$default(String string, Path path, Lazy lazy, ProgressMonitor progressMonitor, int n, Object object) {
        if ((n & 4) != 0) {
            lazy = null;
        }
        if ((n & 8) != 0) {
            NullProgressMonitor nullProgressMonitor = NullProgressMonitor.INSTANCE;
            Intrinsics.checkExpressionValueIsNotNull((Object)nullProgressMonitor, (String)"NullProgressMonitor.INSTANCE");
            progressMonitor = (ProgressMonitor)nullProgressMonitor;
        }
        return GitExKt.cloneBare(string, path, (Lazy<IcsCredentialsStore>)lazy, progressMonitor);
    }

    private static final String getDefaultBranch(String uri, JGitCredentialsProvider credentialsProvider2) {
        Map remoteRefs = ((LsRemoteCommand)new LsRemoteCommand(null).setRemote(uri).setTags(false).setCredentialsProvider((CredentialsProvider)credentialsProvider2)).callAsMap();
        Ref remoteHeadRef = (Ref)remoteRefs.get("HEAD");
        if (remoteHeadRef != null) {
            Map map = remoteRefs;
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"remoteRefs");
            Map map2 = map;
            boolean bl = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                String refName = (String)entry2.getKey();
                entry2 = entry;
                bl2 = false;
                Ref ref = (Ref)entry2.getValue();
                if (ref == remoteHeadRef) continue;
                Ref ref2 = ref;
                Intrinsics.checkExpressionValueIsNotNull((Object)ref2, (String)"ref");
                if (!Intrinsics.areEqual((Object)ref2.getObjectId(), (Object)remoteHeadRef.getObjectId())) continue;
                String string = refName;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"refName");
                return StringsKt.removePrefix((String)string, (CharSequence)"refs/heads/");
            }
        }
        return null;
    }

    private static final Ref findBranchToCheckout(FetchResult result) {
        Object v4;
        block3: {
            Ref ref = result.getAdvertisedRef("HEAD");
            if (ref == null) {
                return null;
            }
            Ref idHead = ref;
            Ref master = result.getAdvertisedRef("refs/heads/master");
            if (master != null && Intrinsics.areEqual((Object)master.getObjectId(), (Object)idHead.getObjectId())) {
                return master;
            }
            Collection collection = result.getAdvertisedRefs();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"result.advertisedRefs");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Ref it = (Ref)element$iv;
                boolean bl = false;
                Ref ref2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)ref2, (String)"it");
                String string = ref2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                if (!(StringsKt.startsWith$default((String)string, (String)"refs/heads/", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)it.getObjectId(), (Object)idHead.getObjectId()))) continue;
                v4 = element$iv;
                break block3;
            }
            v4 = null;
        }
        return v4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void processChildren(@NotNull Repository $this$processChildren, @NotNull String path, @Nullable Function1<? super String, Boolean> filter, @NotNull Function2<? super String, ? super InputStream, Boolean> processor) {
        TreeWalk rootTreeWalk;
        ObjectReader reader;
        boolean closed$iv;
        AutoCloseable $this$use$iv;
        block24: {
            block22: {
                block23: {
                    Intrinsics.checkParameterIsNotNull((Object)$this$processChildren, (String)"$this$processChildren");
                    Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                    Intrinsics.checkParameterIsNotNull(processor, (String)"processor");
                    ObjectId objectId = $this$processChildren.resolve("FETCH_HEAD");
                    if (objectId == null) {
                        return;
                    }
                    ObjectId lastCommitId = objectId;
                    $this$use$iv = (AutoCloseable)$this$processChildren.newObjectReader();
                    boolean $i$f$use = false;
                    closed$iv = false;
                    reader = (ObjectReader)$this$use$iv;
                    boolean bl = false;
                    AnyObjectId[] anyObjectIdArray = new AnyObjectId[1];
                    RevCommit revCommit = new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId);
                    Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"RevWalk(reader).parseCommit(lastCommitId)");
                    anyObjectIdArray[0] = (AnyObjectId)revCommit.getTree();
                    rootTreeWalk = TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])anyObjectIdArray);
                    if (rootTreeWalk != null) break block22;
                    Logger $this$debug$iv = IcsManagerKt.getLOG();
                    Exception e$iv = null;
                    boolean $i$f$debug = false;
                    if (!$this$debug$iv.isDebugEnabled()) break block23;
                    Logger logger = $this$debug$iv;
                    boolean bl2 = false;
                    String string = path + " not found";
                    logger.debug(string, (Throwable)e$iv);
                }
                $this$use$iv.close();
                return;
            }
            if (rootTreeWalk.isSubtree()) break block24;
            IcsManagerKt.getLOG().warn("File " + path + " is not a directory");
            $this$use$iv.close();
            return;
        }
        try {
            TreeWalk treeWalk = new TreeWalk($this$processChildren);
            treeWalk.addTree((AnyObjectId)rootTreeWalk.getObjectId(0));
            treeWalk.setRecursive(false);
            while (treeWalk.next()) {
                boolean bl;
                ObjectLoader objectLoader;
                FileMode fileMode = treeWalk.getFileMode(0);
                if (!Intrinsics.areEqual((Object)fileMode, (Object)FileMode.REGULAR_FILE) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.SYMLINK) && !Intrinsics.areEqual((Object)fileMode, (Object)FileMode.EXECUTABLE_FILE)) continue;
                String fileName = treeWalk.getNameString();
                if (filter != null) {
                    String string = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                    if (!((Boolean)filter.invoke((Object)string)).booleanValue()) continue;
                }
                ObjectLoader objectLoader2 = objectLoader = reader.open((AnyObjectId)treeWalk.getObjectId(0), 3);
                Intrinsics.checkExpressionValueIsNotNull((Object)objectLoader2, (String)"objectLoader");
                if (objectLoader2.getSize() == 0L) {
                    IcsManagerKt.getLOG().warn("File " + path + " skipped because empty (length 0)");
                    continue;
                }
                AutoCloseable $this$use$iv2 = (AutoCloseable)objectLoader.openStream();
                boolean $i$f$use = false;
                boolean closed$iv2 = false;
                try {
                    ObjectStream it = (ObjectStream)$this$use$iv2;
                    boolean bl3 = false;
                    String string = fileName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileName");
                    ObjectStream objectStream = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectStream, (String)"it");
                    bl = (Boolean)processor.invoke((Object)string, (Object)objectStream);
                }
                catch (Exception e$iv) {
                    try {
                        closed$iv2 = true;
                        try {
                            $this$use$iv2.close();
                        }
                        catch (Exception closeException$iv) {
                            Exception exception = e$iv;
                            if (exception == null) {
                                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                            }
                            ((Throwable)exception).addSuppressed(closeException$iv);
                        }
                        throw (Throwable)e$iv;
                    }
                    catch (Throwable throwable) {
                        if (!closed$iv2) {
                            $this$use$iv2.close();
                        }
                        throw throwable;
                    }
                }
                $this$use$iv2.close();
                if (bl) continue;
                break;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Exception e$iv) {
            try {
                closed$iv = true;
                try {
                    $this$use$iv.close();
                }
                catch (Exception closeException$iv) {
                    Exception exception = e$iv;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException$iv);
                }
                throw (Throwable)e$iv;
            }
            catch (Throwable throwable) {
                if (!closed$iv) {
                    $this$use$iv.close();
                }
                throw throwable;
            }
        }
        $this$use$iv.close();
    }

    public static /* synthetic */ void processChildren$default(Repository repository2, String string, Function1 function1, Function2 function2, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        GitExKt.processChildren(repository2, string, (Function1<? super String, Boolean>)function1, (Function2<? super String, ? super InputStream, Boolean>)function2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final InputStream read(@NotNull Repository $this$read, @NotNull String path) {
        ObjectStream input;
        ObjectReader reader;
        block7: {
            TreeWalk treeWalk;
            boolean releaseReader;
            block6: {
                InputStream inputStream;
                Intrinsics.checkParameterIsNotNull((Object)$this$read, (String)"$this$read");
                Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
                ObjectId lastCommitId = $this$read.resolve("HEAD");
                if (lastCommitId == null) {
                    Logger logger = IcsManagerKt.getLOG();
                    StringBuilder stringBuilder = new StringBuilder().append("Repository ");
                    File file = $this$read.getDirectory();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"directory");
                    logger.warn(stringBuilder.append(file.getName()).append(" doesn't have HEAD").toString());
                    return null;
                }
                reader = $this$read.newObjectReader();
                releaseReader = true;
                try {
                    AnyObjectId[] anyObjectIdArray = new AnyObjectId[1];
                    RevCommit revCommit = new RevWalk(reader).parseCommit((AnyObjectId)lastCommitId);
                    Intrinsics.checkExpressionValueIsNotNull((Object)revCommit, (String)"RevWalk(reader).parseCommit(lastCommitId)");
                    anyObjectIdArray[0] = (AnyObjectId)revCommit.getTree();
                    if (TreeWalk.forPath((ObjectReader)reader, (String)path, (AnyObjectId[])anyObjectIdArray) != null) break block6;
                    inputStream = null;
                }
                catch (Throwable throwable) {
                    if (releaseReader) {
                        reader.close();
                    }
                    throw throwable;
                }
                reader.close();
                return inputStream;
            }
            TreeWalk treeWalk2 = treeWalk;
            ObjectLoader objectLoader = reader.open((AnyObjectId)treeWalk2.getObjectId(0), 3);
            input = objectLoader.openStream();
            ObjectLoader objectLoader2 = objectLoader;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectLoader2, (String)"objectLoader");
            if (!objectLoader2.isLarge()) break block7;
            releaseReader = false;
            ObjectStream objectStream = input;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectStream, (String)"input");
            InputStream inputStream = (InputStream)objectStream;
            ObjectReader objectReader = reader;
            Intrinsics.checkExpressionValueIsNotNull((Object)objectReader, (String)"reader");
            InputStream inputStream2 = new InputStreamWrapper(inputStream, objectReader);
            return inputStream2;
        }
        InputStream inputStream = (InputStream)input;
        reader.close();
        return inputStream;
    }

    public static final int getAheadCommitsCount(@NotNull Repository $this$getAheadCommitsCount) {
        RevCommit revCommit;
        StoredConfig config;
        Intrinsics.checkParameterIsNotNull((Object)$this$getAheadCommitsCount, (String)"$this$getAheadCommitsCount");
        StoredConfig storedConfig = config = $this$getAheadCommitsCount.getConfig();
        Intrinsics.checkExpressionValueIsNotNull((Object)storedConfig, (String)"config");
        String shortBranchName = Repository.shortenRefName((String)GitExKt.getRemoteBranchFullName((Config)storedConfig));
        String string = new BranchConfig((Config)config, shortBranchName).getTrackingBranch();
        if (string == null) {
            return -1;
        }
        String trackingBranch = string;
        Ref ref = $this$getAheadCommitsCount.exactRef("refs/heads/" + shortBranchName);
        if (ref == null) {
            return -1;
        }
        Ref local = ref;
        RevWalk walk = new RevWalk($this$getAheadCommitsCount);
        RevCommit localCommit = walk.parseCommit((AnyObjectId)local.getObjectId());
        Ref ref2 = $this$getAheadCommitsCount.findRef(trackingBranch);
        if (ref2 != null) {
            Ref ref3 = ref2;
            boolean bl = false;
            boolean bl2 = false;
            Ref it = ref3;
            boolean bl3 = false;
            revCommit = walk.parseCommit((AnyObjectId)it.getObjectId());
        } else {
            revCommit = null;
        }
        RevCommit trackingCommit = revCommit;
        walk.setRevFilter(RevFilter.MERGE_BASE);
        if (trackingCommit == null) {
            walk.markStart(localCommit);
            walk.sort(RevSort.REVERSE);
        } else {
            walk.markStart(localCommit);
            walk.markStart(trackingCommit);
            RevCommit mergeBase = walk.next();
            walk.reset();
            walk.markStart(localCommit);
            walk.markUninteresting(mergeBase);
        }
        walk.setRevFilter(RevFilter.ALL);
        return CollectionsKt.count((Iterable)((Iterable)walk));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T extends AutoCloseable, R> R use(@NotNull T $this$use, @NotNull Function1<? super T, ? extends R> block) {
        Object object;
        int $i$f$use = 0;
        Intrinsics.checkParameterIsNotNull($this$use, (String)"$this$use");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        boolean closed = false;
        try {
            object = block.invoke($this$use);
        }
        catch (Exception e) {
            try {
                closed = true;
                try {
                    $this$use.close();
                }
                catch (Exception closeException) {
                    Exception exception = e;
                    if (exception == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
                    }
                    ((Throwable)exception).addSuppressed(closeException);
                }
                throw (Throwable)e;
            }
            catch (Throwable throwable) {
                InlineMarker.finallyStart((int)1);
                if (!closed) {
                    $this$use.close();
                }
                InlineMarker.finallyEnd((int)1);
                throw throwable;
            }
        }
        InlineMarker.finallyStart((int)1);
        $this$use.close();
        InlineMarker.finallyEnd((int)1);
        return (R)object;
    }

    @NotNull
    public static final Repository buildRepository(@Nullable Path workTree, boolean bare, @Nullable Path gitDir, boolean mustExists) {
        Path it;
        boolean bl;
        boolean bl2;
        Path path;
        BaseRepositoryBuilder baseRepositoryBuilder = new FileRepositoryBuilder().setUseSystemConfig(false);
        boolean bl3 = false;
        boolean bl4 = false;
        FileRepositoryBuilder $this$with = (FileRepositoryBuilder)baseRepositoryBuilder;
        boolean bl5 = false;
        if (bare) {
            $this$with.setBare();
        } else {
            Path path2 = workTree;
            if (path2 != null) {
                path = path2;
                bl2 = false;
                bl = false;
                it = path;
                boolean bl6 = false;
                FileRepositoryBuilder cfr_ignored_0 = (FileRepositoryBuilder)$this$with.setWorkTree(it.toFile());
            }
        }
        Path path3 = gitDir;
        if (path3 != null) {
            path = path3;
            bl2 = false;
            bl = false;
            it = path;
            boolean bl7 = false;
            FileRepositoryBuilder cfr_ignored_1 = (FileRepositoryBuilder)$this$with.setGitDir(gitDir.toFile());
        }
        $this$with.setMustExist(mustExists);
        Repository repository2 = $this$with.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)repository2, (String)"build()");
        Intrinsics.checkExpressionValueIsNotNull((Object)repository2, (String)"with(FileRepositoryBuild\u2026stExists\n\n    build()\n  }");
        return repository2;
    }

    public static /* synthetic */ Repository buildRepository$default(Path path, boolean bl, Path path2, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            path = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            path2 = null;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return GitExKt.buildRepository(path, bl, path2, bl2);
    }

    @NotNull
    public static final Repository buildBareRepository(@NotNull Path gitDir) {
        Intrinsics.checkParameterIsNotNull((Object)gitDir, (String)"gitDir");
        return GitExKt.buildRepository$default(null, true, gitDir, false, 9, null);
    }

    @NotNull
    public static final Repository createBareRepository(@NotNull Path dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Repository repository2 = GitExKt.buildRepository$default(null, true, dir, false, 9, null);
        repository2.create(true);
        return repository2;
    }
}

