/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.util;

import com.github.hypfvieh.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemUtil.class);
    private static final String[] TERMINAL_EMULATORS = new String[]{"x-terminal-emulator", "gnome-terminal", "mate-terminal", "konsole", "xterm", "rxvt", "xdg-terminal", "lxterminal", "pterm", "aterm", "eterm", "roxterm", "qterminal", "terminator", "tmux", "screen"};
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String TMP_DIR = SystemUtil.normalizePath(System.getProperty("java.io.tmpdir"));

    private SystemUtil() {
    }

    public static String getOs() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException _ex) {
            return null;
        }
    }

    public static String getWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static String getRunningClassPath() {
        return ClassLoader.getSystemClassLoader().getResource(".").getPath();
    }

    public static String getTempDir() {
        return TMP_DIR;
    }

    public static String getJavaVersion() {
        String[] sysPropParms = new String[]{"java.runtime.version", "java.version"};
        for (int i = 0; i < sysPropParms.length; ++i) {
            String val = System.getProperty(sysPropParms[i]);
            if (StringUtil.isEmpty(val)) continue;
            return val;
        }
        return null;
    }

    public static String getCurrentUser() {
        String[] sysPropParms = new String[]{"user.name", "USER", "USERNAME"};
        for (int i = 0; i < sysPropParms.length; ++i) {
            String val = System.getProperty(sysPropParms[i]);
            if (StringUtil.isEmpty(val)) continue;
            return val;
        }
        return null;
    }

    public static String concatFilePath(boolean _includeTrailingDelimiter, String ... _parts) {
        if (_parts == null) {
            return null;
        }
        StringBuilder allParts = new StringBuilder();
        for (int i = 0; i < _parts.length; ++i) {
            if (_parts[i] == null) continue;
            allParts.append(_parts[i]);
            if (_parts[i].endsWith(File.separator)) continue;
            allParts.append(File.separator);
        }
        if (!_includeTrailingDelimiter && allParts.length() > 0) {
            return allParts.substring(0, allParts.lastIndexOf(File.separator));
        }
        return allParts.toString();
    }

    public static String concatFilePath(String ... _parts) {
        return SystemUtil.concatFilePath(false, _parts);
    }

    public static String appendSuffixIfMissing(String _str, String _suffix) {
        if (_str == null) {
            return null;
        }
        if (!_str.endsWith(_suffix)) {
            _str = _str + _suffix;
        }
        return _str;
    }

    public static String appendTrailingDelimiter(String _filePath) {
        if (_filePath == null) {
            return null;
        }
        if (!_filePath.endsWith(File.separator)) {
            _filePath = _filePath + File.separator;
        }
        return _filePath;
    }

    public static File createTempDirectory(String _path, String _name, boolean _deleteOnExit) {
        File outputDir = new File(SystemUtil.concatFilePath(_path, _name));
        if (!outputDir.exists()) {
            try {
                Files.createDirectory(Paths.get(outputDir.toString(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException _ex) {
                LOGGER.error("Error while creating temp directory: ", (Throwable)_ex);
            }
        } else {
            return null;
        }
        if (_deleteOnExit) {
            outputDir.deleteOnExit();
        }
        return outputDir;
    }

    public static File createTempDirectory(String _path, String _prefix, int _length, boolean _timestamp, boolean _deleteOnExit) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd_HHmmss-SSS");
        String randomStr = StringUtil.randomString(_length);
        StringBuilder fileName = new StringBuilder();
        if (_prefix != null) {
            fileName.append(_prefix);
        }
        fileName.append(randomStr);
        if (_timestamp) {
            fileName.append("_").append(formatter.format(new Date()));
        }
        File result = SystemUtil.createTempDirectory(_path, fileName.toString(), _deleteOnExit);
        while (result == null) {
            result = SystemUtil.createTempDirectory(_path, _prefix, _length, _timestamp, _deleteOnExit);
        }
        return result;
    }

    public static boolean isDebuggingEnabled() {
        boolean debuggingEnabled = false;
        if (ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0) {
            debuggingEnabled = true;
        } else if (ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-Xdebug")) {
            debuggingEnabled = true;
        } else if (System.getProperty("debug", "").equals("true")) {
            debuggingEnabled = true;
        }
        return debuggingEnabled;
    }

    public static String getFileExtension(String _fileName) {
        if (_fileName == null) {
            return null;
        }
        int lastDot = _fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return _fileName.substring(lastDot + 1);
    }

    public static String getFileExtension(File _file) {
        return SystemUtil.getFileExtension(_file.getAbsolutePath());
    }

    public static File getFileIfReadable(String _file) throws IOException {
        if (StringUtil.isBlank(_file)) {
            throw new IOException("Empty or null string is not a valid file");
        }
        File file = new File(_file);
        if (!file.exists()) {
            throw new FileNotFoundException("No such file: " + _file);
        }
        if (!file.isFile()) {
            throw new IOException("Not a file: " + _file);
        }
        if (!file.canRead()) {
            throw new AccessDeniedException("File not readable: " + _file);
        }
        return file;
    }

    public static String formatBytesHumanReadable(long _bytes, boolean _use1000BytesPerMb) {
        int unit;
        int n = unit = _use1000BytesPerMb ? 1000 : 1024;
        if (_bytes < (long)unit) {
            return _bytes + " B";
        }
        int exp = (int)(Math.log(_bytes) / Math.log(unit));
        String pre = (_use1000BytesPerMb ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (_use1000BytesPerMb ? "" : "i");
        return String.format("%.1f %sB", (double)_bytes / Math.pow(unit, exp), pre);
    }

    public static String getApplicationVersionFromJar(Class<?> _class, String _default) {
        try {
            Enumeration<URL> resources = _class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            if (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                Attributes attribs = manifest.getMainAttributes();
                String ver = attribs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                if (ver == null) {
                    return _default;
                }
                String rev = attribs.getValue("Implementation-Revision");
                if (rev != null) {
                    ver = ver + "-r" + rev;
                }
                return ver;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return _default;
    }

    public static String guessDefaultTerminal() {
        if (System.getProperty("os.name", "").equalsIgnoreCase("windows")) {
            return "cmd.exe";
        }
        String envPath = System.getenv("PATH");
        if (envPath == null) {
            throw new RuntimeException("Could not find enviroment PATH setting.");
        }
        String[] pathes = envPath.split(":");
        for (String term : TERMINAL_EMULATORS) {
            for (String path : pathes) {
                File terminalExe = new File(SystemUtil.concatFilePath(path, term));
                if (!terminalExe.exists() || !terminalExe.canExecute()) continue;
                return terminalExe.getAbsolutePath();
            }
        }
        return null;
    }

    public static String normalizePath(String _path, boolean _appendFinalSeparator) {
        if (_path == null) {
            return _path;
        }
        String path = _path.replace("\\", FILE_SEPARATOR).replace("/", FILE_SEPARATOR);
        if (_appendFinalSeparator && !path.endsWith(FILE_SEPARATOR)) {
            path = path + FILE_SEPARATOR;
        }
        return path;
    }

    public static String normalizePath(String _path) {
        return SystemUtil.normalizePath(_path, true);
    }

    public static boolean isMacOs() {
        String osName = System.getProperty("os.name");
        return osName == null ? false : osName.toLowerCase().startsWith("mac");
    }

    public static String getMacOsMajorVersion() {
        if (!SystemUtil.isMacOs()) {
            return null;
        }
        String osVersion = System.getProperty("os.version");
        if (osVersion != null) {
            String[] split = osVersion.split("\\.");
            if (split.length >= 2) {
                return split[0] + "." + split[1];
            }
            return osVersion;
        }
        return null;
    }
}

