/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.pdf.page;

import java.util.SortedSet;
import java.util.TreeSet;
import javax.validation.constraints.Min;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.pdf.page.PagesSelection;
import org.sejda.model.validation.constraint.EndGreaterThenOrEqualToStart;

@EndGreaterThenOrEqualToStart
public class PageRange
implements PagesSelection {
    private static final int UNBOUNDED_END = Integer.MAX_VALUE;
    @Min(value=1L)
    private int start;
    @Min(value=1L)
    private int end;

    PageRange() {
    }

    public PageRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public PageRange(int start) {
        this.start = start;
        this.end = Integer.MAX_VALUE;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public boolean isUnbounded() {
        return this.end == Integer.MAX_VALUE;
    }

    public boolean intersects(PageRange range) {
        return range.getStart() >= this.start && range.getStart() <= this.end || range.getEnd() >= this.start && range.getEnd() <= this.end;
    }

    public SortedSet<Integer> getPages(int totalNumberOfPage) {
        TreeSet<Integer> retSet = new TreeSet<Integer>();
        for (int i = this.start; i <= totalNumberOfPage && i <= this.end; ++i) {
            retSet.add(i);
        }
        return retSet;
    }

    public boolean contains(int page) {
        return this.start <= page && this.end >= page;
    }

    public String toString() {
        if (this.isUnbounded()) {
            return String.format("%s-", this.start);
        }
        if (this.start == this.end) {
            return String.format("%s", this.start);
        }
        return String.format("%s-%s", this.start, this.end);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.start).append(this.end).toHashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PageRange)) {
            return false;
        }
        PageRange range = (PageRange)other;
        return new EqualsBuilder().append(this.start, range.getStart()).append(this.end, range.getEnd()).isEquals();
    }

    public static PageRange one(int page) {
        return new PageRange(page, page);
    }
}

