/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.contentstream.operator;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.sejda.sambox.contentstream.PDFStreamEngine;
import org.sejda.sambox.contentstream.operator.Operator;
import org.sejda.sambox.contentstream.operator.OperatorConsumer;
import org.sejda.sambox.contentstream.operator.OperatorProcessor;
import org.sejda.sambox.cos.COSBase;

public class OperatorProcessorDecorator
extends OperatorProcessor {
    private OperatorProcessor delegate;
    private Optional<OperatorConsumer> consumer;

    public OperatorProcessorDecorator(OperatorProcessor delegate, OperatorConsumer consumer) {
        this.delegate = delegate;
        this.consumer = Optional.ofNullable(consumer);
    }

    public OperatorProcessorDecorator(OperatorProcessor delegate) {
        this.delegate = delegate;
        this.consumer = Optional.empty();
    }

    @Override
    public void process(Operator operator, List<COSBase> operands) throws IOException {
        this.delegate.process(operator, operands);
        this.consumer.orElse(OperatorConsumer.NO_OP).apply(operator, operands);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public PDFStreamEngine getContext() {
        return this.delegate.getContext();
    }

    @Override
    public void setContext(PDFStreamEngine context) {
        this.delegate.setContext(context);
    }

    public void setConsumer(OperatorConsumer consumer) {
        this.consumer = Optional.ofNullable(consumer);
    }
}

