/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.AmqpResponseCode;
import com.microsoft.azure.eventhubs.impl.ExceptionUtil;
import com.microsoft.azure.eventhubs.impl.FaultTolerantObject;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import com.microsoft.azure.eventhubs.impl.RequestResponseChannel;
import com.microsoft.azure.eventhubs.impl.RequestResponseCloser;
import com.microsoft.azure.eventhubs.impl.RequestResponseOpener;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import java.util.HashMap;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.Message;

final class CBSChannel {
    final FaultTolerantObject<RequestResponseChannel> innerChannel;
    final SessionProvider sessionProvider;
    final AmqpConnection connectionEventDispatcher;

    public CBSChannel(SessionProvider sessionProvider, AmqpConnection connection) {
        this.sessionProvider = sessionProvider;
        this.connectionEventDispatcher = connection;
        RequestResponseCloser closer = new RequestResponseCloser();
        this.innerChannel = new FaultTolerantObject<RequestResponseChannel>(new RequestResponseOpener(sessionProvider, "cbs-session", "cbs", "$cbs", connection), closer);
        closer.setInnerChannel(this.innerChannel);
    }

    public void sendToken(ReactorDispatcher dispatcher, String token, String tokenAudience, final OperationResult<Void, Exception> sendTokenCallback) {
        final Message request = Proton.message();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("operation", "put-token");
        properties.put("type", "servicebus.windows.net:sastoken");
        properties.put("name", tokenAudience);
        ApplicationProperties applicationProperties = new ApplicationProperties(properties);
        request.setApplicationProperties(applicationProperties);
        request.setBody((Section)new AmqpValue((Object)token));
        this.innerChannel.runOnOpenedObject(dispatcher, new OperationResult<RequestResponseChannel, Exception>(){

            @Override
            public void onComplete(RequestResponseChannel result) {
                result.request(request, new OperationResult<Message, Exception>(){

                    @Override
                    public void onComplete(Message response) {
                        int statusCode = (Integer)response.getApplicationProperties().getValue().get("status-code");
                        String statusDescription = (String)response.getApplicationProperties().getValue().get("status-description");
                        if (statusCode == AmqpResponseCode.ACCEPTED.getValue() || statusCode == AmqpResponseCode.OK.getValue()) {
                            sendTokenCallback.onComplete(null);
                        } else {
                            this.onError(ExceptionUtil.amqpResponseCodeToException(statusCode, statusDescription));
                        }
                    }

                    @Override
                    public void onError(Exception error) {
                        sendTokenCallback.onError(error);
                    }
                });
            }

            @Override
            public void onError(Exception error) {
                sendTokenCallback.onError(error);
            }
        });
    }

    public void close(ReactorDispatcher reactorDispatcher, OperationResult<Void, Exception> closeCallback) {
        this.innerChannel.close(reactorDispatcher, closeCallback);
    }
}

