/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.binding;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.binding.ConstantField;
import org.jruby.javasupport.binding.Initializer;
import org.jruby.javasupport.binding.MethodInstaller;
import org.jruby.javasupport.binding.NamedInstaller;

final class InterfaceInitializer
extends Initializer {
    InterfaceInitializer(Ruby runtime2, Class<?> javaClass) {
        super(runtime2, javaClass);
    }

    @Override
    public RubyModule initialize(RubyModule proxy2) {
        Initializer.State state2 = new Initializer.State(this.runtime, null);
        Field[] fields2 = JavaClass.getDeclaredFields(this.javaClass);
        int i2 = fields2.length;
        while (--i2 >= 0) {
            int mod;
            Field field2 = fields2[i2];
            if (this.javaClass != field2.getDeclaringClass()) continue;
            boolean isConstant = ConstantField.isConstant(field2);
            if (isConstant) {
                state2.constantFields.add(new ConstantField(field2));
            }
            if (!Modifier.isStatic(mod = field2.getModifiers())) continue;
            InterfaceInitializer.addField(state2.staticInstallers, state2.staticNames, field2, Modifier.isFinal(mod), true, isConstant);
        }
        InterfaceInitializer.setupInterfaceMethods(this.javaClass, state2);
        InterfaceInitializer.handleScalaSingletons(this.javaClass, state2);
        Map<String, NamedInstaller> installers = state2.staticInstallers;
        for (Map.Entry<String, NamedInstaller> entry : installers.entrySet()) {
            NamedInstaller installer = entry.getValue();
            if (installer.type != 2 || !installer.hasLocalMethod()) continue;
            InterfaceInitializer.assignAliases((MethodInstaller)installer, state2.staticNames, installers);
        }
        this.runtime.getJavaSupport().getStaticAssignedNames().get(this.javaClass).putAll(state2.staticNames);
        this.runtime.getJavaSupport().getInstanceAssignedNames().get(this.javaClass).clear();
        InterfaceInitializer.installClassFields(proxy2, state2);
        InterfaceInitializer.installClassStaticMethods(proxy2, state2);
        InterfaceInitializer.installClassClasses(this.javaClass, proxy2);
        proxy2.getName();
        return proxy2;
    }

    private static void setupInterfaceMethods(Class<?> javaClass, Initializer.State state2) {
        Map<String, List<Method>> nameMethods = InterfaceInitializer.getMethods(javaClass);
        for (List<Method> methods2 : nameMethods.values()) {
            int i2 = methods2.size();
            while (--i2 >= 0) {
                Method method2 = methods2.get(i2);
                String name2 = method2.getName();
                if (!Modifier.isStatic(method2.getModifiers())) continue;
                InterfaceInitializer.prepareStaticMethod(javaClass, state2, method2, name2);
            }
        }
        InterfaceInitializer.assignStaticAliases(state2);
    }
}

