/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class FindCoordinatorRequestData
implements ApiMessage {
    private String key;
    private byte keyType;
    public static final Schema SCHEMA_0 = new Schema(new Field("key", Type.STRING, "The coordinator key."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;

    public FindCoordinatorRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public FindCoordinatorRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public FindCoordinatorRequestData() {
        this.key = "";
        this.keyType = 0;
    }

    @Override
    public short apiKey() {
        return 10;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 2;
    }

    @Override
    public void read(Readable readable, short version) {
        this.key = readable.readNullableString();
        this.keyType = version >= 1 ? readable.readByte() : (byte)0;
    }

    @Override
    public void write(Writable writable, short version) {
        writable.writeString(this.key);
        if (version >= 1) {
            writable.writeByte(this.keyType);
        }
    }

    @Override
    public void fromStruct(Struct struct, short version) {
        this.key = struct.getString("key");
        this.keyType = version >= 1 ? struct.getByte("key_type") : (byte)0;
    }

    @Override
    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        struct.set("key", (Object)this.key);
        if (version >= 1) {
            struct.set("key_type", (Object)this.keyType);
        }
        return struct;
    }

    @Override
    public int size(short version) {
        int size = 0;
        size += 2;
        size += MessageUtil.serializedUtf8Length(this.key);
        if (version >= 1) {
            ++size;
        } else if (this.keyType != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default keyType at version " + version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FindCoordinatorRequestData)) {
            return false;
        }
        FindCoordinatorRequestData other = (FindCoordinatorRequestData)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return this.keyType == other.keyType;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
        hashCode = 31 * hashCode + this.keyType;
        return hashCode;
    }

    public String toString() {
        return "FindCoordinatorRequestData(key='" + this.key + "', keyType=" + this.keyType + ")";
    }

    public String key() {
        return this.key;
    }

    public byte keyType() {
        return this.keyType;
    }

    public FindCoordinatorRequestData setKey(String v) {
        this.key = v;
        return this;
    }

    public FindCoordinatorRequestData setKeyType(byte v) {
        this.keyType = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("key", Type.STRING, "The coordinator key."), new Field("key_type", Type.INT8, "The coordinator key type.  (Group, transaction, etc.)"));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }
}

