import { tailRec } from './ChainRec';
import { toString } from './function';
import { fromEquals } from './Setoid';
export const URI = 'Identity';
/**
 * @since 1.0.0
 */
export class Identity {
    constructor(value) {
        this.value = value;
    }
    map(f) {
        return new Identity(f(this.value));
    }
    ap(fab) {
        return this.map(fab.value);
    }
    /**
     * Flipped version of `ap`
     */
    ap_(fb) {
        return fb.ap(this);
    }
    chain(f) {
        return f(this.value);
    }
    reduce(b, f) {
        return f(b, this.value);
    }
    alt(fx) {
        return this;
    }
    /**
     * Lazy version of `alt`
     *
     * @example
     * import { Identity } from 'fp-ts/lib/Identity'
     *
     * const a = new Identity(1)
     * assert.deepStrictEqual(a.orElse(() => new Identity(2)), a)
     *
     * @since 1.6.0
     */
    orElse(fx) {
        return this;
    }
    extract() {
        return this.value;
    }
    extend(f) {
        return of(f(this));
    }
    fold(f) {
        return f(this.value);
    }
    inspect() {
        return this.toString();
    }
    toString() {
        return `new Identity(${toString(this.value)})`;
    }
}
/**
 * @since 1.17.0
 */
export const getShow = (S) => {
    return {
        show: i => `new Identity(${S.show(i.value)})`
    };
};
/**
 * @since 1.0.0
 */
export const getSetoid = (S) => {
    return fromEquals((x, y) => S.equals(x.value, y.value));
};
const map = (fa, f) => {
    return fa.map(f);
};
const of = (a) => {
    return new Identity(a);
};
const ap = (fab, fa) => {
    return fa.ap(fab);
};
const chain = (fa, f) => {
    return fa.chain(f);
};
const reduce = (fa, b, f) => {
    return fa.reduce(b, f);
};
const foldMap = (M) => (fa, f) => {
    return f(fa.value);
};
const foldr = (fa, b, f) => {
    return f(fa.value, b);
};
const alt = (fx, fy) => {
    return fx.alt(fy);
};
const extend = (ea, f) => {
    return ea.extend(f);
};
const extract = (fa) => {
    return fa.value;
};
const chainRec = (a, f) => {
    return new Identity(tailRec(a => f(a).value, a));
};
const traverse = (F) => (ta, f) => {
    return F.map(f(ta.value), of);
};
const sequence = (F) => (ta) => {
    return F.map(ta.value, of);
};
/**
 * @since 1.0.0
 */
export const identity = {
    URI,
    map,
    of,
    ap,
    chain,
    reduce,
    foldMap,
    foldr,
    traverse,
    sequence,
    alt,
    extract,
    extend,
    chainRec
};
