/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.impl.operations.PingOperation;
import org.infinispan.client.hotrod.impl.operations.RetryOnFailureOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.commons.dataconversion.MediaType;

public class FaultTolerantPingOperation
extends RetryOnFailureOperation<PingOperation.PingResponse> {
    protected FaultTolerantPingOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg) {
        super((short)23, (short)24, codec, channelFactory, cacheName, topologyId, flags, cfg, null);
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.sendHeaderAndRead(channel);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        MediaType valueMediaType;
        MediaType keyMediaType = this.codec.readKeyType(buf);
        PingOperation.PingResponse pingResponse = new PingOperation.PingResponse(status, keyMediaType, valueMediaType = this.codec.readValueType(buf));
        if (!pingResponse.isSuccess()) {
            String hexStatus = Integer.toHexString(status);
            if (trace) {
                log.tracef("Unknown response status: %s", hexStatus);
            }
            throw new InvalidResponseException("Unexpected response status: " + hexStatus);
        }
        this.complete(pingResponse);
    }

    @Override
    protected Throwable handleException(Throwable cause, ChannelHandlerContext ctx, SocketAddress address) {
        while (cause instanceof DecoderException && cause.getCause() != null) {
            cause = cause.getCause();
        }
        PingOperation.PingResponse pingResponse = new PingOperation.PingResponse(cause);
        if (pingResponse.isCacheNotFound()) {
            this.complete(pingResponse);
            return null;
        }
        return super.handleException(cause, ctx, address);
    }
}

