/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.overrides;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.ThreadInterruptedException;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ConcurrentMergeScheduler
extends org.apache.lucene.index.ConcurrentMergeScheduler {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final ErrorHandler errorHandler;
    private final String indexName;

    public ConcurrentMergeScheduler(ErrorHandler errorHandler, String indexName) {
        this.errorHandler = errorHandler;
        this.indexName = indexName;
    }

    protected void handleMergeException(Directory dir, Throwable t) {
        try {
            super.handleMergeException(dir, t);
        }
        catch (ThreadInterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            this.errorHandler.handleException(log.exceptionDuringIndexMergeOperation(), ex);
        }
    }

    protected synchronized ConcurrentMergeScheduler.MergeThread getMergeThread(IndexWriter writer, MergePolicy.OneMerge merge) throws IOException {
        ConcurrentMergeScheduler.MergeThread thread = new ConcurrentMergeScheduler.MergeThread((org.apache.lucene.index.ConcurrentMergeScheduler)this, writer, merge);
        thread.setDaemon(true);
        thread.setName("Lucene Merge Thread #" + this.mergeThreadCount++ + " for index " + this.indexName);
        return thread;
    }
}

