/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.operations;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.CapabilityServiceTarget;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.management.BaseHttpInterfaceAddStepHandler;
import org.jboss.as.controller.management.HttpInterfaceCommonPolicy;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.http.server.ConsoleMode;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.as.host.controller.DomainModelControllerService;
import org.jboss.as.host.controller.HostControllerEnvironment;
import org.jboss.as.host.controller.HostControllerService;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.operations.HttpManagementRemoveHandler;
import org.jboss.as.host.controller.operations.LocalHostControllerInfoImpl;
import org.jboss.as.host.controller.operations.NativeManagementServices;
import org.jboss.as.host.controller.resources.HttpManagementResourceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.remoting.RemotingHttpUpgradeService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.management.ManagementChannelRegistryService;
import org.jboss.as.remoting.management.ManagementRemotingServices;
import org.jboss.as.server.ExternalManagementRequestExecutor;
import org.jboss.as.server.mgmt.HttpManagementRequestsService;
import org.jboss.as.server.mgmt.HttpShutdownService;
import org.jboss.as.server.mgmt.ManagementWorkerService;
import org.jboss.as.server.mgmt.UndertowHttpManagementService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.server.HttpAuthenticationFactory;
import org.xnio.OptionMap;

public class HttpManagementAddHandler
extends BaseHttpInterfaceAddStepHandler {
    private static final String HTTP_AUTHENTICATION_FACTORY_CAPABILITY = "org.wildfly.security.http-authentication-factory";
    public static final String OPERATION_NAME = "add";
    private final LocalHostControllerInfoImpl hostControllerInfo;
    private final HostControllerEnvironment environment;

    public HttpManagementAddHandler(LocalHostControllerInfoImpl hostControllerInfo, HostControllerEnvironment environment) {
        super(HttpManagementResourceDefinition.ATTRIBUTE_DEFINITIONS);
        this.hostControllerInfo = hostControllerInfo;
        this.environment = environment;
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        HttpManagementResourceDefinition.addAttributeValidator(context);
    }

    protected boolean requiresRuntime(OperationContext context) {
        return super.requiresRuntime(context) && context.getProcessType() != ProcessType.EMBEDDED_HOST_CONTROLLER;
    }

    protected List<ServiceName> installServices(OperationContext context, HttpInterfaceCommonPolicy commonPolicy, ModelNode model) throws OperationFailedException {
        HttpManagementAddHandler.populateHostControllerInfo(this.hostControllerInfo, context, model);
        CapabilityServiceTarget serviceTarget = context.getCapabilityServiceTarget();
        boolean onDemand = context.isBooting();
        String interfaceName = this.hostControllerInfo.getHttpManagementInterface();
        int port = this.hostControllerInfo.getHttpManagementPort();
        String secureInterfaceName = this.hostControllerInfo.getHttpManagementSecureInterface();
        int securePort = this.hostControllerInfo.getHttpManagementSecurePort();
        HostControllerLogger.ROOT_LOGGER.creatingHttpManagementService(interfaceName, port, securePort);
        boolean consoleEnabled = HttpManagementResourceDefinition.CONSOLE_ENABLED.resolveModelAttribute(context, model).asBoolean();
        ConsoleMode consoleMode = ConsoleMode.CONSOLE;
        if (consoleEnabled) {
            if (context.getRunningMode() == RunningMode.ADMIN_ONLY) {
                consoleMode = ConsoleMode.ADMIN_ONLY;
            } else if (!this.hostControllerInfo.isMasterDomainController()) {
                consoleMode = ConsoleMode.SLAVE_HC;
            }
        } else {
            consoleMode = ConsoleMode.NO_CONSOLE;
        }
        NativeManagementServices.installManagementWorkerService((ServiceTarget)serviceTarget, context.getServiceRegistry(false));
        ServiceName requestProcessorName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"requests"});
        HttpManagementRequestsService.installService((ServiceName)requestProcessorName, (ServiceTarget)serviceTarget);
        String httpAuthenticationFactory = commonPolicy.getHttpAuthenticationFactory();
        String securityRealm = commonPolicy.getSecurityRealm();
        String sslContext = commonPolicy.getSSLContext();
        if (httpAuthenticationFactory == null && securityRealm == null) {
            HostControllerLogger.ROOT_LOGGER.httpManagementInterfaceIsUnsecured();
        }
        CapabilityServiceBuilder builder = serviceTarget.addCapability(UndertowHttpManagementService.EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY);
        Consumer hmConsumer = builder.provides(new RuntimeCapability[]{UndertowHttpManagementService.EXTENSIBLE_HTTP_MANAGEMENT_CAPABILITY});
        Supplier lrSupplier = builder.requires(RemotingServices.HTTP_LISTENER_REGISTRY);
        Supplier mcSupplier = builder.requires(DomainModelControllerService.SERVICE_NAME);
        Supplier ibSupplier = builder.requiresCapability("org.wildfly.network.interface", NetworkInterfaceBinding.class, new String[]{interfaceName});
        Supplier sibSupplier = builder.requiresCapability("org.wildfly.network.interface", NetworkInterfaceBinding.class, new String[]{secureInterfaceName});
        Supplier cpssSupplier = builder.requires(ControlledProcessStateService.SERVICE_NAME);
        Supplier rpSupplier = builder.requires(requestProcessorName);
        Supplier xwSupplier = builder.requires(ManagementWorkerService.SERVICE_NAME);
        Supplier eSupplier = builder.requires(ExternalManagementRequestExecutor.SERVICE_NAME);
        Supplier hafSupplier = httpAuthenticationFactory != null ? builder.requiresCapability(HTTP_AUTHENTICATION_FACTORY_CAPABILITY, HttpAuthenticationFactory.class, new String[]{httpAuthenticationFactory}) : null;
        Supplier srSupplier = securityRealm != null ? SecurityRealm.ServiceUtil.requires((ServiceBuilder)builder, (String)securityRealm) : null;
        Supplier scSupplier = sslContext != null ? builder.requiresCapability("org.wildfly.security.ssl-context", SSLContext.class, new String[]{sslContext}) : null;
        UndertowHttpManagementService service = new UndertowHttpManagementService(hmConsumer, lrSupplier, mcSupplier, null, null, null, ibSupplier, sibSupplier, cpssSupplier, rpSupplier, xwSupplier, eSupplier, hafSupplier, srSupplier, scSupplier, Integer.valueOf(port), Integer.valueOf(securePort), (Collection)commonPolicy.getAllowedOrigins(), consoleMode, this.environment.getProductConfig().getConsoleSlot());
        builder.setInstance((Service)service);
        builder.setInitialMode(onDemand ? ServiceController.Mode.ON_DEMAND : ServiceController.Mode.ACTIVE).install();
        ServiceName shutdownName = UndertowHttpManagementService.SERVICE_NAME.append(new String[]{"shutdown"});
        ServiceBuilder sb = serviceTarget.addService(shutdownName);
        Supplier executorSupplier = sb.requires(HostControllerService.HC_EXECUTOR_SERVICE_NAME);
        Supplier processorSupplier = sb.requires(requestProcessorName);
        Supplier registrySupplier = sb.requires(ManagementChannelRegistryService.SERVICE_NAME);
        sb.requires(UndertowHttpManagementService.SERVICE_NAME);
        sb.setInstance((Service)new HttpShutdownService(executorSupplier, processorSupplier, registrySupplier));
        sb.install();
        if (commonPolicy.isHttpUpgradeEnabled()) {
            NativeManagementServices.installRemotingServicesIfNotInstalled((ServiceTarget)serviceTarget, this.hostControllerInfo.getLocalHostName(), context.getServiceRegistry(true), onDemand);
            String httpConnectorName = port > -1 || securePort < 0 ? "http-management" : "https-management";
            RemotingHttpUpgradeService.installServices((OperationContext)context, (String)"http-management", (String)httpConnectorName, (ServiceName)ManagementRemotingServices.MANAGEMENT_ENDPOINT, (OptionMap)commonPolicy.getConnectorOptions(), (String)securityRealm, (String)commonPolicy.getSaslAuthenticationFactory());
            return Arrays.asList(UndertowHttpManagementService.SERVICE_NAME, RemotingHttpUpgradeService.HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}));
        }
        return Collections.singletonList(UndertowHttpManagementService.SERVICE_NAME);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        HttpManagementRemoveHandler.clearHostControllerInfo(this.hostControllerInfo);
    }

    static void populateHostControllerInfo(LocalHostControllerInfoImpl hostControllerInfo, OperationContext context, ModelNode model) throws OperationFailedException {
        hostControllerInfo.setHttpManagementInterface(HttpManagementResourceDefinition.INTERFACE.resolveModelAttribute(context, model).asString());
        ModelNode portNode = HttpManagementResourceDefinition.HTTP_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementPort(portNode.isDefined() ? portNode.asInt() : -1);
        ModelNode secureAddress = HttpManagementResourceDefinition.SECURE_INTERFACE.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementSecureInterface(secureAddress.isDefined() ? secureAddress.asString() : null);
        ModelNode securePortNode = HttpManagementResourceDefinition.HTTPS_PORT.resolveModelAttribute(context, model);
        hostControllerInfo.setHttpManagementSecurePort(securePortNode.isDefined() ? securePortNode.asInt() : -1);
    }
}

