/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.common.util.Time;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialModel;
import org.keycloak.credential.UserCredentialStore;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.FederatedIdentityModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserConsentModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.jpa.JpaUserCredentialStore;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.FederatedIdentityEntity;
import org.keycloak.models.jpa.entities.UserConsentClientScopeEntity;
import org.keycloak.models.jpa.entities.UserConsentEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.jpa.entities.UserGroupMembershipEntity;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.client.ClientStorageProvider;

public class JpaUserProvider
implements UserProvider,
UserCredentialStore {
    private static final String EMAIL = "email";
    private static final String USERNAME = "username";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private final KeycloakSession session;
    protected EntityManager em;
    private final JpaUserCredentialStore credentialStore;

    public JpaUserProvider(KeycloakSession session, EntityManager em) {
        this.session = session;
        this.em = em;
        this.credentialStore = new JpaUserCredentialStore(session, em);
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles, boolean addDefaultRequiredActions) {
        if (id == null) {
            id = KeycloakModelUtils.generateId();
        }
        UserEntity entity = new UserEntity();
        entity.setId(id);
        entity.setCreatedTimestamp(System.currentTimeMillis());
        entity.setUsername(username.toLowerCase());
        entity.setRealmId(realm.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(this.session, realm, this.em, entity);
        if (addDefaultRoles) {
            DefaultRoles.addDefaultRoles((RealmModel)realm, (UserModel)userModel);
            for (GroupModel g : realm.getDefaultGroups()) {
                userModel.joinGroupImpl(g);
            }
        }
        if (addDefaultRequiredActions) {
            for (RequiredActionProviderModel r : realm.getRequiredActionProviders()) {
                if (!r.isEnabled() || !r.isDefaultAction()) continue;
                userModel.addRequiredAction(r.getAlias());
            }
        }
        return userModel;
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.addUser(realm, KeycloakModelUtils.generateId(), username.toLowerCase(), true, true);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)user.getId());
        if (userEntity == null) {
            return false;
        }
        this.removeUser(userEntity);
        return true;
    }

    private void removeUser(UserEntity user) {
        String id = user.getId();
        this.em.createNamedQuery("deleteUserRoleMappingsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserGroupMembershipsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteFederatedIdentityByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentClientScopesByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByUser").setParameter("user", (Object)user).executeUpdate();
        this.em.flush();
        this.em.clear();
        user = (UserEntity)this.em.find(UserEntity.class, (Object)id, LockModeType.PESSIMISTIC_WRITE);
        if (user != null) {
            this.em.remove((Object)user);
        }
        this.em.flush();
    }

    public void addFederatedIdentity(RealmModel realm, UserModel user, FederatedIdentityModel identity) {
        FederatedIdentityEntity entity = new FederatedIdentityEntity();
        entity.setRealmId(realm.getId());
        entity.setIdentityProvider(identity.getIdentityProvider());
        entity.setUserId(identity.getUserId());
        entity.setUserName(identity.getUserName().toLowerCase());
        entity.setToken(identity.getToken());
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setUser(userEntity);
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void updateFederatedIdentity(RealmModel realm, UserModel federatedUser, FederatedIdentityModel federatedIdentityModel) {
        FederatedIdentityEntity federatedIdentity = this.findFederatedIdentity(federatedUser, federatedIdentityModel.getIdentityProvider(), LockModeType.PESSIMISTIC_WRITE);
        federatedIdentity.setToken(federatedIdentityModel.getToken());
        this.em.persist((Object)federatedIdentity);
        this.em.flush();
    }

    public boolean removeFederatedIdentity(RealmModel realm, UserModel user, String identityProvider) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider, LockModeType.PESSIMISTIC_WRITE);
        if (entity != null) {
            this.em.remove((Object)entity);
            this.em.flush();
            return true;
        }
        return false;
    }

    public void addConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId, LockModeType.NONE);
        if (consentEntity != null) {
            throw new ModelDuplicateException("Consent already exists for client [" + clientId + "] and user [" + userId + "]");
        }
        long currentTime = Time.currentTimeMillis();
        consentEntity = new UserConsentEntity();
        consentEntity.setId(KeycloakModelUtils.generateId());
        consentEntity.setUser((UserEntity)this.em.getReference(UserEntity.class, (Object)userId));
        StorageId clientStorageId = new StorageId(clientId);
        if (clientStorageId.isLocal()) {
            consentEntity.setClientId(clientId);
        } else {
            consentEntity.setClientStorageProvider(clientStorageId.getProviderId());
            consentEntity.setExternalClientId(clientStorageId.getExternalId());
        }
        consentEntity.setCreatedDate(currentTime);
        consentEntity.setLastUpdatedDate(currentTime);
        this.em.persist((Object)consentEntity);
        this.em.flush();
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public UserConsentModel getConsentByClient(RealmModel realm, String userId, String clientId) {
        UserConsentEntity entity = this.getGrantedConsentEntity(userId, clientId, LockModeType.NONE);
        return this.toConsentModel(realm, entity);
    }

    public List<UserConsentModel> getConsents(RealmModel realm, String userId) {
        TypedQuery query = this.em.createNamedQuery("userConsentsByUser", UserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        List results = query.getResultList();
        ArrayList<UserConsentModel> consents = new ArrayList<UserConsentModel>();
        for (UserConsentEntity entity : results) {
            UserConsentModel model = this.toConsentModel(realm, entity);
            consents.add(model);
        }
        return consents;
    }

    public void updateConsent(RealmModel realm, String userId, UserConsentModel consent) {
        String clientId = consent.getClient().getId();
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId, LockModeType.PESSIMISTIC_WRITE);
        if (consentEntity == null) {
            throw new ModelException("Consent not found for client [" + clientId + "] and user [" + userId + "]");
        }
        this.updateGrantedConsentEntity(consentEntity, consent);
    }

    public boolean revokeConsentForClient(RealmModel realm, String userId, String clientId) {
        UserConsentEntity consentEntity = this.getGrantedConsentEntity(userId, clientId, LockModeType.PESSIMISTIC_WRITE);
        if (consentEntity == null) {
            return false;
        }
        this.em.remove((Object)consentEntity);
        this.em.flush();
        return true;
    }

    private UserConsentEntity getGrantedConsentEntity(String userId, String clientId, LockModeType lockMode) {
        StorageId clientStorageId = new StorageId(clientId);
        String queryName = clientStorageId.isLocal() ? "userConsentByUserAndClient" : "userConsentByUserAndExternalClient";
        TypedQuery query = this.em.createNamedQuery(queryName, UserConsentEntity.class);
        query.setParameter("userId", (Object)userId);
        if (clientStorageId.isLocal()) {
            query.setParameter("clientId", (Object)clientId);
        } else {
            query.setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId());
            query.setParameter("externalClientId", (Object)clientStorageId.getExternalId());
        }
        query.setLockMode(lockMode);
        List results = query.getResultList();
        if (results.size() > 1) {
            throw new ModelException("More results found for user [" + userId + "] and client [" + clientId + "]");
        }
        if (results.size() == 1) {
            return (UserConsentEntity)results.get(0);
        }
        return null;
    }

    private UserConsentModel toConsentModel(RealmModel realm, UserConsentEntity entity) {
        if (entity == null) {
            return null;
        }
        StorageId clientStorageId = null;
        clientStorageId = entity.getClientId() == null ? new StorageId(entity.getClientStorageProvider(), entity.getExternalClientId()) : new StorageId(entity.getClientId());
        ClientModel client = realm.getClientById(clientStorageId.getId());
        if (client == null) {
            throw new ModelException("Client with id " + clientStorageId.getId() + " is not available");
        }
        UserConsentModel model = new UserConsentModel(client);
        model.setCreatedDate(entity.getCreatedDate());
        model.setLastUpdatedDate(entity.getLastUpdatedDate());
        Collection<UserConsentClientScopeEntity> grantedClientScopeEntities = entity.getGrantedClientScopes();
        if (grantedClientScopeEntities != null) {
            for (UserConsentClientScopeEntity grantedClientScope : grantedClientScopeEntities) {
                ClientScopeModel grantedClientScopeModel = KeycloakModelUtils.findClientScopeById((RealmModel)realm, (ClientModel)client, (String)grantedClientScope.getScopeId());
                if (grantedClientScopeModel == null) continue;
                model.addGrantedClientScope(grantedClientScopeModel);
            }
        }
        return model;
    }

    private void updateGrantedConsentEntity(UserConsentEntity consentEntity, UserConsentModel consentModel) {
        Collection<UserConsentClientScopeEntity> grantedClientScopeEntities = consentEntity.getGrantedClientScopes();
        HashSet<UserConsentClientScopeEntity> scopesToRemove = new HashSet<UserConsentClientScopeEntity>(grantedClientScopeEntities);
        for (ClientScopeModel clientScope : consentModel.getGrantedClientScopes()) {
            UserConsentClientScopeEntity grantedClientScopeEntity = new UserConsentClientScopeEntity();
            grantedClientScopeEntity.setUserConsent(consentEntity);
            grantedClientScopeEntity.setScopeId(clientScope.getId());
            if (!grantedClientScopeEntities.contains(grantedClientScopeEntity)) {
                this.em.persist((Object)grantedClientScopeEntity);
                this.em.flush();
                grantedClientScopeEntities.add(grantedClientScopeEntity);
                continue;
            }
            scopesToRemove.remove(grantedClientScopeEntity);
        }
        for (UserConsentClientScopeEntity toRemove : scopesToRemove) {
            grantedClientScopeEntities.remove(toRemove);
            this.em.remove((Object)toRemove);
        }
        consentEntity.setLastUpdatedDate(Time.currentTimeMillis());
        this.em.flush();
    }

    public void setNotBeforeForUser(RealmModel realm, UserModel user, int notBefore) {
        UserEntity entity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        entity.setNotBefore(notBefore);
    }

    public int getNotBeforeOfUser(RealmModel realm, UserModel user) {
        UserEntity entity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        return entity.getNotBefore();
    }

    public void grantToAllUsers(RealmModel realm, RoleModel role) {
        int num = this.em.createNamedQuery("grantRoleToAllUsers").setParameter("realmId", (Object)realm.getId()).setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm) {
        int num = this.em.createNamedQuery("deleteUserConsentClientScopesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRoleMappingsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRequiredActionsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedIdentityByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialsByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserAttributesByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUserGroupMembershipByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
        num = this.em.createNamedQuery("deleteUsersByRealm").setParameter("realmId", (Object)realm.getId()).executeUpdate();
    }

    public void removeImportedUsers(RealmModel realm, String storageProviderId) {
        int num = this.em.createNamedQuery("deleteUserRoleMappingsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserRequiredActionsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteFederatedIdentityByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteCredentialsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserAttributesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserGroupMembershipsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentClientScopesByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUserConsentsByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
        num = this.em.createNamedQuery("deleteUsersByRealmAndLink").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
    }

    public void unlinkUsers(RealmModel realm, String storageProviderId) {
        this.em.createNamedQuery("unlinkUsers").setParameter("realmId", (Object)realm.getId()).setParameter("link", (Object)storageProviderId).executeUpdate();
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.em.createNamedQuery("deleteUserRoleMappingsByRole").setParameter("roleId", (Object)role.getId()).executeUpdate();
    }

    public void preRemove(RealmModel realm, ClientModel client) {
        StorageId clientStorageId = new StorageId(client.getId());
        if (clientStorageId.isLocal()) {
            int num = this.em.createNamedQuery("deleteUserConsentClientScopesByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
            num = this.em.createNamedQuery("deleteUserConsentsByClient").setParameter("clientId", (Object)client.getId()).executeUpdate();
        } else {
            this.em.createNamedQuery("deleteUserConsentClientScopesByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
            this.em.createNamedQuery("deleteUserConsentsByExternalClient").setParameter("clientStorageProvider", (Object)clientStorageId.getProviderId()).setParameter("externalClientId", (Object)clientStorageId.getExternalId()).executeUpdate();
        }
    }

    public void preRemove(ProtocolMapperModel protocolMapper) {
    }

    public void preRemove(ClientScopeModel clientScope) {
        this.em.createNamedQuery("deleteUserConsentClientScopesByClientScope").setParameter("scopeId", (Object)clientScope.getId()).executeUpdate();
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        TypedQuery query = this.em.createNamedQuery("groupMembership", UserEntity.class);
        query.setParameter("groupId", (Object)group.getId());
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("usersInRole", UserEntity.class);
        query.setParameter("roleId", (Object)role.getId());
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    public void preRemove(RealmModel realm, GroupModel group) {
        this.em.createNamedQuery("deleteUserGroupMembershipsByGroup").setParameter("groupId", (Object)group.getId()).executeUpdate();
    }

    public UserModel getUserById(String id, RealmModel realm) {
        UserEntity userEntity = (UserEntity)this.em.find(UserEntity.class, (Object)id);
        if (userEntity == null || !realm.getId().equals(userEntity.getRealmId())) {
            return null;
        }
        return new UserAdapter(this.session, realm, this.em, userEntity);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByUsername", UserEntity.class);
        query.setParameter(USERNAME, (Object)username.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter(this.session, realm, this.em, (UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter(EMAIL, (Object)email.toLowerCase());
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        this.ensureEmailConstraint(results, realm);
        return new UserAdapter(this.session, realm, this.em, (UserEntity)results.get(0));
    }

    public void close() {
    }

    public UserModel getUserByFederatedIdentity(FederatedIdentityModel identity, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findUserByFederatedIdentityAndRealm", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("identityProvider", (Object)identity.getIdentityProvider());
        query.setParameter("userId", (Object)identity.getUserId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for identityProvider=" + identity.getIdentityProvider() + ", userId=" + identity.getUserId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(this.session, realm, this.em, user);
    }

    public UserModel getServiceAccount(ClientModel client) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByServiceAccount", UserEntity.class);
        query.setParameter("realmId", (Object)client.getRealm().getId());
        query.setParameter("clientInternalId", (Object)client.getId());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More service account linked users found for client=" + client.getClientId() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(this.session, client.getRealm(), this.em, user);
    }

    public List<UserModel> getUsers(RealmModel realm, boolean includeServiceAccounts) {
        return this.getUsers(realm, -1, -1, includeServiceAccounts);
    }

    public int getUsersCount(RealmModel realm, boolean includeServiceAccount) {
        String namedQuery = "getRealmUserCountExcludeServiceAccount";
        if (includeServiceAccount) {
            namedQuery = "getRealmUserCount";
        }
        Object count = this.em.createNamedQuery(namedQuery).setParameter("realmId", (Object)realm.getId()).getSingleResult();
        return ((Number)count).intValue();
    }

    public int getUsersCount(RealmModel realm) {
        return this.getUsersCount(realm, false);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getUsers(realm, firstResult, maxResults, false);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults, boolean includeServiceAccounts) {
        String queryName = includeServiceAccounts ? "getAllUsersByRealm" : "getAllUsersByRealmExcludeServiceAccount";
        TypedQuery query = this.em.createNamedQuery(queryName, UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(this.session, realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("groupMembership", UserEntity.class);
        query.setParameter("groupId", (Object)group.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    public List<UserModel> getRoleMembers(RealmModel realm, RoleModel role, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("usersInRole", UserEntity.class);
        query.setParameter("roleId", (Object)role.getId());
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, -1, -1);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        TypedQuery query = this.em.createNamedQuery("searchForUser", UserEntity.class);
        query.setParameter("realmId", (Object)realm.getId());
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        List results = query.getResultList();
        LinkedList<UserModel> users = new LinkedList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(this.session, realm, this.em, entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUser(attributes, realm, -1, -1);
    }

    public List<UserModel> searchForUser(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(UserEntity.class);
        Root root = queryBuilder.from(UserEntity.class);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realmId"), (Object)realm.getId()));
        if (!((Boolean)this.session.getAttributeOrDefault("keycloak.session.realm.users.query.include_service_account", (Object)true)).booleanValue()) {
            predicates.add(root.get("serviceAccountClientLink").isNull());
        }
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null) continue;
            switch (key) {
                case "username": 
                case "firstName": 
                case "lastName": 
                case "email": {
                    predicates.add(builder.like(builder.lower((Expression)root.get(key)), "%" + value.toLowerCase() + "%"));
                }
            }
        }
        Set userGroups = (Set)this.session.getAttribute("keycloak.session.realm.users.query.groups");
        if (userGroups != null) {
            Subquery subquery = queryBuilder.subquery(String.class);
            Root from = subquery.from(UserGroupMembershipEntity.class);
            subquery.select(builder.literal((Object)1));
            ArrayList<Predicate> subPredicates = new ArrayList<Predicate>();
            subPredicates.add(from.get("groupId").in((Collection)userGroups));
            subPredicates.add(builder.equal((Expression)from.get("user").get("id"), (Expression)root.get("id")));
            Subquery subquery1 = queryBuilder.subquery(String.class);
            subquery1.select(builder.literal((Object)1));
            Root from1 = subquery1.from(ResourceEntity.class);
            ArrayList<Predicate> subs = new ArrayList<Predicate>();
            Path groupId = from.get("groupId");
            subs.add(builder.like((Expression)from1.get("name"), builder.concat("group.resource.", (Expression)groupId)));
            subquery1.where(subs.toArray(new Predicate[subs.size()]));
            subPredicates.add(builder.exists(subquery1));
            subquery.where(subPredicates.toArray(new Predicate[subPredicates.size()]));
            predicates.add(builder.exists(subquery));
        }
        queryBuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get(USERNAME))});
        TypedQuery query = this.em.createQuery(queryBuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        ArrayList<UserModel> results = new ArrayList<UserModel>();
        UserProvider users = this.session.users();
        for (UserEntity entity : query.getResultList()) {
            results.add(users.getUserById(entity.getId(), realm));
        }
        return results;
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("getRealmUsersByAttributeNameAndValue", UserEntity.class);
        query.setParameter("name", (Object)attrName);
        query.setParameter("value", (Object)attrValue);
        query.setParameter("realmId", (Object)realm.getId());
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity user : results) {
            users.add(new UserAdapter(this.session, realm, this.em, user));
        }
        return users;
    }

    private FederatedIdentityEntity findFederatedIdentity(UserModel user, String identityProvider, LockModeType lockMode) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUserAndProvider", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        query.setParameter("identityProvider", (Object)identityProvider);
        query.setLockMode(lockMode);
        List results = query.getResultList();
        return results.size() > 0 ? (FederatedIdentityEntity)results.get(0) : null;
    }

    public Set<FederatedIdentityModel> getFederatedIdentities(UserModel user, RealmModel realm) {
        TypedQuery query = this.em.createNamedQuery("findFederatedIdentityByUser", FederatedIdentityEntity.class);
        UserEntity userEntity = (UserEntity)this.em.getReference(UserEntity.class, (Object)user.getId());
        query.setParameter("user", (Object)userEntity);
        List results = query.getResultList();
        HashSet<FederatedIdentityModel> set = new HashSet<FederatedIdentityModel>();
        for (FederatedIdentityEntity entity : results) {
            set.add(new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken()));
        }
        return set;
    }

    public FederatedIdentityModel getFederatedIdentity(UserModel user, String identityProvider, RealmModel realm) {
        FederatedIdentityEntity entity = this.findFederatedIdentity(user, identityProvider, LockModeType.NONE);
        return entity != null ? new FederatedIdentityModel(entity.getIdentityProvider(), entity.getUserId(), entity.getUserName(), entity.getToken()) : null;
    }

    public void preRemove(RealmModel realm, ComponentModel component) {
        if (component.getProviderType().equals(UserStorageProvider.class.getName())) {
            this.removeImportedUsers(realm, component.getId());
        }
        if (component.getProviderType().equals(ClientStorageProvider.class.getName())) {
            this.removeConsentByClientStorageProvider(realm, component.getId());
        }
    }

    protected void removeConsentByClientStorageProvider(RealmModel realm, String providerId) {
        this.em.createNamedQuery("deleteUserConsentClientScopesByClientStorageProvider").setParameter("clientStorageProvider", (Object)providerId).executeUpdate();
        this.em.createNamedQuery("deleteUserConsentsByClientStorageProvider").setParameter("clientStorageProvider", (Object)providerId).executeUpdate();
    }

    public void updateCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        this.credentialStore.updateCredential(realm, user, cred);
    }

    public CredentialModel createCredential(RealmModel realm, UserModel user, CredentialModel cred) {
        CredentialEntity entity = this.credentialStore.createCredentialEntity(realm, user, cred);
        UserEntity userEntity = this.userInEntityManagerContext(user.getId());
        if (userEntity != null) {
            userEntity.getCredentials().add(entity);
        }
        return this.toModel(entity);
    }

    public boolean removeStoredCredential(RealmModel realm, UserModel user, String id) {
        CredentialEntity entity = this.credentialStore.removeCredentialEntity(realm, user, id);
        UserEntity userEntity = this.userInEntityManagerContext(user.getId());
        if (entity != null && userEntity != null) {
            userEntity.getCredentials().remove(entity);
        }
        return entity != null;
    }

    public CredentialModel getStoredCredentialById(RealmModel realm, UserModel user, String id) {
        return this.credentialStore.getStoredCredentialById(realm, user, id);
    }

    protected CredentialModel toModel(CredentialEntity entity) {
        return this.credentialStore.toModel(entity);
    }

    public List<CredentialModel> getStoredCredentials(RealmModel realm, UserModel user) {
        return this.credentialStore.getStoredCredentials(realm, user);
    }

    public List<CredentialModel> getStoredCredentialsByType(RealmModel realm, UserModel user, String type) {
        UserEntity userEntity = this.userInEntityManagerContext(user.getId());
        if (userEntity != null) {
            List results = userEntity.getCredentials().stream().filter(it -> type.equals(it.getType())).collect(Collectors.toList());
            LinkedList<CredentialModel> rtn = new LinkedList<CredentialModel>();
            for (CredentialEntity entity : results) {
                rtn.add(this.toModel(entity));
            }
            return rtn;
        }
        return this.credentialStore.getStoredCredentialsByType(realm, user, type);
    }

    public CredentialModel getStoredCredentialByNameAndType(RealmModel realm, UserModel user, String name, String type) {
        return this.credentialStore.getStoredCredentialByNameAndType(realm, user, name, type);
    }

    public boolean moveCredentialTo(RealmModel realm, UserModel user, String id, String newPreviousCredentialId) {
        return this.credentialStore.moveCredentialTo(realm, user, id, newPreviousCredentialId);
    }

    protected void ensureEmailConstraint(List<UserEntity> users, RealmModel realm) {
        UserEntity user = users.get(0);
        if (users.size() > 1) {
            throw new ModelDuplicateException("Multiple users with email '" + user.getEmail() + "' exist in Keycloak.");
        }
        if (realm.isDuplicateEmailsAllowed()) {
            return;
        }
        if (user.getEmail() != null && !user.getEmail().equals(user.getEmailConstraint())) {
            user.setEmailConstraint(user.getEmail());
            this.em.persist((Object)user);
        }
    }

    private UserEntity userInEntityManagerContext(String id) {
        UserEntity user = (UserEntity)this.em.getReference(UserEntity.class, (Object)id);
        boolean isLoaded = this.em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded((Object)user);
        return isLoaded ? user : null;
    }
}

