/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.entityprovider;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ProxyClassLoader
extends ClassLoader {
    private Set<ClassLoader> classloaders;

    public ProxyClassLoader(Collection<Class<?>> classes, ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.init(classes);
    }

    public ProxyClassLoader(Collection<Class<?>> classes) {
        this.init(classes);
    }

    private void init(Collection<Class<?>> classes) {
        this.classloaders = new HashSet<ClassLoader>();
        for (Class<?> clazz : classes) {
            this.classloaders.add(clazz.getClassLoader());
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader classloader : this.classloaders) {
            try {
                return classloader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.loadClass(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader classloader : this.classloaders) {
            URL resource = classloader.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return super.getResource(name);
    }
}

