/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.attestation.authenticator;

import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.util.ArrayUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class AttestedCredentialData
implements Serializable {
    private final AAGUID aaguid;
    private final byte[] credentialId;
    private final COSEKey coseKey;

    public AttestedCredentialData(AAGUID aaguid, byte[] credentialId, COSEKey coseKey) {
        this.aaguid = aaguid;
        this.credentialId = credentialId;
        this.coseKey = coseKey;
    }

    public AttestedCredentialData() {
        this.aaguid = null;
        this.credentialId = null;
        this.coseKey = null;
    }

    public AAGUID getAaguid() {
        return this.aaguid;
    }

    public byte[] getCredentialId() {
        return ArrayUtil.clone((byte[])this.credentialId);
    }

    public COSEKey getCOSEKey() {
        return this.coseKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttestedCredentialData that = (AttestedCredentialData)o;
        return Objects.equals(this.aaguid, that.aaguid) && Arrays.equals(this.credentialId, that.credentialId) && Objects.equals(this.coseKey, that.coseKey);
    }

    public int hashCode() {
        int result = Objects.hash(this.aaguid, this.coseKey);
        result = 31 * result + Arrays.hashCode(this.credentialId);
        return result;
    }
}

