/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.webauthn4j.data.extension.client.ExtensionClientInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

public class ExtensionClientInputDeserializer
extends StdDeserializer<ExtensionClientInput> {
    public ExtensionClientInputDeserializer() {
        super(ExtensionClientInput.class);
    }

    public ExtensionClientInput deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String name = p.getParsingContext().getCurrentName();
        if (name == null) {
            name = p.getParsingContext().getParent().getCurrentName();
        }
        DeserializationConfig config = ctxt.getConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)config, ExtensionClientInput.class);
        Collection namedTypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)config, annotatedClass);
        for (NamedType namedType : namedTypes) {
            if (!Objects.equals(namedType.getName(), name)) continue;
            return (ExtensionClientInput)ctxt.readValue(p, namedType.getType());
        }
        throw new InvalidFormatException(p, "value is out of range", (Object)name, ExtensionClientInput.class);
    }
}

