/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kotlinx.coroutines.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.kotlinx.coroutines.CancellableContinuation;
import org.jetbrains.kotlin.kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.kotlin.kotlinx.coroutines.DebugKt;
import org.jetbrains.kotlin.kotlinx.coroutines.Delay;
import org.jetbrains.kotlin.kotlinx.coroutines.DisposableHandle;
import org.jetbrains.kotlin.kotlinx.coroutines.EventLoop;
import org.jetbrains.kotlin.kotlinx.coroutines.ObsoleteCoroutinesApi;
import org.jetbrains.kotlin.kotlinx.coroutines.internal.ThreadSafeHeap;
import org.jetbrains.kotlin.kotlinx.coroutines.internal.ThreadSafeHeapNode;
import org.jetbrains.kotlin.kotlinx.coroutines.test.TimedRunnable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0001<B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J$\u0010\u001d\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0 J$\u0010\"\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0 J*\u0010#\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0018\u0010\u001f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020!0 J$\u0010$\u001a\u00020\u001b2\b\b\u0002\u0010\u001e\u001a\u00020\u00032\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020!0 J\u0006\u0010%\u001a\u00020\u001bJ\u0014\u0010&\u001a\u00020\u001b2\n\u0010'\u001a\u00060(j\u0002`)H\u0002J5\u0010*\u001a\u0002H+\"\u0004\b\u0000\u0010+2\u0006\u0010,\u001a\u0002H+2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u0002H+\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H+0.H\u0016\u00a2\u0006\u0002\u00100J(\u00101\u001a\u0004\u0018\u0001H2\"\b\b\u0000\u00102*\u00020/2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H204H\u0096\u0002\u00a2\u0006\u0002\u00105J\u0014\u00106\u001a\u00020\u00012\n\u00103\u001a\u0006\u0012\u0002\b\u000304H\u0016J\u0010\u00107\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u001c\u00108\u001a\u00020\u00122\n\u0010'\u001a\u00060(j\u0002`)2\u0006\u0010\u0017\u001a\u00020\u0006H\u0002J\b\u00109\u001a\u00020\u0006H\u0002J\b\u0010:\u001a\u00020\u0003H\u0016J\u0006\u0010;\u001a\u00020\u001bJ\u0010\u0010;\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/test/TestCoroutineContext;", "Lkotlin/coroutines/CoroutineContext;", "name", "", "(Ljava/lang/String;)V", "counter", "", "ctxDispatcher", "Lorg/jetbrains/kotlin/kotlinx/coroutines/test/TestCoroutineContext$Dispatcher;", "ctxHandler", "Lorg/jetbrains/kotlin/kotlinx/coroutines/CoroutineExceptionHandler;", "exceptions", "", "", "getExceptions", "()Ljava/util/List;", "queue", "Lorg/jetbrains/kotlin/kotlinx/coroutines/internal/ThreadSafeHeap;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/test/TimedRunnable;", "time", "uncaughtExceptions", "", "advanceTimeBy", "delayTime", "unit", "Ljava/util/concurrent/TimeUnit;", "advanceTimeTo", "", "targetTime", "assertAllUnhandledExceptions", "message", "predicate", "Lkotlin/Function1;", "", "assertAnyUnhandledException", "assertExceptions", "assertUnhandledException", "cancelAllActions", "enqueue", "block", "Ljava/lang/Runnable;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Runnable;", "fold", "R", "initial", "operation", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext$Element;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "get", "E", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext$Element;", "minusKey", "now", "postDelayed", "processNextEvent", "toString", "triggerActions", "Dispatcher", "kotlinx-coroutines-core"})
@ObsoleteCoroutinesApi
public final class TestCoroutineContext
implements CoroutineContext {
    private final List<Throwable> uncaughtExceptions;
    private final Dispatcher ctxDispatcher;
    private final CoroutineExceptionHandler ctxHandler;
    private final ThreadSafeHeap<TimedRunnable> queue;
    private long counter;
    private long time;
    private final String name;

    @NotNull
    public final List<Throwable> getExceptions() {
        return this.uncaughtExceptions;
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)operation.invoke(operation.invoke(initial, (Object)this.ctxDispatcher), (Object)this.ctxHandler);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        CoroutineContext.Element element;
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        if (key == ContinuationInterceptor.Key) {
            Dispatcher dispatcher = this.ctxDispatcher;
            if (dispatcher == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            element = (CoroutineContext.Element)dispatcher;
        } else if (key == CoroutineExceptionHandler.Key) {
            CoroutineExceptionHandler coroutineExceptionHandler = this.ctxHandler;
            if (coroutineExceptionHandler == null) {
                throw new TypeCastException("null cannot be cast to non-null type E");
            }
            element = coroutineExceptionHandler;
        } else {
            element = null;
        }
        return (E)element;
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        return key == ContinuationInterceptor.Key ? (CoroutineContext)this.ctxHandler : (key == CoroutineExceptionHandler.Key ? (CoroutineContext)this.ctxDispatcher : (CoroutineContext)this);
    }

    public final long now(@NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        return unit.convert(this.time, TimeUnit.NANOSECONDS);
    }

    public static /* synthetic */ long now$default(TestCoroutineContext testCoroutineContext, TimeUnit timeUnit, int n, Object object) {
        if ((n & 1) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return testCoroutineContext.now(timeUnit);
    }

    public final long advanceTimeBy(long delayTime, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        long oldTime = this.time;
        this.advanceTimeTo(oldTime + unit.toNanos(delayTime), TimeUnit.NANOSECONDS);
        return unit.convert(this.time - oldTime, TimeUnit.NANOSECONDS);
    }

    public static /* synthetic */ long advanceTimeBy$default(TestCoroutineContext testCoroutineContext, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        return testCoroutineContext.advanceTimeBy(l, timeUnit);
    }

    public final void advanceTimeTo(long targetTime, @NotNull TimeUnit unit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)unit), (String)"unit");
        long nanoTime = unit.toNanos(targetTime);
        this.triggerActions(nanoTime);
        if (nanoTime > this.time) {
            this.time = nanoTime;
        }
    }

    public static /* synthetic */ void advanceTimeTo$default(TestCoroutineContext testCoroutineContext, long l, TimeUnit timeUnit, int n, Object object) {
        if ((n & 2) != 0) {
            timeUnit = TimeUnit.MILLISECONDS;
        }
        testCoroutineContext.advanceTimeTo(l, timeUnit);
    }

    public final void triggerActions() {
        this.triggerActions(this.time);
    }

    public final void cancelAllActions() {
        if (!this.queue.isEmpty()) {
            this.queue.clear();
        }
    }

    public final void assertUnhandledException(@NotNull String message2, @NotNull Function1<? super Throwable, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        if (this.uncaughtExceptions.size() != 1 || !((Boolean)predicate.invoke((Object)this.uncaughtExceptions.get(0))).booleanValue()) {
            throw (Throwable)((Object)new AssertionError((Object)message2));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertUnhandledException$default(TestCoroutineContext testCoroutineContext, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        testCoroutineContext.assertUnhandledException(string, (Function1<? super Throwable, Boolean>)function1);
    }

    public final void assertAllUnhandledExceptions(@NotNull String message2, @NotNull Function1<? super Throwable, Boolean> predicate) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Iterable $receiver$iv = this.uncaughtExceptions;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    if (((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            throw (Throwable)((Object)new AssertionError((Object)message2));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertAllUnhandledExceptions$default(TestCoroutineContext testCoroutineContext, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        testCoroutineContext.assertAllUnhandledExceptions(string, (Function1<? super Throwable, Boolean>)function1);
    }

    public final void assertAnyUnhandledException(@NotNull String message2, @NotNull Function1<? super Throwable, Boolean> predicate) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            Iterable $receiver$iv = this.uncaughtExceptions;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    if (!((Boolean)predicate.invoke(element$iv)).booleanValue()) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            throw (Throwable)((Object)new AssertionError((Object)message2));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertAnyUnhandledException$default(TestCoroutineContext testCoroutineContext, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        testCoroutineContext.assertAnyUnhandledException(string, (Function1<? super Throwable, Boolean>)function1);
    }

    public final void assertExceptions(@NotNull String message2, @NotNull Function1<? super List<? extends Throwable>, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        if (!((Boolean)predicate.invoke(this.uncaughtExceptions)).booleanValue()) {
            throw (Throwable)((Object)new AssertionError((Object)message2));
        }
        this.uncaughtExceptions.clear();
    }

    public static /* synthetic */ void assertExceptions$default(TestCoroutineContext testCoroutineContext, String string, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        testCoroutineContext.assertExceptions(string, (Function1<? super List<? extends Throwable>, Boolean>)function1);
    }

    private final void enqueue(Runnable block) {
        long l = this.counter;
        this.counter = l + 1L;
        this.queue.addLast((TimedRunnable)((ThreadSafeHeapNode)new TimedRunnable(block, l, 0L, 4, null)));
    }

    private final TimedRunnable postDelayed(Runnable block, long delayTime) {
        TimedRunnable timedRunnable;
        long l = this.counter;
        this.counter = l + 1L;
        TimedRunnable it = timedRunnable = new TimedRunnable(block, l, this.time + TimeUnit.MILLISECONDS.toNanos(delayTime));
        boolean bl = false;
        this.queue.addLast((TimedRunnable)((ThreadSafeHeapNode)it));
        return timedRunnable;
    }

    private final long processNextEvent() {
        TimedRunnable current = this.queue.peek();
        if (current != null) {
            this.triggerActions(current.time);
        }
        return this.queue.isEmpty() ? Long.MAX_VALUE : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void triggerActions(long targetTime) {
        while (true) {
            TimedRunnable current;
            TimedRunnable timedRunnable;
            ThreadSafeHeap<TimedRunnable> this_$iv = this.queue;
            boolean $i$f$removeFirstIf = false;
            ThreadSafeHeap<TimedRunnable> lock$iv$iv = this_$iv;
            boolean $i$f$synchronized = false;
            synchronized (lock$iv$iv) {
                TimedRunnable timedRunnable2;
                TimedRunnable first$iv;
                block7: {
                    boolean bl = false;
                    if (this_$iv.firstImpl() != null) break block7;
                    TimedRunnable timedRunnable3 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 2, 4] lbl12 : MonitorExitStatement: MONITOREXIT : lock$iv$iv
                    timedRunnable = timedRunnable3;
                }
                TimedRunnable it = first$iv = timedRunnable2;
                boolean bl = false;
                TimedRunnable timedRunnable4 = it.time <= targetTime ? this_$iv.removeAtImpl(0) : null;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 4] lbl19 : MonitorExitStatement: MONITOREXIT : lock$iv$iv
                timedRunnable = timedRunnable4;
            }
            if ((TimedRunnable)timedRunnable == null) {
                break;
            }
            if (current.time != 0L) {
                this.time = current.time;
            }
            current.run();
        }
    }

    @NotNull
    public String toString() {
        String string = this.name;
        if (string == null) {
            string = "TestCoroutineContext@" + DebugKt.getHexAddress(this);
        }
        return string;
    }

    public TestCoroutineContext(@Nullable String name) {
        this.name = name;
        TestCoroutineContext testCoroutineContext = this;
        Object object = new ArrayList();
        testCoroutineContext.uncaughtExceptions = object;
        this.ctxDispatcher = new Dispatcher();
        testCoroutineContext = this;
        boolean $i$f$CoroutineExceptionHandler = false;
        testCoroutineContext.ctxHandler = object = (CoroutineExceptionHandler)new CoroutineExceptionHandler(CoroutineExceptionHandler.Key, this){
            final /* synthetic */ TestCoroutineContext this$0;
            {
                this.this$0 = testCoroutineContext;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void handleException(@NotNull CoroutineContext context2, @NotNull Throwable exception) {
                void exception2;
                Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
                Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
                Throwable throwable = exception;
                CoroutineContext $noName_0 = context2;
                boolean bl = false;
                Collection collection = TestCoroutineContext.access$getUncaughtExceptions$p(this.this$0);
                collection.add(exception2);
            }
        };
        this.queue = new ThreadSafeHeap();
    }

    public /* synthetic */ TestCoroutineContext(String string, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public TestCoroutineContext() {
        this(null, 1, null);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        return CoroutineContext.DefaultImpls.plus((CoroutineContext)this, (CoroutineContext)context2);
    }

    public static final /* synthetic */ ThreadSafeHeap access$getQueue$p(TestCoroutineContext $this) {
        return $this.queue;
    }

    public static final /* synthetic */ List access$getUncaughtExceptions$p(TestCoroutineContext $this) {
        return $this.uncaughtExceptions;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0016J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\b\u001a\u00060\tj\u0002`\nH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/kotlinx/coroutines/test/TestCoroutineContext$Dispatcher;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/EventLoop;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Delay;", "(Lkotlinx/coroutines/test/TestCoroutineContext;)V", "dispatch", "", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lorg/jetbrains/kotlin/kotlinx/coroutines/Runnable;", "invokeOnTimeout", "Lorg/jetbrains/kotlin/kotlinx/coroutines/DisposableHandle;", "timeMillis", "", "processNextEvent", "scheduleResumeAfterDelay", "continuation", "Lorg/jetbrains/kotlin/kotlinx/coroutines/CancellableContinuation;", "shouldBeProcessedFromContext", "", "toString", "", "kotlinx-coroutines-core"})
    private final class Dispatcher
    extends EventLoop
    implements Delay {
        @Override
        public void dispatch(@NotNull CoroutineContext context2, @NotNull Runnable block) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            TestCoroutineContext.this.enqueue(block);
        }

        @Override
        public boolean shouldBeProcessedFromContext() {
            return true;
        }

        @Override
        public void scheduleResumeAfterDelay(long timeMillis, @NotNull CancellableContinuation<? super Unit> continuation2) {
            Intrinsics.checkParameterIsNotNull(continuation2, (String)"continuation");
            TestCoroutineContext testCoroutineContext = TestCoroutineContext.this;
            boolean $i$f$Runnable = false;
            Runnable runnable = new Runnable(this, continuation2){
                final /* synthetic */ Dispatcher this$0;
                final /* synthetic */ CancellableContinuation $continuation$inlined;
                {
                    this.this$0 = dispatcher;
                    this.$continuation$inlined = cancellableContinuation;
                }

                public final void run() {
                    CancellableContinuation cancellableContinuation;
                    boolean bl = false;
                    CancellableContinuation $receiver = cancellableContinuation = this.$continuation$inlined;
                    boolean bl2 = false;
                    $receiver.resumeUndispatched(this.this$0, Unit.INSTANCE);
                }
            };
            testCoroutineContext.postDelayed(runnable, timeMillis);
        }

        @Override
        @NotNull
        public DisposableHandle invokeOnTimeout(long timeMillis, @NotNull Runnable block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            TimedRunnable node = TestCoroutineContext.this.postDelayed(block, timeMillis);
            return new DisposableHandle(this, node){
                final /* synthetic */ Dispatcher this$0;
                final /* synthetic */ TimedRunnable $node;

                public void dispose() {
                    TestCoroutineContext.access$getQueue$p(this.this$0.TestCoroutineContext.this).remove((ThreadSafeHeapNode)this.$node);
                }
                {
                    this.this$0 = $outer;
                    this.$node = $captured_local_variable$1;
                }
            };
        }

        @Override
        public long processNextEvent() {
            return TestCoroutineContext.this.processNextEvent();
        }

        @Override
        @NotNull
        public String toString() {
            return "Dispatcher(" + TestCoroutineContext.this + ')';
        }

        public Dispatcher() {
            EventLoop.incrementUseCount$default(this, false, 1, null);
        }

        @Override
        @Nullable
        public Object delay(long time, @NotNull Continuation<? super Unit> continuation2) {
            return Delay.DefaultImpls.delay(this, time, continuation2);
        }
    }
}

