/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.util.LazyInitializer;
import org.jetbrains.kotlin.org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.jetbrains.kotlin.org.apache.batik.anim.dom.SVGDOMImplementation;
import org.jetbrains.kotlin.org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.jetbrains.kotlin.org.apache.batik.transcoder.TranscoderException;
import org.jetbrains.kotlin.org.apache.batik.transcoder.TranscoderInput;
import org.jetbrains.kotlin.org.apache.batik.transcoder.image.ImageTranscoder;
import org.jetbrains.kotlin.org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SVGLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.SVGLoader");
    private static SvgColorPatcher ourColorPatcher = null;
    public static final LazyInitializer.NotNullValue<Double> ICON_MAX_SIZE = new LazyInitializer.NotNullValue<Double>(){

        @Override
        @NotNull
        public Double initialize() {
            double maxSize = 2.147483647E9;
            if (!GraphicsEnvironment.isHeadless()) {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                Rectangle bounds = device.getDefaultConfiguration().getBounds();
                AffineTransform tx = device.getDefaultConfiguration().getDefaultTransform();
                maxSize = (int)Math.max((double)bounds.width * tx.getScaleX(), (double)bounds.height * tx.getScaleY());
            }
            Double d = maxSize;
            if (d == null) {
                1.$$$reportNull$$$0(0);
            }
            return d;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/SVGLoader$1", "initialize"));
        }
    };
    private final TranscoderInput myTranscoderInput;
    private final double myScale;
    private final double myOverridenWidth;
    private final double myOverridenHeight;
    private BufferedImage myImage;

    public static Image load(@Nullable URL url, @NotNull InputStream stream, double scale) throws IOException {
        if (stream == null) {
            SVGLoader.$$$reportNull$$$0(2);
        }
        try {
            return new SVGLoader(url, stream, scale).createImage();
        }
        catch (TranscoderException ex) {
            throw new IOException(ex);
        }
    }

    private SVGLoader(@Nullable URL url, InputStream stream, double scale) throws IOException {
        this(url, stream, -1.0, -1.0, scale);
    }

    private SVGLoader(@Nullable URL url, InputStream stream, double width, double height, double scale) throws IOException {
        String uri = null;
        try {
            if (url != null && "jar".equals(url.getProtocol()) && stream != null) {
                url = new URL(url.getPath());
            }
            uri = url != null ? url.toURI().toString() : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Document document = new MySAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName()).createDocument(uri, stream);
        if (document == null) {
            throw new IOException("document not created");
        }
        SVGLoader.patchColors(document);
        this.myTranscoderInput = new TranscoderInput(document);
        this.myOverridenWidth = width;
        this.myOverridenHeight = height;
        this.myScale = scale;
    }

    private static void patchColors(Document document) {
        if (ourColorPatcher != null) {
            ourColorPatcher.patchColors(document.getDocumentElement());
        }
    }

    private BufferedImage createImage() throws TranscoderException {
        MyTranscoder transcoder = new MyTranscoder();
        if (this.myOverridenWidth != -1.0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, new Float(this.myOverridenWidth));
        }
        if (this.myOverridenHeight != -1.0) {
            transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_HEIGHT, new Float(this.myOverridenHeight));
        }
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_WIDTH, new Float(ICON_MAX_SIZE.get()));
        transcoder.addTranscodingHint(SVGAbstractTranscoder.KEY_MAX_HEIGHT, new Float(ICON_MAX_SIZE.get()));
        transcoder.transcode(this.myTranscoderInput, null);
        return this.myImage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/SVGLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/SVGLoader";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFallbackPlaceholder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadHiDPI";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDocumentSize";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMaxZoomFactor";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySVGDOMImplementation
    extends SVGDOMImplementation {
        private MySVGDOMImplementation() {
        }

        static {
            svg11Factories.put("rect", new SVGDOMImplementation.RectElementFactory(){});
        }
    }

    private static class MySAXSVGDocumentFactory
    extends SAXSVGDocumentFactory {
        MySAXSVGDocumentFactory(String parser) {
            super(parser);
            this.implementation = new MySVGDOMImplementation();
        }
    }

    public static interface SvgColorPatcher {
        public void patchColors(Element var1);
    }

    private class MyTranscoder
    extends ImageTranscoder {
        protected MyTranscoder() {
            this.width = 16.0f;
            this.height = 16.0f;
        }
    }
}

