/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.tasks;

import java.util.IllegalFormatException;
import java.util.List;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.exif.ExifWriter;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.BackgroundTask;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class ExifWriterTask
extends BackgroundTask<ImageInfo> {
    private static final I18n i18n = I18nFactory.getI18n(ExifWriterTask.class);
    private ImagesTableModel imagesTableModel;
    private List<ImageInfo> imageInfos;
    private int currentProgress = 0;

    public ExifWriterTask(String name, ImagesTableModel imagestableModel, List<ImageInfo> imageInfos) {
        super(name);
        this.imagesTableModel = imagestableModel;
        this.imageInfos = imageInfos;
    }

    @Override
    public int getCurrentProgress() {
        return this.currentProgress;
    }

    @Override
    public int getMaxProgress() {
        return this.imageInfos.size();
    }

    @Override
    public int getMinProgress() {
        return 1;
    }

    @Override
    protected String doInBackground() throws Exception {
        int imagesUpdated = 0;
        for (ImageInfo imageInfo : this.imageInfos) {
            if (this.interruptRequested()) break;
            ++this.currentProgress;
            this.setProgressMessage();
            try {
                ExifWriter exifWriter = new ExifWriter();
                if (!exifWriter.write(imageInfo)) continue;
                ++imagesUpdated;
                imageInfo.setSource(ImageInfo.DATA_SOURCE.IMAGE);
                this.publish(imageInfo);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
        String result = null;
        if (imagesUpdated == 1) {
            result = i18n.tr("One image updated.");
        } else {
            try {
                result = String.format(i18n.tr("%d images updated."), imagesUpdated);
            }
            catch (IllegalFormatException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    @Override
    protected void process(List<ImageInfo> chunks) {
        for (ImageInfo imageInfo : chunks) {
            int imageRow = this.imagesTableModel.getRow(imageInfo);
            this.imagesTableModel.fireTableRowsUpdated(imageRow, imageRow);
        }
    }
}

