define(["appHeader","itemShortcuts","itemContextMenu","backdrop","appRouter","playbackManager","dom","inputmanager","datetime","itemHelper","mediaInfo","focusManager","imageLoader","events","connectionManager","browser","globalize","apphost","layoutManager","userSettings","./playqueue","./tvplayqueue","scrollStyles","emby-slider","paper-icon-button-light","css!./videoosd"],function(appHeader,itemShortcuts,itemContextMenu,backdrop,appRouter,playbackManager,dom,inputManager,datetime,itemHelper,mediaInfo,focusManager,imageLoader,events,connectionManager,browser,globalize,appHost,layoutManager,userSettings,OsdPlayQueue,TvPlayQueue){"use strict";function seriesImageUrl(item,options){return"Episode"!==item.Type?null:((options=options||{}).type=options.type||"Primary","Primary"===options.type&&item.SeriesPrimaryImageTag?(options.tag=item.SeriesPrimaryImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.SeriesId,options)):"Thumb"===options.type&&item.ParentThumbImageTag?(options.tag=item.ParentThumbImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.ParentThumbItemId,options)):null)}function imageUrl(item,options){return(options=options||{}).type=options.type||"Primary",item.ImageTags&&item.ImageTags[options.type]?(options.tag=item.ImageTags[options.type],connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.PrimaryImageItemId||item.Id,options)):"Primary"===options.type&&item.AlbumId&&item.AlbumPrimaryImageTag?(options.tag=item.AlbumPrimaryImageTag,connectionManager.getApiClient(item.ServerId).getScaledImageUrl(item.AlbumId,options)):null}function logoImageUrl(item,apiClient,options){return(options=options||{}).type="Logo",item.ImageTags&&item.ImageTags.Logo?(options.tag=item.ImageTags.Logo,apiClient.getScaledImageUrl(item.Id,options)):item.ParentLogoImageTag?(options.tag=item.ParentLogoImageTag,apiClient.getScaledImageUrl(item.ParentLogoItemId,options)):"TvChannel"===item.Type&&item.ImageTags&&item.ImageTags.Primary?(options.tag=item.ImageTags.Primary,options.type="Primary",apiClient.getScaledImageUrl(item.Id,options)):null}function isDisplayingLocalVideo(player,mediaType){return player&&player.isLocalPlayer&&"Video"===(mediaType||playbackManager.getCurrentMediaType(player))}function setForwardIcon(btnFastForward){var icon=btnFastForward.querySelector("i");switch(icon.innerHTML=function(){switch(userSettings.skipForwardLength()){case 5e3:return"&#xe058;";case 1e4:return"&#xe056;";case 3e4:return"&#xe057;";default:return"&#xE042;"}}(),userSettings.skipForwardLength()){case 5e3:case 1e4:case 3e4:break;default:icon.classList.add("videoOsd-forwardIcon-flipped")}}function setRewindIcon(btnRewind){btnRewind.querySelector("i").innerHTML=function(){switch(userSettings.skipBackLength()){case 5e3:return"&#xe05b;";case 1e4:return"&#xe059;";case 3e4:return"&#xe05a;";default:return"&#xE042;"}}()}function hideOrShowAll(elems,hide){for(var i=0,length=elems.length;i<length;i++)hide?elems[i].classList.add("hide"):elems[i].classList.remove("hide")}function getTextActionButton(item,text){text=text||itemHelper.getDisplayName(item);var html="<button "+itemShortcuts.getShortcutAttributesHtml(item,{})+' type="button" class="itemAction button-link osdTextActionButton" is="emby-button" data-action="link">';return html+=text,html+="</button>"}function getSecondaryName(item,enableLinkButton){var title=itemHelper.getDisplayName(item,{includeParentInfo:"Program"!==item.Type,includeIndexNumber:"Program"!==item.Type});return enableLinkButton?getTextActionButton(item,title):title}return function(view,params){var currentPlayer,comingUpNextDisplayed,currentUpNextDialog,isEnabled,currentItem,currentItemThumbnails,currentItemThumbnailsPromise,recordingButtonManager,enableProgressByTimeOfDay,enableStopOnBack,enableBackOnStop,lastPointerUpType,playQueue,currentVisibleMenu,statsOverlay,osdHideTimeout,lastPointerMoveData,self=this,currentPlayerSupportedCommands=[],currentRuntimeTicks=0,lastUpdateTime=0,programStartDateMs=0,programEndDateMs=0,playbackStartTimeTicks=0,nowPlayingVolumeSlider=view.querySelector(".videoOsdVolumeSlider"),nowPlayingVolumeSliderContainer=view.querySelector(".videoOsdVolumeSliderWrapper"),nowPlayingPositionSlider=view.querySelector(".videoOsdPositionSlider"),nowPlayingPositionText=view.querySelector(".videoOsdPositionText"),nowPlayingDurationText=view.querySelector(".videoOsdDurationText"),btnRewind=view.querySelector(".btnRewind"),btnRewindIcon=btnRewind.querySelector("i"),btnFastForward=view.querySelector(".btnOsdFastForward"),btnFastForwardIcon=btnFastForward.querySelector("i"),btnPause=view.querySelector(".videoOsd-btnPause"),stopButtons=view.querySelectorAll(".btnVideoOsd-stop"),btnRepeatMode=view.querySelector(".btnOsdRepeatMode"),btnMore=view.querySelector(".btnOsdMore"),transitionEndEventName=dom.whichTransitionEvent(),headerElement=document.querySelector(".skinHeader"),osdBottomElement=(document.querySelector(".backgroundContainer"),document.querySelector(".videoOsdBottom-maincontrols")),endsAtText=(document.querySelector(".videoOsdBottomInner"),view.querySelector(".videoOsd-endsAtText")),btnFavorite=view.querySelector(".btnOsdFavorite"),btnPreviousTrack=view.querySelector(".btnPreviousTrack"),btnNextTrack=view.querySelector(".btnNextTrack"),buttonMute=view.querySelector(".buttonMute"),btnSubtitles=view.querySelector(".btnSubtitles"),btnAudio=view.querySelector(".btnAudio"),btnFullscreen=view.querySelector(".btnFullscreen"),videoOsdSecondaryText=view.querySelector(".videoOsdSecondaryText"),videoOsdText=view.querySelector(".videoOsdText"),osdButtons=view.querySelector(".videoOsdBottom-buttons"),centerButtons=view.querySelector(".videoOsd-centerButtons"),videoOsdPositionContainer=view.querySelector(".videoOsdPositionContainer"),osdTitle=view.querySelector(".videoOsdTitle"),backdropContainer=document.querySelector(".backdropContainer");function enableIconAnimation(){return!browser.netcast&&!browser.orsay}function rewind(player){"osd"===currentVisibleMenu&&enableIconAnimation()&&(btnRewindIcon.classList.remove("rew-animate"),btnRewindIcon.offsetWidth,btnRewindIcon.classList.add("rew-animate")),playbackManager.rewind(player)}function onRewindAnimationComplete(e){e&&e.target!==e.currentTarget||this.classList.remove("rew-animate")}function onFastForwardAnimationComplete(e){e&&e.target!==e.currentTarget||this.classList.remove("ff-animate")}function fastForward(player){"osd"===currentVisibleMenu&&enableIconAnimation()&&(btnFastForwardIcon.classList.remove("ff-animate"),btnFastForwardIcon.offsetWidth,btnFastForwardIcon.classList.add("ff-animate")),playbackManager.fastForward(player)}function updateRecordingButton(item){if(!item||"Program"!==item.Type)return recordingButtonManager&&(recordingButtonManager.destroy(),recordingButtonManager=null),void view.querySelector(".btnRecord").classList.add("hide");connectionManager.getApiClient(item.ServerId).getCurrentUser().then(function(user){user.Policy.EnableLiveTvManagement&&require(["recordingButton"],function(RecordingButton){recordingButtonManager?recordingButtonManager.refreshItem(item):(recordingButtonManager=new RecordingButton({item:item,button:view.querySelector(".btnRecord")}),view.querySelector(".btnRecord").classList.remove("hide"))})})}function updateDisplayItem(itemInfo){var item=itemInfo.originalItem;currentItem=item,currentItemThumbnails=currentItemThumbnailsPromise=null;var displayItem=itemInfo.displayItem||item;updateRecordingButton(displayItem);var primaryNameText,primaryNameHtml,displayingLocalVideo=isDisplayingLocalVideo(currentPlayer);displayItem.EpisodeTitle||displayItem.IsSeries?primaryNameText=displayItem.Name:displayItem.SeriesName?(primaryNameText=displayItem.SeriesName,displayItem.SeriesId&&!displayingLocalVideo&&(primaryNameHtml=getTextActionButton({Id:displayItem.SeriesId,Type:"Series",IsFolder:!0,ServerId:displayItem.ServerId,Name:displayItem.SeriesName,ParentId:displayItem.ParentId}))):displayItem.Album&&(primaryNameText=displayItem.Album,primaryNameHtml=displayItem.AlbumId&&!displayingLocalVideo?getTextActionButton({Id:displayItem.AlbumId,Type:"MusicAlbum",IsFolder:!0,ServerId:displayItem.ServerId,Name:displayItem.Album,ParentId:displayItem.ParentId}):primaryNameText,displayItem.ArtistItems&&displayItem.ArtistItems.length&&(primaryNameHtml=function(displayItem){var html=[],artistItems=displayItem.ArtistItems;if(!artistItems)return html;for(var i=0,length=artistItems.length;i<length;i++)html.push(getTextActionButton({Id:artistItems[i].Id,ServerId:displayItem.ServerId,Name:artistItems[i].Name,Type:"MusicArtist",IsFolder:!0}));return html}(displayItem).join(", ")+" - "+primaryNameHtml)),primaryNameHtml=primaryNameHtml||primaryNameText,function(item,originalItem,title){var url=logoImageUrl(item,connectionManager.getApiClient(item.ServerId),{})||logoImageUrl(originalItem,connectionManager.getApiClient(originalItem.ServerId),{});if(url){appHeader.setTitle("");var pageTitle=document.querySelector(".pageTitle");pageTitle.style.backgroundImage="url('"+url+"')",pageTitle.classList.add("pageTitleWithLogo"),pageTitle.classList.remove("pageTitleWithDefaultLogo"),pageTitle.innerHTML=""}else appHeader.setTitle("");var documentTitle=title||(item?item.Name:null);documentTitle&&(document.title=documentTitle)}(displayItem,item,primaryNameText);var backdropItems=[displayItem];item.Id!==displayItem.Id&&backdropItems.push(item),displayingLocalVideo?(backdrop.clear(),setPoster(null),playQueue&&playQueue.setBackdropItems([])):(layoutManager.tv?(backdrop.setBackdrops(backdropItems),setPoster(null)):(backdrop.setBackdrops(backdropItems),setPoster(displayItem,item)),playQueue&&playQueue.setBackdropItems(backdropItems));var titleElement,secondaryName,osdParentTitle=view.querySelector(".videoOsdParentTitle");if(titleElement=osdTitle,"Audio"===item.MediaType){var temp=primaryNameHtml;primaryNameHtml=secondaryName=getSecondaryName(displayItem,!1),secondaryName=temp}else secondaryName=getSecondaryName(displayItem,!displayingLocalVideo);primaryNameHtml||(primaryNameHtml=secondaryName,secondaryName=null),osdParentTitle.innerHTML=primaryNameHtml,secondaryName||displayItem.Type,(titleElement.innerHTML=secondaryName)?titleElement.classList.remove("hide"):titleElement.classList.add("hide");var mediaInfoHtml=mediaInfo.getPrimaryMediaInfoHtml(displayItem,{runtime:!1,subtitles:!1,endsAt:!1,episodeTitle:!1,originalAirDate:!1,episodeTitleIndexNumber:"Program"!==displayItem.Type,programIndicator:!1,criticRating:!1,communityRating:!1,container:!1,year:"Video"===displayItem.MediaType}),osdMediaInfo=view.querySelector(".videoOsdMediaInfo");(osdMediaInfo.innerHTML=mediaInfoHtml)?osdMediaInfo.classList.remove("hide"):osdMediaInfo.classList.add("hide");var secondaryMediaInfo=view.querySelector(".videoOsdSecondaryMediaInfo"),secondaryMediaInfoHtml=mediaInfo.getSecondaryMediaInfoHtml(displayItem,{startDate:!1,programTime:!1});(secondaryMediaInfo.innerHTML=secondaryMediaInfoHtml)?secondaryMediaInfo.classList.remove("hide"):secondaryMediaInfo.classList.add("hide"),programEndDateMs=enableProgressByTimeOfDay?(setDisplayTime(nowPlayingPositionText,displayItem.StartDate),setDisplayTime(nowPlayingDurationText,displayItem.EndDate),programStartDateMs=displayItem.StartDate?datetime.parseISO8601Date(displayItem.StartDate).getTime():0,displayItem.EndDate?datetime.parseISO8601Date(displayItem.EndDate).getTime():0):programStartDateMs=0}function getDisplayTimeWithoutAmPm(date,showSeconds){return showSeconds?datetime.toLocaleTimeString(date,{hour:"numeric",minute:"2-digit",second:"2-digit"}).toLowerCase().replace("am","").replace("pm","").trim():datetime.getDisplayTime(date).toLowerCase().replace("am","").replace("pm","").trim()}function setDisplayTime(elem,date){var html;date&&(html=getDisplayTimeWithoutAmPm(date=datetime.parseISO8601Date(date))),elem.innerHTML=html||""}function updateNowPlayingInfo(player,state){var item=state.NowPlayingItem;if(currentItemThumbnails=currentItemThumbnailsPromise=null,!(currentItem=item))return setPoster(null),updateRecordingButton(null),appHeader.setTitle(""),nowPlayingVolumeSlider.disabled=!0,nowPlayingPositionSlider.disabled=!0,btnFastForward.disabled=!0,btnRewind.disabled=!0,btnSubtitles.classList.add("hide"),btnAudio.classList.add("hide"),osdTitle.innerHTML="",view.querySelector(".videoOsdMediaInfo").innerHTML="",void(endsAtText.innerHTML="");enableProgressByTimeOfDay=function(item){return!("TvChannel"!==item.Type||!item.CurrentProgram)}(item),function(item){if("TvChannel"!==item.Type)return Promise.resolve({originalItem:item});var apiClient=connectionManager.getApiClient(item.ServerId);return apiClient.getItem(apiClient.getCurrentUserId(),item.Id).then(function(refreshedItem){return{originalItem:refreshedItem,displayItem:refreshedItem.CurrentProgram}})}(item).then(updateDisplayItem),nowPlayingVolumeSlider.disabled=!1,nowPlayingPositionSlider.disabled=!1,btnFastForward.disabled=!1,btnRewind.disabled=!1,playbackManager.subtitleTracks(player).length?btnSubtitles.classList.remove("hide"):btnSubtitles.classList.add("hide"),1<playbackManager.audioTracks(player).length?btnAudio.classList.remove("hide"):btnAudio.classList.add("hide")}function setPoster(item,secondaryItem){var osdPoster=view.querySelector(".osdPoster-img");if(item){var imgUrl=function(item,secondaryItem){var imgUrl=seriesImageUrl(item,{type:"Primary"})||seriesImageUrl(item,{type:"Thumb"})||imageUrl(item,{type:"Primary"});return!imgUrl&&secondaryItem&&(imgUrl=seriesImageUrl(secondaryItem,{type:"Primary"})||seriesImageUrl(secondaryItem,{type:"Thumb"})||imageUrl(secondaryItem,{type:"Primary"})),imgUrl}(item,secondaryItem);if(imgUrl)return void(osdPoster?osdPoster.style.backgroundImage="url('"+imgUrl+"')":view.querySelector(".videoOsdBottom-maincontrols").insertAdjacentHTML("afterbegin",'<div class="osdPoster-img" loading="lazy" style="background-image:url('+imgUrl+');"></div>'))}osdPoster&&function(elem){try{elem.parentNode.removeChild(elem)}catch(err){console.log("Error removing poster node: "+err)}}(osdPoster)}function showOsd(timeoutMs){headerElement.classList.remove("videoOsdHeader-hidden"),function(){if(currentVisibleMenu)return;var elem=osdBottomElement;currentVisibleMenu="osd",elem.classList.remove("hide"),elem.offsetWidth,elem.classList.remove("videoOsdBottom-hidden"),focusManager.hasExclusiveFocusScope()||focusManager.focus(btnPause);view.dispatchEvent(new CustomEvent("video-osd-show",{bubbles:!0}))}(),function(timeoutMs){if(stopOsdHideTimer(),!isDisplayingLocalVideo(currentPlayer))return;0!==timeoutMs&&(osdHideTimeout=setTimeout(hideOsd,timeoutMs||4e3))}(timeoutMs)}function hideOsd(){isDisplayingLocalVideo(currentPlayer)&&(headerElement.classList.add("videoOsdHeader-hidden"),function(){if("osd"!==currentVisibleMenu)return;var elem=osdBottomElement;elem.offsetWidth,elem.classList.add("videoOsdBottom-hidden"),currentVisibleMenu=null}())}function toggleOsd(){"osd"===currentVisibleMenu?hideOsd():currentVisibleMenu||showOsd()}function stopOsdHideTimer(){osdHideTimeout&&(clearTimeout(osdHideTimeout),osdHideTimeout=null)}function onPointerMove(e){if("mouse"===(e.pointerType||(layoutManager.mobile?"touch":"mouse"))){var eventX=e.screenX||0,eventY=e.screenY||0,obj=lastPointerMoveData;if(!obj)return lastPointerMoveData={x:eventX,y:eventY},void showOsd();if(Math.abs(eventX-obj.x)<10&&Math.abs(eventY-obj.y)<10)return;obj.x=eventX,obj.y=eventY,showOsd()}}function onInputCommand(e){if(!playQueue||!playQueue.onInputCommand(e))switch(e.detail.command){case"back":!playQueue&&layoutManager.tv&&"osd"===currentVisibleMenu&&isDisplayingLocalVideo(currentPlayer)&&!focusManager.hasExclusiveFocusScope()&&(e.preventDefault(),hideOsd());break;case"left":currentVisibleMenu?showOsd():currentVisibleMenu||(e.preventDefault(),rewind(currentPlayer));break;case"right":currentVisibleMenu?showOsd():currentVisibleMenu||(e.preventDefault(),fastForward(currentPlayer));break;case"pageup":playbackManager.nextChapter(currentPlayer);break;case"pagedown":playbackManager.previousChapter(currentPlayer);break;case"up":case"down":case"select":case"menu":case"info":case"play":case"playpause":case"pause":case"fastforward":case"rewind":case"next":case"previous":showOsd();break;case"record":showOsd(),function(){var btnRecord=view.querySelector(".btnRecord");btnRecord.classList.contains("hide")||btnRecord.click()}();break;case"togglestats":toggleStats();break;case"movies":case"music":case"tv":case"settings":case"nowplaying":case"search":case"favorites":case"livetv":case"recordedtv":case"guide":e.preventDefault()}}function updateFullscreenIcon(){playbackManager.isFullscreen(currentPlayer)?(btnFullscreen.setAttribute("title",globalize.translate("ExitFullscreen")),btnFullscreen.querySelector("i").innerHTML="&#xE5D1;"):(btnFullscreen.setAttribute("title",globalize.translate("Fullscreen")),btnFullscreen.querySelector("i").innerHTML="&#xE5D0;")}function onPlaylistExpanded(){osdBottomElement.classList.add("videoOsdBottom-playlistexpanded")}function onPlaylistCollapsed(){osdBottomElement.classList.remove("videoOsdBottom-playlistexpanded")}function updateTransparency(player,mediaType){var isLocalVideo=isDisplayingLocalVideo(player,mediaType);enableBackOnStop=isLocalVideo?(currentVisibleMenu||(headerElement.classList.add("videoOsdHeader-hidden"),osdBottomElement.classList.add("hide"),osdBottomElement.classList.add("videoOsdBottom-hidden")),headerElement.classList.remove("videoOsdHeader-remotecontrol"),backdropContainer.classList.remove("backdropContainer-remotecontrol"),osdBottomElement.classList.add("videoOsdBottom-video"),videoOsdSecondaryText.classList.add("videoOsdSecondaryText-video"),videoOsdSecondaryText.classList.remove("videoOsdSecondaryText-remotecontrol"),appRouter.setTransparency("full"),hideOrShowAll(stopButtons,!0),videoOsdText.classList.remove("videoOsdText-remotecontrol"),videoOsdText.classList.remove("videoOsdText-tvplayqueue"),osdButtons.classList.remove("videoOsdBottom-buttons-remotecontrol"),osdBottomElement.classList.remove("videoOsdBottom-remotecontrol"),osdTitle.classList.remove("osdTitle-remotecontrol"),videoOsdPositionContainer.classList.remove("videoOsd-customFont-remotecontrol"),osdButtons.classList.remove("videoOsd-customFont-remotecontrol"),headerElement.classList.remove("videoOsd-customFont-remotecontrol"),enableStopOnBack=!0):(osdBottomElement.classList.remove("videoOsdBottom-video"),osdBottomElement.classList.remove("videoOsdBottom-hidden"),osdBottomElement.classList.remove("hide"),showOsd(),layoutManager.tv?(headerElement.classList.remove("videoOsdHeader-remotecontrol"),backdropContainer.classList.remove("backdropContainer-remotecontrol"),videoOsdText.classList.add("videoOsdText-tvplayqueue"),videoOsdText.classList.remove("videoOsdText-remotecontrol"),osdTitle.classList.remove("osdTitle-remotecontrol"),osdBottomElement.classList.remove("videoOsdBottom-remotecontrol"),videoOsdSecondaryText.classList.remove("videoOsdSecondaryText-remotecontrol"),osdButtons.classList.remove("videoOsdBottom-buttons-remotecontrol"),videoOsdPositionContainer.classList.remove("videoOsd-customFont-remotecontrol"),osdButtons.classList.remove("videoOsd-customFont-remotecontrol"),headerElement.classList.remove("videoOsd-customFont-remotecontrol")):(headerElement.classList.add("videoOsdHeader-remotecontrol"),backdropContainer.classList.add("backdropContainer-remotecontrol"),videoOsdText.classList.remove("videoOsdText-tvplayqueue"),videoOsdText.classList.add("videoOsdText-remotecontrol"),osdTitle.classList.add("osdTitle-remotecontrol"),osdBottomElement.classList.add("videoOsdBottom-remotecontrol"),videoOsdSecondaryText.classList.add("videoOsdSecondaryText-remotecontrol"),osdButtons.classList.add("videoOsdBottom-buttons-remotecontrol"),videoOsdPositionContainer.classList.add("videoOsd-customFont-remotecontrol"),osdButtons.classList.add("videoOsd-customFont-remotecontrol"),headerElement.classList.add("videoOsd-customFont-remotecontrol")),appRouter.setTransparency(0),hideOrShowAll(stopButtons,!1),!(enableStopOnBack=!1)),isLocalVideo?destroyPlayQueue():layoutManager.tv?playQueue=playQueue||new TvPlayQueue({parent:view.querySelector(".tvPlayQueue")}):playQueue||(playQueue=new OsdPlayQueue({parent:view.querySelector(".osdPlayQueue"),toggleBar:!0}),events.on(playQueue,"playlistexpanded",onPlaylistExpanded),events.on(playQueue,"playlistcollapsed",onPlaylistCollapsed)),isLocalVideo&&!layoutManager.tv?(centerButtons.classList.add("videoOsd-centerButtons-autolayout"),btnPause.classList.add("videoOsd-btnPause-autolayout"),stopButtons[0].classList.add("btnVideoOsd-stop-center-autolayout"),stopButtons[1].classList.add("btnVideoOsd-stop-bottom-autolayout")):(centerButtons.classList.remove("videoOsd-centerButtons-autolayout"),btnPause.classList.remove("videoOsd-btnPause-autolayout"),stopButtons[0].classList.remove("btnVideoOsd-stop-center-autolayout"),stopButtons[1].classList.remove("btnVideoOsd-stop-bottom-autolayout"))}function onPlayerChange(e,player){bindToPlayer(player)}function onStateChanged(event,state){state.NowPlayingItem&&(isEnabled=!0,function(event,player,state){var playState=state.PlayState||{};updatePlayPauseState(playState.IsPaused);var supportedCommands=playbackManager.getSupportedCommands(player);currentPlayerSupportedCommands=supportedCommands,updatePlayerVolumeState(player,playState.IsMuted,playState.VolumeLevel),nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging&&(nowPlayingPositionSlider.disabled=!playState.CanSeek);btnFastForward.disabled=!playState.CanSeek,btnRewind.disabled=!playState.CanSeek;var nowPlayingItem=state.NowPlayingItem||{};updateTransparency(player,nowPlayingItem.MediaType),playbackStartTimeTicks=playState.PlaybackStartTimeTicks,updateTimeDisplay(playState.PositionTicks,nowPlayingItem.RunTimeTicks,playState.PlaybackStartTimeTicks,playState.BufferedRanges||[]),updateNowPlayingInfo(player,state);var focusedElement=document.activeElement;state.MediaSource&&"Video"===nowPlayingItem.MediaType?view.querySelector(".btnVideoOsdSettings").classList.remove("hide"):hideButton(view.querySelector(".btnVideoOsdSettings"),focusedElement);var isProgressClear=state.MediaSource&&null==state.MediaSource.RunTimeTicks;nowPlayingPositionSlider.setIsClear(isProgressClear),-1===supportedCommands.indexOf("ToggleFullscreen")||player.isLocalPlayer&&layoutManager.tv&&playbackManager.isFullscreen(player)?hideButton(btnFullscreen,focusedElement):btnFullscreen.classList.remove("hide");-1===supportedCommands.indexOf("PictureInPicture")?hideButton(view.querySelector(".btnPip"),focusedElement):view.querySelector(".btnPip").classList.remove("hide");updateRepeatModeDisplay(playState.RepeatMode),-1===supportedCommands.indexOf("SetRepeatMode")||"Video"===nowPlayingItem.MediaType?hideButton(btnRepeatMode,focusedElement):btnRepeatMode.classList.remove("hide");var displayingLocalVideo=isDisplayingLocalVideo(player,nowPlayingItem.MediaType);displayingLocalVideo?hideButton(btnMore,focusedElement):btnMore.classList.remove("hide");updateFullscreenIcon(),btnFavorite.setItem(nowPlayingItem),!displayingLocalVideo&&itemHelper.canRate(nowPlayingItem)&&"TvChannel"!==nowPlayingItem.Type?btnFavorite.classList.remove("hide"):hideButton(btnFavorite,focusedElement);var playlistIndex=state.PlaylistIndex,playlistLength=state.PlaylistLength;if(updatePlaylistButtons(playlistIndex,playlistLength,focusedElement),playQueue){var playlistItemId=state.PlaylistItemId;playQueue.updatePlaylist(player,playlistItemId,playlistIndex,playlistLength)}}(0,this,state))}function onPlayPauseStateChanged(e){if(isEnabled){updatePlayPauseState(this.paused())}}function onVolumeChanged(e){if(isEnabled){updatePlayerVolumeState(this,this.isMuted(),this.getVolume())}}function onPlaybackStart(e,state){console.log("nowplaying event: "+e.type);onStateChanged.call(this,e,state),setTimeout(resetUpNextDialog,300)}function onRepeatModeChange(e){updateRepeatModeDisplay(playbackManager.getRepeatMode(this))}function onPlaylistItemAdd(e){var playlistIndex=playbackManager.getCurrentPlaylistIndex(this),playlistLength=playbackManager.getCurrentPlaylistLength(this);if(updatePlaylistButtons(playlistIndex,playlistLength,document.activeElement),playQueue){var playlistItemId=playbackManager.getCurrentPlaylistItemId(this);playQueue.updatePlaylist(this,playlistItemId,playlistIndex,playlistLength)}}function onPlaylistItemMove(e,info){if(updatePlaylistButtons(playbackManager.getCurrentPlaylistIndex(this),playbackManager.getCurrentPlaylistLength(this),document.activeElement),playQueue){playbackManager.getCurrentPlaylistItemId(this);playQueue.onPlaylistItemMoved(this,e,info)}}function onPlaylistItemRemove(e,info){updatePlaylistButtons(playbackManager.getCurrentPlaylistIndex(this),playbackManager.getCurrentPlaylistLength(this),document.activeElement),playQueue&&playQueue.onPlaylistItemRemoved(this,e,info)}function resetUpNextDialog(){comingUpNextDisplayed=!1;currentUpNextDialog&&(currentUpNextDialog.destroy(),currentUpNextDialog=null)}function onPlaybackStopped(e,state){currentRuntimeTicks=null,resetUpNextDialog(),console.log("nowplaying event: "+e.type),state.NextMediaType||(playQueue&&playQueue.onPlaybackStopped(),enableStopOnBack=!1,enableBackOnStop&&(enableBackOnStop=!1,appRouter.back()))}function onMediaStreamsChanged(e){var state=playbackManager.getPlayerState(this);onStateChanged.call(this,{type:"init"},state)}function bindToPlayer(player){if(player!==currentPlayer&&(releaseCurrentPlayer(),currentPlayer=player)){var state=playbackManager.getPlayerState(player);onStateChanged.call(player,{type:"init"},state),events.on(player,"playbackstart",onPlaybackStart),events.on(player,"playbackstop",onPlaybackStopped),events.on(player,"volumechange",onVolumeChanged),events.on(player,"pause",onPlayPauseStateChanged),events.on(player,"unpause",onPlayPauseStateChanged),events.on(player,"timeupdate",onTimeUpdate),events.on(player,"fullscreenchange",updateFullscreenIcon),events.on(player,"mediastreamschange",onMediaStreamsChanged),events.on(player,"statechange",onStateChanged),events.on(player,"repeatmodechange",onRepeatModeChange),events.on(player,"playlistitemadd",onPlaylistItemAdd),events.on(player,"playlistitemmove",onPlaylistItemMove),events.on(player,"playlistitemremove",onPlaylistItemRemove),resetUpNextDialog()}}function releaseCurrentPlayer(){destroyStats(),resetUpNextDialog();var player=currentPlayer;player&&(events.off(player,"playbackstart",onPlaybackStart),events.off(player,"playbackstop",onPlaybackStopped),events.off(player,"volumechange",onVolumeChanged),events.off(player,"pause",onPlayPauseStateChanged),events.off(player,"unpause",onPlayPauseStateChanged),events.off(player,"timeupdate",onTimeUpdate),events.off(player,"fullscreenchange",updateFullscreenIcon),events.off(player,"mediastreamschange",onMediaStreamsChanged),events.off(player,"statechange",onStateChanged),events.off(player,"repeatmodechange",onRepeatModeChange),events.off(player,"playlistitemadd",onPlaylistItemAdd),events.off(player,"playlistitemmove",onPlaylistItemMove),events.off(player,"playlistitemremove",onPlaylistItemRemove),currentPlayer=null)}function onTimeUpdate(e){if(isEnabled){var now=Date.now();if(!(now-lastUpdateTime<700)){lastUpdateTime=now;currentRuntimeTicks=playbackManager.duration(this);var currentTime=playbackManager.currentTime(this);updateTimeDisplay(currentTime,currentRuntimeTicks,playbackManager.playbackStartTime(this),playbackManager.getBufferedRanges(this));var item=currentItem;!function(player,item){if("TvChannel"!==item.Type)return;var program=item.CurrentProgram;if(!program||!program.EndDate)return;try{var endDate=datetime.parseISO8601Date(program.EndDate);if(Date.now()>=endDate.getTime()){console.log("program info needs to be refreshed");var state=playbackManager.getPlayerState(player);onStateChanged.call(player,{type:"init"},state)}}catch(e){console.log("Error parsing date: "+program.EndDate)}}(this,item),function(player,currentItem,currentTimeTicks,runtimeTicks){if(runtimeTicks&&currentTimeTicks&&!comingUpNextDisplayed&&!currentVisibleMenu&&"Episode"===currentItem.Type&&userSettings.enableNextVideoInfoOverlay()){var timeRemainingTicks=runtimeTicks-currentTimeTicks;runtimeTicks-1e3*(3e10<=runtimeTicks?40:24e9<=runtimeTicks?35:30)*1e4<=currentTimeTicks&&6e9<=runtimeTicks&&2e8<=timeRemainingTicks&&function(player){require(["upNextDialog"],function(UpNextDialog){currentVisibleMenu||currentUpNextDialog||(currentVisibleMenu="upnext",comingUpNextDisplayed=!0,playbackManager.nextItem(player).then(function(nextItem){currentUpNextDialog=new UpNextDialog({parent:view.querySelector(".upNextContainer"),player:player,nextItem:nextItem}),events.on(currentUpNextDialog,"hide",onUpNextHidden)},onUpNextHidden))})}(player)}}(this,item,currentTime,currentRuntimeTicks)}}}function onUpNextHidden(){"upnext"===currentVisibleMenu&&(currentVisibleMenu=null)}function updatePlayPauseState(isPaused){isPaused?(btnPause.querySelector("i").innerHTML="&#xE037;",btnPause.title=globalize.translate("Play")):(btnPause.querySelector("i").innerHTML="&#xE034;",btnPause.title=globalize.translate("Pause"))}function hideButton(btn,focusedElement){var isFocused=btn===focusedElement;btn.classList.add("hide"),isFocused&&focusManager.focus(btnPause)}function updatePlaylistButtons(playlistIndex,playlistLength,focusedElement){playlistIndex?btnPreviousTrack.classList.remove("hide"):hideButton(btnPreviousTrack,focusedElement),null!=playlistIndex&&playlistLength&&playlistIndex<playlistLength-1?btnNextTrack.classList.remove("hide"):hideButton(btnNextTrack,focusedElement)}function updateRepeatModeDisplay(repeatMode){"RepeatAll"===repeatMode?(btnRepeatMode.querySelector("i").innerHTML="&#xE040;",btnRepeatMode.classList.add("repeatButton-active")):"RepeatOne"===repeatMode?(btnRepeatMode.querySelector("i").innerHTML="&#xE041;",btnRepeatMode.classList.add("repeatButton-active")):(btnRepeatMode.querySelector("i").innerHTML="&#xE040;",btnRepeatMode.classList.remove("repeatButton-active"))}function getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,currentTimeMs){return(currentTimeMs-programStartDateMs)/programRuntimeMs*100}function updateTimeDisplay(positionTicks,runtimeTicks,playbackStartTimeTicks,bufferedRanges){if(enableProgressByTimeOfDay){if(nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging)if(programStartDateMs&&programEndDateMs){var currentTimeMs=(playbackStartTimeTicks+(positionTicks||0))/1e4,programRuntimeMs=programEndDateMs-programStartDateMs;if(nowPlayingPositionSlider.value=getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,currentTimeMs),bufferedRanges.length){var rangeStart=getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,(playbackStartTimeTicks+(bufferedRanges[0].start||0))/1e4),rangeEnd=getDisplayPercentByTimeOfDay(programStartDateMs,programRuntimeMs,(playbackStartTimeTicks+(bufferedRanges[0].end||0))/1e4);nowPlayingPositionSlider.setBufferedRanges([{start:rangeStart,end:rangeEnd}])}else nowPlayingPositionSlider.setBufferedRanges([])}else nowPlayingPositionSlider.value=0,nowPlayingPositionSlider.setBufferedRanges([]);endsAtText.innerHTML=""}else{if(nowPlayingPositionSlider&&!nowPlayingPositionSlider.dragging){if(runtimeTicks){var pct=positionTicks/runtimeTicks;pct*=100,nowPlayingPositionSlider.value=pct}else nowPlayingPositionSlider.value=0;runtimeTicks&&null!=positionTicks&&currentRuntimeTicks&&!enableProgressByTimeOfDay&&currentItem.RunTimeTicks&&"Video"===currentItem.MediaType&&"Recording"!==currentItem.Type?endsAtText.innerHTML=mediaInfo.getEndsAtFromPosition(runtimeTicks,positionTicks,!0):endsAtText.innerHTML=""}nowPlayingPositionSlider&&nowPlayingPositionSlider.setBufferedRanges(bufferedRanges,runtimeTicks,positionTicks),updateTimeText(nowPlayingPositionText,positionTicks),updateTimeText(nowPlayingDurationText,runtimeTicks-positionTicks)}}function updatePlayerVolumeState(player,isMuted,volumeLevel){var supportedCommands=currentPlayerSupportedCommands,showMuteButton=!0,showVolumeSlider=!0;-1===supportedCommands.indexOf("Mute")&&(showMuteButton=!1),-1===supportedCommands.indexOf("SetVolume")&&(showVolumeSlider=!1),player.isLocalPlayer&&appHost.supports("physicalvolumecontrol")&&(showVolumeSlider=showMuteButton=!1),isMuted?(buttonMute.setAttribute("title",globalize.translate("Unmute")),buttonMute.querySelector("i").innerHTML="&#xE04F;"):(buttonMute.setAttribute("title",globalize.translate("Mute")),buttonMute.querySelector("i").innerHTML="&#xE050;"),showMuteButton?buttonMute.classList.remove("hide"):buttonMute.classList.add("hide"),nowPlayingVolumeSlider&&(showVolumeSlider?nowPlayingVolumeSliderContainer.classList.remove("hide"):nowPlayingVolumeSliderContainer.classList.add("hide"),nowPlayingVolumeSlider.dragging||(nowPlayingVolumeSlider.value=volumeLevel||0))}function updateTimeText(elem,ticks,dash){if(null!=ticks){var html=datetime.getDisplayRunningTime(ticks);dash&&(html="-"+html),elem.innerHTML=html}else elem.innerHTML=""}function onSettingsOption(selectedOption){"stats"===selectedOption&&toggleStats()}function toggleStats(){require(["playerStats"],function(PlayerStats){var player=currentPlayer;player&&(statsOverlay?statsOverlay.toggle():statsOverlay=new PlayerStats({player:player}))})}function destroyStats(){statsOverlay&&(statsOverlay.destroy(),statsOverlay=null)}function destroyPlayQueue(){playQueue&&(playQueue.destroy(),playQueue=null)}function onWindowKeyDown(e){var keyCode=e.keyCode;if(32===keyCode||13===keyCode)return currentVisibleMenu||browser.edge||playbackManager.playPause(currentPlayer),void showOsd();switch(e.key){case"f":e.ctrlKey||playbackManager.toggleFullscreen(currentPlayer);break;case"m":playbackManager.toggleMute(currentPlayer);break;case"ArrowLeft":case"Left":case"NavigationLeft":case"GamepadDPadLeft":case"GamepadLeftThumbstickLeft":e.shiftKey&&rewind(currentPlayer);break;case"ArrowRight":case"Right":case"NavigationRight":case"GamepadDPadRight":case"GamepadLeftThumbstickRight":e.shiftKey&&fastForward(currentPlayer)}}layoutManager.tv||(videoOsdPositionContainer.classList.add("videoOsd-customFont"),osdButtons.classList.add("videoOsd-customFont"),videoOsdText.classList.add("videoOsdText-customFont")),setRewindIcon(btnRewind),setForwardIcon(btnFastForward),dom.addEventListener(btnRewindIcon,dom.whichAnimationEvent(),onRewindAnimationComplete,{passive:!0}),dom.addEventListener(btnRewindIcon,dom.whichAnimationCancelEvent(),onRewindAnimationComplete,{passive:!0}),dom.addEventListener(btnFastForwardIcon,dom.whichAnimationEvent(),onFastForwardAnimationComplete,{passive:!0}),dom.addEventListener(btnFastForwardIcon,dom.whichAnimationCancelEvent(),onFastForwardAnimationComplete,{passive:!0}),view.addEventListener("viewbeforeshow",function(e){headerElement.classList.add("videoOsdHeader"),layoutManager.tv||headerElement.classList.add("videoOsd-customFont")}),view.addEventListener("viewshow",function(e){events.on(playbackManager,"playerchange",onPlayerChange),bindToPlayer(playbackManager.getCurrentPlayer());currentPlayer&&updateTransparency(currentPlayer),dom.addEventListener(document,window.PointerEvent?"pointermove":"mousemove",onPointerMove,{passive:!0}),params.controls?showOsd(0):function(view){var activeElement=document.activeElement;if(activeElement&&!view.contains(activeElement))try{activeElement.blur()}catch(err){console.log("Error blurring element from previous view: "+err)}}(view),inputManager.on(window,onInputCommand),dom.addEventListener(window,"keydown",onWindowKeyDown,{passive:!0})}),view.addEventListener("viewbeforehide",function(){if(statsOverlay&&statsOverlay.enabled(!1),dom.removeEventListener(window,"keydown",onWindowKeyDown,{passive:!0}),stopOsdHideTimer(),headerElement.classList.remove("videoOsdHeader"),headerElement.classList.remove("videoOsdHeader-hidden"),headerElement.classList.remove("videoOsd-customFont"),headerElement.classList.remove("videoOsd-customFont-remotecontrol"),headerElement.classList.remove("videoOsdHeader-remotecontrol"),backdropContainer.classList.remove("backdropContainer-remotecontrol"),dom.removeEventListener(document,window.PointerEvent?"pointermove":"mousemove",onPointerMove,{passive:!0}),inputManager.off(window,onInputCommand),events.off(playbackManager,"playerchange",onPlayerChange),enableStopOnBack){enableBackOnStop=enableStopOnBack=!1;var player=currentPlayer;player&&playbackManager.isPlayingVideo(player)&&playbackManager.stop(player)}releaseCurrentPlayer()}),dom.addEventListener(btnFullscreen,"click",function(){playbackManager.toggleFullscreen(currentPlayer)},{passive:!0}),view.querySelector(".btnPip").addEventListener("click",function(){playbackManager.togglePictureInPicture(currentPlayer)}),view.querySelector(".btnVideoOsdSettings").addEventListener("click",function(e){var btn=this;require(["playerSettingsMenu"],function(playerSettingsMenu){var player=currentPlayer;player&&playerSettingsMenu.show({player:player,positionTo:btn,stats:!0,onOption:onSettingsOption,mediaType:currentItem.MediaType})})}),view.addEventListener("viewdestroy",function(){itemShortcuts.off(videoOsdText),destroyPlayQueue(),self.touchHelper&&(self.touchHelper.destroy(),self.touchHelper=null),recordingButtonManager&&(recordingButtonManager.destroy(),recordingButtonManager=null),destroyStats()});var lastPointerEvent=0;function refreshThumbnailsIfNeeded(itemId,mediaSourceId,apiClient,maxThumbnailWidth){currentItemThumbnails||currentItemThumbnailsPromise||function(itemId,mediaSourceId,apiClient,maxThumbnailWidth){if(currentItemThumbnailsPromise)return;var promise=apiClient.getThumbnails(itemId,{MediaSourceId:mediaSourceId,Width:maxThumbnailWidth}).then(function(result){return currentItemThumbnails=result,Promise.resolve(result)},function(){currentItemThumbnailsPromise=null});currentItemThumbnailsPromise=promise}(itemId,mediaSourceId,apiClient,maxThumbnailWidth)}function onStop(){playbackManager.stop(currentPlayer)}dom.addEventListener(view,window.PointerEvent?"pointerup":"click",function(e){var pointerType=e.pointerType||(layoutManager.mobile?"touch":"mouse");switch(lastPointerUpType=pointerType){case"touch":if(dom.parentWithTag(e.target,["BUTTON","INPUT"]))return void showOsd();var now=Date.now();300<now-lastPointerEvent&&(lastPointerEvent=now,setTimeout(toggleOsd,10));break;default:if(showOsd(),dom.parentWithClass(e.target,["videoOsdBottom","upNextContainer"]))return;var player=currentPlayer;!e.button&&player&&isDisplayingLocalVideo(player)&&playbackManager.playPause(player)}},{passive:!0}),dom.addEventListener(view,"dblclick",function(e){if(!dom.parentWithTag(e.target,"BUTTON"))if("mouse"!==lastPointerUpType){var clientX=e.clientX;if(null!=clientX){var windowSize=dom.getWindowSize();clientX<=.45*windowSize.innerWidth?rewind(currentPlayer):clientX>=.55*windowSize.innerWidth&&fastForward(currentPlayer),e.preventDefault(),e.stopPropagation()}}else playbackManager.toggleFullscreen(currentPlayer)},{passive:!0}),dom.addEventListener(buttonMute,"click",function(){playbackManager.toggleMute(currentPlayer)},{passive:!0}),dom.addEventListener(nowPlayingVolumeSlider,"change",function(){playbackManager.setVolume(this.value,currentPlayer)},{passive:!0}),dom.addEventListener(nowPlayingPositionSlider,"change",function(){var player=currentPlayer;if(player){var newPercent=parseFloat(this.value);if(enableProgressByTimeOfDay){var seekAirTimeTicks=newPercent/100*(programEndDateMs-programStartDateMs)*1e4;seekAirTimeTicks+=1e4*programStartDateMs,seekAirTimeTicks-=playbackStartTimeTicks,playbackManager.seek(seekAirTimeTicks,player)}else playbackManager.seekPercent(newPercent,player)}},{passive:!0}),nowPlayingPositionSlider.getBubbleHtml=function(value){if(showOsd(),enableProgressByTimeOfDay){if(programStartDateMs&&programEndDateMs){var ms=programEndDateMs-programStartDateMs;return ms/=100,ms*=value,ms+=programStartDateMs,'<h1 class="sliderBubbleText">'+getDisplayTimeWithoutAmPm(new Date(parseInt(ms)),!0)+"</h1>"}return"--:--"}if(!currentRuntimeTicks)return"--:--";var ticks=currentRuntimeTicks;ticks/=100,ticks*=value;var item=currentItem;if(item){var apiClient=connectionManager.getApiClient(item.ServerId);refreshThumbnailsIfNeeded(item.Id,"",apiClient,400);var thumbnails=currentItemThumbnails;if(thumbnails){var html=function(apiClient,itemId,mediaSourceId,thumbnailSet,chapters,positionTicks,maxThumbnailWidth){var thumbnail,i,length,chapter,thumbnails=thumbnailSet.Thumbnails;for(i=0,length=thumbnails.length;i<length;i++){var currentThumbnail=thumbnails[i];if(positionTicks>=currentThumbnail.PositionTicks)thumbnail=currentThumbnail;else if(thumbnail)break}if(!thumbnail)return null;for(i=0,length=chapters.length;i<length;i++){var currentChapter=chapters[i];if(positionTicks>=currentChapter.StartPositionTicks)chapter=currentChapter;else if(chapter)break}chapter=chapter||{Name:"&nbsp;"};var src=function(itemId,thumbnail,maxWidth,apiClient){return thumbnail.ImageTag?apiClient.getScaledImageUrl(itemId,{maxWidth:maxWidth,tag:thumbnail.ImageTag,type:"Thumbnail",PositionTicks:thumbnail.PositionTicks}):null}(itemId,thumbnail,maxThumbnailWidth,apiClient);if(src){var html='<div class="chapterThumbContainer">',className="chapterThumbImageContainer";return thumbnailSet.AspectRatio&&thumbnailSet.AspectRatio<1.4&&(className+=" chapterThumbImageContainer-fourthree"),html+='<div class="'+className+'" style="background-image:url(\''+src+"');\">",html+="</div>",html+='<div class="chapterThumbTextContainer">',html+='<div class="chapterThumbTextContainerInner">',html+='<div class="chapterThumbText">',html+=datetime.getDisplayRunningTime(positionTicks),html+="</div>",html+="</div>",html+="</div>",html+="</div>"}return null}(apiClient,item.Id,0,thumbnails,item.Chapters||{},ticks,400);if(html)return html}}return'<h1 class="sliderBubbleText">'+datetime.getDisplayRunningTime(ticks)+"</h1>"},dom.addEventListener(osdBottomElement,transitionEndEventName,function(e){var elem=e.currentTarget;elem===e.target&&elem.classList.contains("videoOsdBottom-hidden")&&(elem.classList.add("hide"),onRewindAnimationComplete.call(btnRewindIcon),onFastForwardAnimationComplete.call(btnFastForwardIcon),view.dispatchEvent(new CustomEvent("video-osd-hide",{bubbles:!0})))},{passive:!0}),dom.addEventListener(btnPreviousTrack,"click",function(){playbackManager.previousTrack(currentPlayer)},{passive:!0}),Array.prototype.forEach.call(stopButtons,function(btnStop){btnStop.addEventListener("click",onStop)}),dom.addEventListener(btnPause,"click",function(){playbackManager.playPause(currentPlayer)},{passive:!0}),dom.addEventListener(btnNextTrack,"click",function(){playbackManager.nextTrack(currentPlayer)},{passive:!0}),dom.addEventListener(btnRewind,"click",function(){rewind(currentPlayer)},{passive:!0}),dom.addEventListener(btnFastForward,"click",function(){fastForward(currentPlayer)},{passive:!0}),dom.addEventListener(btnRepeatMode,"click",function(){!function(player){if(player)switch(playbackManager.getRepeatMode(player)){case"RepeatNone":playbackManager.setRepeatMode("RepeatAll",player);break;case"RepeatAll":playbackManager.setRepeatMode("RepeatOne",player);break;case"RepeatOne":playbackManager.setRepeatMode("RepeatNone",player)}}(currentPlayer)},{passive:!0}),dom.addEventListener(btnMore,"click",function(){!function(item,button){connectionManager.getApiClient(item.ServerId).getCurrentUser().then(function(user){return itemContextMenu.show(function(item,user,button){return{item:item,open:!1,play:!1,playAllFromHere:!1,queueAllFromHere:!1,positionTo:button,cancelTimer:!1,record:!1,deleteItem:!1,shuffle:!1,instantMix:!1,user:user,share:!0,queue:!1}}(item,user,button)).then(function(result){result.updated})})}(currentItem,this)},{passive:!0}),dom.addEventListener(btnAudio,"click",function(){var player=currentPlayer;if(player){var audioTracks=playbackManager.audioTracks(player),currentIndex=playbackManager.getAudioStreamIndex(player),menuItems=audioTracks.map(function(stream){var opt={name:stream.DisplayTitle,id:stream.Index};return stream.Index===currentIndex&&(opt.selected=!0),opt}),positionTo=this;require(["actionsheet"],function(actionsheet){actionsheet.show({items:menuItems,title:globalize.translate("Audio"),positionTo:positionTo}).then(function(id){var index=parseInt(id);index!==currentIndex&&playbackManager.setAudioStreamIndex(index,player)})})}},{passive:!0}),dom.addEventListener(btnSubtitles,"click",function(){var player=currentPlayer,streams=playbackManager.subtitleTracks(player),currentIndex=playbackManager.getSubtitleStreamIndex(player);null==currentIndex&&(currentIndex=-1),streams.unshift({Index:-1,DisplayTitle:globalize.translate("Off")});var menuItems=streams.map(function(stream){var opt={name:stream.DisplayTitle,id:stream.Index};return stream.Index===currentIndex&&(opt.selected=!0),opt}),positionTo=this;require(["actionsheet"],function(actionsheet){actionsheet.show({title:globalize.translate("Subtitles"),items:menuItems,positionTo:positionTo}).then(function(id){var index=parseInt(id);index!==currentIndex&&playbackManager.setSubtitleStreamIndex(index,player)})})},{passive:!0}),itemShortcuts.on(videoOsdText)}});