define(["appSettings","layoutManager","playbackManager","inputManager","connectionManager","appRouter","globalize","loading","dom","recordingHelper"],function(appSettings,layoutManager,playbackManager,inputManager,connectionManager,appRouter,globalize,loading,dom,recordingHelper){"use strict";function playAllFromHere(card,serverId,queue){for(var startIndex,parent=card.parentNode,className=card.classList.length?"."+card.classList[0]:"",cards=parent.querySelectorAll(className+"[data-id]"),ids=[],foundCard=!1,i=0,length=cards.length;i<length;i++)cards[i]===card&&(foundCard=!0,startIndex=i),!foundCard&&queue||ids.push(cards[i].getAttribute("data-id"));var itemsContainer=dom.parentWithClass(card,"itemsContainer");if(itemsContainer&&itemsContainer.fetchData){var queryOptions=queue?{StartIndex:startIndex}:{};return itemsContainer.fetchData(queryOptions).then(function(result){return queue?playbackManager.queue({items:result.Items||result}):playbackManager.play({items:result.Items||result,startIndex:startIndex})})}if(ids.length)return queue?playbackManager.queue({ids:ids,serverId:serverId}):playbackManager.play({ids:ids,serverId:serverId,startIndex:startIndex})}function getItem(button){var type=(button=dom.parentWithAttribute(button,"data-type")).getAttribute("data-type");if("Plugin"===type)return Promise.resolve(getItemInfoFromCard(button));if("Device"===type)return Promise.resolve(getItemInfoFromCard(button));if("Server"===type)return Promise.resolve(getItemInfoFromCard(button));var id=button.getAttribute("data-id");if(!id)return Promise.resolve(getItemInfoFromCard(button));var serverId=button.getAttribute("data-serverid"),apiClient=connectionManager.getApiClient(serverId);return"VirtualFolder"===type?function(apiClient,id){return apiClient.getVirtualFolders().then(function(items){return items.filter(function(u){return u.ItemId===id})[0]})}(apiClient,id):"User"===type?apiClient.getUser(id):"Timer"===type?apiClient.getLiveTvTimer(id):"SeriesTimer"===type?apiClient.getLiveTvSeriesTimer(id):apiClient.getItem(apiClient.getCurrentUserId(),id)}function notifyRefreshNeeded(childElement,itemsContainer){(itemsContainer=itemsContainer||dom.parentWithAttribute(childElement,"is","emby-itemscontainer"))&&itemsContainer.notifyRefreshNeeded(!0)}function showContextMenu(card,options){return getItem(card).then(function(item){var playlistId=card.getAttribute("data-playlistid"),collectionId=card.getAttribute("data-collectionid");if(playlistId){var elem=dom.parentWithAttribute(card,"data-playlistitemid");item.PlaylistItemId=elem?elem.getAttribute("data-playlistitemid"):null}return require(["itemContextMenu"]).then(function(responses){return function(item){var serverId=item.ServerId;if(!serverId)return Promise.resolve(null);var apiClient=connectionManager.getApiClient(serverId);return apiClient.getCurrentUserId()?apiClient.getCurrentUser():Promise.resolve(null)}(item).then(function(user){return responses[0].show(Object.assign({item:item,play:!0,queue:!0,playAllFromHere:!item.IsFolder,queueAllFromHere:!item.IsFolder,playlistId:playlistId,collectionId:collectionId,user:user,multiSelect:layoutManager.mobile&&"false"!==card.getAttribute("data-multiselect")},options||{})).then(function(result){if("playallfromhere"===result.command||"queueallfromhere"===result.command)return executeAction(card,options.positionTo,result.command);"addtoplaylist"===result.command||"addtocollection"===result.command||(result.updated||result.deleted)&&notifyRefreshNeeded(card,options.itemsContainer)},onRejected)})})})}function onRejected(){}function getItemInfoFromCard(card){var item={Type:card.getAttribute("data-type"),Id:card.getAttribute("data-id"),ServerId:card.getAttribute("data-serverid"),IsFolder:"true"===card.getAttribute("data-isfolder")},timerId=card.getAttribute("data-timerid");timerId&&(item.TimerId=timerId);var collectionType=card.getAttribute("data-collectiontype");collectionType&&(item.CollectionType=collectionType);var channelId=card.getAttribute("data-channelid");channelId&&(item.ChannelId=channelId);var mediaType=card.getAttribute("data-mediatype");mediaType&&(item.MediaType=mediaType);var seriesId=card.getAttribute("data-seriesid");seriesId&&(item.SeriesId=seriesId);var configpageurl=card.getAttribute("data-configpageurl");configpageurl&&(item.ConfigPageUrl=configpageurl);var startpositionticks=card.getAttribute("data-startpositionticks");return startpositionticks&&(item.StartPositionTicks=parseInt(startpositionticks)),item}function executeAction(card,target,action){target=target||card;var item=getItemInfoFromCard(card=dom.parentWithAttribute(card,"data-type")),serverId=item.ServerId,type=item.Type,playableItemId="Program"===type?item.ChannelId:item.Id;if("Photo"===item.MediaType&&"link"===action&&(action="play"),"link"===action)"AddVirtualFolder"===item.Type?function(card){card.dispatchEvent(new CustomEvent("addvirtualfolder",{cancelable:!1,bubbles:!0}))}(card):appRouter.showItem(item,{context:card.getAttribute("data-context"),parentId:card.getAttribute("data-parentid")});else if("programdialog"===action)!function(item){require(["recordingCreator"],function(recordingCreator){recordingCreator.show(item.Id,item.ServerId)})}(item);else if("instantmix"===action)playbackManager.instantMix({Id:playableItemId,ServerId:serverId});else if("play"===action||"resume"===action)playbackManager.play({ids:[playableItemId],serverId:serverId,startPositionTicks:item.StartPositionTicks});else if("queue"===action)playbackManager.isPlaying()?(playbackManager.queue({ids:[playableItemId],serverId:serverId}),function(text){require(["toast"],function(toast){toast(text)})}(globalize.translate("MediaQueued"))):playbackManager.queue({ids:[playableItemId],serverId:serverId});else if("playallfromhere"===action)playAllFromHere(card,serverId);else if("queueallfromhere"===action)playAllFromHere(card,serverId,!0);else if("setplaylistindex"===action)playbackManager.setCurrentPlaylistItem(card.getAttribute("data-playlistitemid"));else if("record"===action)!function(serverId,id,type,timerId,timerStatus,seriesTimerId){if("Program"===type||timerId||seriesTimerId){var programId="Program"===type?id:null;recordingHelper.toggleRecording(serverId,programId,timerId,timerStatus,seriesTimerId)}}(serverId,item.Id,type,card.getAttribute("data-timerid"),card.getAttribute("data-status"),card.getAttribute("data-seriestimerid"));else if("menu"===action){var options="false"===target.getAttribute("data-playoptions")?{shuffle:!1,instantMix:!1,play:!1,playAllFromHere:!1,queue:!1,queueAllFromHere:!1}:{};options.positionTo=target,showContextMenu(card,options)}else if("edit"===action)!function(apiClient,item,button){(function(apiClient,item,button){var itemType=item.Type;return"Timer"===itemType?function(itemId,serverId){return connectionManager.getApiClient(serverId).getLiveTvTimer(itemId).then(function(item){return item.ProgramId?require(["recordingCreator"]).then(function(objects){return objects[0].show(item.ProgramId,serverId)}):require(["recordingEditor"]).then(function(objects){return objects[0].show(itemId,serverId)})})}(item.Id,item.ServerId):"VirtualFolder"===itemType?function(button){return getItem(button).then(function(item){var view=dom.parentWithClass(button,"page"),refreshLibrary=!!button&&"true"===view.getAttribute("data-refreshlibrary");return require(["medialibraryeditor"]).then(function(responses){return(new responses[0]).show({refresh:refreshLibrary,library:item})})})}(button):require(["metadataEditor"]).then(function(responses){return responses[0].show(item.Id,item.ServerId)})})(0,item,button).then(function(){notifyRefreshNeeded(button)})}(connectionManager.getApiClient(item),item,card);else if("playtrailer"===action)!function(itemId,serverId){var apiClient=connectionManager.getApiClient(serverId);apiClient.getLocalTrailers(apiClient.getCurrentUserId(),itemId).then(function(trailers){playbackManager.play({items:trailers})})}(item.Id,serverId);else if("addtoplaylist"===action)!function(itemId,serverId){require(["playlistEditor"],function(playlistEditor){(new playlistEditor).show({items:[itemId],serverId:serverId})})}(item.Id,serverId);else if("multiselect"===action){dom.parentWithClass(card,"itemsContainer").showMultiSelect(dom.parentWithClass(card,"card"))}else if("custom"===action){var customAction=target.getAttribute("data-customaction");card.dispatchEvent(new CustomEvent("action-"+customAction,{detail:{playlistItemId:card.getAttribute("data-playlistitemid"),item:item},cancelable:!1,bubbles:!0}))}else"connecttoserver"===action&&function(item){if("AddServer"===item.Type)return appRouter.showItem(item);if("EmbyConnect"===item.Type)return appRouter.showConnectLogin();loading.show(),item=connectionManager.getServerInfo(item.Id)||item,connectionManager.connectToServer(item,{enableAutoLogin:appSettings.enableAutoLogin()}).then(function(result){appRouter.handleConnectionResult(result)})}(item)}function onClick(e){var card=dom.parentWithClass(e.target,"itemAction");if(card){var actionElement=card,action=actionElement.getAttribute("data-action");if(action||(actionElement=dom.parentWithAttribute(actionElement,"data-action"))&&(action=actionElement.getAttribute("data-action")),action)return executeAction(card,actionElement,action),e.preventDefault(),e.stopPropagation(),!1}}function onCommand(e){var cmd=e.detail.command;if("play"===cmd||"resume"===cmd||"record"===cmd||"menu"===cmd||"info"===cmd){var target=e.target,card=dom.parentWithClass(target,"itemAction")||dom.parentWithAttribute(target,"data-id");card&&(e.preventDefault(),e.stopPropagation(),executeAction(card,card,cmd))}}return{on:function(context,options){!1!==(options=options||{}).click&&context.addEventListener("click",onClick),!1!==options.command&&inputManager.on(context,onCommand)},off:function(context,options){options=options||{},context.removeEventListener("click",onClick),!1!==options.command&&inputManager.off(context,onCommand)},onClick:onClick,getShortcutAttributesHtml:function(item,options){var dataAttributes="";!1===options.multiSelect&&(dataAttributes+=' data-multiselect="false"');var context=options.context;context&&(dataAttributes+=' data-context="'+context+'"');var parentId=options.parentId;parentId&&(dataAttributes+=' data-parentid="'+parentId+'"'),item.StartPositionTicks&&(dataAttributes+=' data-startpositionticks="'+item.StartPositionTicks+'"'),item.ConfigPageUrl&&(dataAttributes+=' data-configpageurl="'+item.ConfigPageUrl+'"');var status=item.Status;status&&(dataAttributes+=' data-status="'+status+'"');var channelId=item.ChannelId;channelId&&(dataAttributes+=' data-channelid="'+channelId+'"'),item.CollectionType&&(dataAttributes+=' data-collectiontype="'+item.CollectionType+'"');var type=item.Type;type&&(dataAttributes+=' data-type="'+type+'"');var mediaType=item.MediaType;mediaType&&(dataAttributes+=' data-mediatype="'+mediaType+'"'),options.collectionId?dataAttributes+=' data-collectionid="'+options.collectionId+'"':options.playlistId&&(dataAttributes+=' data-playlistid="'+options.playlistId+'"'),item.IsFolder&&(dataAttributes+=' data-isfolder="true"');var playlistItemId=item.PlaylistItemId;playlistItemId&&(dataAttributes+=' data-playlistitemid="'+playlistItemId+'"');var serverId=item.ServerId||options.serverId;serverId&&(dataAttributes+=' data-serverid="'+serverId+'"');var itemId=item.Id||item.ItemId;itemId&&(dataAttributes+=' data-id="'+itemId+'"');var nameWithPrefix=item.SortName||item.Name||"",prefix=nameWithPrefix.substring(0,Math.min(3,nameWithPrefix.length));return(prefix=prefix&&prefix.toUpperCase())&&(dataAttributes+=' data-prefix="'+prefix+'"'),item.TimerId&&(dataAttributes+=' data-timerid="'+item.TimerId+'"'),item.SeriesTimerId&&(dataAttributes+=' data-seriestimerid="'+item.SeriesTimerId+'"'),dataAttributes}}});