/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import org.eclipse.dltk.internal.ui.actions.MultiActionGroup;
import org.eclipse.dltk.internal.ui.scriptview.ScriptMessages;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class CommonLayoutActionGroup
extends MultiActionGroup {
    private IExtensionStateModel fStateModel;
    private StructuredViewer fStructuredViewer;
    private boolean fHasContributedToViewMenu = false;
    private IAction fHierarchicalLayout = null;
    private IAction fFlatLayoutAction = null;
    private IAction[] actions;

    public CommonLayoutActionGroup(StructuredViewer structuredViewer, IExtensionStateModel stateModel) {
        this.fStateModel = stateModel;
        this.fStructuredViewer = structuredViewer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        if (!this.fHasContributedToViewMenu) {
            CommonLayoutActionGroup commonLayoutActionGroup = this;
            synchronized (commonLayoutActionGroup) {
                if (!this.fHasContributedToViewMenu) {
                    this.fHasContributedToViewMenu = true;
                    this.contributeToViewMenu(actionBars.getMenuManager());
                }
            }
        }
    }

    private void contributeToViewMenu(IMenuManager viewMenu) {
        String layoutGroupName = "layout";
        MenuManager layoutSubMenu = new MenuManager(ScriptMessages.LayoutActionGroup_label);
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IContributionItem)new Separator("additions"));
        viewMenu.add((IContributionItem)new Separator("layout"));
        viewMenu.appendToGroup("layout", (IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)layoutSubMenu);
    }

    private IAction[] createActions() {
        this.fFlatLayoutAction = new CommonLayoutAction(true);
        this.fFlatLayoutAction.setText(ScriptMessages.LayoutActionGroup_flatLayoutAction_label);
        DLTKPluginImages.setLocalImageDescriptors(this.fFlatLayoutAction, "flatLayout.png");
        this.fHierarchicalLayout = new CommonLayoutAction(false);
        this.fHierarchicalLayout.setText(ScriptMessages.LayoutActionGroup_hierarchicalLayoutAction_label);
        DLTKPluginImages.setLocalImageDescriptors(this.fHierarchicalLayout, "hierarchicalLayout.png");
        return new IAction[]{this.fFlatLayoutAction, this.fHierarchicalLayout};
    }

    public void setFlatLayout(boolean flatLayout) {
        if (this.actions == null) {
            this.actions = this.createActions();
            this.setActions(this.actions, flatLayout ? 0 : 1);
        }
        this.fHierarchicalLayout.setChecked(!flatLayout);
        this.fFlatLayoutAction.setChecked(flatLayout);
    }

    private class CommonLayoutAction
    extends Action
    implements IAction {
        private final boolean fIsFlatLayout;

        public CommonLayoutAction(boolean flat) {
            super("", 8);
            this.fIsFlatLayout = flat;
        }

        public void run() {
            if (CommonLayoutActionGroup.this.fStateModel.getBooleanProperty("isLayoutFlat") != this.fIsFlatLayout) {
                CommonLayoutActionGroup.this.fStateModel.setBooleanProperty("isLayoutFlat", this.fIsFlatLayout);
                CommonLayoutActionGroup.this.fStructuredViewer.getControl().setRedraw(false);
                try {
                    CommonLayoutActionGroup.this.fStructuredViewer.refresh();
                }
                finally {
                    CommonLayoutActionGroup.this.fStructuredViewer.getControl().setRedraw(true);
                }
            }
        }
    }
}

