/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.select;

import java.util.Iterator;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.select.SelectTableElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;

public class RemoveOrderByExpressionAction
extends Action {
    TableViewer gridViewer;

    public RemoveOrderByExpressionAction(TableViewer gridViewer) {
        super(Messages._UI_ACTION_REMOVE_ORDER_BY_EXPRESSION);
        this.gridViewer = gridViewer;
    }

    public void run() {
        ISelection selection = this.gridViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection es = (IStructuredSelection)selection;
        Iterator elements = es.iterator();
        this.gridViewer.cancelEditing();
        while (elements.hasNext()) {
            Object item = elements.next();
            if (!(item instanceof SelectTableElement)) continue;
            SelectTableElement tableElement = (SelectTableElement)item;
            SQLQueryObject selectStatement = tableElement.getSelectStatement();
            QueryValueExpression sqlExpr = tableElement.getSQLExpression();
            if (sqlExpr == null) continue;
            SelectHelper.removeColumnFromOrderBy(selectStatement, sqlExpr);
            SelectHelper.refresh(selectStatement);
        }
    }
}

