/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import org.eclipse.pde.api.tools.internal.provisional.IApiAccess;

public class ApiAccess
implements IApiAccess {
    public static final IApiAccess NORMAL_ACCESS = new NormalAccess();
    private int access = 0;

    public ApiAccess(int access) {
        this.access = access;
    }

    @Override
    public int getAccessLevel() {
        return this.access;
    }

    public int hashCode() {
        return this.access;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiAccess) {
            return this.access == ((IApiAccess)obj).getAccessLevel();
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Access Level: ");
        buffer.append(ApiAccess.getAccessText(this.getAccessLevel()));
        return buffer.toString();
    }

    public static String getAccessText(int access) {
        switch (access) {
            case 0: {
                return "NORMAL";
            }
            case 1: {
                return "FRIEND";
            }
        }
        return "<UNKNOWN ACCESS LEVEL>";
    }

    static class NormalAccess
    implements IApiAccess {
        NormalAccess() {
        }

        @Override
        public int getAccessLevel() {
            return 0;
        }
    }
}

