/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.dialogs.MavenRepositorySearchDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.part.FileEditorInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPomAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IObjectActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(OpenPomAction.class);
    String type = "artifact";
    private IStructuredSelection selection;
    private MavenProject mavenProject;

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mavenProject = (MavenProject)targetPart.getAdapter(MavenProject.class);
    }

    protected MavenProject getMavenProject() {
        return this.mavenProject;
    }

    public void run(IAction action) {
        if (this.selection != null) {
            Object element = this.selection.getFirstElement();
            if ("artifact".equals(this.type) && element != null) {
                try {
                    final ArtifactKey ak = SelectionUtil.getArtifactKey(element);
                    if (ak != null) {
                        new Job(Messages.OpenPomAction_job_opening){

                            protected IStatus run(IProgressMonitor monitor) {
                                OpenPomAction.openEditor(ak.getGroupId(), ak.getArtifactId(), ak.getVersion(), OpenPomAction.this.getMavenProject(), monitor);
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                        return;
                    }
                }
                catch (CoreException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.OpenPomAction_open_error_title, (String)Messages.OpenPomAction_open_error_message);
                        }
                    });
                }
            }
        }
        String title = Messages.OpenPomAction_title_pom;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        MavenRepositorySearchDialog dialog = MavenRepositorySearchDialog.createOpenPomDialog(shell, title);
        if (dialog.open() == 0) {
            final IndexedArtifactFile iaf = (IndexedArtifactFile)dialog.getFirstResult();
            new Job(Messages.OpenPomAction_job_opening){

                protected IStatus run(IProgressMonitor monitor) {
                    if (iaf != null) {
                        OpenPomAction.openEditor(iaf.group, iaf.artifact, iaf.version, monitor);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }

    public static void openEditor(IndexedArtifact ia, IndexedArtifactFile f, IProgressMonitor monitor) {
        new OpenPomAction().openPomEditor(ia, f, monitor);
    }

    public void openPomEditor(IndexedArtifact ia, IndexedArtifactFile f, IProgressMonitor monitor) {
        if (f == null || ia.getClassname() == null || ia.getPackageName() == null) {
            return;
        }
        String groupId = f.getDependency().getGroupId();
        String artifactId = f.getDependency().getArtifactId();
        String version = f.getDependency().getVersion();
        String name = ia.getClassname();
        String fileName = String.valueOf(ia.getPackageName().replace('.', '/')) + "/" + ia.getClassname() + ".java";
        String tooltip = String.valueOf(groupId) + ":" + artifactId + ":" + version + "/" + fileName;
        try {
            IMaven maven = MavenPlugin.getMaven();
            List artifactRepositories = maven.getArtifactRepositories();
            Artifact artifact = maven.resolve(groupId, artifactId, version, "java-source", "sources", artifactRepositories, monitor);
            File file = artifact.getFile();
            if (file == null) {
                this.openDialog(NLS.bind((String)Messages.OpenPomAction_error_download_source, (Object)tooltip));
                return;
            }
            String url = "jar:" + file.toURL().toString() + "!/" + fileName;
            InputStream is = new URL(url).openStream();
            byte[] buff = OpenPomAction.readStream(is);
            OpenPomAction.openEditor((IEditorInput)new MavenPathStorageEditorInput(String.valueOf(name) + ".java", tooltip, url, buff), String.valueOf(name) + ".java");
        }
        catch (IOException ex) {
            String msg = NLS.bind((String)Messages.OpenPomAction_error_open_editor, (Object)name);
            log.error(msg, (Throwable)ex);
            this.openDialog(String.valueOf(msg) + "\n" + ex.toString());
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            this.openDialog(String.valueOf(ex.getMessage()) + "\n" + ex.toString());
        }
    }

    public static IEditorPart openEditor(String groupId, String artifactId, String version, IProgressMonitor monitor) {
        return OpenPomAction.openEditor(groupId, artifactId, version, null, monitor);
    }

    public static IEditorPart openEditor(String groupId, String artifactId, String version, MavenProject project, IProgressMonitor monitor) {
        return new OpenPomAction().openPomEditor(groupId, artifactId, version, project, monitor);
    }

    public IEditorPart openPomEditor(String groupId, String artifactId, String version, MavenProject project, IProgressMonitor monitor) {
        if (groupId.length() > 0 && artifactId.length() > 0) {
            String name = String.valueOf(groupId) + ":" + artifactId + ":" + version + ".pom";
            try {
                List artifactRepositories;
                IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
                IMavenProjectFacade projectFacade = projectManager.getMavenProject(groupId, artifactId, version);
                if (projectFacade != null) {
                    IFile pomFile = projectFacade.getPom();
                    return this.openPomEditor((IEditorInput)new FileEditorInput(pomFile), name);
                }
                IMaven maven = MavenPlugin.getMaven();
                Artifact artifact = maven.resolve(groupId, artifactId, version, "pom", null, artifactRepositories = project != null ? project.getRemoteArtifactRepositories() : maven.getArtifactRepositories(), monitor);
                File file = artifact.getFile();
                if (file != null) {
                    return this.openPomEditor((IEditorInput)new MavenPathStorageEditorInput(name, name, file.getAbsolutePath(), OpenPomAction.readStream(new FileInputStream(file))), name);
                }
                this.openDialog(NLS.bind((String)Messages.OpenPomAction_error_download, (Object)name));
            }
            catch (IOException ex) {
                String msg = NLS.bind((String)Messages.OpenPomAction_error_open_pom, (Object)name);
                log.error(msg, (Throwable)ex);
                this.openDialog(String.valueOf(msg) + "\n" + ex.toString());
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
                this.openDialog(String.valueOf(ex.getMessage()) + "\n" + ex.toString());
            }
        }
        return null;
    }

    public static IEditorPart openEditor(IEditorInput editorInput, String name) {
        return new OpenPomAction().openPomEditor(editorInput, name);
    }

    public IEditorPart openPomEditor(final IEditorInput editorInput, final String name) {
        final IEditorPart[] part = new IEditorPart[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page;
                IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
                IContentType contentType = contentTypeManager.findContentTypeFor(name);
                IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
                IEditorDescriptor editor = editorRegistry.getDefaultEditor(name, contentType);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    try {
                        part[0] = page.openEditor(editorInput, editor.getId());
                    }
                    catch (PartInitException ex) {
                        OpenPomAction.this.openDialog(NLS.bind((String)Messages.OpenPomAction_33, (Object)editorInput.getName(), (Object)ex.toString()));
                    }
                }
            }
        });
        return part[0];
    }

    protected void openDialog(final String msg) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.OpenPomAction_open_title, (String)msg);
            }
        };
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == Display.getCurrent()) {
            r.run();
        } else {
            display.asyncExec(r);
        }
    }

    private static byte[] readStream(InputStream is) throws IOException {
        byte[] b = new byte[is.available()];
        int len = 0;
        while (true) {
            byte[] c;
            int n;
            if ((n = is.read(b, len, b.length - len)) == -1) {
                if (len < b.length) {
                    c = new byte[len];
                    System.arraycopy(b, 0, c, 0, len);
                    b = c;
                }
                return b;
            }
            if ((len += n) != b.length) continue;
            c = new byte[b.length + 1000];
            System.arraycopy(b, 0, c, 0, len);
            b = c;
        }
    }

    public static class MavenPathStorageEditorInput
    extends MavenStorageEditorInput
    implements IPathEditorInput {
        public MavenPathStorageEditorInput(String name, String tooltip, String path, byte[] content) {
            super(name, tooltip, path, content);
        }

        public boolean equals(Object obj) {
            IPath path = this.getPath();
            if (path != null && obj instanceof MavenPathStorageEditorInput) {
                return path.equals((Object)((MavenPathStorageEditorInput)obj).getPath());
            }
            return super.equals(obj);
        }
    }

    private static class MavenStorage
    implements IStorage {
        private String name;
        private final String path;
        private final byte[] content;

        public MavenStorage(String name, String path, byte[] content) {
            this.name = name;
            this.path = path;
            this.content = content;
        }

        public String getName() {
            return this.name;
        }

        public IPath getFullPath() {
            return this.path == null ? null : new Path(this.path);
        }

        public InputStream getContents() {
            return new ByteArrayInputStream(this.content);
        }

        public boolean isReadOnly() {
            return true;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }
    }

    public static class MavenStorageEditorInput
    implements IStorageEditorInput {
        private final String name;
        private final String path;
        private final String tooltip;
        private final byte[] content;

        public MavenStorageEditorInput(String name, String tooltip, String path, byte[] content) {
            this.name = name;
            this.path = path;
            this.tooltip = tooltip;
            this.content = content;
        }

        public boolean exists() {
            return true;
        }

        public String getName() {
            return this.name;
        }

        public String getToolTipText() {
            return this.tooltip;
        }

        public IStorage getStorage() {
            return new MavenStorage(this.name, this.path, this.content);
        }

        public ImageDescriptor getImageDescriptor() {
            return null;
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public IPath getPath() {
            return this.path == null ? null : new Path(this.path);
        }
    }
}

