/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.overridemethods;

import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.INodeFactory;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMember;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPNodeFactory;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.rewrite.DeclarationGenerator;
import org.eclipse.cdt.internal.ui.refactoring.CRefactoringContext;
import org.eclipse.cdt.internal.ui.refactoring.overridemethods.OverrideOptions;
import org.eclipse.cdt.internal.ui.refactoring.utils.DefinitionFinder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class Method {
    private IASTDeclSpecifier fDeclSpecifier;
    private ICPPMethod fMethod;
    private OverrideOptions fOptions;

    public Method(ICPPMethod method, IASTDeclSpecifier declSpecifier, OverrideOptions options) {
        this.fMethod = method;
        this.fOptions = options;
        this.fDeclSpecifier = declSpecifier;
    }

    public Method(ICPPMethod method, OverrideOptions options) {
        this.fMethod = method;
        this.fOptions = options;
        this.fDeclSpecifier = null;
    }

    public int hashCode() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.fMethod.getName());
        ICPPParameter[] iCPPParameterArray = this.fMethod.getParameters();
        int n = iCPPParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPParameter parameter = iCPPParameterArray[n2];
            stringBuilder.append(parameter.getType());
            ++n2;
        }
        return stringBuilder.toString().hashCode();
    }

    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    public ICPPMethod getMethod() {
        return this.fMethod;
    }

    public void setMethod(ICPPMethod fMethod) {
        this.fMethod = fMethod;
    }

    public String toString() {
        return this.fMethod.toString();
    }

    public IASTDeclSpecifier getDeclSpecifier() {
        return this.fDeclSpecifier;
    }

    public IASTNode createNode(CRefactoringContext context) throws OperationCanceledException, CoreException {
        ICPPFunctionType functionType = this.fMethod.getDeclaredType();
        ICPPParameter[] parameters = this.fMethod.getParameters();
        IASTName declaration = DefinitionFinder.getMemberDeclaration((ICPPMember)this.fMethod, this.getDeclSpecifier().getTranslationUnit(), context, null);
        INodeFactory factory = this.getDeclSpecifier().getTranslationUnit().getASTNodeFactory();
        DeclarationGenerator declGen = DeclarationGenerator.create((INodeFactory)factory);
        if (declaration == null) {
            return null;
        }
        IASTDeclarator declarator = (IASTDeclarator)declaration.getParent();
        IASTStandardFunctionDeclarator newDeclarator = factory.newFunctionDeclarator(declarator.getName().copy());
        IASTDeclSpecifier newDeclSpec = declGen.createDeclSpecFromType((IType)functionType);
        if (newDeclSpec instanceof ICPPASTDeclSpecifier && this.fOptions.preserveVirtual()) {
            ((ICPPASTDeclSpecifier)newDeclSpec).setVirtual(true);
        }
        IASTSimpleDeclaration simple = factory.newSimpleDeclaration(newDeclSpec);
        if (newDeclarator instanceof ICPPASTFunctionDeclarator) {
            ICPPASTFunctionDeclarator funcDeclarator = (ICPPASTFunctionDeclarator)newDeclarator;
            funcDeclarator.setPureVirtual(false);
            funcDeclarator.setConst(functionType.isConst());
            if (this.fOptions.addOverride()) {
                funcDeclarator.addVirtSpecifier(((ICPPNodeFactory)factory).newVirtSpecifier(ICPPASTVirtSpecifier.SpecifierKind.Override));
            }
            ICPPParameter[] iCPPParameterArray = parameters;
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPParameter par = iCPPParameterArray[n2];
                IASTDeclarator parDeclarator = declGen.createDeclaratorFromType(par.getType(), par.getName().toCharArray());
                IASTDeclSpecifier parSpecifier = declGen.createDeclSpecFromType(par.getType());
                IASTParameterDeclaration parameter = factory.newParameterDeclaration(parSpecifier, parDeclarator);
                funcDeclarator.addParameterDeclaration(parameter);
                ++n2;
            }
            iCPPParameterArray = declarator.getPointerOperators();
            n = iCPPParameterArray.length;
            n2 = 0;
            while (n2 < n) {
                ICPPParameter op = iCPPParameterArray[n2];
                funcDeclarator.addPointerOperator(op.copy());
                ++n2;
            }
            if (declarator instanceof ICPPASTFunctionDeclarator) {
                ICPPASTFunctionDeclarator orig = (ICPPASTFunctionDeclarator)declarator;
                funcDeclarator.setRefQualifier(orig.getRefQualifier());
                IASTTypeId[] typesId = orig.getExceptionSpecification();
                if (typesId == IASTTypeId.EMPTY_TYPEID_ARRAY) {
                    funcDeclarator.setEmptyExceptionSpecification();
                } else {
                    IASTTypeId[] iASTTypeIdArray = typesId;
                    int n3 = typesId.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IASTTypeId typeId = iASTTypeIdArray[n4];
                        funcDeclarator.addExceptionSpecificationTypeId(typeId == null ? null : typeId.copy());
                        ++n4;
                    }
                }
                ICPPASTExpression noexceptExpression = orig.getNoexceptExpression();
                if (noexceptExpression != null) {
                    funcDeclarator.setNoexceptExpression(noexceptExpression == ICPPASTFunctionDeclarator.NOEXCEPT_DEFAULT ? noexceptExpression : (ICPPASTExpression)noexceptExpression.copy());
                }
            }
        }
        simple.addDeclarator((IASTDeclarator)newDeclarator);
        simple.setDeclSpecifier(newDeclSpec);
        simple.setParent((IASTNode)this.getDeclSpecifier());
        return simple;
    }
}

