/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.osgi.service.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewPaneRenderingMgr
implements IDebugEventSetListener {
    private final ArrayList<IMemoryRendering> fRenderings = new ArrayList();
    private final IMemoryRenderingContainer fViewPane;
    private static final String RENDERINGS_TAG = "persistedMemoryRenderings";
    private static final String MEMORY_RENDERING_TAG = "memoryRendering";
    private static final String MEMORY_BLOCK = "memoryBlock";
    private static final String RENDERING_ID = "renderingId";

    public ViewPaneRenderingMgr(IMemoryRenderingContainer viewPane) {
        this.fViewPane = viewPane;
        this.loadPersistedRenderings(this.getPrefId());
    }

    public void removeMemoryBlockRendering(IMemoryBlock mem, String renderingId) {
        if (this.fRenderings == null) {
            return;
        }
        IMemoryRendering[] toRemove = this.getRenderings(mem, renderingId);
        int i = 0;
        while (i < toRemove.length) {
            this.fRenderings.remove(toRemove[i]);
            if (this.fRenderings.isEmpty()) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            }
            ++i;
        }
        this.storeRenderings();
    }

    public void addMemoryBlockRendering(IMemoryRendering rendering) {
        if (this.fRenderings.contains(rendering)) {
            return;
        }
        this.fRenderings.add(rendering);
        if (this.fRenderings.size() == 1) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
        this.storeRenderings();
    }

    public void removeMemoryBlockRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        if (!this.fRenderings.contains(rendering)) {
            return;
        }
        this.fRenderings.remove(rendering);
        if (this.fRenderings.isEmpty()) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }
        this.storeRenderings();
    }

    public IMemoryRendering[] getRenderings(IMemoryBlock mem, String renderingId) {
        if (renderingId == null) {
            return this.getRenderingsFromMemoryBlock(mem);
        }
        ArrayList<IMemoryRendering> ret = new ArrayList<IMemoryRendering>();
        int i = 0;
        while (i < this.fRenderings.size()) {
            IMemoryRendering rendering;
            if (this.fRenderings.get(i) != null && (rendering = this.fRenderings.get(i)).getMemoryBlock() == mem && renderingId.equals(rendering.getRenderingId())) {
                ret.add(rendering);
            }
            ++i;
        }
        return ret.toArray(new IMemoryRendering[ret.size()]);
    }

    public IMemoryRendering[] getRenderings() {
        return this.fRenderings.toArray(new IMemoryRendering[this.fRenderings.size()]);
    }

    public IMemoryRendering[] getRenderingsFromDebugTarget(IDebugTarget target) {
        ArrayList<IMemoryRendering> ret = new ArrayList<IMemoryRendering>();
        int i = 0;
        while (i < this.fRenderings.size()) {
            IMemoryRendering rendering;
            if (this.fRenderings.get(i) != null && (rendering = this.fRenderings.get(i)).getMemoryBlock().getDebugTarget() == target) {
                ret.add(rendering);
            }
            ++i;
        }
        return ret.toArray(new IMemoryRendering[ret.size()]);
    }

    public IMemoryRendering[] getRenderingsFromMemoryBlock(IMemoryBlock block) {
        ArrayList<IMemoryRendering> ret = new ArrayList<IMemoryRendering>();
        int i = 0;
        while (i < this.fRenderings.size()) {
            IMemoryRendering rendering;
            if (this.fRenderings.get(i) != null && (rendering = this.fRenderings.get(i)).getMemoryBlock() == block) {
                ret.add(rendering);
            }
            ++i;
        }
        return ret.toArray(new IMemoryRendering[ret.size()]);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            this.handleDebugEvent(events[i]);
            ++i;
        }
    }

    public void handleDebugEvent(DebugEvent event) {
        Object obj = event.getSource();
        IDebugTarget dt = null;
        if (event.getKind() == 8 && obj instanceof IDebugTarget) {
            dt = (IDebugTarget)obj;
            IMemoryRendering[] deletedrendering = this.getRenderingsFromDebugTarget(dt);
            int i = 0;
            while (i < deletedrendering.length) {
                this.removeMemoryBlockRendering(deletedrendering[i].getMemoryBlock(), deletedrendering[i].getRenderingId());
                this.fViewPane.removeMemoryRendering(deletedrendering[i]);
                ++i;
            }
        }
    }

    public void dispose() {
        this.fRenderings.clear();
        String secondaryId = this.getViewSiteSecondaryId();
        if (secondaryId != null) {
            String prefid = this.getPrefId();
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
            if (node != null) {
                node.remove(prefid);
                try {
                    node.flush();
                }
                catch (BackingStoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    private void storeRenderings() {
        String renderingsStr = "";
        try {
            renderingsStr = this.getRenderingsAsXML();
        }
        catch (IOException e) {
            DebugUIPlugin.log(e);
        }
        catch (ParserConfigurationException e) {
            DebugUIPlugin.log(e);
        }
        catch (TransformerException e) {
            DebugUIPlugin.log(e);
        }
        String prefid = this.getPrefId();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
        if (node != null) {
            if (renderingsStr != null) {
                node.put(prefid, renderingsStr);
            } else {
                IEclipsePreferences def = DefaultScope.INSTANCE.getNode(DebugUIPlugin.getUniqueIdentifier());
                if (def != null) {
                    node.put(prefid, def.get(prefid, ""));
                }
            }
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                DebugUIPlugin.log(e);
            }
        }
    }

    private String getPrefId() {
        IViewSite vs;
        String secondaryId;
        StringBuilder id = new StringBuilder();
        IMemoryRenderingSite renderingSite = this.fViewPane.getMemoryRenderingSite();
        IWorkbenchPartSite ps = renderingSite.getSite();
        if (ps instanceof IViewSite && (secondaryId = (vs = (IViewSite)ps).getSecondaryId()) != null) {
            id.append(secondaryId);
            id.append(":");
        }
        id.append(this.fViewPane.getId());
        String prefId = id.toString();
        return prefId;
    }

    private String getRenderingsAsXML() throws IOException, ParserConfigurationException, TransformerException {
        IMemoryRendering[] renderings = this.fRenderings.toArray(new IMemoryRendering[this.fRenderings.size()]);
        if (renderings.length == 0) {
            return null;
        }
        Document document = LaunchManager.getDocument();
        Element rootElement = document.createElement(RENDERINGS_TAG);
        document.appendChild(rootElement);
        int i = 0;
        while (i < renderings.length) {
            IMemoryRendering rendering = renderings[i];
            Element element = document.createElement(MEMORY_RENDERING_TAG);
            element.setAttribute(MEMORY_BLOCK, Integer.toString(rendering.getMemoryBlock().hashCode()));
            element.setAttribute(RENDERING_ID, rendering.getRenderingId());
            rootElement.appendChild(element);
            ++i;
        }
        return LaunchManager.serializeDocument((Document)document);
    }

    private void loadPersistedRenderings(String prefId) {
        Element root;
        String renderingsStr = Platform.getPreferencesService().getString(DebugUIPlugin.getUniqueIdentifier(), prefId, "", null);
        if (renderingsStr.length() == 0) {
            return;
        }
        try {
            root = DebugPlugin.parseDocument((String)renderingsStr);
        }
        catch (CoreException coreException) {
            DebugUIPlugin.logErrorMessage("An exception occurred while loading memory renderings.");
            return;
        }
        if (!root.getNodeName().equals(RENDERINGS_TAG)) {
            DebugUIPlugin.logErrorMessage("Invalid format encountered while loading memory renderings.");
            return;
        }
        NodeList list = root.getChildNodes();
        boolean renderingsAdded = false;
        int i = 0;
        int numItems = list.getLength();
        while (i < numItems) {
            Node node = list.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                if (!element.getNodeName().equals(MEMORY_RENDERING_TAG)) {
                    DebugUIPlugin.logErrorMessage("Invalid XML element encountered while loading memory rendering.");
                } else {
                    String memoryBlockHashCode = element.getAttribute(MEMORY_BLOCK);
                    String renderingId = element.getAttribute(RENDERING_ID);
                    IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks();
                    IMemoryBlock memoryBlock = null;
                    int j = 0;
                    while (j < memoryBlocks.length) {
                        if (Integer.toString(memoryBlocks[j].hashCode()).equals(memoryBlockHashCode)) {
                            memoryBlock = memoryBlocks[j];
                        }
                        ++j;
                    }
                    if (memoryBlock != null) {
                        IMemoryRenderingType[] types = DebugUITools.getMemoryRenderingManager().getRenderingTypes(memoryBlock);
                        IMemoryRenderingType type = null;
                        int k = 0;
                        while (k < types.length) {
                            if (types[k].getId().equals(renderingId)) {
                                type = types[k];
                            }
                            ++k;
                        }
                        if (type != null) {
                            try {
                                IMemoryRendering rendering = type.createRendering();
                                if (rendering != null) {
                                    rendering.init(this.fViewPane, memoryBlock);
                                    if (!this.fRenderings.contains(rendering)) {
                                        this.fRenderings.add(rendering);
                                        renderingsAdded = true;
                                    }
                                }
                            }
                            catch (CoreException e1) {
                                DebugUIPlugin.log(e1);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        if (renderingsAdded) {
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        }
    }

    private String getViewSiteSecondaryId() {
        IMemoryRenderingSite renderingSite = this.fViewPane.getMemoryRenderingSite();
        IWorkbenchPartSite ps = renderingSite.getSite();
        if (ps instanceof IViewSite) {
            IViewSite vs = (IViewSite)ps;
            String secondaryId = vs.getSecondaryId();
            return secondaryId;
        }
        return null;
    }
}

