/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceCreator;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;

public class ResourcePropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.resource";
    public static final String PROP_CAN_OPEN = "canOpen";
    public static final String PROP_CAN_CREATE_FILE = "canCreateFile";
    public static final String PROP_CAN_CREATE_FOLDER = "canCreateFolder";
    public static final String PROP_CAN_CREATE_LINK = "canCreateLink";
    public static final String PROP_CAN_SET_ACTIVE = "canSetActive";
    public static final String PROP_CAN_DELETE = "canDelete";
    public static final String PROP_TYPE = "type";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof IResource)) {
            return false;
        }
        IResource resource = (IResource)receiver;
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        DBPResourceHandler handler = workspace.getResourceHandler(resource);
        if (handler == null) {
            return false;
        }
        switch (property) {
            case "canOpen": {
                return (handler.getFeatures(resource) & 1) != 0;
            }
            case "canDelete": {
                return (handler.getFeatures(resource) & 2) != 0;
            }
            case "canCreateFile": {
                return handler instanceof DBPResourceCreator && (handler.getFeatures(resource) & 0x20) != 0;
            }
            case "canCreateFolder": {
                return (handler.getFeatures(resource) & 4) != 0;
            }
            case "canCreateLink": {
                return (handler.getFeatures(resource) & 4) != 0 && !resource.isLinked(512);
            }
            case "canSetActive": {
                DBPProject activeProject = workspace.getActiveProject();
                return resource instanceof IProject && (activeProject == null || resource != activeProject.getEclipseProject());
            }
            case "type": {
                DBPResourceHandler resourceHandler = DBWorkbench.getPlatform().getWorkspace().getResourceHandler(resource);
                return resourceHandler != null && expectedValue.equals(resourceHandler.getTypeName(resource));
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.resource." + propName));
    }
}

