/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.preferences;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.runtime.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageSQLExecute
extends TargetPrefPage {
    private static final Log log = Log.getLog(PrefPageSQLExecute.class);
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.sqlexecute";
    private Button invalidateBeforeExecuteCheck;
    private Spinner executeTimeoutText;
    private Button soundOnQueryEnd;
    private Button updateDefaultAfterExecute;
    private Button clearOutputBeforeExecute;
    private Combo commitTypeCombo;
    private Combo errorHandlingCombo;
    private Spinner commitLinesText;
    private Button fetchResultSetsCheck;
    private Button resetCursorCheck;
    private Button maxEditorCheck;
    private Text statementDelimiterText;
    private Button ignoreNativeDelimiter;
    private Button blankLineDelimiter;
    private Button removeTrailingDelimiter;
    private Button enableSQLParameters;
    private Button enableSQLAnonymousParameters;
    private Text anonymousParameterMarkText;
    private Text namedParameterPrefixText;
    private Button enableParametersInDDL;
    private Button enableVariables;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("statement.invalidate.before.execute") || store.contains("statement.timeout") || store.contains("script.commit.type") || store.contains("script.error.handling") || store.contains("script.commit.lines") || store.contains("script.fetch.resultset") || store.contains("script.sql.delimiter") || store.contains("script.sql.ignoreNativeDelimiter") || store.contains("script.sql.delimiter.blank") || store.contains("script.sql.query.remove.trailing.delimiter") || store.contains("sql.parameter.enabled") || store.contains("sql.parameter.ddl.enabled") || store.contains("sql.parameter.anonymous.enabled") || store.contains("sql.parameter.mark") || store.contains("sql.parameter.prefix") || store.contains("sql.variables.enabled") || store.contains("SQLEditor.resetCursorOnExecute") || store.contains("SQLEditor.maxEditorOnScriptExecute") || store.contains("SQLEditor.beepOnQueryEnd") || store.contains("SQLEditor.refreshDefaultsAfterExecute") || store.contains("SQLEditor.clearOutputBeforeExecute");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group commonGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_common, (int)2, (int)770, (int)0);
        this.invalidateBeforeExecuteCheck = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_invalidate_before_execute, null, (boolean)false, (int)2);
        this.soundOnQueryEnd = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_sound_on_query_end, null, (boolean)false, (int)2);
        this.updateDefaultAfterExecute = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_refresh_defaults_after_execute, (String)SQLEditorMessages.pref_page_sql_editor_label_refresh_defaults_after_execute_tip, (boolean)false, (int)2);
        this.clearOutputBeforeExecute = UIUtils.createCheckbox((Composite)commonGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_clear_output_before_execute, (String)SQLEditorMessages.pref_page_sql_editor_label_clear_output_before_execute_tip, (boolean)false, (int)2);
        UIUtils.createControlLabel((Composite)commonGroup, (String)(String.valueOf(SQLEditorMessages.pref_page_sql_editor_label_sql_timeout) + UIMessages.label_sec));
        this.executeTimeoutText = new Spinner((Composite)commonGroup, 2048);
        this.executeTimeoutText.setSelection(0);
        this.executeTimeoutText.setDigits(0);
        this.executeTimeoutText.setIncrement(1);
        this.executeTimeoutText.setMinimum(0);
        this.executeTimeoutText.setMaximum(100000);
        this.executeTimeoutText.setToolTipText(SQLEditorMessages.pref_page_sql_editor_label_sql_timeout_tip);
        Group scriptsGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_scripts, (int)2, (int)768, (int)0);
        UIUtils.createControlLabel((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_commit_type);
        this.commitTypeCombo = new Combo((Composite)scriptsGroup, 2060);
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_script_end, SQLScriptCommitType.AT_END.ordinal());
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_each_line_autocommit, SQLScriptCommitType.AUTOCOMMIT.ordinal());
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_each_spec_line, SQLScriptCommitType.NLINES.ordinal());
        this.commitTypeCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_no_commit, SQLScriptCommitType.NO_COMMIT.ordinal());
        UIUtils.createControlLabel((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_commit_after_line);
        this.commitLinesText = new Spinner((Composite)scriptsGroup, 2048);
        this.commitLinesText.setSelection(0);
        this.commitLinesText.setDigits(0);
        this.commitLinesText.setIncrement(1);
        this.commitLinesText.setMinimum(1);
        this.commitLinesText.setMaximum(0x100000);
        UIUtils.createControlLabel((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_label_error_handling);
        this.errorHandlingCombo = new Combo((Composite)scriptsGroup, 2060);
        this.errorHandlingCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_stop_rollback, SQLScriptErrorHandling.STOP_ROLLBACK.ordinal());
        this.errorHandlingCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_stop_commit, SQLScriptErrorHandling.STOP_COMMIT.ordinal());
        this.errorHandlingCombo.add(SQLEditorMessages.pref_page_sql_editor_combo_item_ignore, SQLScriptErrorHandling.IGNORE.ordinal());
        this.fetchResultSetsCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_fetch_resultsets, null, (boolean)false, (int)2);
        this.resetCursorCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_reset_cursor, null, (boolean)false, (int)2);
        this.maxEditorCheck = UIUtils.createCheckbox((Composite)scriptsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_max_editor_on_script_exec, null, (boolean)false, (int)2);
        Group paramsGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_parameters, (int)2, (int)768, (int)0);
        this.enableSQLParameters = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_enable_sql_parameters, null, (boolean)false, (int)2);
        this.enableSQLAnonymousParameters = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_enable_sql_anonymous_parameters, null, (boolean)false, (int)2);
        this.anonymousParameterMarkText = UIUtils.createLabelText((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_anonymous_parameter_mark, (String)"", (int)2048, (Object)new GridData(32, -1));
        this.anonymousParameterMarkText.setTextLimit(1);
        this.namedParameterPrefixText = UIUtils.createLabelText((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_named_parameter_prefix, (String)"", (int)2048, (Object)new GridData(32, -1));
        this.namedParameterPrefixText.setTextLimit(1);
        this.enableParametersInDDL = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_enable_parameters_in_ddl, (String)SQLEditorMessages.pref_page_sql_editor_enable_parameters_in_ddl_tip, (boolean)false, (int)2);
        this.enableVariables = UIUtils.createCheckbox((Composite)paramsGroup, (String)SQLEditorMessages.pref_page_sql_editor_enable_variables, (String)SQLEditorMessages.pref_page_sql_editor_enable_variables_tip, (boolean)false, (int)2);
        Group delimGroup = UIUtils.createControlGroup((Composite)composite, (String)SQLEditorMessages.pref_page_sql_editor_group_delimiters, (int)2, (int)770, (int)0);
        this.statementDelimiterText = UIUtils.createLabelText((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_text_statement_delimiter, (String)"", (int)2048, (Object)new GridData(32, -1));
        this.ignoreNativeDelimiter = UIUtils.createCheckbox((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_ignore_native_delimiter, null, (boolean)false, (int)2);
        this.blankLineDelimiter = UIUtils.createCheckbox((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_blank_line_delimiter, null, (boolean)false, (int)2);
        this.removeTrailingDelimiter = UIUtils.createCheckbox((Composite)delimGroup, (String)SQLEditorMessages.pref_page_sql_editor_checkbox_remove_trailing_delimiter, null, (boolean)false, (int)2);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.invalidateBeforeExecuteCheck.setSelection(store.getBoolean("statement.invalidate.before.execute"));
            this.executeTimeoutText.setSelection(store.getInt("statement.timeout"));
            this.soundOnQueryEnd.setSelection(store.getBoolean("SQLEditor.beepOnQueryEnd"));
            this.updateDefaultAfterExecute.setSelection(store.getBoolean("SQLEditor.refreshDefaultsAfterExecute"));
            this.clearOutputBeforeExecute.setSelection(store.getBoolean("SQLEditor.clearOutputBeforeExecute"));
            this.commitTypeCombo.select(SQLScriptCommitType.valueOf(store.getString("script.commit.type")).ordinal());
            this.errorHandlingCombo.select(SQLScriptErrorHandling.valueOf(store.getString("script.error.handling")).ordinal());
            this.commitLinesText.setSelection(store.getInt("script.commit.lines"));
            this.fetchResultSetsCheck.setSelection(store.getBoolean("script.fetch.resultset"));
            this.resetCursorCheck.setSelection(store.getBoolean("SQLEditor.resetCursorOnExecute"));
            this.maxEditorCheck.setSelection(store.getBoolean("SQLEditor.maxEditorOnScriptExecute"));
            this.statementDelimiterText.setText(store.getString("script.sql.delimiter"));
            this.ignoreNativeDelimiter.setSelection(store.getBoolean("script.sql.ignoreNativeDelimiter"));
            this.blankLineDelimiter.setSelection(store.getBoolean("script.sql.delimiter.blank"));
            this.removeTrailingDelimiter.setSelection(store.getBoolean("script.sql.query.remove.trailing.delimiter"));
            this.enableSQLParameters.setSelection(store.getBoolean("sql.parameter.enabled"));
            this.enableSQLAnonymousParameters.setSelection(store.getBoolean("sql.parameter.anonymous.enabled"));
            this.anonymousParameterMarkText.setText(store.getString("sql.parameter.mark"));
            this.namedParameterPrefixText.setText(store.getString("sql.parameter.prefix"));
            this.enableParametersInDDL.setSelection(store.getBoolean("sql.parameter.ddl.enabled"));
            this.enableVariables.setSelection(store.getBoolean("sql.variables.enabled"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("statement.invalidate.before.execute", this.invalidateBeforeExecuteCheck.getSelection());
            store.setValue("statement.timeout", this.executeTimeoutText.getSelection());
            store.setValue("SQLEditor.beepOnQueryEnd", this.soundOnQueryEnd.getSelection());
            store.setValue("SQLEditor.refreshDefaultsAfterExecute", this.updateDefaultAfterExecute.getSelection());
            store.setValue("SQLEditor.clearOutputBeforeExecute", this.clearOutputBeforeExecute.getSelection());
            store.setValue("script.commit.type", ((SQLScriptCommitType)CommonUtils.fromOrdinal(SQLScriptCommitType.class, (int)this.commitTypeCombo.getSelectionIndex())).name());
            store.setValue("script.commit.lines", this.commitLinesText.getSelection());
            store.setValue("script.error.handling", ((SQLScriptErrorHandling)CommonUtils.fromOrdinal(SQLScriptErrorHandling.class, (int)this.errorHandlingCombo.getSelectionIndex())).name());
            store.setValue("script.fetch.resultset", this.fetchResultSetsCheck.getSelection());
            store.setValue("SQLEditor.resetCursorOnExecute", this.resetCursorCheck.getSelection());
            store.setValue("SQLEditor.maxEditorOnScriptExecute", this.maxEditorCheck.getSelection());
            store.setValue("script.sql.delimiter", this.statementDelimiterText.getText());
            store.setValue("script.sql.ignoreNativeDelimiter", this.ignoreNativeDelimiter.getSelection());
            store.setValue("script.sql.delimiter.blank", this.blankLineDelimiter.getSelection());
            store.setValue("script.sql.query.remove.trailing.delimiter", this.removeTrailingDelimiter.getSelection());
            store.setValue("sql.parameter.enabled", this.enableSQLParameters.getSelection());
            store.setValue("sql.parameter.anonymous.enabled", this.enableSQLAnonymousParameters.getSelection());
            store.setValue("sql.parameter.mark", this.anonymousParameterMarkText.getText());
            store.setValue("sql.parameter.prefix", this.namedParameterPrefixText.getText());
            store.setValue("sql.parameter.ddl.enabled", this.enableParametersInDDL.getSelection());
            store.setValue("sql.variables.enabled", this.enableVariables.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("statement.invalidate.before.execute");
        store.setToDefault("statement.timeout");
        store.setToDefault("script.commit.type");
        store.setToDefault("script.error.handling");
        store.setToDefault("script.commit.lines");
        store.setToDefault("script.fetch.resultset");
        store.setToDefault("SQLEditor.resetCursorOnExecute");
        store.setToDefault("SQLEditor.maxEditorOnScriptExecute");
        store.setToDefault("script.sql.delimiter");
        store.setToDefault("script.sql.ignoreNativeDelimiter");
        store.setToDefault("script.sql.delimiter.blank");
        store.setToDefault("script.sql.query.remove.trailing.delimiter");
        store.setToDefault("sql.parameter.enabled");
        store.setToDefault("sql.parameter.ddl.enabled");
        store.setToDefault("sql.parameter.anonymous.enabled");
        store.setToDefault("sql.parameter.mark");
        store.setToDefault("sql.variables.enabled");
        store.setToDefault("sql.parameter.prefix");
        store.setToDefault("SQLEditor.beepOnQueryEnd");
        store.setToDefault("SQLEditor.refreshDefaultsAfterExecute");
        store.setToDefault("SQLEditor.clearOutputBeforeExecute");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

