/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable } from '@angular/core';
import { finalize } from 'rxjs/operators';
import { BlockUIService, BLOCKUI_DEFAULT } from 'ng-block-ui';
import { BlockUIHttpSettings } from './block-ui-http-settings.service';
export class BlockUIInterceptor {
    /**
     * @param {?} blockUIService
     * @param {?} blockUIHttpSettings
     */
    constructor(blockUIService, blockUIHttpSettings) {
        this.blockUIService = blockUIService;
        this.blockUIHttpSettings = blockUIHttpSettings;
        this.activeHttpRequests = 0;
    }
    /**
     * @param {?} request
     * @param {?} next
     * @return {?}
     */
    intercept(request, next) {
        let /** @type {?} */ active = false;
        if (this.shouldBlock(request)) {
            active = true;
            this.activeHttpRequests++;
            this.blockUIService.start(BLOCKUI_DEFAULT);
        }
        return next.handle(request)
            .pipe(finalize(() => {
            if (this.shouldBlock(request)) {
                this.activeHttpRequests--;
                let /** @type {?} */ stopBlockUI = false;
                if (!!this.blockUIHttpSettings.settings.blockAllRequestsInProgress && this.activeHttpRequests <= 0) {
                    this.activeHttpRequests = 0;
                    stopBlockUI = true;
                }
                else if (active) {
                    stopBlockUI = true;
                }
                if (stopBlockUI) {
                    this.blockUIService.stop(BLOCKUI_DEFAULT);
                }
            }
        }));
    }
    /**
     * @param {?} request
     * @return {?}
     */
    shouldBlock(request) {
        const { method, urlWithParams } = request;
        const /** @type {?} */ settings = this.blockUIHttpSettings.settings;
        const /** @type {?} */ requestFilters = settings.requestFilters || [];
        return !requestFilters.some((f) => {
            if (f && f.method && f.url) {
                return f.method.toUpperCase() === method && f.url.test(urlWithParams);
            }
            else if (typeof f === 'function') {
                return f(request);
            }
            return f.test(urlWithParams);
        });
    }
}
BlockUIInterceptor.decorators = [
    { type: Injectable },
];
/** @nocollapse */
BlockUIInterceptor.ctorParameters = () => [
    { type: BlockUIService },
    { type: BlockUIHttpSettings }
];
function BlockUIInterceptor_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIInterceptor.prototype.activeHttpRequests;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIService;
    /** @type {?} */
    BlockUIInterceptor.prototype.blockUIHttpSettings;
}

//# sourceMappingURL=data:application/json;base64,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