(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/core'), require('rxjs'), require('@angular/common')) :
    typeof define === 'function' && define.amd ? define('ng-block-ui', ['exports', '@angular/core', 'rxjs', '@angular/common'], factory) :
    (factory((global['ng-block-ui'] = {}),global.ng.core,global.rxjs,global.ng.common));
}(this, (function (exports,core,rxjs,common) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    var __assign = function () {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s)
                    if (Object.prototype.hasOwnProperty.call(s, p))
                        t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIActions = (function () {
        function BlockUIActions() {
        }
        BlockUIActions.START = 'start';
        BlockUIActions.STOP = 'stop';
        BlockUIActions.UPDATE = 'update';
        BlockUIActions.RESET = 'reset';
        BlockUIActions.UNSUBSCRIBE = 'unsubscribe';
        return BlockUIActions;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var /** @type {?} */ BlockUIDefaultName = "block-ui-main";

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIInstanceService = (function () {
        function BlockUIInstanceService() {
            this.blockUISettings = {};
            this.blockUIInstances = {};
            this.blockUISubject = new rxjs.ReplaySubject();
            this.blockUIObservable = this.blockUISubject.asObservable();
            this.blockUIObservable.subscribe(this.blockUIMiddleware.bind(this));
        }
        /**
         * @return {?}
         */
        BlockUIInstanceService.prototype.getSettings = /**
         * @return {?}
         */
            function () {
                return this.blockUISettings;
            };
        /**
         * @param {?=} settings
         * @return {?}
         */
        BlockUIInstanceService.prototype.updateSettings = /**
         * @param {?=} settings
         * @return {?}
         */
            function (settings) {
                if (settings === void 0) {
                    settings = {};
                }
                this.blockUISettings = __assign({}, this.blockUISettings, settings);
            };
        /**
         * @param {?=} name
         * @return {?}
         */
        BlockUIInstanceService.prototype.decorate = /**
         * @param {?=} name
         * @return {?}
         */
            function (name) {
                if (name === void 0) {
                    name = BlockUIDefaultName;
                }
                var /** @type {?} */ blockUI = ({
                    name: name,
                    isActive: false,
                    blockCount: 0,
                    start: this.dispatch(this.blockUISubject, BlockUIActions.START, name),
                    update: this.dispatch(this.blockUISubject, BlockUIActions.UPDATE, name),
                    stop: this.dispatch(this.blockUISubject, BlockUIActions.STOP, name),
                    reset: this.dispatch(this.blockUISubject, BlockUIActions.RESET, name),
                    unsubscribe: this.dispatch(this.blockUISubject, BlockUIActions.UNSUBSCRIBE, name)
                });
                this.blockUIInstances[name] = this.blockUIInstances[name] || blockUI;
                return blockUI;
            };
        /**
         * @return {?}
         */
        BlockUIInstanceService.prototype.observe = /**
         * @return {?}
         */
            function () {
                return this.blockUIObservable;
            };
        /**
         * @param {?} __0
         * @return {?}
         */
        BlockUIInstanceService.prototype.blockUIMiddleware = /**
         * @param {?} __0
         * @return {?}
         */
            function (_a) {
                var action = _a.action, name = _a.name;
                var /** @type {?} */ isActive = null;
                switch (action) {
                    case (BlockUIActions.START):
                        isActive = true;
                        break;
                    case (BlockUIActions.STOP):
                    case (BlockUIActions.RESET):
                        isActive = false;
                        break;
                }
                if (isActive !== null) {
                    this.blockUIInstances[name].isActive = isActive;
                }
            };
        /**
         * @param {?} subject
         * @param {?} action
         * @param {?=} name
         * @return {?}
         */
        BlockUIInstanceService.prototype.dispatch = /**
         * @param {?} subject
         * @param {?} action
         * @param {?=} name
         * @return {?}
         */
            function (subject, action, name) {
                if (name === void 0) {
                    name = BlockUIDefaultName;
                }
                return function (message) {
                    subject.next({
                        name: name,
                        action: action,
                        message: message
                    });
                };
            };
        BlockUIInstanceService.decorators = [
            { type: core.Injectable },
        ];
        /** @nocollapse */
        BlockUIInstanceService.ctorParameters = function () { return []; };
        return BlockUIInstanceService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIComponent = (function () {
        function BlockUIComponent(blockUI) {
            this.blockUI = blockUI;
        }
        /**
         * @return {?}
         */
        BlockUIComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.name = this.name || BlockUIDefaultName;
                this.template = this.template || this.blockUI.blockUISettings.template;
            };
        BlockUIComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'block-ui',
                        template: "\n    <ng-content></ng-content>\n    <block-ui-content\n      [name]=\"name\"\n      [message]=\"message\"\n      [template]=\"template\"\n      [delayStart]=\"delayStart\"\n      [delayStop]=\"delayStop\"\n    >\n    </block-ui-content>\n  ",
                        encapsulation: core.ViewEncapsulation.None
                    },] },
        ];
        /** @nocollapse */
        BlockUIComponent.ctorParameters = function () {
            return [
                { type: BlockUIInstanceService }
            ];
        };
        BlockUIComponent.propDecorators = {
            name: [{ type: core.Input }],
            message: [{ type: core.Input }],
            delayStart: [{ type: core.Input }],
            delayStop: [{ type: core.Input }],
            template: [{ type: core.Input }]
        };
        return BlockUIComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    // Spinner style - https://github.com/lukehaas/css-loaders
    var /** @type {?} */ styles = "\n.block-ui-wrapper {\n  display: none;\n  position: fixed;\n  height: 100%;\n  width: 100%;\n  top: 0;\n  left: 0;\n  background: rgba(0, 0, 0, 0.70);\n  z-index: 30000;\n  cursor: wait;\n}\n\n.block-ui-wrapper.block-ui-wrapper--element {\n  position: absolute;\n}\n\n.block-ui-wrapper.active {\n  display: block;\n}\n\n.block-ui-wrapper.block-ui-main {\n  position: fixed;\n}\n\n.block-ui-spinner,\n.block-ui-template {\n  position: absolute;\n  top: 40%;\n  margin: 0 auto;\n  left: 0;\n  right: 0;\n  transform: translateY(-50%);\n}\n\n.block-ui-spinner > .message {\n  font-size: 1.3em;\n  text-align: center;\n  color: #fff;\n}\n\n.block-ui__element {\n  position: relative;\n}\n\n.loader,\n.loader:after {\n  border-radius: 50%;\n  width: 10em;\n  height: 10em;\n}\n.loader {\n  margin: 7px auto;\n  font-size: 5px;\n  position: relative;\n  text-indent: -9999em;\n  border-top: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-right: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-bottom: 1.1em solid rgba(255, 255, 255, 0.2);\n  border-left: 1.1em solid #ffffff;\n  -webkit-transform: translateZ(0);\n  -ms-transform: translateZ(0);\n  transform: translateZ(0);\n  -webkit-animation: load8 1.1s infinite linear;\n  animation: load8 1.1s infinite linear;\n}\n\n@-webkit-keyframes load8 {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes load8 {\n  0% {\n    -webkit-transform: rotate(0deg);\n    transform: rotate(0deg);\n  }\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var /** @type {?} */ template = "\n<div class=\"block-ui-wrapper {{name}} {{className}}\" [ngClass]=\"{ 'active': active }\">\n  <div class=\"block-ui-spinner\" *ngIf=\"!templateCmp\">\n    <div class=\"loader\"></div>\n    <div *ngIf=\"message || defaultMessage\" class=\"message\">\n      {{ message || defaultMessage }}\n    </div>\n  </div>\n  <ng-template *ngIf=\"templateCmp\" #templateOutlet></ng-template>\n</div>\n";

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIContentComponent = (function () {
        function BlockUIContentComponent(blockUI, resolver, changeDetectionRef) {
            this.blockUI = blockUI;
            this.resolver = resolver;
            this.changeDetectionRef = changeDetectionRef;
            this.name = BlockUIDefaultName;
            this.delayStart = 0;
            this.delayStop = 0;
            this.state = { startTimeout: null, stopTimeout: null, blockCount: 0 };
            this.active = false;
        }
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                this.settings = this.blockUI.getSettings();
                this.blockUISubscription = this.subscribeToBlockUI(this.blockUI.observe());
            };
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.ngAfterViewInit = /**
         * @return {?}
         */
            function () {
                try {
                    if (!this.templateCmp) {
                        return false;
                    }
                    if (this.templateCmp instanceof core.TemplateRef) {
                        this.templateOutlet.createEmbeddedView(this.templateCmp);
                    }
                    else {
                        var /** @type {?} */ templateComp = this.resolver.resolveComponentFactory(this.templateCmp);
                        this.templateCompRef = this.templateOutlet.createComponent(templateComp);
                        this.updateBlockTemplate(this.message);
                    }
                }
                catch (error) {
                    console.error('ng-block-ui:', error);
                }
            };
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.ngAfterViewChecked = /**
         * @return {?}
         */
            function () {
                this.changeDetectionRef.detectChanges();
            };
        /**
         * @param {?} blockUI$
         * @return {?}
         */
        BlockUIContentComponent.prototype.subscribeToBlockUI = /**
         * @param {?} blockUI$
         * @return {?}
         */
            function (blockUI$) {
                var _this = this;
                return blockUI$
                    .subscribe(function (event) { return _this.onDispatchedEvent(event); });
            };
        /**
         * @param {?} event
         * @return {?}
         */
        BlockUIContentComponent.prototype.onDispatchedEvent = /**
         * @param {?} event
         * @return {?}
         */
            function (event) {
                switch (event.action) {
                    case (BlockUIActions.START):
                        this.onStart(event);
                        break;
                    case (BlockUIActions.STOP):
                        this.onStop(event);
                        break;
                    case (BlockUIActions.UPDATE):
                        this.onUpdate(event);
                        break;
                    case (BlockUIActions.RESET):
                        this.onReset();
                        break;
                    case (BlockUIActions.UNSUBSCRIBE):
                        this.onStop(event);
                        this.onUnsubscribe(event.name);
                        break;
                }
            };
        /**
         * @param {?} __0
         * @return {?}
         */
        BlockUIContentComponent.prototype.onStart = /**
         * @param {?} __0
         * @return {?}
         */
            function (_a) {
                var _this = this;
                var name = _a.name, message = _a.message;
                if (name === this.name) {
                    var /** @type {?} */ delay = this.delayStart || this.settings.delayStart || 0;
                    if (delay) {
                        if (this.state.startTimeout === null) {
                            this.state.startTimeout = setTimeout(function () {
                                _this.showBlock(message);
                            }, delay);
                        }
                        this.state.blockCount++;
                    }
                    else {
                        this.showBlock(message);
                    }
                    this.updateInstanceBlockCount();
                }
            };
        /**
         * @param {?} __0
         * @return {?}
         */
        BlockUIContentComponent.prototype.onStop = /**
         * @param {?} __0
         * @return {?}
         */
            function (_a) {
                var _this = this;
                var name = _a.name, action = _a.action;
                if (name === this.name) {
                    if (this.state.blockCount > 1) {
                        this.state.blockCount--;
                    }
                    else {
                        if (!this.active) {
                            this.clearState();
                        }
                        else {
                            var /** @type {?} */ delay = this.delayStop || this.settings.delayStop || 0;
                            if (delay) {
                                if (this.state.stopTimeout === null) {
                                    this.state.stopTimeout = setTimeout(function () {
                                        _this.hideBlock();
                                    }, delay);
                                }
                            }
                            else {
                                this.hideBlock();
                            }
                        }
                    }
                    this.updateInstanceBlockCount();
                }
            };
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.onReset = /**
         * @return {?}
         */
            function () {
                this.hideBlock();
            };
        /**
         * @param {?} __0
         * @return {?}
         */
        BlockUIContentComponent.prototype.onUpdate = /**
         * @param {?} __0
         * @return {?}
         */
            function (_a) {
                var name = _a.name, message = _a.message;
                if (name === this.name) {
                    this.active = true;
                    this.message = message || this.defaultMessage || this.settings.message;
                    this.updateBlockTemplate(this.message);
                    this.changeDetectionRef.detectChanges();
                }
            };
        /**
         * @param {?} message
         * @return {?}
         */
        BlockUIContentComponent.prototype.showBlock = /**
         * @param {?} message
         * @return {?}
         */
            function (message) {
                this.active = true;
                this.message = message || this.defaultMessage || this.settings.message;
                this.updateBlockTemplate(this.message);
                this.changeDetectionRef.detectChanges();
            };
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.hideBlock = /**
         * @return {?}
         */
            function () {
                this.clearState();
                this.active = false;
                this.changeDetectionRef.detectChanges();
            };
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.clearState = /**
         * @return {?}
         */
            function () {
                this.state.startTimeout != null && clearTimeout(this.state.startTimeout);
                this.state.stopTimeout != null && clearTimeout(this.state.stopTimeout);
                this.state.blockCount = 0;
                this.state.startTimeout = null;
                this.state.stopTimeout = null;
                this.updateInstanceBlockCount();
            };
        /**
         * @param {?} msg
         * @return {?}
         */
        BlockUIContentComponent.prototype.updateBlockTemplate = /**
         * @param {?} msg
         * @return {?}
         */
            function (msg) {
                if (this.templateCompRef && this.templateCompRef instanceof core.ComponentRef) {
                    this.templateCompRef.instance.message = msg;
                }
            };
        /**
         * @param {?} name
         * @return {?}
         */
        BlockUIContentComponent.prototype.onUnsubscribe = /**
         * @param {?} name
         * @return {?}
         */
            function (name) {
                if (this.blockUISubscription && name === this.name) {
                    this.blockUISubscription.unsubscribe();
                }
            };
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.updateInstanceBlockCount = /**
         * @return {?}
         */
            function () {
                if (this.blockUI.blockUIInstances[this.name]) {
                    this.blockUI.blockUIInstances[this.name].blockCount = this.state.blockCount;
                }
            };
        /**
         * @return {?}
         */
        BlockUIContentComponent.prototype.ngOnDestroy = /**
         * @return {?}
         */
            function () {
                this.onUnsubscribe(this.name);
            };
        BlockUIContentComponent.decorators = [
            { type: core.Component, args: [{
                        selector: 'block-ui-content',
                        template: template,
                        styles: [styles],
                        // TODO: Find how to bundle styles for npm
                        encapsulation: core.ViewEncapsulation.None
                    },] },
        ];
        /** @nocollapse */
        BlockUIContentComponent.ctorParameters = function () {
            return [
                { type: BlockUIInstanceService },
                { type: core.ComponentFactoryResolver },
                { type: core.ChangeDetectorRef }
            ];
        };
        BlockUIContentComponent.propDecorators = {
            name: [{ type: core.Input }],
            delayStart: [{ type: core.Input }],
            delayStop: [{ type: core.Input }],
            defaultMessage: [{ type: core.Input, args: ['message',] }],
            templateCmp: [{ type: core.Input, args: ['template',] }],
            templateOutlet: [{ type: core.ViewChild, args: ['templateOutlet', { read: core.ViewContainerRef },] }]
        };
        return BlockUIContentComponent;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIService = (function () {
        function BlockUIService(blockUIInstance) {
            this.blockUIInstance = blockUIInstance;
        }
        /**
        * Starts blocking for given BlockUI instance or instances
        */
        /**
         * Starts blocking for given BlockUI instance or instances
         * @param {?} target
         * @param {?=} message
         * @return {?}
         */
        BlockUIService.prototype.start = /**
         * Starts blocking for given BlockUI instance or instances
         * @param {?} target
         * @param {?=} message
         * @return {?}
         */
            function (target, message) {
                this.dispatch(target, BlockUIActions.START, message);
            };
        /**
        * Stops blocking for given BlockUI instance or instances
        */
        /**
         * Stops blocking for given BlockUI instance or instances
         * @param {?} target
         * @return {?}
         */
        BlockUIService.prototype.stop = /**
         * Stops blocking for given BlockUI instance or instances
         * @param {?} target
         * @return {?}
         */
            function (target) {
                this.dispatch(target, BlockUIActions.STOP);
            };
        /**
        * Unsubscribes for given BlockUI instance or instances
        */
        /**
         * Unsubscribes for given BlockUI instance or instances
         * @param {?} target
         * @return {?}
         */
        BlockUIService.prototype.unsubscribe = /**
         * Unsubscribes for given BlockUI instance or instances
         * @param {?} target
         * @return {?}
         */
            function (target) {
                this.dispatch(target, BlockUIActions.UNSUBSCRIBE);
            };
        /**
        * Checks if BlockUI is actively blocking
        */
        /**
         * Checks if BlockUI is actively blocking
         * @param {?=} target
         * @return {?}
         */
        BlockUIService.prototype.isActive = /**
         * Checks if BlockUI is actively blocking
         * @param {?=} target
         * @return {?}
         */
            function (target) {
                if (target === void 0) {
                    target = null;
                }
                var /** @type {?} */ targets = target ? this.toArray(target) : null;
                var /** @type {?} */ instances = this.blockUIInstance.blockUIInstances;
                return Object.keys(instances).some(function (key) {
                    if (!targets) {
                        return instances[key].isActive;
                    }
                    return targets.indexOf(instances[key].name) >= 0 && instances[key].isActive;
                });
            };
        /**
         * @param {?=} target
         * @param {?=} type
         * @param {?=} message
         * @return {?}
         */
        BlockUIService.prototype.dispatch = /**
         * @param {?=} target
         * @param {?=} type
         * @param {?=} message
         * @return {?}
         */
            function (target, type, message) {
                var _this = this;
                if (target === void 0) {
                    target = [];
                }
                var /** @type {?} */ instances = this.toArray(target);
                instances.forEach(function (i) { return _this.blockUIInstance.decorate(i)[type](message); });
            };
        /**
         * @param {?=} target
         * @return {?}
         */
        BlockUIService.prototype.toArray = /**
         * @param {?=} target
         * @return {?}
         */
            function (target) {
                if (target === void 0) {
                    target = [];
                }
                return typeof target === 'string' ? [target] : target;
            };
        BlockUIService.decorators = [
            { type: core.Injectable },
        ];
        /** @nocollapse */
        BlockUIService.ctorParameters = function () {
            return [
                { type: BlockUIInstanceService }
            ];
        };
        return BlockUIService;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var BlockUIDirective = (function () {
        function BlockUIDirective(blockUIService, viewRef, templateRef, renderer, componentFactoryResolver) {
            this.blockUIService = blockUIService;
            this.viewRef = viewRef;
            this.templateRef = templateRef;
            this.renderer = renderer;
            this.componentFactoryResolver = componentFactoryResolver;
        }
        Object.defineProperty(BlockUIDirective.prototype, "blockUI", {
            set: /**
             * @param {?} name
             * @return {?}
             */ function (name) { this.blockTarget = name; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BlockUIDirective.prototype, "blockUIMessage", {
            set: /**
             * @param {?} message
             * @return {?}
             */ function (message) { this.message = message; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BlockUIDirective.prototype, "blockUITemplate", {
            set: /**
             * @param {?} template
             * @return {?}
             */ function (template) { this.template = template; },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStart", {
            set: /**
             * @param {?} delayStart
             * @return {?}
             */ function (delayStart) {
                this.delayStart = delayStart ? Number(delayStart) : null;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(BlockUIDirective.prototype, "blockUIDelayStop", {
            set: /**
             * @param {?} delayStop
             * @return {?}
             */ function (delayStop) {
                this.delayStop = delayStop ? Number(delayStop) : null;
            },
            enumerable: true,
            configurable: true
        });
        /**
         * @return {?}
         */
        BlockUIDirective.prototype.ngOnInit = /**
         * @return {?}
         */
            function () {
                try {
                    this.viewRef.createEmbeddedView(this.templateRef);
                    var /** @type {?} */ parentElement = this.viewRef.element.nativeElement.nextSibling;
                    if (parentElement && !this.isComponentInTemplate(parentElement)) {
                        this.renderer.addClass(parentElement, 'block-ui__element');
                        this.blockUIComponentRef = this.createComponent();
                        var /** @type {?} */ blockUIContent = this.findContentNode(this.viewRef.element.nativeElement);
                        if (blockUIContent) {
                            var /** @type {?} */ settings = this.blockUIService.getSettings();
                            parentElement.appendChild(blockUIContent);
                            this.blockUIComponentRef.instance.className = 'block-ui-wrapper--element';
                            this.blockUIComponentRef.instance.name = this.blockTarget || BlockUIDefaultName;
                            if (this.message)
                                this.blockUIComponentRef.instance.defaultMessage = this.message;
                            if (this.delayStart)
                                this.blockUIComponentRef.instance.delayStart = this.delayStart;
                            if (this.delayStop)
                                this.blockUIComponentRef.instance.delayStop = this.delayStop;
                            if (this.template || settings.template)
                                this.blockUIComponentRef.instance.templateCmp = this.template || settings.template;
                        }
                    }
                }
                catch (error) {
                    console.error('ng-block-ui:', error);
                }
            };
        /**
         * @param {?} element
         * @return {?}
         */
        BlockUIDirective.prototype.isComponentInTemplate = /**
         * @param {?} element
         * @return {?}
         */
            function (element) {
                var children = (element || []).children;
                children = Array.from(children).reverse();
                return children.some(function (el) { return el.localName === 'block-ui'; });
            };
        /**
         * @param {?} element
         * @return {?}
         */
        BlockUIDirective.prototype.findContentNode = /**
         * @param {?} element
         * @return {?}
         */
            function (element) {
                var nextSibling = element.nextSibling;
                return [nextSibling, nextSibling.nextSibling].find(function (e) { return e.localName === 'block-ui-content'; });
            };
        /**
         * @return {?}
         */
        BlockUIDirective.prototype.createComponent = /**
         * @return {?}
         */
            function () {
                var /** @type {?} */ resolvedBlockUIComponent = this.componentFactoryResolver.resolveComponentFactory(BlockUIContentComponent);
                return this.viewRef.createComponent(resolvedBlockUIComponent);
            };
        BlockUIDirective.decorators = [
            { type: core.Directive, args: [{ selector: '[blockUI]' },] },
        ];
        /** @nocollapse */
        BlockUIDirective.ctorParameters = function () {
            return [
                { type: BlockUIInstanceService },
                { type: core.ViewContainerRef },
                { type: core.TemplateRef },
                { type: core.Renderer2 },
                { type: core.ComponentFactoryResolver }
            ];
        };
        BlockUIDirective.propDecorators = {
            blockUI: [{ type: core.Input }],
            blockUIMessage: [{ type: core.Input }],
            blockUITemplate: [{ type: core.Input }],
            blockUIDelayStart: [{ type: core.Input }],
            blockUIDelayStop: [{ type: core.Input }]
        };
        return BlockUIDirective;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    var /** @type {?} */ BlockUIServiceInstance = new BlockUIInstanceService();
    // Needed for AOT compiling
    var /** @type {?} */ BlockUIModuleSettings = new core.InjectionToken('BlockUIModuleSettings');
    /**
     * @param {?} settings
     * @return {?}
     */
    function provideInstance(settings) {
        BlockUIServiceInstance.updateSettings(settings);
        return BlockUIServiceInstance;
    }
    var BlockUIModule = (function () {
        function BlockUIModule() {
        }
        /**
         * @param {?=} settings
         * @return {?}
         */
        BlockUIModule.forRoot = /**
         * @param {?=} settings
         * @return {?}
         */
            function (settings) {
                if (settings === void 0) {
                    settings = {};
                }
                return {
                    ngModule: BlockUIModule,
                    providers: [
                        {
                            provide: BlockUIModuleSettings,
                            useValue: settings
                        },
                        {
                            provide: BlockUIInstanceService,
                            useFactory: provideInstance,
                            deps: [BlockUIModuleSettings]
                        },
                        BlockUIService
                    ]
                };
            };
        BlockUIModule.decorators = [
            { type: core.NgModule, args: [{
                        imports: [
                            common.CommonModule
                        ],
                        entryComponents: [
                            BlockUIComponent,
                            BlockUIContentComponent
                        ],
                        declarations: [
                            BlockUIComponent,
                            BlockUIDirective,
                            BlockUIContentComponent
                        ],
                        exports: [
                            BlockUIComponent,
                            BlockUIDirective,
                            BlockUIContentComponent
                        ]
                    },] },
        ];
        return BlockUIModule;
    }());

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */
    /**
     * @param {?=} value
     * @return {?}
     */
    function BlockUI(value) {
        return function (target, propertyKey, descriptor) {
            target[propertyKey] = BlockUIServiceInstance.decorate(value);
        };
    }

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    /**
     * @fileoverview added by tsickle
     * @suppress {checkTypes} checked by tsc
     */

    exports.BlockUIModule = BlockUIModule;
    exports.BlockUIComponent = BlockUIComponent;
    exports.BlockUIContentComponent = BlockUIContentComponent;
    exports.BlockUI = BlockUI;
    exports.BlockUIService = BlockUIService;
    exports.BLOCKUI_DEFAULT = BlockUIDefaultName;
    exports.ɵa = BlockUIModuleSettings;
    exports.ɵb = provideInstance;
    exports.ɵe = styles;
    exports.ɵd = template;
    exports.ɵf = BlockUIDirective;
    exports.ɵc = BlockUIInstanceService;

    Object.defineProperty(exports, '__esModule', { value: true });

})));

//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmctYmxvY2stdWkudW1kLmpzLm1hcCIsInNvdXJjZXMiOltudWxsLCJuZzovL25nLWJsb2NrLXVpL2NvbnN0YW50cy9ibG9jay11aS1hY3Rpb25zLmNvbnN0YW50LnRzIiwibmc6Ly9uZy1ibG9jay11aS9jb25zdGFudHMvYmxvY2stdWktZGVmYXVsdC1uYW1lLmNvbnN0YW50LnRzIiwibmc6Ly9uZy1ibG9jay11aS9zZXJ2aWNlcy9ibG9jay11aS1pbnN0YW5jZS5zZXJ2aWNlLnRzIiwibmc6Ly9uZy1ibG9jay11aS9jb21wb25lbnRzL2Jsb2NrLXVpL2Jsb2NrLXVpLmNvbXBvbmVudC50cyIsIm5nOi8vbmctYmxvY2stdWkvY29tcG9uZW50cy9ibG9jay11aS1jb250ZW50L2Jsb2NrLXVpLWNvbnRlbnQuY29tcG9uZW50LnN0eWxlLnRzIiwibmc6Ly9uZy1ibG9jay11aS9jb21wb25lbnRzL2Jsb2NrLXVpLWNvbnRlbnQvYmxvY2stdWktY29udGVudC5jb21wb25lbnQudGVtcGxhdGUudHMiLCJuZzovL25nLWJsb2NrLXVpL2NvbXBvbmVudHMvYmxvY2stdWktY29udGVudC9ibG9jay11aS1jb250ZW50LmNvbXBvbmVudC50cyIsIm5nOi8vbmctYmxvY2stdWkvc2VydmljZXMvYmxvY2stdWkuc2VydmljZS50cyIsIm5nOi8vbmctYmxvY2stdWkvZGlyZWN0aXZlcy9ibG9jay11aS5kaXJlY3RpdmUudHMiLCJuZzovL25nLWJsb2NrLXVpL2Jsb2NrLXVpLm1vZHVsZS50cyIsIm5nOi8vbmctYmxvY2stdWkvZGVjb3JhdG9ycy9ibG9jay11aS5kZWNvcmF0b3IudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLyohICoqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqXHJcbkNvcHlyaWdodCAoYykgTWljcm9zb2Z0IENvcnBvcmF0aW9uLiBBbGwgcmlnaHRzIHJlc2VydmVkLlxyXG5MaWNlbnNlZCB1bmRlciB0aGUgQXBhY2hlIExpY2Vuc2UsIFZlcnNpb24gMi4wICh0aGUgXCJMaWNlbnNlXCIpOyB5b3UgbWF5IG5vdCB1c2VcclxudGhpcyBmaWxlIGV4Y2VwdCBpbiBjb21wbGlhbmNlIHdpdGggdGhlIExpY2Vuc2UuIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGVcclxuTGljZW5zZSBhdCBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcclxuXHJcblRISVMgQ09ERSBJUyBQUk9WSURFRCBPTiBBTiAqQVMgSVMqIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVMgT1IgQ09ORElUSU9OUyBPRiBBTllcclxuS0lORCwgRUlUSEVSIEVYUFJFU1MgT1IgSU1QTElFRCwgSU5DTFVESU5HIFdJVEhPVVQgTElNSVRBVElPTiBBTlkgSU1QTElFRFxyXG5XQVJSQU5USUVTIE9SIENPTkRJVElPTlMgT0YgVElUTEUsIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFLFxyXG5NRVJDSEFOVEFCTElUWSBPUiBOT04tSU5GUklOR0VNRU5ULlxyXG5cclxuU2VlIHRoZSBBcGFjaGUgVmVyc2lvbiAyLjAgTGljZW5zZSBmb3Igc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zXHJcbmFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cclxuKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKioqKiogKi9cclxuLyogZ2xvYmFsIFJlZmxlY3QsIFByb21pc2UgKi9cclxuXHJcbnZhciBleHRlbmRTdGF0aWNzID0gZnVuY3Rpb24oZCwgYikge1xyXG4gICAgZXh0ZW5kU3RhdGljcyA9IE9iamVjdC5zZXRQcm90b3R5cGVPZiB8fFxyXG4gICAgICAgICh7IF9fcHJvdG9fXzogW10gfSBpbnN0YW5jZW9mIEFycmF5ICYmIGZ1bmN0aW9uIChkLCBiKSB7IGQuX19wcm90b19fID0gYjsgfSkgfHxcclxuICAgICAgICBmdW5jdGlvbiAoZCwgYikgeyBmb3IgKHZhciBwIGluIGIpIGlmIChiLmhhc093blByb3BlcnR5KHApKSBkW3BdID0gYltwXTsgfTtcclxuICAgIHJldHVybiBleHRlbmRTdGF0aWNzKGQsIGIpO1xyXG59O1xyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9fZXh0ZW5kcyhkLCBiKSB7XHJcbiAgICBleHRlbmRTdGF0aWNzKGQsIGIpO1xyXG4gICAgZnVuY3Rpb24gX18oKSB7IHRoaXMuY29uc3RydWN0b3IgPSBkOyB9XHJcbiAgICBkLnByb3RvdHlwZSA9IGIgPT09IG51bGwgPyBPYmplY3QuY3JlYXRlKGIpIDogKF9fLnByb3RvdHlwZSA9IGIucHJvdG90eXBlLCBuZXcgX18oKSk7XHJcbn1cclxuXHJcbmV4cG9ydCB2YXIgX19hc3NpZ24gPSBmdW5jdGlvbigpIHtcclxuICAgIF9fYXNzaWduID0gT2JqZWN0LmFzc2lnbiB8fCBmdW5jdGlvbiBfX2Fzc2lnbih0KSB7XHJcbiAgICAgICAgZm9yICh2YXIgcywgaSA9IDEsIG4gPSBhcmd1bWVudHMubGVuZ3RoOyBpIDwgbjsgaSsrKSB7XHJcbiAgICAgICAgICAgIHMgPSBhcmd1bWVudHNbaV07XHJcbiAgICAgICAgICAgIGZvciAodmFyIHAgaW4gcykgaWYgKE9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChzLCBwKSkgdFtwXSA9IHNbcF07XHJcbiAgICAgICAgfVxyXG4gICAgICAgIHJldHVybiB0O1xyXG4gICAgfVxyXG4gICAgcmV0dXJuIF9fYXNzaWduLmFwcGx5KHRoaXMsIGFyZ3VtZW50cyk7XHJcbn1cclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBfX3Jlc3QocywgZSkge1xyXG4gICAgdmFyIHQgPSB7fTtcclxuICAgIGZvciAodmFyIHAgaW4gcykgaWYgKE9iamVjdC5wcm90b3R5cGUuaGFzT3duUHJvcGVydHkuY2FsbChzLCBwKSAmJiBlLmluZGV4T2YocCkgPCAwKVxyXG4gICAgICAgIHRbcF0gPSBzW3BdO1xyXG4gICAgaWYgKHMgIT0gbnVsbCAmJiB0eXBlb2YgT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyA9PT0gXCJmdW5jdGlvblwiKVxyXG4gICAgICAgIGZvciAodmFyIGkgPSAwLCBwID0gT2JqZWN0LmdldE93blByb3BlcnR5U3ltYm9scyhzKTsgaSA8IHAubGVuZ3RoOyBpKyspIGlmIChlLmluZGV4T2YocFtpXSkgPCAwKVxyXG4gICAgICAgICAgICB0W3BbaV1dID0gc1twW2ldXTtcclxuICAgIHJldHVybiB0O1xyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gX19kZWNvcmF0ZShkZWNvcmF0b3JzLCB0YXJnZXQsIGtleSwgZGVzYykge1xyXG4gICAgdmFyIGMgPSBhcmd1bWVudHMubGVuZ3RoLCByID0gYyA8IDMgPyB0YXJnZXQgOiBkZXNjID09PSBudWxsID8gZGVzYyA9IE9iamVjdC5nZXRPd25Qcm9wZXJ0eURlc2NyaXB0b3IodGFyZ2V0LCBrZXkpIDogZGVzYywgZDtcclxuICAgIGlmICh0eXBlb2YgUmVmbGVjdCA9PT0gXCJvYmplY3RcIiAmJiB0eXBlb2YgUmVmbGVjdC5kZWNvcmF0ZSA9PT0gXCJmdW5jdGlvblwiKSByID0gUmVmbGVjdC5kZWNvcmF0ZShkZWNvcmF0b3JzLCB0YXJnZXQsIGtleSwgZGVzYyk7XHJcbiAgICBlbHNlIGZvciAodmFyIGkgPSBkZWNvcmF0b3JzLmxlbmd0aCAtIDE7IGkgPj0gMDsgaS0tKSBpZiAoZCA9IGRlY29yYXRvcnNbaV0pIHIgPSAoYyA8IDMgPyBkKHIpIDogYyA+IDMgPyBkKHRhcmdldCwga2V5LCByKSA6IGQodGFyZ2V0LCBrZXkpKSB8fCByO1xyXG4gICAgcmV0dXJuIGMgPiAzICYmIHIgJiYgT2JqZWN0LmRlZmluZVByb3BlcnR5KHRhcmdldCwga2V5LCByKSwgcjtcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9fcGFyYW0ocGFyYW1JbmRleCwgZGVjb3JhdG9yKSB7XHJcbiAgICByZXR1cm4gZnVuY3Rpb24gKHRhcmdldCwga2V5KSB7IGRlY29yYXRvcih0YXJnZXQsIGtleSwgcGFyYW1JbmRleCk7IH1cclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9fbWV0YWRhdGEobWV0YWRhdGFLZXksIG1ldGFkYXRhVmFsdWUpIHtcclxuICAgIGlmICh0eXBlb2YgUmVmbGVjdCA9PT0gXCJvYmplY3RcIiAmJiB0eXBlb2YgUmVmbGVjdC5tZXRhZGF0YSA9PT0gXCJmdW5jdGlvblwiKSByZXR1cm4gUmVmbGVjdC5tZXRhZGF0YShtZXRhZGF0YUtleSwgbWV0YWRhdGFWYWx1ZSk7XHJcbn1cclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBfX2F3YWl0ZXIodGhpc0FyZywgX2FyZ3VtZW50cywgUCwgZ2VuZXJhdG9yKSB7XHJcbiAgICByZXR1cm4gbmV3IChQIHx8IChQID0gUHJvbWlzZSkpKGZ1bmN0aW9uIChyZXNvbHZlLCByZWplY3QpIHtcclxuICAgICAgICBmdW5jdGlvbiBmdWxmaWxsZWQodmFsdWUpIHsgdHJ5IHsgc3RlcChnZW5lcmF0b3IubmV4dCh2YWx1ZSkpOyB9IGNhdGNoIChlKSB7IHJlamVjdChlKTsgfSB9XHJcbiAgICAgICAgZnVuY3Rpb24gcmVqZWN0ZWQodmFsdWUpIHsgdHJ5IHsgc3RlcChnZW5lcmF0b3JbXCJ0aHJvd1wiXSh2YWx1ZSkpOyB9IGNhdGNoIChlKSB7IHJlamVjdChlKTsgfSB9XHJcbiAgICAgICAgZnVuY3Rpb24gc3RlcChyZXN1bHQpIHsgcmVzdWx0LmRvbmUgPyByZXNvbHZlKHJlc3VsdC52YWx1ZSkgOiBuZXcgUChmdW5jdGlvbiAocmVzb2x2ZSkgeyByZXNvbHZlKHJlc3VsdC52YWx1ZSk7IH0pLnRoZW4oZnVsZmlsbGVkLCByZWplY3RlZCk7IH1cclxuICAgICAgICBzdGVwKChnZW5lcmF0b3IgPSBnZW5lcmF0b3IuYXBwbHkodGhpc0FyZywgX2FyZ3VtZW50cyB8fCBbXSkpLm5leHQoKSk7XHJcbiAgICB9KTtcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9fZ2VuZXJhdG9yKHRoaXNBcmcsIGJvZHkpIHtcclxuICAgIHZhciBfID0geyBsYWJlbDogMCwgc2VudDogZnVuY3Rpb24oKSB7IGlmICh0WzBdICYgMSkgdGhyb3cgdFsxXTsgcmV0dXJuIHRbMV07IH0sIHRyeXM6IFtdLCBvcHM6IFtdIH0sIGYsIHksIHQsIGc7XHJcbiAgICByZXR1cm4gZyA9IHsgbmV4dDogdmVyYigwKSwgXCJ0aHJvd1wiOiB2ZXJiKDEpLCBcInJldHVyblwiOiB2ZXJiKDIpIH0sIHR5cGVvZiBTeW1ib2wgPT09IFwiZnVuY3Rpb25cIiAmJiAoZ1tTeW1ib2wuaXRlcmF0b3JdID0gZnVuY3Rpb24oKSB7IHJldHVybiB0aGlzOyB9KSwgZztcclxuICAgIGZ1bmN0aW9uIHZlcmIobikgeyByZXR1cm4gZnVuY3Rpb24gKHYpIHsgcmV0dXJuIHN0ZXAoW24sIHZdKTsgfTsgfVxyXG4gICAgZnVuY3Rpb24gc3RlcChvcCkge1xyXG4gICAgICAgIGlmIChmKSB0aHJvdyBuZXcgVHlwZUVycm9yKFwiR2VuZXJhdG9yIGlzIGFscmVhZHkgZXhlY3V0aW5nLlwiKTtcclxuICAgICAgICB3aGlsZSAoXykgdHJ5IHtcclxuICAgICAgICAgICAgaWYgKGYgPSAxLCB5ICYmICh0ID0gb3BbMF0gJiAyID8geVtcInJldHVyblwiXSA6IG9wWzBdID8geVtcInRocm93XCJdIHx8ICgodCA9IHlbXCJyZXR1cm5cIl0pICYmIHQuY2FsbCh5KSwgMCkgOiB5Lm5leHQpICYmICEodCA9IHQuY2FsbCh5LCBvcFsxXSkpLmRvbmUpIHJldHVybiB0O1xyXG4gICAgICAgICAgICBpZiAoeSA9IDAsIHQpIG9wID0gW29wWzBdICYgMiwgdC52YWx1ZV07XHJcbiAgICAgICAgICAgIHN3aXRjaCAob3BbMF0pIHtcclxuICAgICAgICAgICAgICAgIGNhc2UgMDogY2FzZSAxOiB0ID0gb3A7IGJyZWFrO1xyXG4gICAgICAgICAgICAgICAgY2FzZSA0OiBfLmxhYmVsKys7IHJldHVybiB7IHZhbHVlOiBvcFsxXSwgZG9uZTogZmFsc2UgfTtcclxuICAgICAgICAgICAgICAgIGNhc2UgNTogXy5sYWJlbCsrOyB5ID0gb3BbMV07IG9wID0gWzBdOyBjb250aW51ZTtcclxuICAgICAgICAgICAgICAgIGNhc2UgNzogb3AgPSBfLm9wcy5wb3AoKTsgXy50cnlzLnBvcCgpOyBjb250aW51ZTtcclxuICAgICAgICAgICAgICAgIGRlZmF1bHQ6XHJcbiAgICAgICAgICAgICAgICAgICAgaWYgKCEodCA9IF8udHJ5cywgdCA9IHQubGVuZ3RoID4gMCAmJiB0W3QubGVuZ3RoIC0gMV0pICYmIChvcFswXSA9PT0gNiB8fCBvcFswXSA9PT0gMikpIHsgXyA9IDA7IGNvbnRpbnVlOyB9XHJcbiAgICAgICAgICAgICAgICAgICAgaWYgKG9wWzBdID09PSAzICYmICghdCB8fCAob3BbMV0gPiB0WzBdICYmIG9wWzFdIDwgdFszXSkpKSB7IF8ubGFiZWwgPSBvcFsxXTsgYnJlYWs7IH1cclxuICAgICAgICAgICAgICAgICAgICBpZiAob3BbMF0gPT09IDYgJiYgXy5sYWJlbCA8IHRbMV0pIHsgXy5sYWJlbCA9IHRbMV07IHQgPSBvcDsgYnJlYWs7IH1cclxuICAgICAgICAgICAgICAgICAgICBpZiAodCAmJiBfLmxhYmVsIDwgdFsyXSkgeyBfLmxhYmVsID0gdFsyXTsgXy5vcHMucHVzaChvcCk7IGJyZWFrOyB9XHJcbiAgICAgICAgICAgICAgICAgICAgaWYgKHRbMl0pIF8ub3BzLnBvcCgpO1xyXG4gICAgICAgICAgICAgICAgICAgIF8udHJ5cy5wb3AoKTsgY29udGludWU7XHJcbiAgICAgICAgICAgIH1cclxuICAgICAgICAgICAgb3AgPSBib2R5LmNhbGwodGhpc0FyZywgXyk7XHJcbiAgICAgICAgfSBjYXRjaCAoZSkgeyBvcCA9IFs2LCBlXTsgeSA9IDA7IH0gZmluYWxseSB7IGYgPSB0ID0gMDsgfVxyXG4gICAgICAgIGlmIChvcFswXSAmIDUpIHRocm93IG9wWzFdOyByZXR1cm4geyB2YWx1ZTogb3BbMF0gPyBvcFsxXSA6IHZvaWQgMCwgZG9uZTogdHJ1ZSB9O1xyXG4gICAgfVxyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gX19leHBvcnRTdGFyKG0sIGV4cG9ydHMpIHtcclxuICAgIGZvciAodmFyIHAgaW4gbSkgaWYgKCFleHBvcnRzLmhhc093blByb3BlcnR5KHApKSBleHBvcnRzW3BdID0gbVtwXTtcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9fdmFsdWVzKG8pIHtcclxuICAgIHZhciBtID0gdHlwZW9mIFN5bWJvbCA9PT0gXCJmdW5jdGlvblwiICYmIG9bU3ltYm9sLml0ZXJhdG9yXSwgaSA9IDA7XHJcbiAgICBpZiAobSkgcmV0dXJuIG0uY2FsbChvKTtcclxuICAgIHJldHVybiB7XHJcbiAgICAgICAgbmV4dDogZnVuY3Rpb24gKCkge1xyXG4gICAgICAgICAgICBpZiAobyAmJiBpID49IG8ubGVuZ3RoKSBvID0gdm9pZCAwO1xyXG4gICAgICAgICAgICByZXR1cm4geyB2YWx1ZTogbyAmJiBvW2krK10sIGRvbmU6ICFvIH07XHJcbiAgICAgICAgfVxyXG4gICAgfTtcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9fcmVhZChvLCBuKSB7XHJcbiAgICB2YXIgbSA9IHR5cGVvZiBTeW1ib2wgPT09IFwiZnVuY3Rpb25cIiAmJiBvW1N5bWJvbC5pdGVyYXRvcl07XHJcbiAgICBpZiAoIW0pIHJldHVybiBvO1xyXG4gICAgdmFyIGkgPSBtLmNhbGwobyksIHIsIGFyID0gW10sIGU7XHJcbiAgICB0cnkge1xyXG4gICAgICAgIHdoaWxlICgobiA9PT0gdm9pZCAwIHx8IG4tLSA+IDApICYmICEociA9IGkubmV4dCgpKS5kb25lKSBhci5wdXNoKHIudmFsdWUpO1xyXG4gICAgfVxyXG4gICAgY2F0Y2ggKGVycm9yKSB7IGUgPSB7IGVycm9yOiBlcnJvciB9OyB9XHJcbiAgICBmaW5hbGx5IHtcclxuICAgICAgICB0cnkge1xyXG4gICAgICAgICAgICBpZiAociAmJiAhci5kb25lICYmIChtID0gaVtcInJldHVyblwiXSkpIG0uY2FsbChpKTtcclxuICAgICAgICB9XHJcbiAgICAgICAgZmluYWxseSB7IGlmIChlKSB0aHJvdyBlLmVycm9yOyB9XHJcbiAgICB9XHJcbiAgICByZXR1cm4gYXI7XHJcbn1cclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBfX3NwcmVhZCgpIHtcclxuICAgIGZvciAodmFyIGFyID0gW10sIGkgPSAwOyBpIDwgYXJndW1lbnRzLmxlbmd0aDsgaSsrKVxyXG4gICAgICAgIGFyID0gYXIuY29uY2F0KF9fcmVhZChhcmd1bWVudHNbaV0pKTtcclxuICAgIHJldHVybiBhcjtcclxufVxyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9fYXdhaXQodikge1xyXG4gICAgcmV0dXJuIHRoaXMgaW5zdGFuY2VvZiBfX2F3YWl0ID8gKHRoaXMudiA9IHYsIHRoaXMpIDogbmV3IF9fYXdhaXQodik7XHJcbn1cclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBfX2FzeW5jR2VuZXJhdG9yKHRoaXNBcmcsIF9hcmd1bWVudHMsIGdlbmVyYXRvcikge1xyXG4gICAgaWYgKCFTeW1ib2wuYXN5bmNJdGVyYXRvcikgdGhyb3cgbmV3IFR5cGVFcnJvcihcIlN5bWJvbC5hc3luY0l0ZXJhdG9yIGlzIG5vdCBkZWZpbmVkLlwiKTtcclxuICAgIHZhciBnID0gZ2VuZXJhdG9yLmFwcGx5KHRoaXNBcmcsIF9hcmd1bWVudHMgfHwgW10pLCBpLCBxID0gW107XHJcbiAgICByZXR1cm4gaSA9IHt9LCB2ZXJiKFwibmV4dFwiKSwgdmVyYihcInRocm93XCIpLCB2ZXJiKFwicmV0dXJuXCIpLCBpW1N5bWJvbC5hc3luY0l0ZXJhdG9yXSA9IGZ1bmN0aW9uICgpIHsgcmV0dXJuIHRoaXM7IH0sIGk7XHJcbiAgICBmdW5jdGlvbiB2ZXJiKG4pIHsgaWYgKGdbbl0pIGlbbl0gPSBmdW5jdGlvbiAodikgeyByZXR1cm4gbmV3IFByb21pc2UoZnVuY3Rpb24gKGEsIGIpIHsgcS5wdXNoKFtuLCB2LCBhLCBiXSkgPiAxIHx8IHJlc3VtZShuLCB2KTsgfSk7IH07IH1cclxuICAgIGZ1bmN0aW9uIHJlc3VtZShuLCB2KSB7IHRyeSB7IHN0ZXAoZ1tuXSh2KSk7IH0gY2F0Y2ggKGUpIHsgc2V0dGxlKHFbMF1bM10sIGUpOyB9IH1cclxuICAgIGZ1bmN0aW9uIHN0ZXAocikgeyByLnZhbHVlIGluc3RhbmNlb2YgX19hd2FpdCA/IFByb21pc2UucmVzb2x2ZShyLnZhbHVlLnYpLnRoZW4oZnVsZmlsbCwgcmVqZWN0KSA6IHNldHRsZShxWzBdWzJdLCByKTsgfVxyXG4gICAgZnVuY3Rpb24gZnVsZmlsbCh2YWx1ZSkgeyByZXN1bWUoXCJuZXh0XCIsIHZhbHVlKTsgfVxyXG4gICAgZnVuY3Rpb24gcmVqZWN0KHZhbHVlKSB7IHJlc3VtZShcInRocm93XCIsIHZhbHVlKTsgfVxyXG4gICAgZnVuY3Rpb24gc2V0dGxlKGYsIHYpIHsgaWYgKGYodiksIHEuc2hpZnQoKSwgcS5sZW5ndGgpIHJlc3VtZShxWzBdWzBdLCBxWzBdWzFdKTsgfVxyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gX19hc3luY0RlbGVnYXRvcihvKSB7XHJcbiAgICB2YXIgaSwgcDtcclxuICAgIHJldHVybiBpID0ge30sIHZlcmIoXCJuZXh0XCIpLCB2ZXJiKFwidGhyb3dcIiwgZnVuY3Rpb24gKGUpIHsgdGhyb3cgZTsgfSksIHZlcmIoXCJyZXR1cm5cIiksIGlbU3ltYm9sLml0ZXJhdG9yXSA9IGZ1bmN0aW9uICgpIHsgcmV0dXJuIHRoaXM7IH0sIGk7XHJcbiAgICBmdW5jdGlvbiB2ZXJiKG4sIGYpIHsgaVtuXSA9IG9bbl0gPyBmdW5jdGlvbiAodikgeyByZXR1cm4gKHAgPSAhcCkgPyB7IHZhbHVlOiBfX2F3YWl0KG9bbl0odikpLCBkb25lOiBuID09PSBcInJldHVyblwiIH0gOiBmID8gZih2KSA6IHY7IH0gOiBmOyB9XHJcbn1cclxuXHJcbmV4cG9ydCBmdW5jdGlvbiBfX2FzeW5jVmFsdWVzKG8pIHtcclxuICAgIGlmICghU3ltYm9sLmFzeW5jSXRlcmF0b3IpIHRocm93IG5ldyBUeXBlRXJyb3IoXCJTeW1ib2wuYXN5bmNJdGVyYXRvciBpcyBub3QgZGVmaW5lZC5cIik7XHJcbiAgICB2YXIgbSA9IG9bU3ltYm9sLmFzeW5jSXRlcmF0b3JdLCBpO1xyXG4gICAgcmV0dXJuIG0gPyBtLmNhbGwobykgOiAobyA9IHR5cGVvZiBfX3ZhbHVlcyA9PT0gXCJmdW5jdGlvblwiID8gX192YWx1ZXMobykgOiBvW1N5bWJvbC5pdGVyYXRvcl0oKSwgaSA9IHt9LCB2ZXJiKFwibmV4dFwiKSwgdmVyYihcInRocm93XCIpLCB2ZXJiKFwicmV0dXJuXCIpLCBpW1N5bWJvbC5hc3luY0l0ZXJhdG9yXSA9IGZ1bmN0aW9uICgpIHsgcmV0dXJuIHRoaXM7IH0sIGkpO1xyXG4gICAgZnVuY3Rpb24gdmVyYihuKSB7IGlbbl0gPSBvW25dICYmIGZ1bmN0aW9uICh2KSB7IHJldHVybiBuZXcgUHJvbWlzZShmdW5jdGlvbiAocmVzb2x2ZSwgcmVqZWN0KSB7IHYgPSBvW25dKHYpLCBzZXR0bGUocmVzb2x2ZSwgcmVqZWN0LCB2LmRvbmUsIHYudmFsdWUpOyB9KTsgfTsgfVxyXG4gICAgZnVuY3Rpb24gc2V0dGxlKHJlc29sdmUsIHJlamVjdCwgZCwgdikgeyBQcm9taXNlLnJlc29sdmUodikudGhlbihmdW5jdGlvbih2KSB7IHJlc29sdmUoeyB2YWx1ZTogdiwgZG9uZTogZCB9KTsgfSwgcmVqZWN0KTsgfVxyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gX19tYWtlVGVtcGxhdGVPYmplY3QoY29va2VkLCByYXcpIHtcclxuICAgIGlmIChPYmplY3QuZGVmaW5lUHJvcGVydHkpIHsgT2JqZWN0LmRlZmluZVByb3BlcnR5KGNvb2tlZCwgXCJyYXdcIiwgeyB2YWx1ZTogcmF3IH0pOyB9IGVsc2UgeyBjb29rZWQucmF3ID0gcmF3OyB9XHJcbiAgICByZXR1cm4gY29va2VkO1xyXG59O1xyXG5cclxuZXhwb3J0IGZ1bmN0aW9uIF9faW1wb3J0U3Rhcihtb2QpIHtcclxuICAgIGlmIChtb2QgJiYgbW9kLl9fZXNNb2R1bGUpIHJldHVybiBtb2Q7XHJcbiAgICB2YXIgcmVzdWx0ID0ge307XHJcbiAgICBpZiAobW9kICE9IG51bGwpIGZvciAodmFyIGsgaW4gbW9kKSBpZiAoT2JqZWN0Lmhhc093blByb3BlcnR5LmNhbGwobW9kLCBrKSkgcmVzdWx0W2tdID0gbW9kW2tdO1xyXG4gICAgcmVzdWx0LmRlZmF1bHQgPSBtb2Q7XHJcbiAgICByZXR1cm4gcmVzdWx0O1xyXG59XHJcblxyXG5leHBvcnQgZnVuY3Rpb24gX19pbXBvcnREZWZhdWx0KG1vZCkge1xyXG4gICAgcmV0dXJuIChtb2QgJiYgbW9kLl9fZXNNb2R1bGUpID8gbW9kIDogeyBkZWZhdWx0OiBtb2QgfTtcclxufVxyXG4iLCJleHBvcnQgY2xhc3MgQmxvY2tVSUFjdGlvbnMge1xuICAgIHN0YXRpYyBTVEFSVCA9ICdzdGFydCc7XG4gICAgc3RhdGljIFNUT1AgPSAnc3RvcCc7XG4gICAgc3RhdGljIFVQREFURSA9ICd1cGRhdGUnO1xuICAgIHN0YXRpYyBSRVNFVCA9ICdyZXNldCc7XG4gICAgc3RhdGljIFVOU1VCU0NSSUJFID0gJ3Vuc3Vic2NyaWJlJztcbn0iLCJleHBvcnQgY29uc3QgQmxvY2tVSURlZmF1bHROYW1lOiBzdHJpbmcgPSBgYmxvY2stdWktbWFpbmA7XG4iLCJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBPYnNlcnZhYmxlLCBSZXBsYXlTdWJqZWN0IH0gZnJvbSAncnhqcyc7XG5pbXBvcnQgeyBCbG9ja1VJQWN0aW9ucyB9IGZyb20gJy4uL2NvbnN0YW50cy9ibG9jay11aS1hY3Rpb25zLmNvbnN0YW50JztcbmltcG9ydCB7IEJsb2NrVUlEZWZhdWx0TmFtZSB9IGZyb20gJy4uL2NvbnN0YW50cy9ibG9jay11aS1kZWZhdWx0LW5hbWUuY29uc3RhbnQnO1xuaW1wb3J0IHsgTmdCbG9ja1VJIH0gZnJvbSAnLi4vbW9kZWxzL2Jsb2NrLXVpLm1vZGVsJztcbmltcG9ydCB7IEJsb2NrVUlTZXR0aW5ncyB9IGZyb20gJy4uL21vZGVscy9ibG9jay11aS1zZXR0aW5ncy5tb2RlbCc7XG5pbXBvcnQgeyBCbG9ja1VJRXZlbnQgfSBmcm9tICcuLi9tb2RlbHMvYmxvY2stdWktZXZlbnQubW9kZWwnO1xuXG5cbkBJbmplY3RhYmxlKClcbmV4cG9ydCBjbGFzcyBCbG9ja1VJSW5zdGFuY2VTZXJ2aWNlIHtcbiAgYmxvY2tVSVNldHRpbmdzOiBCbG9ja1VJU2V0dGluZ3MgfCBhbnkgPSB7fTtcbiAgYmxvY2tVSUluc3RhbmNlczogYW55ID0ge307XG4gIHByaXZhdGUgYmxvY2tVSVN1YmplY3Q6IFJlcGxheVN1YmplY3Q8YW55PiA9IG5ldyBSZXBsYXlTdWJqZWN0KCk7XG4gIHByaXZhdGUgYmxvY2tVSU9ic2VydmFibGU6IE9ic2VydmFibGU8YW55PiA9IHRoaXMuYmxvY2tVSVN1YmplY3QuYXNPYnNlcnZhYmxlKCk7XG5cbiAgY29uc3RydWN0b3IoKSB7XG4gICAgdGhpcy5ibG9ja1VJT2JzZXJ2YWJsZS5zdWJzY3JpYmUodGhpcy5ibG9ja1VJTWlkZGxld2FyZS5iaW5kKHRoaXMpKTtcbiAgfVxuXG4gIGdldFNldHRpbmdzKCk6IEJsb2NrVUlTZXR0aW5ncyB8IGFueSB7XG4gICAgcmV0dXJuIHRoaXMuYmxvY2tVSVNldHRpbmdzO1xuICB9XG5cbiAgdXBkYXRlU2V0dGluZ3Moc2V0dGluZ3M6IEJsb2NrVUlTZXR0aW5ncyB8IGFueSA9IHt9KTogdm9pZCB7XG4gICAgdGhpcy5ibG9ja1VJU2V0dGluZ3MgPSB7IC4uLnRoaXMuYmxvY2tVSVNldHRpbmdzLCAuLi5zZXR0aW5ncyB9O1xuICB9XG5cbiAgZGVjb3JhdGUobmFtZTogc3RyaW5nID0gQmxvY2tVSURlZmF1bHROYW1lKTogTmdCbG9ja1VJIHtcbiAgICBjb25zdCBibG9ja1VJID0ge1xuICAgICAgbmFtZSxcbiAgICAgIGlzQWN0aXZlOiBmYWxzZSxcbiAgICAgIGJsb2NrQ291bnQ6IDAsXG4gICAgICBzdGFydDogdGhpcy5kaXNwYXRjaCh0aGlzLmJsb2NrVUlTdWJqZWN0LCBCbG9ja1VJQWN0aW9ucy5TVEFSVCwgbmFtZSksXG4gICAgICB1cGRhdGU6IHRoaXMuZGlzcGF0Y2godGhpcy5ibG9ja1VJU3ViamVjdCwgQmxvY2tVSUFjdGlvbnMuVVBEQVRFLCBuYW1lKSxcbiAgICAgIHN0b3A6IHRoaXMuZGlzcGF0Y2godGhpcy5ibG9ja1VJU3ViamVjdCwgQmxvY2tVSUFjdGlvbnMuU1RPUCwgbmFtZSksXG4gICAgICByZXNldDogdGhpcy5kaXNwYXRjaCh0aGlzLmJsb2NrVUlTdWJqZWN0LCBCbG9ja1VJQWN0aW9ucy5SRVNFVCwgbmFtZSksXG4gICAgICB1bnN1YnNjcmliZTogdGhpcy5kaXNwYXRjaCh0aGlzLmJsb2NrVUlTdWJqZWN0LCBCbG9ja1VJQWN0aW9ucy5VTlNVQlNDUklCRSwgbmFtZSlcbiAgICB9IGFzIE5nQmxvY2tVSTtcblxuICAgIHRoaXMuYmxvY2tVSUluc3RhbmNlc1tuYW1lXSA9IHRoaXMuYmxvY2tVSUluc3RhbmNlc1tuYW1lXSB8fCBibG9ja1VJO1xuXG4gICAgcmV0dXJuIGJsb2NrVUk7XG4gIH1cblxuICBvYnNlcnZlKCk6IE9ic2VydmFibGU8YW55PiB7XG4gICAgcmV0dXJuIHRoaXMuYmxvY2tVSU9ic2VydmFibGU7XG4gIH1cblxuICBwcml2YXRlIGJsb2NrVUlNaWRkbGV3YXJlKHsgYWN0aW9uLCBuYW1lIH06IEJsb2NrVUlFdmVudCk6IHZvaWQge1xuICAgIGxldCBpc0FjdGl2ZTogYm9vbGVhbiA9IG51bGw7XG5cbiAgICBzd2l0Y2ggKGFjdGlvbikge1xuICAgICAgY2FzZSAoQmxvY2tVSUFjdGlvbnMuU1RBUlQpOlxuICAgICAgICBpc0FjdGl2ZSA9IHRydWU7XG4gICAgICAgIGJyZWFrO1xuXG4gICAgICBjYXNlIChCbG9ja1VJQWN0aW9ucy5TVE9QKTpcbiAgICAgIGNhc2UgKEJsb2NrVUlBY3Rpb25zLlJFU0VUKTpcbiAgICAgICAgaXNBY3RpdmUgPSBmYWxzZTtcbiAgICAgICAgYnJlYWs7XG4gICAgfVxuXG4gICAgaWYgKGlzQWN0aXZlICE9PSBudWxsKSB7XG4gICAgICB0aGlzLmJsb2NrVUlJbnN0YW5jZXNbbmFtZV0uaXNBY3RpdmUgPSBpc0FjdGl2ZTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIGRpc3BhdGNoKHN1YmplY3Q6IFJlcGxheVN1YmplY3Q8YW55PiwgYWN0aW9uOiBCbG9ja1VJQWN0aW9ucywgbmFtZTogc3RyaW5nID0gQmxvY2tVSURlZmF1bHROYW1lKTogRnVuY3Rpb24ge1xuICAgIHJldHVybiAobWVzc2FnZT86IGFueSk6IHZvaWQgPT4ge1xuICAgICAgc3ViamVjdC5uZXh0KHtcbiAgICAgICAgbmFtZSxcbiAgICAgICAgYWN0aW9uLFxuICAgICAgICBtZXNzYWdlXG4gICAgICB9KTtcbiAgICB9O1xuICB9XG59XG4iLCJpbXBvcnQge1xuICBDb21wb25lbnQsXG4gIElucHV0LFxuICBWaWV3RW5jYXBzdWxhdGlvbixcbiAgT25Jbml0LFxuICBDb21wb25lbnRSZWZcbn0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBCbG9ja1VJSW5zdGFuY2VTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vc2VydmljZXMvYmxvY2stdWktaW5zdGFuY2Uuc2VydmljZSc7XG5pbXBvcnQgeyBCbG9ja1VJRGVmYXVsdE5hbWUgfSBmcm9tICcuLi8uLi9jb25zdGFudHMvYmxvY2stdWktZGVmYXVsdC1uYW1lLmNvbnN0YW50JztcblxuQENvbXBvbmVudCh7XG4gIHNlbGVjdG9yOiAnYmxvY2stdWknLFxuICB0ZW1wbGF0ZTogYFxuICAgIDxuZy1jb250ZW50PjwvbmctY29udGVudD5cbiAgICA8YmxvY2stdWktY29udGVudFxuICAgICAgW25hbWVdPVwibmFtZVwiXG4gICAgICBbbWVzc2FnZV09XCJtZXNzYWdlXCJcbiAgICAgIFt0ZW1wbGF0ZV09XCJ0ZW1wbGF0ZVwiXG4gICAgICBbZGVsYXlTdGFydF09XCJkZWxheVN0YXJ0XCJcbiAgICAgIFtkZWxheVN0b3BdPVwiZGVsYXlTdG9wXCJcbiAgICA+XG4gICAgPC9ibG9jay11aS1jb250ZW50PlxuICBgLFxuICBlbmNhcHN1bGF0aW9uOiBWaWV3RW5jYXBzdWxhdGlvbi5Ob25lXG59KVxuZXhwb3J0IGNsYXNzIEJsb2NrVUlDb21wb25lbnQgaW1wbGVtZW50cyBPbkluaXQge1xuICBASW5wdXQoKSBuYW1lOiBzdHJpbmc7XG4gIEBJbnB1dCgpIG1lc3NhZ2U6IGFueTtcbiAgQElucHV0KCkgZGVsYXlTdGFydDogbnVtYmVyO1xuICBASW5wdXQoKSBkZWxheVN0b3A6IG51bWJlcjtcbiAgQElucHV0KCkgdGVtcGxhdGU6IGFueTtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIGJsb2NrVUk6IEJsb2NrVUlJbnN0YW5jZVNlcnZpY2UsXG4gICkgeyB9XG5cbiAgbmdPbkluaXQoKSB7XG4gICAgdGhpcy5uYW1lID0gdGhpcy5uYW1lIHx8IEJsb2NrVUlEZWZhdWx0TmFtZTtcbiAgICB0aGlzLnRlbXBsYXRlID0gdGhpcy50ZW1wbGF0ZSB8fCB0aGlzLmJsb2NrVUkuYmxvY2tVSVNldHRpbmdzLnRlbXBsYXRlO1xuICB9XG59XG4iLCIvLyBTcGlubmVyIHN0eWxlIC0gaHR0cHM6Ly9naXRodWIuY29tL2x1a2VoYWFzL2Nzcy1sb2FkZXJzXG5cbmV4cG9ydCBjb25zdCBzdHlsZXMgPSBgXG4uYmxvY2stdWktd3JhcHBlciB7XG4gIGRpc3BsYXk6IG5vbmU7XG4gIHBvc2l0aW9uOiBmaXhlZDtcbiAgaGVpZ2h0OiAxMDAlO1xuICB3aWR0aDogMTAwJTtcbiAgdG9wOiAwO1xuICBsZWZ0OiAwO1xuICBiYWNrZ3JvdW5kOiByZ2JhKDAsIDAsIDAsIDAuNzApO1xuICB6LWluZGV4OiAzMDAwMDtcbiAgY3Vyc29yOiB3YWl0O1xufVxuXG4uYmxvY2stdWktd3JhcHBlci5ibG9jay11aS13cmFwcGVyLS1lbGVtZW50IHtcbiAgcG9zaXRpb246IGFic29sdXRlO1xufVxuXG4uYmxvY2stdWktd3JhcHBlci5hY3RpdmUge1xuICBkaXNwbGF5OiBibG9jaztcbn1cblxuLmJsb2NrLXVpLXdyYXBwZXIuYmxvY2stdWktbWFpbiB7XG4gIHBvc2l0aW9uOiBmaXhlZDtcbn1cblxuLmJsb2NrLXVpLXNwaW5uZXIsXG4uYmxvY2stdWktdGVtcGxhdGUge1xuICBwb3NpdGlvbjogYWJzb2x1dGU7XG4gIHRvcDogNDAlO1xuICBtYXJnaW46IDAgYXV0bztcbiAgbGVmdDogMDtcbiAgcmlnaHQ6IDA7XG4gIHRyYW5zZm9ybTogdHJhbnNsYXRlWSgtNTAlKTtcbn1cblxuLmJsb2NrLXVpLXNwaW5uZXIgPiAubWVzc2FnZSB7XG4gIGZvbnQtc2l6ZTogMS4zZW07XG4gIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgY29sb3I6ICNmZmY7XG59XG5cbi5ibG9jay11aV9fZWxlbWVudCB7XG4gIHBvc2l0aW9uOiByZWxhdGl2ZTtcbn1cblxuLmxvYWRlcixcbi5sb2FkZXI6YWZ0ZXIge1xuICBib3JkZXItcmFkaXVzOiA1MCU7XG4gIHdpZHRoOiAxMGVtO1xuICBoZWlnaHQ6IDEwZW07XG59XG4ubG9hZGVyIHtcbiAgbWFyZ2luOiA3cHggYXV0bztcbiAgZm9udC1zaXplOiA1cHg7XG4gIHBvc2l0aW9uOiByZWxhdGl2ZTtcbiAgdGV4dC1pbmRlbnQ6IC05OTk5ZW07XG4gIGJvcmRlci10b3A6IDEuMWVtIHNvbGlkIHJnYmEoMjU1LCAyNTUsIDI1NSwgMC4yKTtcbiAgYm9yZGVyLXJpZ2h0OiAxLjFlbSBzb2xpZCByZ2JhKDI1NSwgMjU1LCAyNTUsIDAuMik7XG4gIGJvcmRlci1ib3R0b206IDEuMWVtIHNvbGlkIHJnYmEoMjU1LCAyNTUsIDI1NSwgMC4yKTtcbiAgYm9yZGVyLWxlZnQ6IDEuMWVtIHNvbGlkICNmZmZmZmY7XG4gIC13ZWJraXQtdHJhbnNmb3JtOiB0cmFuc2xhdGVaKDApO1xuICAtbXMtdHJhbnNmb3JtOiB0cmFuc2xhdGVaKDApO1xuICB0cmFuc2Zvcm06IHRyYW5zbGF0ZVooMCk7XG4gIC13ZWJraXQtYW5pbWF0aW9uOiBsb2FkOCAxLjFzIGluZmluaXRlIGxpbmVhcjtcbiAgYW5pbWF0aW9uOiBsb2FkOCAxLjFzIGluZmluaXRlIGxpbmVhcjtcbn1cblxuQC13ZWJraXQta2V5ZnJhbWVzIGxvYWQ4IHtcbiAgMCUge1xuICAgIC13ZWJraXQtdHJhbnNmb3JtOiByb3RhdGUoMGRlZyk7XG4gICAgdHJhbnNmb3JtOiByb3RhdGUoMGRlZyk7XG4gIH1cbiAgMTAwJSB7XG4gICAgLXdlYmtpdC10cmFuc2Zvcm06IHJvdGF0ZSgzNjBkZWcpO1xuICAgIHRyYW5zZm9ybTogcm90YXRlKDM2MGRlZyk7XG4gIH1cbn1cblxuQGtleWZyYW1lcyBsb2FkOCB7XG4gIDAlIHtcbiAgICAtd2Via2l0LXRyYW5zZm9ybTogcm90YXRlKDBkZWcpO1xuICAgIHRyYW5zZm9ybTogcm90YXRlKDBkZWcpO1xuICB9XG4gIDEwMCUge1xuICAgIC13ZWJraXQtdHJhbnNmb3JtOiByb3RhdGUoMzYwZGVnKTtcbiAgICB0cmFuc2Zvcm06IHJvdGF0ZSgzNjBkZWcpO1xuICB9XG59XG5gO1xuIiwiZXhwb3J0IGNvbnN0IHRlbXBsYXRlID0gYFxuPGRpdiBjbGFzcz1cImJsb2NrLXVpLXdyYXBwZXIge3tuYW1lfX0ge3tjbGFzc05hbWV9fVwiIFtuZ0NsYXNzXT1cInsgJ2FjdGl2ZSc6IGFjdGl2ZSB9XCI+XG4gIDxkaXYgY2xhc3M9XCJibG9jay11aS1zcGlubmVyXCIgKm5nSWY9XCIhdGVtcGxhdGVDbXBcIj5cbiAgICA8ZGl2IGNsYXNzPVwibG9hZGVyXCI+PC9kaXY+XG4gICAgPGRpdiAqbmdJZj1cIm1lc3NhZ2UgfHwgZGVmYXVsdE1lc3NhZ2VcIiBjbGFzcz1cIm1lc3NhZ2VcIj5cbiAgICAgIHt7IG1lc3NhZ2UgfHwgZGVmYXVsdE1lc3NhZ2UgfX1cbiAgICA8L2Rpdj5cbiAgPC9kaXY+XG4gIDxuZy10ZW1wbGF0ZSAqbmdJZj1cInRlbXBsYXRlQ21wXCIgI3RlbXBsYXRlT3V0bGV0PjwvbmctdGVtcGxhdGU+XG48L2Rpdj5cbmA7XG4iLCJpbXBvcnQge1xuICBDb21wb25lbnQsXG4gIE9uSW5pdCxcbiAgQWZ0ZXJWaWV3SW5pdCxcbiAgQWZ0ZXJWaWV3Q2hlY2tlZCxcbiAgT25EZXN0cm95LFxuICBWaWV3RW5jYXBzdWxhdGlvbixcbiAgSW5wdXQsXG4gIFZpZXdDaGlsZCxcbiAgQ29tcG9uZW50UmVmLFxuICBUZW1wbGF0ZVJlZixcbiAgQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyLFxuICBWaWV3Q29udGFpbmVyUmVmLFxuICBDaGFuZ2VEZXRlY3RvclJlZlxufSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IE9ic2VydmFibGUsIFN1YnNjcmlwdGlvbiB9IGZyb20gJ3J4anMnO1xuXG5pbXBvcnQgeyBCbG9ja1VJSW5zdGFuY2VTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vc2VydmljZXMvYmxvY2stdWktaW5zdGFuY2Uuc2VydmljZSc7XG5pbXBvcnQgeyBCbG9ja1VJRXZlbnQgfSBmcm9tICcuLi8uLi9tb2RlbHMvYmxvY2stdWktZXZlbnQubW9kZWwnO1xuaW1wb3J0IHsgQmxvY2tVSUFjdGlvbnMgfSBmcm9tICcuLi8uLi9jb25zdGFudHMvYmxvY2stdWktYWN0aW9ucy5jb25zdGFudCc7XG5pbXBvcnQgeyBCbG9ja1VJRGVmYXVsdE5hbWUgfSBmcm9tICcuLi8uLi9jb25zdGFudHMvYmxvY2stdWktZGVmYXVsdC1uYW1lLmNvbnN0YW50JztcbmltcG9ydCB7IHN0eWxlcyB9IGZyb20gJy4vYmxvY2stdWktY29udGVudC5jb21wb25lbnQuc3R5bGUnO1xuaW1wb3J0IHsgdGVtcGxhdGUgfSBmcm9tICcuL2Jsb2NrLXVpLWNvbnRlbnQuY29tcG9uZW50LnRlbXBsYXRlJztcbmltcG9ydCB7IEJsb2NrVUlTZXR0aW5ncyB9IGZyb20gJy4uLy4uL21vZGVscy9ibG9jay11aS1zZXR0aW5ncy5tb2RlbCc7XG5cbkBDb21wb25lbnQoe1xuICBzZWxlY3RvcjogJ2Jsb2NrLXVpLWNvbnRlbnQnLFxuICB0ZW1wbGF0ZTogdGVtcGxhdGUsXG4gIHN0eWxlczogW3N0eWxlc10sIC8vIFRPRE86IEZpbmQgaG93IHRvIGJ1bmRsZSBzdHlsZXMgZm9yIG5wbVxuICBlbmNhcHN1bGF0aW9uOiBWaWV3RW5jYXBzdWxhdGlvbi5Ob25lXG59KVxuZXhwb3J0IGNsYXNzIEJsb2NrVUlDb250ZW50Q29tcG9uZW50IGltcGxlbWVudHMgT25Jbml0LCBBZnRlclZpZXdJbml0LCBBZnRlclZpZXdDaGVja2VkLCBPbkRlc3Ryb3kge1xuICBASW5wdXQoKSBuYW1lOiBzdHJpbmcgPSBCbG9ja1VJRGVmYXVsdE5hbWU7XG4gIEBJbnB1dCgpIGRlbGF5U3RhcnQ6IG51bWJlciA9IDA7XG4gIEBJbnB1dCgpIGRlbGF5U3RvcDogbnVtYmVyID0gMDtcbiAgQElucHV0KCdtZXNzYWdlJykgZGVmYXVsdE1lc3NhZ2U6IHN0cmluZztcbiAgQElucHV0KCd0ZW1wbGF0ZScpIHRlbXBsYXRlQ21wOiBhbnk7XG4gIEBWaWV3Q2hpbGQoJ3RlbXBsYXRlT3V0bGV0JywgeyByZWFkOiBWaWV3Q29udGFpbmVyUmVmIH0pXG4gIHRlbXBsYXRlT3V0bGV0OiBWaWV3Q29udGFpbmVyUmVmO1xuXG4gIHN0YXRlOiBhbnkgPSB7IHN0YXJ0VGltZW91dDogbnVsbCwgc3RvcFRpbWVvdXQ6IG51bGwsIGJsb2NrQ291bnQ6IDAgfTtcbiAgY2xhc3NOYW1lOiBzdHJpbmc7XG4gIGFjdGl2ZTogYm9vbGVhbiA9IGZhbHNlO1xuICB0ZW1wbGF0ZUNvbXBSZWY6IENvbXBvbmVudFJlZjx7IG1lc3NhZ2U/OiBhbnkgfT4gfCBUZW1wbGF0ZVJlZjx7fT47XG4gIG1lc3NhZ2U6IGFueTtcblxuICBwcml2YXRlIGJsb2NrVUlTdWJzY3JpcHRpb246IFN1YnNjcmlwdGlvbjtcbiAgcHJpdmF0ZSBzZXR0aW5nczogQmxvY2tVSVNldHRpbmdzO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIHByaXZhdGUgYmxvY2tVSTogQmxvY2tVSUluc3RhbmNlU2VydmljZSxcbiAgICBwcml2YXRlIHJlc29sdmVyOiBDb21wb25lbnRGYWN0b3J5UmVzb2x2ZXIsXG4gICAgcHJpdmF0ZSBjaGFuZ2VEZXRlY3Rpb25SZWY6IENoYW5nZURldGVjdG9yUmVmXG4gICkge31cblxuICBuZ09uSW5pdCgpIHtcbiAgICB0aGlzLnNldHRpbmdzID0gdGhpcy5ibG9ja1VJLmdldFNldHRpbmdzKCk7XG4gICAgdGhpcy5ibG9ja1VJU3Vic2NyaXB0aW9uID0gdGhpcy5zdWJzY3JpYmVUb0Jsb2NrVUkodGhpcy5ibG9ja1VJLm9ic2VydmUoKSk7XG4gIH1cblxuICBuZ0FmdGVyVmlld0luaXQoKSB7XG4gICAgdHJ5IHtcbiAgICAgIGlmICghdGhpcy50ZW1wbGF0ZUNtcCkge1xuICAgICAgICByZXR1cm4gZmFsc2U7XG4gICAgICB9XG5cbiAgICAgIGlmICh0aGlzLnRlbXBsYXRlQ21wIGluc3RhbmNlb2YgVGVtcGxhdGVSZWYpIHtcbiAgICAgICAgdGhpcy50ZW1wbGF0ZU91dGxldC5jcmVhdGVFbWJlZGRlZFZpZXcodGhpcy50ZW1wbGF0ZUNtcCk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBjb25zdCB0ZW1wbGF0ZUNvbXAgPSB0aGlzLnJlc29sdmVyLnJlc29sdmVDb21wb25lbnRGYWN0b3J5KHRoaXMudGVtcGxhdGVDbXApO1xuICAgICAgICB0aGlzLnRlbXBsYXRlQ29tcFJlZiA9IHRoaXMudGVtcGxhdGVPdXRsZXQuY3JlYXRlQ29tcG9uZW50KHRlbXBsYXRlQ29tcCk7XG5cbiAgICAgICAgdGhpcy51cGRhdGVCbG9ja1RlbXBsYXRlKHRoaXMubWVzc2FnZSk7XG4gICAgICB9XG4gICAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICAgIGNvbnNvbGUuZXJyb3IoJ25nLWJsb2NrLXVpOicsIGVycm9yKTtcbiAgICB9XG4gIH1cblxuICBuZ0FmdGVyVmlld0NoZWNrZWQoKSB7XG4gICAgdGhpcy5jaGFuZ2VEZXRlY3Rpb25SZWYuZGV0ZWN0Q2hhbmdlcygpO1xuICB9XG5cbiAgcHJpdmF0ZSBzdWJzY3JpYmVUb0Jsb2NrVUkoYmxvY2tVSSQ6IE9ic2VydmFibGU8YW55Pik6IFN1YnNjcmlwdGlvbiB7XG4gICAgcmV0dXJuIGJsb2NrVUkkXG4gICAgICAuc3Vic2NyaWJlKGV2ZW50ID0+IHRoaXMub25EaXNwYXRjaGVkRXZlbnQoZXZlbnQpKTtcbiAgfVxuXG4gIHByaXZhdGUgb25EaXNwYXRjaGVkRXZlbnQoZXZlbnQ6IEJsb2NrVUlFdmVudCkge1xuICAgIHN3aXRjaCAoZXZlbnQuYWN0aW9uKSB7XG4gICAgICBjYXNlIChCbG9ja1VJQWN0aW9ucy5TVEFSVCk6XG4gICAgICAgIHRoaXMub25TdGFydChldmVudCk7XG4gICAgICAgIGJyZWFrO1xuXG4gICAgICBjYXNlIChCbG9ja1VJQWN0aW9ucy5TVE9QKTpcbiAgICAgICAgdGhpcy5vblN0b3AoZXZlbnQpO1xuICAgICAgICBicmVhaztcblxuICAgICAgY2FzZSAoQmxvY2tVSUFjdGlvbnMuVVBEQVRFKTpcbiAgICAgICAgdGhpcy5vblVwZGF0ZShldmVudCk7XG4gICAgICAgIGJyZWFrO1xuXG4gICAgICBjYXNlIChCbG9ja1VJQWN0aW9ucy5SRVNFVCk6XG4gICAgICAgIHRoaXMub25SZXNldCgpO1xuICAgICAgICBicmVhaztcblxuICAgICAgY2FzZSAoQmxvY2tVSUFjdGlvbnMuVU5TVUJTQ1JJQkUpOlxuICAgICAgICB0aGlzLm9uU3RvcChldmVudCk7XG4gICAgICAgIHRoaXMub25VbnN1YnNjcmliZShldmVudC5uYW1lKTtcbiAgICAgICAgYnJlYWs7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBvblN0YXJ0KHsgbmFtZSwgbWVzc2FnZSB9OiBCbG9ja1VJRXZlbnQpIHtcbiAgICBpZiAobmFtZSA9PT0gdGhpcy5uYW1lKSB7XG4gICAgICBjb25zdCBkZWxheSA9IHRoaXMuZGVsYXlTdGFydCB8fCB0aGlzLnNldHRpbmdzLmRlbGF5U3RhcnQgfHwgMDtcblxuICAgICAgaWYgKGRlbGF5KSB7XG4gICAgICAgIGlmICh0aGlzLnN0YXRlLnN0YXJ0VGltZW91dCA9PT0gbnVsbCkge1xuICAgICAgICAgIHRoaXMuc3RhdGUuc3RhcnRUaW1lb3V0ID0gc2V0VGltZW91dCgoKSA9PiB7XG4gICAgICAgICAgICB0aGlzLnNob3dCbG9jayhtZXNzYWdlKTtcbiAgICAgICAgICB9LCBkZWxheSk7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5zdGF0ZS5ibG9ja0NvdW50Kys7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICB0aGlzLnNob3dCbG9jayhtZXNzYWdlKTtcbiAgICAgIH1cblxuICAgICAgdGhpcy51cGRhdGVJbnN0YW5jZUJsb2NrQ291bnQoKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIG9uU3RvcCh7IG5hbWUsIGFjdGlvbiB9OiBCbG9ja1VJRXZlbnQpIHtcbiAgICBpZiAobmFtZSA9PT0gdGhpcy5uYW1lKSB7XG4gICAgICBpZiAodGhpcy5zdGF0ZS5ibG9ja0NvdW50ID4gMSkge1xuICAgICAgICB0aGlzLnN0YXRlLmJsb2NrQ291bnQtLTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIGlmICghdGhpcy5hY3RpdmUpIHtcbiAgICAgICAgICB0aGlzLmNsZWFyU3RhdGUoKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBjb25zdCBkZWxheSA9IHRoaXMuZGVsYXlTdG9wIHx8IHRoaXMuc2V0dGluZ3MuZGVsYXlTdG9wIHx8IDA7XG4gICAgICAgICAgaWYgKGRlbGF5KSB7XG4gICAgICAgICAgICBpZiAodGhpcy5zdGF0ZS5zdG9wVGltZW91dCA9PT0gbnVsbCkge1xuICAgICAgICAgICAgICB0aGlzLnN0YXRlLnN0b3BUaW1lb3V0ID0gc2V0VGltZW91dCgoKSA9PiB7XG4gICAgICAgICAgICAgICAgdGhpcy5oaWRlQmxvY2soKTtcbiAgICAgICAgICAgICAgfSwgZGVsYXkpO1xuICAgICAgICAgICAgfVxuICAgICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgICB0aGlzLmhpZGVCbG9jaygpO1xuICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgfVxuXG4gICAgICB0aGlzLnVwZGF0ZUluc3RhbmNlQmxvY2tDb3VudCgpO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgb25SZXNldCgpIHtcbiAgICB0aGlzLmhpZGVCbG9jaygpO1xuICB9XG5cbiAgcHJpdmF0ZSBvblVwZGF0ZSh7IG5hbWUsIG1lc3NhZ2UgfTogQmxvY2tVSUV2ZW50KSB7XG4gICAgaWYgKG5hbWUgPT09IHRoaXMubmFtZSkge1xuICAgICAgdGhpcy5hY3RpdmUgPSB0cnVlO1xuICAgICAgdGhpcy5tZXNzYWdlID0gbWVzc2FnZSB8fCB0aGlzLmRlZmF1bHRNZXNzYWdlIHx8IHRoaXMuc2V0dGluZ3MubWVzc2FnZTtcbiAgICAgIHRoaXMudXBkYXRlQmxvY2tUZW1wbGF0ZSh0aGlzLm1lc3NhZ2UpO1xuICAgICAgdGhpcy5jaGFuZ2VEZXRlY3Rpb25SZWYuZGV0ZWN0Q2hhbmdlcygpO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgc2hvd0Jsb2NrKG1lc3NhZ2U6IGFueSkge1xuICAgIHRoaXMuYWN0aXZlID0gdHJ1ZTtcbiAgICB0aGlzLm1lc3NhZ2UgPSBtZXNzYWdlIHx8IHRoaXMuZGVmYXVsdE1lc3NhZ2UgfHwgdGhpcy5zZXR0aW5ncy5tZXNzYWdlO1xuICAgIHRoaXMudXBkYXRlQmxvY2tUZW1wbGF0ZSh0aGlzLm1lc3NhZ2UpO1xuICAgIHRoaXMuY2hhbmdlRGV0ZWN0aW9uUmVmLmRldGVjdENoYW5nZXMoKTtcbiAgfVxuXG4gIHByaXZhdGUgaGlkZUJsb2NrKCkge1xuICAgIHRoaXMuY2xlYXJTdGF0ZSgpO1xuICAgIHRoaXMuYWN0aXZlID0gZmFsc2U7XG4gICAgdGhpcy5jaGFuZ2VEZXRlY3Rpb25SZWYuZGV0ZWN0Q2hhbmdlcygpO1xuICB9XG5cbiAgcHJpdmF0ZSBjbGVhclN0YXRlKCkge1xuICAgIHRoaXMuc3RhdGUuc3RhcnRUaW1lb3V0ICE9IG51bGwgJiYgY2xlYXJUaW1lb3V0KHRoaXMuc3RhdGUuc3RhcnRUaW1lb3V0KTtcbiAgICB0aGlzLnN0YXRlLnN0b3BUaW1lb3V0ICE9IG51bGwgJiYgY2xlYXJUaW1lb3V0KHRoaXMuc3RhdGUuc3RvcFRpbWVvdXQpO1xuICAgIHRoaXMuc3RhdGUuYmxvY2tDb3VudCA9IDA7XG4gICAgdGhpcy5zdGF0ZS5zdGFydFRpbWVvdXQgPSBudWxsO1xuICAgIHRoaXMuc3RhdGUuc3RvcFRpbWVvdXQgPSBudWxsO1xuICAgIHRoaXMudXBkYXRlSW5zdGFuY2VCbG9ja0NvdW50KCk7XG4gIH1cblxuICBwcml2YXRlIHVwZGF0ZUJsb2NrVGVtcGxhdGUobXNnOiBhbnkpOiB2b2lkIHtcbiAgICBpZiAodGhpcy50ZW1wbGF0ZUNvbXBSZWYgJiYgdGhpcy50ZW1wbGF0ZUNvbXBSZWYgaW5zdGFuY2VvZiBDb21wb25lbnRSZWYpIHtcbiAgICAgIHRoaXMudGVtcGxhdGVDb21wUmVmLmluc3RhbmNlLm1lc3NhZ2UgPSBtc2c7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBvblVuc3Vic2NyaWJlKG5hbWU6IHN0cmluZykge1xuICAgIGlmICh0aGlzLmJsb2NrVUlTdWJzY3JpcHRpb24gJiYgbmFtZSA9PT0gdGhpcy5uYW1lKSB7XG4gICAgICB0aGlzLmJsb2NrVUlTdWJzY3JpcHRpb24udW5zdWJzY3JpYmUoKTtcbiAgICB9XG4gIH1cblxuICBwcml2YXRlIHVwZGF0ZUluc3RhbmNlQmxvY2tDb3VudCgpIHtcbiAgICBpZiAodGhpcy5ibG9ja1VJLmJsb2NrVUlJbnN0YW5jZXNbdGhpcy5uYW1lXSkge1xuICAgICAgdGhpcy5ibG9ja1VJLmJsb2NrVUlJbnN0YW5jZXNbdGhpcy5uYW1lXS5ibG9ja0NvdW50ID0gdGhpcy5zdGF0ZS5ibG9ja0NvdW50O1xuICAgIH1cbiAgfVxuXG4gIG5nT25EZXN0cm95KCkge1xuICAgIHRoaXMub25VbnN1YnNjcmliZSh0aGlzLm5hbWUpO1xuICB9XG59XG4iLCJpbXBvcnQgeyBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XG5pbXBvcnQgeyBCbG9ja1VJQWN0aW9ucyB9IGZyb20gJy4uL2NvbnN0YW50cy9ibG9jay11aS1hY3Rpb25zLmNvbnN0YW50JztcbmltcG9ydCB7IEJsb2NrVUlEZWZhdWx0TmFtZSB9IGZyb20gJy4uL2NvbnN0YW50cy9ibG9jay11aS1kZWZhdWx0LW5hbWUuY29uc3RhbnQnO1xuaW1wb3J0IHsgQmxvY2tVSUluc3RhbmNlU2VydmljZSB9IGZyb20gJy4vYmxvY2stdWktaW5zdGFuY2Uuc2VydmljZSc7XG5cblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIEJsb2NrVUlTZXJ2aWNlIHtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIGJsb2NrVUlJbnN0YW5jZTogQmxvY2tVSUluc3RhbmNlU2VydmljZVxuICApIHt9XG5cbiAgLyoqXG4gICogU3RhcnRzIGJsb2NraW5nIGZvciBnaXZlbiBCbG9ja1VJIGluc3RhbmNlIG9yIGluc3RhbmNlc1xuICAqL1xuICBzdGFydCh0YXJnZXQ6IHN0cmluZyB8IHN0cmluZ1tdLCBtZXNzYWdlPzogYW55KTogdm9pZCB7XG4gICAgdGhpcy5kaXNwYXRjaCh0YXJnZXQsIEJsb2NrVUlBY3Rpb25zLlNUQVJULCBtZXNzYWdlKTtcbiAgfVxuXG4gIC8qKlxuICAqIFN0b3BzIGJsb2NraW5nIGZvciBnaXZlbiBCbG9ja1VJIGluc3RhbmNlIG9yIGluc3RhbmNlc1xuICAqL1xuICBzdG9wKHRhcmdldDogc3RyaW5nIHwgc3RyaW5nW10pOiB2b2lkIHtcbiAgICB0aGlzLmRpc3BhdGNoKHRhcmdldCwgQmxvY2tVSUFjdGlvbnMuU1RPUCk7XG4gIH1cblxuICAvKipcbiAgKiBVbnN1YnNjcmliZXMgZm9yIGdpdmVuIEJsb2NrVUkgaW5zdGFuY2Ugb3IgaW5zdGFuY2VzXG4gICovXG4gIHVuc3Vic2NyaWJlKHRhcmdldDogc3RyaW5nIHwgc3RyaW5nW10pOiB2b2lkIHtcbiAgICB0aGlzLmRpc3BhdGNoKHRhcmdldCwgQmxvY2tVSUFjdGlvbnMuVU5TVUJTQ1JJQkUpO1xuICB9XG5cbiAgLyoqXG4gICogQ2hlY2tzIGlmIEJsb2NrVUkgaXMgYWN0aXZlbHkgYmxvY2tpbmdcbiAgKi9cbiAgaXNBY3RpdmUodGFyZ2V0OiBzdHJpbmcgfCBzdHJpbmdbXSA9IG51bGwpOiBib29sZWFuIHtcbiAgICBjb25zdCB0YXJnZXRzID0gdGFyZ2V0ID8gdGhpcy50b0FycmF5KHRhcmdldCkgOiBudWxsO1xuICAgIGNvbnN0IGluc3RhbmNlcyA9IHRoaXMuYmxvY2tVSUluc3RhbmNlLmJsb2NrVUlJbnN0YW5jZXM7XG5cbiAgICByZXR1cm4gT2JqZWN0LmtleXMoaW5zdGFuY2VzKS5zb21lKChrZXk6IHN0cmluZykgPT4ge1xuICAgICAgaWYgKCF0YXJnZXRzKSB7XG4gICAgICAgIHJldHVybiBpbnN0YW5jZXNba2V5XS5pc0FjdGl2ZTtcbiAgICAgIH1cblxuICAgICAgcmV0dXJuIHRhcmdldHMuaW5kZXhPZihpbnN0YW5jZXNba2V5XS5uYW1lKSA+PSAwICYmIGluc3RhbmNlc1trZXldLmlzQWN0aXZlO1xuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBkaXNwYXRjaCh0YXJnZXQ6IHN0cmluZyB8IHN0cmluZ1tdID0gW10sIHR5cGU6IHN0cmluZywgbWVzc2FnZT86IGFueSkge1xuICAgIGNvbnN0IGluc3RhbmNlcyA9IHRoaXMudG9BcnJheSh0YXJnZXQpO1xuICAgIGluc3RhbmNlcy5mb3JFYWNoKGkgPT4gdGhpcy5ibG9ja1VJSW5zdGFuY2UuZGVjb3JhdGUoaSlbdHlwZV0obWVzc2FnZSkpO1xuICB9XG5cbiAgcHJpdmF0ZSB0b0FycmF5KHRhcmdldDogc3RyaW5nIHwgc3RyaW5nW10gPSBbXSkge1xuICAgIHJldHVybiB0eXBlb2YgdGFyZ2V0ID09PSAnc3RyaW5nJyA/IFt0YXJnZXRdIDogdGFyZ2V0O1xuICB9XG59XG4iLCJpbXBvcnQge1xuICBEaXJlY3RpdmUsXG4gIElucHV0LFxuICBPbkluaXQsXG4gIENvbXBvbmVudFJlZixcbiAgQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyLFxuICBWaWV3Q29udGFpbmVyUmVmLFxuICBUZW1wbGF0ZVJlZixcbiAgUmVuZGVyZXIyXG59IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQmxvY2tVSUNvbnRlbnRDb21wb25lbnQgfSBmcm9tICcuLi9jb21wb25lbnRzL2Jsb2NrLXVpLWNvbnRlbnQvYmxvY2stdWktY29udGVudC5jb21wb25lbnQnO1xuaW1wb3J0IHsgQmxvY2tVSUluc3RhbmNlU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2Jsb2NrLXVpLWluc3RhbmNlLnNlcnZpY2UnO1xuaW1wb3J0IHsgQmxvY2tVSURlZmF1bHROYW1lIH0gZnJvbSAnLi4vY29uc3RhbnRzL2Jsb2NrLXVpLWRlZmF1bHQtbmFtZS5jb25zdGFudCc7XG5cbkBEaXJlY3RpdmUoeyBzZWxlY3RvcjogJ1tibG9ja1VJXScgfSlcbmV4cG9ydCBjbGFzcyBCbG9ja1VJRGlyZWN0aXZlIGltcGxlbWVudHMgT25Jbml0IHtcbiAgcHJpdmF0ZSBibG9ja1VJQ29tcG9uZW50UmVmOiBDb21wb25lbnRSZWY8QmxvY2tVSUNvbnRlbnRDb21wb25lbnQ+O1xuICBibG9ja1RhcmdldDogc3RyaW5nO1xuICBtZXNzYWdlOiBhbnk7XG4gIHRlbXBsYXRlOiBhbnk7XG4gIGRlbGF5U3RhcnQ6IGFueTtcbiAgZGVsYXlTdG9wOiBhbnk7XG5cbiAgQElucHV0KClcbiAgc2V0IGJsb2NrVUkobmFtZTogYW55KSB7IHRoaXMuYmxvY2tUYXJnZXQgPSBuYW1lOyB9O1xuICBASW5wdXQoKVxuICBzZXQgYmxvY2tVSU1lc3NhZ2UobWVzc2FnZTogYW55KSB7IHRoaXMubWVzc2FnZSA9IG1lc3NhZ2U7IH07XG4gIEBJbnB1dCgpXG4gIHNldCBibG9ja1VJVGVtcGxhdGUodGVtcGxhdGU6IGFueSkgeyB0aGlzLnRlbXBsYXRlID0gdGVtcGxhdGU7IH07XG4gIEBJbnB1dCgpXG4gIHNldCBibG9ja1VJRGVsYXlTdGFydChkZWxheVN0YXJ0OiBhbnkpIHtcbiAgICAgdGhpcy5kZWxheVN0YXJ0ID0gZGVsYXlTdGFydCA/IE51bWJlcihkZWxheVN0YXJ0KSA6IG51bGw7XG4gIH07XG4gIEBJbnB1dCgpXG4gIHNldCBibG9ja1VJRGVsYXlTdG9wKGRlbGF5U3RvcDogYW55KSB7XG4gICAgdGhpcy5kZWxheVN0b3AgPSBkZWxheVN0b3AgPyBOdW1iZXIoZGVsYXlTdG9wKSA6IG51bGw7XG4gIH07XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSBibG9ja1VJU2VydmljZTogQmxvY2tVSUluc3RhbmNlU2VydmljZSxcbiAgICBwcml2YXRlIHZpZXdSZWY6IFZpZXdDb250YWluZXJSZWYsXG4gICAgcHJpdmF0ZSB0ZW1wbGF0ZVJlZjogVGVtcGxhdGVSZWY8YW55PixcbiAgICBwcml2YXRlIHJlbmRlcmVyOiBSZW5kZXJlcjIsXG4gICAgcHJpdmF0ZSBjb21wb25lbnRGYWN0b3J5UmVzb2x2ZXI6IENvbXBvbmVudEZhY3RvcnlSZXNvbHZlclxuICApIHsgfVxuXG4gIG5nT25Jbml0KCkge1xuICAgIHRyeSB7XG4gICAgICB0aGlzLnZpZXdSZWYuY3JlYXRlRW1iZWRkZWRWaWV3KHRoaXMudGVtcGxhdGVSZWYpO1xuICAgICAgY29uc3QgcGFyZW50RWxlbWVudCA9IHRoaXMudmlld1JlZi5lbGVtZW50Lm5hdGl2ZUVsZW1lbnQubmV4dFNpYmxpbmc7XG5cbiAgICAgIGlmIChwYXJlbnRFbGVtZW50ICYmICF0aGlzLmlzQ29tcG9uZW50SW5UZW1wbGF0ZShwYXJlbnRFbGVtZW50KSkge1xuICAgICAgICB0aGlzLnJlbmRlcmVyLmFkZENsYXNzKHBhcmVudEVsZW1lbnQsICdibG9jay11aV9fZWxlbWVudCcpO1xuXG4gICAgICAgIHRoaXMuYmxvY2tVSUNvbXBvbmVudFJlZiA9IHRoaXMuY3JlYXRlQ29tcG9uZW50KCk7XG5cbiAgICAgICAgbGV0IGJsb2NrVUlDb250ZW50ID0gdGhpcy5maW5kQ29udGVudE5vZGUodGhpcy52aWV3UmVmLmVsZW1lbnQubmF0aXZlRWxlbWVudCk7XG5cbiAgICAgICAgaWYgKGJsb2NrVUlDb250ZW50KSB7XG4gICAgICAgICAgY29uc3Qgc2V0dGluZ3MgPSB0aGlzLmJsb2NrVUlTZXJ2aWNlLmdldFNldHRpbmdzKCk7XG5cbiAgICAgICAgICBwYXJlbnRFbGVtZW50LmFwcGVuZENoaWxkKGJsb2NrVUlDb250ZW50KTtcbiAgICAgICAgICB0aGlzLmJsb2NrVUlDb21wb25lbnRSZWYuaW5zdGFuY2UuY2xhc3NOYW1lID0gJ2Jsb2NrLXVpLXdyYXBwZXItLWVsZW1lbnQnO1xuICAgICAgICAgIHRoaXMuYmxvY2tVSUNvbXBvbmVudFJlZi5pbnN0YW5jZS5uYW1lID0gdGhpcy5ibG9ja1RhcmdldCB8fCBCbG9ja1VJRGVmYXVsdE5hbWU7XG4gICAgICAgICAgaWYgKHRoaXMubWVzc2FnZSkgdGhpcy5ibG9ja1VJQ29tcG9uZW50UmVmLmluc3RhbmNlLmRlZmF1bHRNZXNzYWdlID0gdGhpcy5tZXNzYWdlO1xuICAgICAgICAgIGlmICh0aGlzLmRlbGF5U3RhcnQpIHRoaXMuYmxvY2tVSUNvbXBvbmVudFJlZi5pbnN0YW5jZS5kZWxheVN0YXJ0ID0gdGhpcy5kZWxheVN0YXJ0O1xuICAgICAgICAgIGlmICh0aGlzLmRlbGF5U3RvcCkgdGhpcy5ibG9ja1VJQ29tcG9uZW50UmVmLmluc3RhbmNlLmRlbGF5U3RvcCA9IHRoaXMuZGVsYXlTdG9wO1xuICAgICAgICAgIGlmICh0aGlzLnRlbXBsYXRlIHx8IHNldHRpbmdzLnRlbXBsYXRlKVxuICAgICAgICAgICAgdGhpcy5ibG9ja1VJQ29tcG9uZW50UmVmLmluc3RhbmNlLnRlbXBsYXRlQ21wID0gdGhpcy50ZW1wbGF0ZSB8fCBzZXR0aW5ncy50ZW1wbGF0ZTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICBjb25zb2xlLmVycm9yKCduZy1ibG9jay11aTonLCBlcnJvcik7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBpc0NvbXBvbmVudEluVGVtcGxhdGUoZWxlbWVudDogYW55KTogYm9vbGVhbiB7XG4gICAgbGV0IHsgY2hpbGRyZW4gfSA9IGVsZW1lbnQgfHwgW107XG4gICAgY2hpbGRyZW4gPSBBcnJheS5mcm9tKGNoaWxkcmVuKS5yZXZlcnNlKCk7XG4gICAgcmV0dXJuIGNoaWxkcmVuLnNvbWUoKGVsOiBhbnkpID0+IGVsLmxvY2FsTmFtZSA9PT0gJ2Jsb2NrLXVpJyk7XG4gIH1cblxuICAvLyBOZWVkZWQgZm9yIElFICgjMTcpXG4gIHByaXZhdGUgZmluZENvbnRlbnROb2RlKGVsZW1lbnQ6IGFueSkge1xuICAgIGNvbnN0IHsgbmV4dFNpYmxpbmcgfSA9IGVsZW1lbnQ7XG4gICAgcmV0dXJuIFtuZXh0U2libGluZywgbmV4dFNpYmxpbmcubmV4dFNpYmxpbmddLmZpbmQoKGUpID0+IGUubG9jYWxOYW1lID09PSAnYmxvY2stdWktY29udGVudCcpO1xuICB9XG5cbiAgcHJpdmF0ZSBjcmVhdGVDb21wb25lbnQoKSB7XG4gICAgY29uc3QgcmVzb2x2ZWRCbG9ja1VJQ29tcG9uZW50ID0gdGhpcy5jb21wb25lbnRGYWN0b3J5UmVzb2x2ZXIucmVzb2x2ZUNvbXBvbmVudEZhY3RvcnkoQmxvY2tVSUNvbnRlbnRDb21wb25lbnQpO1xuICAgIHJldHVybiB0aGlzLnZpZXdSZWYuY3JlYXRlQ29tcG9uZW50KHJlc29sdmVkQmxvY2tVSUNvbXBvbmVudCk7XG4gIH1cbn1cbiIsImltcG9ydCB7IE5nTW9kdWxlLCBNb2R1bGVXaXRoUHJvdmlkZXJzLCBJbmplY3Rpb25Ub2tlbiB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xuaW1wb3J0IHsgQ29tbW9uTW9kdWxlIH0gZnJvbSAnQGFuZ3VsYXIvY29tbW9uJztcblxuaW1wb3J0IHsgQmxvY2tVSUNvbXBvbmVudCB9IGZyb20gJy4vY29tcG9uZW50cy9ibG9jay11aS9ibG9jay11aS5jb21wb25lbnQnO1xuaW1wb3J0IHsgQmxvY2tVSUNvbnRlbnRDb21wb25lbnQgfSBmcm9tICcuL2NvbXBvbmVudHMvYmxvY2stdWktY29udGVudC9ibG9jay11aS1jb250ZW50LmNvbXBvbmVudCc7XG5pbXBvcnQgeyBCbG9ja1VJSW5zdGFuY2VTZXJ2aWNlIH0gZnJvbSAnLi9zZXJ2aWNlcy9ibG9jay11aS1pbnN0YW5jZS5zZXJ2aWNlJztcbmltcG9ydCB7IEJsb2NrVUlTZXJ2aWNlIH0gZnJvbSAnLi9zZXJ2aWNlcy9ibG9jay11aS5zZXJ2aWNlJztcbmltcG9ydCB7IEJsb2NrVUlEaXJlY3RpdmUgfSBmcm9tICcuL2RpcmVjdGl2ZXMvYmxvY2stdWkuZGlyZWN0aXZlJztcbmltcG9ydCB7IEJsb2NrVUlTZXR0aW5ncyB9IGZyb20gJy4vbW9kZWxzL2Jsb2NrLXVpLXNldHRpbmdzLm1vZGVsJztcblxuZXhwb3J0IGNvbnN0IEJsb2NrVUlTZXJ2aWNlSW5zdGFuY2UgPSBuZXcgQmxvY2tVSUluc3RhbmNlU2VydmljZSgpO1xuXG4vLyBOZWVkZWQgZm9yIEFPVCBjb21waWxpbmdcbmV4cG9ydCBjb25zdCBCbG9ja1VJTW9kdWxlU2V0dGluZ3MgPSBuZXcgSW5qZWN0aW9uVG9rZW48c3RyaW5nPignQmxvY2tVSU1vZHVsZVNldHRpbmdzJyk7XG5cbmV4cG9ydCBmdW5jdGlvbiBwcm92aWRlSW5zdGFuY2Uoc2V0dGluZ3M6IEJsb2NrVUlTZXR0aW5ncyk6IGFueSB7XG4gIEJsb2NrVUlTZXJ2aWNlSW5zdGFuY2UudXBkYXRlU2V0dGluZ3Moc2V0dGluZ3MpO1xuICByZXR1cm4gQmxvY2tVSVNlcnZpY2VJbnN0YW5jZTtcbn1cblxuQE5nTW9kdWxlKHtcbiAgaW1wb3J0czogW1xuICAgIENvbW1vbk1vZHVsZVxuICBdLFxuICBlbnRyeUNvbXBvbmVudHM6IFtcbiAgICBCbG9ja1VJQ29tcG9uZW50LFxuICAgIEJsb2NrVUlDb250ZW50Q29tcG9uZW50XG4gIF0sXG4gIGRlY2xhcmF0aW9uczogW1xuICAgIEJsb2NrVUlDb21wb25lbnQsXG4gICAgQmxvY2tVSURpcmVjdGl2ZSxcbiAgICBCbG9ja1VJQ29udGVudENvbXBvbmVudFxuICBdLFxuICBleHBvcnRzOiBbXG4gICAgQmxvY2tVSUNvbXBvbmVudCxcbiAgICBCbG9ja1VJRGlyZWN0aXZlLFxuICAgIEJsb2NrVUlDb250ZW50Q29tcG9uZW50XG4gIF1cbn0pXG5leHBvcnQgY2xhc3MgQmxvY2tVSU1vZHVsZSB7XG4gIHB1YmxpYyBzdGF0aWMgZm9yUm9vdChzZXR0aW5nczogQmxvY2tVSVNldHRpbmdzID0ge30pOiBNb2R1bGVXaXRoUHJvdmlkZXJzIHtcbiAgICByZXR1cm4ge1xuICAgICAgbmdNb2R1bGU6IEJsb2NrVUlNb2R1bGUsXG4gICAgICBwcm92aWRlcnM6IFtcbiAgICAgICAge1xuICAgICAgICAgIHByb3ZpZGU6IEJsb2NrVUlNb2R1bGVTZXR0aW5ncyxcbiAgICAgICAgICB1c2VWYWx1ZTogc2V0dGluZ3NcbiAgICAgICAgfSxcbiAgICAgICAge1xuICAgICAgICAgIHByb3ZpZGU6IEJsb2NrVUlJbnN0YW5jZVNlcnZpY2UsXG4gICAgICAgICAgdXNlRmFjdG9yeTogcHJvdmlkZUluc3RhbmNlLFxuICAgICAgICAgIGRlcHM6IFtCbG9ja1VJTW9kdWxlU2V0dGluZ3NdXG4gICAgICAgIH0sXG4gICAgICAgIEJsb2NrVUlTZXJ2aWNlXG4gICAgICBdXG4gICAgfTtcbiAgfVxufVxuIiwiaW1wb3J0IHsgQmxvY2tVSVNlcnZpY2VJbnN0YW5jZSB9IGZyb20gJy4uL2Jsb2NrLXVpLm1vZHVsZSc7XG5cblxuZXhwb3J0IGZ1bmN0aW9uIEJsb2NrVUkodmFsdWU/OiBzdHJpbmcpIHtcbiAgcmV0dXJuIGZ1bmN0aW9uICh0YXJnZXQ/OiBhbnksIHByb3BlcnR5S2V5Pzogc3RyaW5nLCBkZXNjcmlwdG9yPzogYW55KSB7XG4gICAgdGFyZ2V0W3Byb3BlcnR5S2V5XSA9IEJsb2NrVUlTZXJ2aWNlSW5zdGFuY2UuZGVjb3JhdGUodmFsdWUpO1xuICB9O1xufVxuIl0sIm5hbWVzIjpbIlJlcGxheVN1YmplY3QiLCJJbmplY3RhYmxlIiwiQ29tcG9uZW50IiwiVmlld0VuY2Fwc3VsYXRpb24iLCJJbnB1dCIsIlRlbXBsYXRlUmVmIiwiQ29tcG9uZW50UmVmIiwiQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyIiwiQ2hhbmdlRGV0ZWN0b3JSZWYiLCJWaWV3Q2hpbGQiLCJWaWV3Q29udGFpbmVyUmVmIiwiRGlyZWN0aXZlIiwiUmVuZGVyZXIyIiwiSW5qZWN0aW9uVG9rZW4iLCJOZ01vZHVsZSIsIkNvbW1vbk1vZHVsZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0lBQUE7Ozs7Ozs7Ozs7Ozs7O0FBY0EsSUFlTyxJQUFJLFFBQVEsR0FBRztRQUNsQixRQUFRLEdBQUcsTUFBTSxDQUFDLE1BQU0sSUFBSSxrQkFBa0IsQ0FBQztZQUMzQyxLQUFLLElBQUksQ0FBQyxFQUFFLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLFNBQVMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxHQUFHLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtnQkFDakQsQ0FBQyxHQUFHLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDakIsS0FBSyxJQUFJLENBQUMsSUFBSSxDQUFDO29CQUFFLElBQUksTUFBTSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsSUFBSSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7d0JBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzthQUNoRjtZQUNELE9BQU8sQ0FBQyxDQUFDO1NBQ1osQ0FBQTtRQUNELE9BQU8sUUFBUSxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLENBQUM7SUFDM0MsQ0FBQyxDQUFBOzs7Ozs7Ozs7K0JDckNrQixPQUFPOzhCQUNSLE1BQU07Z0NBQ0osUUFBUTsrQkFDVCxPQUFPO3FDQUNELGFBQWE7NkJBTHRDOzs7Ozs7O0FDQUEseUJBQWEsa0JBQWtCLEdBQVcsZUFBZTs7Ozs7OztRQ2dCdkQ7bUNBTHlDLEVBQUU7b0NBQ25CLEVBQUU7a0NBQ21CLElBQUlBLGtCQUFhLEVBQUU7cUNBQ25CLElBQUksQ0FBQyxjQUFjLENBQUMsWUFBWSxFQUFFO1lBRzdFLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO1NBQ3JFOzs7O1FBRUQsNENBQVc7OztZQUFYO2dCQUNFLE9BQU8sSUFBSSxDQUFDLGVBQWUsQ0FBQzthQUM3Qjs7Ozs7UUFFRCwrQ0FBYzs7OztZQUFkLFVBQWUsUUFBb0M7Z0JBQXBDLHlCQUFBO29CQUFBLGFBQW9DOztnQkFDakQsSUFBSSxDQUFDLGVBQWUsZ0JBQVEsSUFBSSxDQUFDLGVBQWUsRUFBSyxRQUFRLENBQUUsQ0FBQzthQUNqRTs7Ozs7UUFFRCx5Q0FBUTs7OztZQUFSLFVBQVMsSUFBaUM7Z0JBQWpDLHFCQUFBO29CQUFBLHlCQUFpQzs7Z0JBQ3hDLHFCQUFNLE9BQU8sSUFBRztvQkFDZCxJQUFJLE1BQUE7b0JBQ0osUUFBUSxFQUFFLEtBQUs7b0JBQ2YsVUFBVSxFQUFFLENBQUM7b0JBQ2IsS0FBSyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQztvQkFDckUsTUFBTSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsTUFBTSxFQUFFLElBQUksQ0FBQztvQkFDdkUsSUFBSSxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQztvQkFDbkUsS0FBSyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsS0FBSyxFQUFFLElBQUksQ0FBQztvQkFDckUsV0FBVyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLGNBQWMsRUFBRSxjQUFjLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQztpQkFDckUsQ0FBQSxDQUFDO2dCQUVmLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLElBQUksT0FBTyxDQUFDO2dCQUVyRSxPQUFPLE9BQU8sQ0FBQzthQUNoQjs7OztRQUVELHdDQUFPOzs7WUFBUDtnQkFDRSxPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQzthQUMvQjs7Ozs7UUFFTyxrREFBaUI7Ozs7c0JBQUMsRUFBOEI7b0JBQTVCLGtCQUFNLEVBQUUsY0FBSTtnQkFDdEMscUJBQUksUUFBUSxHQUFZLElBQUksQ0FBQztnQkFFN0IsUUFBUSxNQUFNO29CQUNaLE1BQU0sY0FBYyxDQUFDLEtBQUs7d0JBQ3hCLFFBQVEsR0FBRyxJQUFJLENBQUM7d0JBQ2hCLE1BQU07b0JBRVIsTUFBTSxjQUFjLENBQUMsSUFBSSxFQUFFO29CQUMzQixNQUFNLGNBQWMsQ0FBQyxLQUFLO3dCQUN4QixRQUFRLEdBQUcsS0FBSyxDQUFDO3dCQUNqQixNQUFNO2lCQUNUO2dCQUVELElBQUksUUFBUSxLQUFLLElBQUksRUFBRTtvQkFDckIsSUFBSSxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7aUJBQ2pEOzs7Ozs7OztRQUdLLHlDQUFROzs7Ozs7c0JBQUMsT0FBMkIsRUFBRSxNQUFzQixFQUFFLElBQWlDO2dCQUFqQyxxQkFBQTtvQkFBQSx5QkFBaUM7O2dCQUNyRyxPQUFPLFVBQUMsT0FBYTtvQkFDbkIsT0FBTyxDQUFDLElBQUksQ0FBQzt3QkFDWCxJQUFJLE1BQUE7d0JBQ0osTUFBTSxRQUFBO3dCQUNOLE9BQU8sU0FBQTtxQkFDUixDQUFDLENBQUM7aUJBQ0osQ0FBQzs7O29CQWxFTEMsZUFBVTs7OztxQ0FUWDs7Ozs7OztBQ0FBO1FBZ0NFLDBCQUNVO1lBQUEsWUFBTyxHQUFQLE9BQU87U0FDWjs7OztRQUVMLG1DQUFROzs7WUFBUjtnQkFDRSxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQyxJQUFJLElBQUksa0JBQWtCLENBQUM7Z0JBQzVDLElBQUksQ0FBQyxRQUFRLEdBQUcsSUFBSSxDQUFDLFFBQVEsSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUM7YUFDeEU7O29CQTdCRkMsY0FBUyxTQUFDO3dCQUNULFFBQVEsRUFBRSxVQUFVO3dCQUNwQixRQUFRLEVBQUUsbVBBVVQ7d0JBQ0QsYUFBYSxFQUFFQyxzQkFBaUIsQ0FBQyxJQUFJO3FCQUN0Qzs7Ozs7d0JBakJRLHNCQUFzQjs7OzsyQkFtQjVCQyxVQUFLOzhCQUNMQSxVQUFLO2lDQUNMQSxVQUFLO2dDQUNMQSxVQUFLOytCQUNMQSxVQUFLOzsrQkE5QlI7Ozs7Ozs7O0FDRUEseUJBQWEsTUFBTSxHQUFHLCtuREF3RnJCOzs7Ozs7QUMxRkQseUJBQWEsUUFBUSxHQUFHLHdZQVV2Qjs7Ozs7O0FDVkQ7UUFpREUsaUNBQ1UsU0FDQSxVQUNBO1lBRkEsWUFBTyxHQUFQLE9BQU87WUFDUCxhQUFRLEdBQVIsUUFBUTtZQUNSLHVCQUFrQixHQUFsQixrQkFBa0I7d0JBcEJKLGtCQUFrQjs4QkFDWixDQUFDOzZCQUNGLENBQUM7eUJBTWpCLEVBQUUsWUFBWSxFQUFFLElBQUksRUFBRSxXQUFXLEVBQUUsSUFBSSxFQUFFLFVBQVUsRUFBRSxDQUFDLEVBQUU7MEJBRW5ELEtBQUs7U0FXbkI7Ozs7UUFFSiwwQ0FBUTs7O1lBQVI7Z0JBQ0UsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVcsRUFBRSxDQUFDO2dCQUMzQyxJQUFJLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLGtCQUFrQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLENBQUMsQ0FBQzthQUM1RTs7OztRQUVELGlEQUFlOzs7WUFBZjtnQkFDRSxJQUFJO29CQUNGLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFO3dCQUNyQixPQUFPLEtBQUssQ0FBQztxQkFDZDtvQkFFRCxJQUFJLElBQUksQ0FBQyxXQUFXLFlBQVlDLGdCQUFXLEVBQUU7d0JBQzNDLElBQUksQ0FBQyxjQUFjLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO3FCQUMxRDt5QkFBTTt3QkFDTCxxQkFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyx1QkFBdUIsQ0FBQyxJQUFJLENBQUMsV0FBVyxDQUFDLENBQUM7d0JBQzdFLElBQUksQ0FBQyxlQUFlLEdBQUcsSUFBSSxDQUFDLGNBQWMsQ0FBQyxlQUFlLENBQUMsWUFBWSxDQUFDLENBQUM7d0JBRXpFLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7cUJBQ3hDO2lCQUNGO2dCQUFDLE9BQU8sS0FBSyxFQUFFO29CQUNkLE9BQU8sQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLEtBQUssQ0FBQyxDQUFDO2lCQUN0QzthQUNGOzs7O1FBRUQsb0RBQWtCOzs7WUFBbEI7Z0JBQ0UsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsRUFBRSxDQUFDO2FBQ3pDOzs7OztRQUVPLG9EQUFrQjs7OztzQkFBQyxRQUF5Qjs7Z0JBQ2xELE9BQU8sUUFBUTtxQkFDWixTQUFTLENBQUMsVUFBQSxLQUFLLElBQUksT0FBQSxLQUFJLENBQUMsaUJBQWlCLENBQUMsS0FBSyxDQUFDLEdBQUEsQ0FBQyxDQUFDOzs7Ozs7UUFHL0MsbURBQWlCOzs7O3NCQUFDLEtBQW1CO2dCQUMzQyxRQUFRLEtBQUssQ0FBQyxNQUFNO29CQUNsQixNQUFNLGNBQWMsQ0FBQyxLQUFLO3dCQUN4QixJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO3dCQUNwQixNQUFNO29CQUVSLE1BQU0sY0FBYyxDQUFDLElBQUk7d0JBQ3ZCLElBQUksQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLENBQUM7d0JBQ25CLE1BQU07b0JBRVIsTUFBTSxjQUFjLENBQUMsTUFBTTt3QkFDekIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQzt3QkFDckIsTUFBTTtvQkFFUixNQUFNLGNBQWMsQ0FBQyxLQUFLO3dCQUN4QixJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7d0JBQ2YsTUFBTTtvQkFFUixNQUFNLGNBQWMsQ0FBQyxXQUFXO3dCQUM5QixJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO3dCQUNuQixJQUFJLENBQUMsYUFBYSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsQ0FBQzt3QkFDL0IsTUFBTTtpQkFDVDs7Ozs7O1FBR0sseUNBQU87Ozs7c0JBQUMsRUFBK0I7O29CQUE3QixjQUFJLEVBQUUsb0JBQU87Z0JBQzdCLElBQUksSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLEVBQUU7b0JBQ3RCLHFCQUFNLEtBQUssR0FBRyxJQUFJLENBQUMsVUFBVSxJQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsVUFBVSxJQUFJLENBQUMsQ0FBQztvQkFFL0QsSUFBSSxLQUFLLEVBQUU7d0JBQ1QsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksS0FBSyxJQUFJLEVBQUU7NEJBQ3BDLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxHQUFHLFVBQVUsQ0FBQztnQ0FDbkMsS0FBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsQ0FBQzs2QkFDekIsRUFBRSxLQUFLLENBQUMsQ0FBQzt5QkFDWDt3QkFDRCxJQUFJLENBQUMsS0FBSyxDQUFDLFVBQVUsRUFBRSxDQUFDO3FCQUN6Qjt5QkFBTTt3QkFDTCxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDO3FCQUN6QjtvQkFFRCxJQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQztpQkFDakM7Ozs7OztRQUdLLHdDQUFNOzs7O3NCQUFDLEVBQThCOztvQkFBNUIsY0FBSSxFQUFFLGtCQUFNO2dCQUMzQixJQUFJLElBQUksS0FBSyxJQUFJLENBQUMsSUFBSSxFQUFFO29CQUN0QixJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxHQUFHLENBQUMsRUFBRTt3QkFDN0IsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsQ0FBQztxQkFDekI7eUJBQU07d0JBQ0wsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUU7NEJBQ2hCLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQzt5QkFDbkI7NkJBQU07NEJBQ0wscUJBQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLElBQUksQ0FBQyxDQUFDOzRCQUM3RCxJQUFJLEtBQUssRUFBRTtnQ0FDVCxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxLQUFLLElBQUksRUFBRTtvQ0FDbkMsSUFBSSxDQUFDLEtBQUssQ0FBQyxXQUFXLEdBQUcsVUFBVSxDQUFDO3dDQUNsQyxLQUFJLENBQUMsU0FBUyxFQUFFLENBQUM7cUNBQ2xCLEVBQUUsS0FBSyxDQUFDLENBQUM7aUNBQ1g7NkJBQ0Y7aUNBQU07Z0NBQ0wsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDOzZCQUNsQjt5QkFDRjtxQkFDRjtvQkFFRCxJQUFJLENBQUMsd0JBQXdCLEVBQUUsQ0FBQztpQkFDakM7Ozs7O1FBR0sseUNBQU87Ozs7Z0JBQ2IsSUFBSSxDQUFDLFNBQVMsRUFBRSxDQUFDOzs7Ozs7UUFHWCwwQ0FBUTs7OztzQkFBQyxFQUErQjtvQkFBN0IsY0FBSSxFQUFFLG9CQUFPO2dCQUM5QixJQUFJLElBQUksS0FBSyxJQUFJLENBQUMsSUFBSSxFQUFFO29CQUN0QixJQUFJLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQztvQkFDbkIsSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLElBQUksSUFBSSxDQUFDLGNBQWMsSUFBSSxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQztvQkFDdkUsSUFBSSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztvQkFDdkMsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsRUFBRSxDQUFDO2lCQUN6Qzs7Ozs7O1FBR0ssMkNBQVM7Ozs7c0JBQUMsT0FBWTtnQkFDNUIsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUM7Z0JBQ25CLElBQUksQ0FBQyxPQUFPLEdBQUcsT0FBTyxJQUFJLElBQUksQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUM7Z0JBQ3ZFLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBQ3ZDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxhQUFhLEVBQUUsQ0FBQzs7Ozs7UUFHbEMsMkNBQVM7Ozs7Z0JBQ2YsSUFBSSxDQUFDLFVBQVUsRUFBRSxDQUFDO2dCQUNsQixJQUFJLENBQUMsTUFBTSxHQUFHLEtBQUssQ0FBQztnQkFDcEIsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGFBQWEsRUFBRSxDQUFDOzs7OztRQUdsQyw0Q0FBVTs7OztnQkFDaEIsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLElBQUksSUFBSSxJQUFJLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxDQUFDO2dCQUN6RSxJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsSUFBSSxJQUFJLElBQUksWUFBWSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsV0FBVyxDQUFDLENBQUM7Z0JBQ3ZFLElBQUksQ0FBQyxLQUFLLENBQUMsVUFBVSxHQUFHLENBQUMsQ0FBQztnQkFDMUIsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDO2dCQUMvQixJQUFJLENBQUMsS0FBSyxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUM7Z0JBQzlCLElBQUksQ0FBQyx3QkFBd0IsRUFBRSxDQUFDOzs7Ozs7UUFHMUIscURBQW1COzs7O3NCQUFDLEdBQVE7Z0JBQ2xDLElBQUksSUFBSSxDQUFDLGVBQWUsSUFBSSxJQUFJLENBQUMsZUFBZSxZQUFZQyxpQkFBWSxFQUFFO29CQUN4RSxJQUFJLENBQUMsZUFBZSxDQUFDLFFBQVEsQ0FBQyxPQUFPLEdBQUcsR0FBRyxDQUFDO2lCQUM3Qzs7Ozs7O1FBR0ssK0NBQWE7Ozs7c0JBQUMsSUFBWTtnQkFDaEMsSUFBSSxJQUFJLENBQUMsbUJBQW1CLElBQUksSUFBSSxLQUFLLElBQUksQ0FBQyxJQUFJLEVBQUU7b0JBQ2xELElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxXQUFXLEVBQUUsQ0FBQztpQkFDeEM7Ozs7O1FBR0ssMERBQXdCOzs7O2dCQUM5QixJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFO29CQUM1QyxJQUFJLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUM7aUJBQzdFOzs7OztRQUdILDZDQUFXOzs7WUFBWDtnQkFDRSxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQzthQUMvQjs7b0JBM0xGSixjQUFTLFNBQUM7d0JBQ1QsUUFBUSxFQUFFLGtCQUFrQjt3QkFDNUIsUUFBUSxFQUFFLFFBQVE7d0JBQ2xCLE1BQU0sRUFBRSxDQUFDLE1BQU0sQ0FBQzs7d0JBQ2hCLGFBQWEsRUFBRUMsc0JBQWlCLENBQUMsSUFBSTtxQkFDdEM7Ozs7O3dCQWJRLHNCQUFzQjt3QkFON0JJLDZCQUF3Qjt3QkFFeEJDLHNCQUFpQjs7OzsyQkFtQmhCSixVQUFLO2lDQUNMQSxVQUFLO2dDQUNMQSxVQUFLO3FDQUNMQSxVQUFLLFNBQUMsU0FBUztrQ0FDZkEsVUFBSyxTQUFDLFVBQVU7cUNBQ2hCSyxjQUFTLFNBQUMsZ0JBQWdCLEVBQUUsRUFBRSxJQUFJLEVBQUVDLHFCQUFnQixFQUFFOztzQ0FyQ3pEOzs7Ozs7O0FDQUE7UUFTRSx3QkFDVTtZQUFBLG9CQUFlLEdBQWYsZUFBZTtTQUNyQjs7Ozs7Ozs7OztRQUtKLDhCQUFLOzs7Ozs7WUFBTCxVQUFNLE1BQXlCLEVBQUUsT0FBYTtnQkFDNUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUUsY0FBYyxDQUFDLEtBQUssRUFBRSxPQUFPLENBQUMsQ0FBQzthQUN0RDs7Ozs7Ozs7O1FBS0QsNkJBQUk7Ozs7O1lBQUosVUFBSyxNQUF5QjtnQkFDNUIsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLEVBQUUsY0FBYyxDQUFDLElBQUksQ0FBQyxDQUFDO2FBQzVDOzs7Ozs7Ozs7UUFLRCxvQ0FBVzs7Ozs7WUFBWCxVQUFZLE1BQXlCO2dCQUNuQyxJQUFJLENBQUMsUUFBUSxDQUFDLE1BQU0sRUFBRSxjQUFjLENBQUMsV0FBVyxDQUFDLENBQUM7YUFDbkQ7Ozs7Ozs7OztRQUtELGlDQUFROzs7OztZQUFSLFVBQVMsTUFBZ0M7Z0JBQWhDLHVCQUFBO29CQUFBLGFBQWdDOztnQkFDdkMscUJBQU0sT0FBTyxHQUFHLE1BQU0sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxHQUFHLElBQUksQ0FBQztnQkFDckQscUJBQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxlQUFlLENBQUMsZ0JBQWdCLENBQUM7Z0JBRXhELE9BQU8sTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FBQyxJQUFJLENBQUMsVUFBQyxHQUFXO29CQUM3QyxJQUFJLENBQUMsT0FBTyxFQUFFO3dCQUNaLE9BQU8sU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLFFBQVEsQ0FBQztxQkFDaEM7b0JBRUQsT0FBTyxPQUFPLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDLFFBQVEsQ0FBQztpQkFDN0UsQ0FBQyxDQUFDO2FBQ0o7Ozs7Ozs7UUFFTyxpQ0FBUTs7Ozs7O3NCQUFDLE1BQThCLEVBQUUsSUFBWSxFQUFFLE9BQWE7O2dCQUEzRCx1QkFBQTtvQkFBQSxXQUE4Qjs7Z0JBQzdDLHFCQUFNLFNBQVMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDO2dCQUN2QyxTQUFTLENBQUMsT0FBTyxDQUFDLFVBQUEsQ0FBQyxJQUFJLE9BQUEsS0FBSSxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUFDLEdBQUEsQ0FBQyxDQUFDOzs7Ozs7UUFHbEUsZ0NBQU87Ozs7c0JBQUMsTUFBOEI7Z0JBQTlCLHVCQUFBO29CQUFBLFdBQThCOztnQkFDNUMsT0FBTyxPQUFPLE1BQU0sS0FBSyxRQUFRLEdBQUcsQ0FBQyxNQUFNLENBQUMsR0FBRyxNQUFNLENBQUM7OztvQkFsRHpEVCxlQUFVOzs7Ozt3QkFIRixzQkFBc0I7Ozs2QkFIL0I7Ozs7Ozs7QUNBQTtRQXNDRSwwQkFDVSxnQkFDQSxTQUNBLGFBQ0EsVUFDQTtZQUpBLG1CQUFjLEdBQWQsY0FBYztZQUNkLFlBQU8sR0FBUCxPQUFPO1lBQ1AsZ0JBQVcsR0FBWCxXQUFXO1lBQ1gsYUFBUSxHQUFSLFFBQVE7WUFDUiw2QkFBd0IsR0FBeEIsd0JBQXdCO1NBQzdCO1FBckJMLHNCQUNJLHFDQUFPOzs7O2dCQURYLFVBQ1ksSUFBUyxJQUFJLElBQUksQ0FBQyxXQUFXLEdBQUcsSUFBSSxDQUFDLEVBQUU7OztXQUFBO1FBQ25ELHNCQUNJLDRDQUFjOzs7O2dCQURsQixVQUNtQixPQUFZLElBQUksSUFBSSxDQUFDLE9BQU8sR0FBRyxPQUFPLENBQUMsRUFBRTs7O1dBQUE7UUFDNUQsc0JBQ0ksNkNBQWU7Ozs7Z0JBRG5CLFVBQ29CLFFBQWEsSUFBSSxJQUFJLENBQUMsUUFBUSxHQUFHLFFBQVEsQ0FBQyxFQUFFOzs7V0FBQTtRQUNoRSxzQkFDSSwrQ0FBaUI7Ozs7Z0JBRHJCLFVBQ3NCLFVBQWU7Z0JBQ2xDLElBQUksQ0FBQyxVQUFVLEdBQUcsVUFBVSxHQUFHLE1BQU0sQ0FBQyxVQUFVLENBQUMsR0FBRyxJQUFJLENBQUM7YUFDM0Q7OztXQUFBO1FBQ0Qsc0JBQ0ksOENBQWdCOzs7O2dCQURwQixVQUNxQixTQUFjO2dCQUNqQyxJQUFJLENBQUMsU0FBUyxHQUFHLFNBQVMsR0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDLEdBQUcsSUFBSSxDQUFDO2FBQ3ZEOzs7V0FBQTs7OztRQVVELG1DQUFROzs7WUFBUjtnQkFDRSxJQUFJO29CQUNGLElBQUksQ0FBQyxPQUFPLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO29CQUNsRCxxQkFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FBQztvQkFFckUsSUFBSSxhQUFhLElBQUksQ0FBQyxJQUFJLENBQUMscUJBQXFCLENBQUMsYUFBYSxDQUFDLEVBQUU7d0JBQy9ELElBQUksQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLGFBQWEsRUFBRSxtQkFBbUIsQ0FBQyxDQUFDO3dCQUUzRCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsSUFBSSxDQUFDLGVBQWUsRUFBRSxDQUFDO3dCQUVsRCxxQkFBSSxjQUFjLEdBQUcsSUFBSSxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxhQUFhLENBQUMsQ0FBQzt3QkFFOUUsSUFBSSxjQUFjLEVBQUU7NEJBQ2xCLHFCQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsY0FBYyxDQUFDLFdBQVcsRUFBRSxDQUFDOzRCQUVuRCxhQUFhLENBQUMsV0FBVyxDQUFDLGNBQWMsQ0FBQyxDQUFDOzRCQUMxQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxDQUFDLFNBQVMsR0FBRywyQkFBMkIsQ0FBQzs0QkFDMUUsSUFBSSxDQUFDLG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxJQUFJLEdBQUcsSUFBSSxDQUFDLFdBQVcsSUFBSSxrQkFBa0IsQ0FBQzs0QkFDaEYsSUFBSSxJQUFJLENBQUMsT0FBTztnQ0FBRSxJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxDQUFDLGNBQWMsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDOzRCQUNsRixJQUFJLElBQUksQ0FBQyxVQUFVO2dDQUFFLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLENBQUMsVUFBVSxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUM7NEJBQ3BGLElBQUksSUFBSSxDQUFDLFNBQVM7Z0NBQUUsSUFBSSxDQUFDLG1CQUFtQixDQUFDLFFBQVEsQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQzs0QkFDakYsSUFBSSxJQUFJLENBQUMsUUFBUSxJQUFJLFFBQVEsQ0FBQyxRQUFRO2dDQUNwQyxJQUFJLENBQUMsbUJBQW1CLENBQUMsUUFBUSxDQUFDLFdBQVcsR0FBRyxJQUFJLENBQUMsUUFBUSxJQUFJLFFBQVEsQ0FBQyxRQUFRLENBQUM7eUJBQ3RGO3FCQUNGO2lCQUNGO2dCQUFDLE9BQU8sS0FBSyxFQUFFO29CQUNkLE9BQU8sQ0FBQyxLQUFLLENBQUMsY0FBYyxFQUFFLEtBQUssQ0FBQyxDQUFDO2lCQUN0QzthQUNGOzs7OztRQUVPLGdEQUFxQjs7OztzQkFBQyxPQUFZO2dCQUNsQyxJQUFBLG1DQUFRLENBQW1CO2dCQUNqQyxRQUFRLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztnQkFDMUMsT0FBTyxRQUFRLENBQUMsSUFBSSxDQUFDLFVBQUMsRUFBTyxJQUFLLE9BQUEsRUFBRSxDQUFDLFNBQVMsS0FBSyxVQUFVLEdBQUEsQ0FBQyxDQUFDOzs7Ozs7UUFJekQsMENBQWU7Ozs7c0JBQUMsT0FBWTtnQkFDMUIsSUFBQSxpQ0FBVyxDQUFhO2dCQUNoQyxPQUFPLENBQUMsV0FBVyxFQUFFLFdBQVcsQ0FBQyxXQUFXLENBQUMsQ0FBQyxJQUFJLENBQUMsVUFBQyxDQUFDLElBQUssT0FBQSxDQUFDLENBQUMsU0FBUyxLQUFLLGtCQUFrQixHQUFBLENBQUMsQ0FBQzs7Ozs7UUFHeEYsMENBQWU7Ozs7Z0JBQ3JCLHFCQUFNLHdCQUF3QixHQUFHLElBQUksQ0FBQyx3QkFBd0IsQ0FBQyx1QkFBdUIsQ0FBQyx1QkFBdUIsQ0FBQyxDQUFDO2dCQUNoSCxPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLHdCQUF3QixDQUFDLENBQUM7OztvQkE1RWpFVSxjQUFTLFNBQUMsRUFBRSxRQUFRLEVBQUUsV0FBVyxFQUFFOzs7Ozt3QkFIM0Isc0JBQXNCO3dCQUw3QkQscUJBQWdCO3dCQUNoQkwsZ0JBQVc7d0JBQ1hPLGNBQVM7d0JBSFRMLDZCQUF3Qjs7Ozs4QkFrQnZCSCxVQUFLO3FDQUVMQSxVQUFLO3NDQUVMQSxVQUFLO3dDQUVMQSxVQUFLO3VDQUlMQSxVQUFLOzsrQkFqQ1I7Ozs7Ozs7QUNBQSxJQVVPLHFCQUFNLHNCQUFzQixHQUFHLElBQUksc0JBQXNCLEVBQUUsQ0FBQzs7QUFHbkUseUJBQWEscUJBQXFCLEdBQUcsSUFBSVMsbUJBQWMsQ0FBUyx1QkFBdUIsQ0FBQyxDQUFDOzs7OztBQUV6Riw2QkFBZ0MsUUFBeUI7UUFDdkQsc0JBQXNCLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ2hELE9BQU8sc0JBQXNCLENBQUM7S0FDL0I7Ozs7Ozs7O1FBc0JlLHFCQUFPOzs7O3NCQUFDLFFBQThCO2dCQUE5Qix5QkFBQTtvQkFBQSxhQUE4Qjs7Z0JBQ2xELE9BQU87b0JBQ0wsUUFBUSxFQUFFLGFBQWE7b0JBQ3ZCLFNBQVMsRUFBRTt3QkFDVDs0QkFDRSxPQUFPLEVBQUUscUJBQXFCOzRCQUM5QixRQUFRLEVBQUUsUUFBUTt5QkFDbkI7d0JBQ0Q7NEJBQ0UsT0FBTyxFQUFFLHNCQUFzQjs0QkFDL0IsVUFBVSxFQUFFLGVBQWU7NEJBQzNCLElBQUksRUFBRSxDQUFDLHFCQUFxQixDQUFDO3lCQUM5Qjt3QkFDRCxjQUFjO3FCQUNmO2lCQUNGLENBQUM7OztvQkFuQ0xDLGFBQVEsU0FBQzt3QkFDUixPQUFPLEVBQUU7NEJBQ1BDLG1CQUFZO3lCQUNiO3dCQUNELGVBQWUsRUFBRTs0QkFDZixnQkFBZ0I7NEJBQ2hCLHVCQUF1Qjt5QkFDeEI7d0JBQ0QsWUFBWSxFQUFFOzRCQUNaLGdCQUFnQjs0QkFDaEIsZ0JBQWdCOzRCQUNoQix1QkFBdUI7eUJBQ3hCO3dCQUNELE9BQU8sRUFBRTs0QkFDUCxnQkFBZ0I7NEJBQ2hCLGdCQUFnQjs0QkFDaEIsdUJBQXVCO3lCQUN4QjtxQkFDRjs7NEJBdENEOzs7Ozs7O0FDQUE7Ozs7QUFHQSxxQkFBd0IsS0FBYztRQUNwQyxPQUFPLFVBQVUsTUFBWSxFQUFFLFdBQW9CLEVBQUUsVUFBZ0I7WUFDbkUsTUFBTSxDQUFDLFdBQVcsQ0FBQyxHQUFHLHNCQUFzQixDQUFDLFFBQVEsQ0FBQyxLQUFLLENBQUMsQ0FBQztTQUM5RCxDQUFDO0tBQ0g7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OzsifQ==