/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/src/types", ["require", "exports", "@angular/compiler-cli/src/language_services"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var language_services_1 = require("@angular/compiler-cli/src/language_services");
    exports.BuiltinType = language_services_1.BuiltinType;
    /**
     * The kind of diagnostic message.
     *
     * @publicApi
     */
    var DiagnosticKind;
    (function (DiagnosticKind) {
        DiagnosticKind[DiagnosticKind["Error"] = 0] = "Error";
        DiagnosticKind[DiagnosticKind["Warning"] = 1] = "Warning";
    })(DiagnosticKind = exports.DiagnosticKind || (exports.DiagnosticKind = {}));
});
//# sourceMappingURL=data:application/json;base64,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