"use strict";
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
class LinkedList {
    constructor(_head) {
        this._head = _head;
    }
    get(l) {
        let c = this._head;
        while (c && l > 0) {
            l--;
            c = c.next;
        }
        return c;
    }
    get head() { return this._head; }
    get length() {
        let c = this._head;
        let i = 0;
        while (c) {
            i++;
            c = c.next;
        }
        return i;
    }
    reduce(accumulator, seed) {
        let c = this._head;
        let acc = seed;
        let i = 0;
        while (c) {
            acc = accumulator(acc, c, i);
            i++;
            c = c.next;
        }
        return acc;
    }
    find(predicate) {
        let c = this._head;
        let i = 0;
        while (c) {
            if (predicate(c, i)) {
                break;
            }
            i++;
            c = c.next;
        }
        return c;
    }
    forEach(visitor) {
        let c = this._head;
        let i = 0;
        while (c) {
            visitor(c, i);
            i++;
            c = c.next;
        }
    }
}
exports.LinkedList = LinkedList;
//# sourceMappingURL=data:application/json;base64,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