/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.turbine.options.AutoValue_TurbineOptions;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class TurbineOptions {
    public abstract ImmutableList<String> sources();

    public abstract ImmutableList<String> classPath();

    public abstract ImmutableSet<String> bootClassPath();

    public abstract Optional<String> release();

    public abstract Optional<String> system();

    public abstract Optional<String> output();

    @Deprecated
    public @Nullable String outputFile() {
        return this.output().orElse(null);
    }

    public abstract ImmutableList<String> processorPath();

    public abstract ImmutableSet<String> processors();

    public abstract ImmutableSet<String> builtinProcessors();

    public abstract ImmutableList<String> sourceJars();

    public abstract Optional<String> outputDeps();

    public abstract ImmutableSet<String> directJars();

    public abstract Optional<String> targetLabel();

    public abstract Optional<String> injectingRuleKind();

    public abstract ImmutableList<String> depsArtifacts();

    public abstract boolean help();

    public abstract ImmutableList<String> javacOpts();

    public abstract ReducedClasspathMode reducedClasspathMode();

    public abstract Optional<String> profile();

    public abstract Optional<String> gensrcOutput();

    public abstract Optional<String> resourceOutput();

    public abstract int fullClasspathLength();

    public abstract int reducedClasspathLength();

    public static Builder builder() {
        return new AutoValue_TurbineOptions.Builder().setSources((ImmutableList<String>)ImmutableList.of()).setClassPath((ImmutableList<String>)ImmutableList.of()).setBootClassPath((ImmutableList<String>)ImmutableList.of()).setProcessorPath((ImmutableList<String>)ImmutableList.of()).setProcessors((ImmutableList<String>)ImmutableList.of()).setBuiltinProcessors((ImmutableList<String>)ImmutableList.of()).setSourceJars((ImmutableList<String>)ImmutableList.of()).setDirectJars((ImmutableList<String>)ImmutableList.of()).setDepsArtifacts((ImmutableList<String>)ImmutableList.of()).addAllJavacOpts((Iterable<String>)ImmutableList.of()).setReducedClasspathMode(ReducedClasspathMode.NONE).setHelp(false).setFullClasspathLength(0).setReducedClasspathLength(0);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setOutput(String var1);

        @Deprecated
        public Builder addClassPathEntries(Iterable<String> sources) {
            return this.setClassPath((ImmutableList<String>)ImmutableList.copyOf(sources));
        }

        public abstract Builder setClassPath(ImmutableList<String> var1);

        public abstract Builder setBootClassPath(ImmutableList<String> var1);

        @Deprecated
        public Builder addBootClassPathEntries(Iterable<String> sources) {
            return this.setBootClassPath((ImmutableList<String>)ImmutableList.copyOf(sources));
        }

        public abstract Builder setRelease(String var1);

        public abstract Builder setSystem(String var1);

        public abstract Builder setSources(ImmutableList<String> var1);

        @Deprecated
        public Builder addSources(Iterable<String> sources) {
            return this.setSources((ImmutableList<String>)ImmutableList.copyOf(sources));
        }

        @Deprecated
        public Builder addProcessorPathEntries(Iterable<String> processorPath) {
            return this.setProcessorPath((ImmutableList<String>)ImmutableList.copyOf(processorPath));
        }

        public abstract Builder setProcessorPath(ImmutableList<String> var1);

        @Deprecated
        public Builder addProcessors(Iterable<String> processors) {
            return this.setProcessors((ImmutableList<String>)ImmutableList.copyOf(processors));
        }

        public abstract Builder setProcessors(ImmutableList<String> var1);

        @Deprecated
        public Builder addBuiltinProcessors(Iterable<String> builtinProcessors) {
            return this.setBuiltinProcessors((ImmutableList<String>)ImmutableList.copyOf(builtinProcessors));
        }

        public abstract Builder setBuiltinProcessors(ImmutableList<String> var1);

        public abstract Builder setSourceJars(ImmutableList<String> var1);

        public abstract Builder setOutputDeps(String var1);

        public abstract Builder setTargetLabel(String var1);

        public abstract Builder setInjectingRuleKind(String var1);

        @Deprecated
        public Builder addAllDepsArtifacts(Iterable<String> depsArtifacts) {
            return this.setDepsArtifacts((ImmutableList<String>)ImmutableList.copyOf(depsArtifacts));
        }

        public abstract Builder setDepsArtifacts(ImmutableList<String> var1);

        public abstract Builder setHelp(boolean var1);

        abstract ImmutableList.Builder<String> javacOptsBuilder();

        public Builder addAllJavacOpts(Iterable<String> javacOpts) {
            this.javacOptsBuilder().addAll(javacOpts);
            return this;
        }

        public abstract Builder setReducedClasspathMode(ReducedClasspathMode var1);

        @Deprecated
        public Builder addDirectJars(Iterable<String> directJars) {
            return this.setDirectJars((ImmutableList<String>)ImmutableList.copyOf(directJars));
        }

        public abstract Builder setDirectJars(ImmutableList<String> var1);

        public abstract Builder setProfile(String var1);

        public abstract Builder setGensrcOutput(String var1);

        public abstract Builder setResourceOutput(String var1);

        public abstract Builder setFullClasspathLength(int var1);

        public abstract Builder setReducedClasspathLength(int var1);

        public abstract TurbineOptions build();
    }

    public static enum ReducedClasspathMode {
        BAZEL_REDUCED,
        BAZEL_FALLBACK,
        JAVABUILDER_REDUCED,
        NONE;

    }
}

