/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;

public class MultiMemberVisitor
implements MemberVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private MemberVisitor[] memberVisitors;
    private int memberVisitorCount;

    public MultiMemberVisitor() {
    }

    public MultiMemberVisitor(MemberVisitor[] memberVisitorArray) {
        this.memberVisitors = memberVisitorArray;
        this.memberVisitorCount = memberVisitorArray.length;
    }

    public void addMemberVisitor(MemberVisitor memberVisitor) {
        this.ensureArraySize();
        this.memberVisitors[this.memberVisitorCount++] = memberVisitor;
    }

    private void ensureArraySize() {
        if (this.memberVisitors == null) {
            this.memberVisitors = new MemberVisitor[5];
        } else if (this.memberVisitors.length == this.memberVisitorCount) {
            MemberVisitor[] memberVisitorArray = new MemberVisitor[this.memberVisitorCount + 5];
            System.arraycopy(this.memberVisitors, 0, memberVisitorArray, 0, this.memberVisitorCount);
            this.memberVisitors = memberVisitorArray;
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitProgramField(programClass, programField);
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitLibraryField(libraryClass, libraryField);
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        for (int i = 0; i < this.memberVisitorCount; ++i) {
            this.memberVisitors[i].visitLibraryMethod(libraryClass, libraryMethod);
        }
    }
}

