/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _taggedTemplateLiteral2 = _interopRequireDefault(require("./taggedTemplateLiteral"));

var _inheritsLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/inheritsLoose"));

function _templateObject4() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n    fragment RelayModernFlowtest_users on User @relay(plural: true) {\n      name\n    }\n  "]);

  _templateObject4 = function _templateObject4() {
    return data;
  };

  return data;
}

function _templateObject3() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n    fragment RelayModernFlowtest_user on User {\n      name\n    }\n  "]);

  _templateObject3 = function _templateObject3() {
    return data;
  };

  return data;
}

function _templateObject2() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n    fragment RelayModernFlowtest_badref on User {\n      id\n      # Note: this test includes a reference, but *not the right one*.\n      ...RelayModernFlowtest_user\n    }\n  "]);

  _templateObject2 = function _templateObject2() {
    return data;
  };

  return data;
}

function _templateObject() {
  var data = (0, _taggedTemplateLiteral2["default"])(["\n    fragment RelayModernFlowtest_notref on User {\n      id\n      ...RelayModernFlowtest_user\n    }\n  "]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

var React = require("react");

var nullthrows = require("nullthrows");

var _require = require("./ReactRelayPublic"),
    createFragmentContainer = _require.createFragmentContainer,
    graphql = _require.graphql;

var NotReferencedTest_ =
/*#__PURE__*/
function (_React$Component) {
  (0, _inheritsLoose2["default"])(NotReferencedTest_, _React$Component);

  function NotReferencedTest_() {
    return _React$Component.apply(this, arguments) || this;
  }

  var _proto = NotReferencedTest_.prototype;

  _proto.render = function render() {
    return null;
  };

  return NotReferencedTest_;
}(React.Component);

var NotReferencedTest = createFragmentContainer(NotReferencedTest_, {
  notref: graphql(_templateObject())
});

var BadReferenceTest_ =
/*#__PURE__*/
function (_React$Component2) {
  (0, _inheritsLoose2["default"])(BadReferenceTest_, _React$Component2);

  function BadReferenceTest_() {
    return _React$Component2.apply(this, arguments) || this;
  }

  var _proto2 = BadReferenceTest_.prototype;

  _proto2.render = function render() {
    this.props.badref.id; // $FlowExpectedError

    this.props.badref.name; // $FlowExpectedError The notref fragment was not used.

    return React.createElement(NotReferencedTest, {
      notref: this.props.badref
    });
  };

  return BadReferenceTest_;
}(React.Component);

var BadReferenceTest = createFragmentContainer(BadReferenceTest_, {
  badref: graphql(_templateObject2())
});
React.createElement(BadReferenceTest, {
  badref: someRef
});

var SingularTest =
/*#__PURE__*/
function (_React$Component3) {
  (0, _inheritsLoose2["default"])(SingularTest, _React$Component3);

  function SingularTest() {
    return _React$Component3.apply(this, arguments) || this;
  }

  var _proto3 = SingularTest.prototype;

  _proto3.render = function render() {
    nullthrows(this.props.user.name); // $FlowExpectedError

    this.props.nullableUser.name; // $FlowExpectedError

    this.props.optionalUser.name;
    nullthrows(nullthrows(this.props.nullableUser).name);
    nullthrows(nullthrows(this.props.optionalUser).name);
    return null;
  };

  return SingularTest;
}(React.Component);

SingularTest = createFragmentContainer(SingularTest, {
  user: graphql(_templateObject3())
});

var PluralTest =
/*#__PURE__*/
function (_React$Component4) {
  (0, _inheritsLoose2["default"])(PluralTest, _React$Component4);

  function PluralTest() {
    return _React$Component4.apply(this, arguments) || this;
  }

  var _proto4 = PluralTest.prototype;

  _proto4.render = function render() {
    var names = this.props.users.map(function (user) {
      return user.name;
    }).filter(Boolean);
    names; // $FlowExpectedError

    names;
    return null;
  };

  return PluralTest;
}(React.Component);

PluralTest = createFragmentContainer(PluralTest, {
  users: graphql(_templateObject4())
});

function cb() {} // $FlowExpectedError - can't pass null for user


React.createElement(SingularTest, {
  onClick: cb,
  string: "x",
  user: null,
  nullableUser: null
}); // $FlowExpectedError - user is required

React.createElement(SingularTest, {
  onClick: cb,
  string: "x",
  nullableUser: null
}); // $FlowExpectedError - can't pass non-user ref for user

React.createElement(SingularTest, {
  onClick: cb,
  string: "x",
  user: nonUserRef,
  nullableUser: null
}); // $FlowExpectedError - `cb` prop is not a function

React.createElement(SingularTest, {
  onClick: "cb",
  string: "x",
  user: aUserRef,
  nullableUser: null
}); // $FlowExpectedError - `string` prop is not a string

React.createElement(SingularTest, {
  onClick: cb,
  string: 1,
  user: aUserRef,
  nullableUser: null
});
React.createElement(SingularTest, {
  onClick: cb,
  string: "x",
  user: aUserRef,
  nullableUser: null
});
React.createElement(SingularTest, {
  onClick: cb,
  string: "x",
  user: aUserRef,
  nullableUser: aUserRef
});
React.createElement(SingularTest, {
  onClick: cb,
  string: "x",
  user: aUserRef,
  nullableUser: null,
  optionalUser: aUserRef
}); // $FlowExpectedError - optional, not nullable!

React.createElement(SingularTest, {
  string: "x",
  user: aUserRef,
  nullableUser: null,
  optionalUser: null
});
React.createElement(SingularTest, {
  string: "x",
  onClick: cb,
  user: aComplexUserRef,
  nullableUser: aComplexUserRef,
  optionalUser: aComplexUserRef
}); // $FlowExpectedError - can't pass null for user

React.createElement(PluralTest, {
  users: null,
  nullableUsers: null
}); // $FlowExpectedError - users is required

React.createElement(PluralTest, {
  nullableUsers: null
}); // $FlowExpectedError - can't pass non-user refs for user

React.createElement(PluralTest, {
  users: [nonUserRef],
  nullableUsers: null
});
React.createElement(PluralTest, {
  users: usersRef,
  nullableUsers: null
});
React.createElement(PluralTest, {
  users: [oneOfUsersRef],
  nullableUsers: null
});
React.createElement(PluralTest, {
  users: [oneOfUsersRef],
  nullableUsers: null
});
React.createElement(PluralTest, {
  users: usersRef,
  nullableUsers: [oneOfUsersRef]
});
React.createElement(PluralTest, {
  users: usersRef,
  nullableUsers: null,
  optionalUsers: usersRef
}); // $FlowExpectedError - optional, not nullable!

React.createElement(PluralTest, {
  users: usersRef,
  nullableUsers: null,
  optionalUsers: null
});

var AnyTest =
/*#__PURE__*/
function (_React$Component5) {
  (0, _inheritsLoose2["default"])(AnyTest, _React$Component5);

  function AnyTest() {
    return _React$Component5.apply(this, arguments) || this;
  }

  return AnyTest;
}(React.Component);

AnyTest = createFragmentContainer(AnyTest, {});
React.createElement(AnyTest, {
  anything: 42,
  anyFunction: function anyFunction() {},
  maybeFunction: null,
  anyObject: {}
});
React.createElement(AnyTest, {
  anything: 42,
  anyFunction: function anyFunction() {},
  maybeFunction: function maybeFunction() {},
  anyObject: {}
}); // $FlowExpectedError - optional function cannot be null

React.createElement(AnyTest, {
  anything: 42,
  anyFunction: function anyFunction() {},
  optionalFunction: function optionalFunction() {},
  anyObject: {}
}); // $FlowExpectedError - can't pass {} for a Function

React.createElement(AnyTest, {
  anything: 42,
  anyFunction: {},
  maybeFunction: function maybeFunction() {},
  anyObject: {}
});