/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;

public abstract class VisibilityHandler {
    private Component component;
    private boolean wasVisible;
    private HierarchyListener listener;

    public abstract void shown();

    public abstract void hidden();

    public final void handle(Component component) {
        if (component == null) {
            throw new NullPointerException("component cannot be null");
        }
        if (this.listener != null && component != null) {
            component.removeHierarchyListener(this.listener);
        }
        this.component = component;
        this.wasVisible = component.isVisible();
        if (this.listener == null) {
            this.listener = this.createListener();
        }
        component.addHierarchyListener(this.listener);
    }

    private HierarchyListener createListener() {
        return new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                    boolean bl = VisibilityHandler.this.component.isShowing();
                    if (VisibilityHandler.this.wasVisible == bl) {
                        return;
                    }
                    VisibilityHandler.this.wasVisible = bl;
                    if (bl) {
                        VisibilityHandler.this.shown();
                    } else {
                        VisibilityHandler.this.hidden();
                    }
                }
            }
        };
    }
}

