/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterFunctions;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.NativeJavaPackage;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ImporterTopLevel
extends ScriptableObject {
    private ObjArray importedPackages = new ObjArray();

    public ImporterTopLevel() {
    }

    public ImporterTopLevel(Context cx) {
        this(cx, false);
    }

    public ImporterTopLevel(Context cx, boolean sealed) {
        this.initStandardObjects(cx, sealed);
    }

    public String getClassName() {
        return "global";
    }

    public void initStandardObjects(Context cx, boolean sealed) {
        cx.initStandardObjects(this, sealed);
        ImporterFunctions.setup(this);
    }

    public boolean has(String name, Scriptable start) {
        return super.has(name, start) || this.getPackageProperty(name, start) != NOT_FOUND;
    }

    public Object get(String name, Scriptable start) {
        Object result = super.get(name, start);
        if (result != NOT_FOUND) {
            return result;
        }
        result = this.getPackageProperty(name, start);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getPackageProperty(String name, Scriptable start) {
        Object[] elements;
        Object result = NOT_FOUND;
        ObjArray objArray = this.importedPackages;
        synchronized (objArray) {
            elements = this.importedPackages.toArray();
        }
        for (int i = 0; i < elements.length; ++i) {
            NativeJavaPackage p = (NativeJavaPackage)elements[i];
            Object v = p.getPkgProperty(name, start, false);
            if (v == null || v instanceof NativeJavaPackage) continue;
            if (result == NOT_FOUND) {
                result = v;
                continue;
            }
            throw Context.reportRuntimeError2("msg.ambig.import", result.toString(), v.toString());
        }
        return result;
    }

    void importClass(Context cx, Scriptable thisObj, Object[] args) {
        for (int i = 0; i < args.length; ++i) {
            Object cl = args[i];
            if (!(cl instanceof NativeJavaClass)) {
                throw Context.reportRuntimeError1("msg.not.class", Context.toString(cl));
            }
            String s = ((NativeJavaClass)cl).getClassObject().getName();
            String n = s.substring(s.lastIndexOf(46) + 1);
            Object val = thisObj.get(n, thisObj);
            if (val != NOT_FOUND && val != cl) {
                throw Context.reportRuntimeError1("msg.prop.defined", n);
            }
            thisObj.put(n, thisObj, cl);
        }
    }

    public void importPackage(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        this.importPackage(cx, thisObj, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importPackage(Context cx, Scriptable thisObj, Object[] args) {
        for (int i = 0; i != args.length; ++i) {
            Object pkg = args[i];
            if (!(pkg instanceof NativeJavaPackage)) {
                throw Context.reportRuntimeError1("msg.not.pkg", Context.toString(pkg));
            }
            ObjArray objArray = this.importedPackages;
            synchronized (objArray) {
                for (int j = 0; j != this.importedPackages.size(); ++j) {
                    if (pkg != this.importedPackages.get(j)) continue;
                    pkg = null;
                    break;
                }
                if (pkg != null) {
                    this.importedPackages.add(pkg);
                }
                continue;
            }
        }
    }
}

