/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.JavaAdapter;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.optimizer.Codegen;

public class ClassCompiler {
    private CompilerEnvirons compilerEnv;
    private Class targetExtends;
    private Class[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnv) {
        if (compilerEnv == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnv;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class extendsClass) {
        this.targetExtends = extendsClass;
    }

    public Class[] getTargetImplements() {
        return this.targetImplements;
    }

    public void setTargetImplements(Class[] implementsClasses) {
        this.targetImplements = implementsClasses;
    }

    protected String makeAuxiliaryClassName(String mainClassName, String auxMarker) {
        return mainClassName + auxMarker;
    }

    public Object[] compileToClassFiles(String source, String sourceLocation, int lineno, String mainClassName) {
        Parser p = new Parser(this.compilerEnv);
        ScriptOrFnNode tree = p.parse(source, sourceLocation, lineno);
        int syntaxErrorCount = this.compilerEnv.getSyntaxErrorCount();
        if (syntaxErrorCount == 0) {
            String encodedSource = p.getEncodedSource();
            Class superClass = this.getTargetExtends();
            Class[] interfaces = this.getTargetImplements();
            boolean isPrimary = interfaces == null && superClass == null;
            String scriptClassName = isPrimary ? mainClassName : this.makeAuxiliaryClassName(mainClassName, "1");
            Codegen codegen = new Codegen();
            byte[] scriptClassBytes = codegen.compileToClassFile(this.compilerEnv, scriptClassName, tree, encodedSource, false);
            syntaxErrorCount = this.compilerEnv.getSyntaxErrorCount();
            if (syntaxErrorCount == 0) {
                if (isPrimary) {
                    return new Object[]{scriptClassName, scriptClassBytes};
                }
                int functionCount = tree.getFunctionCount();
                ObjToIntMap functionNames = new ObjToIntMap(functionCount);
                for (int i = 0; i != functionCount; ++i) {
                    FunctionNode ofn = tree.getFunctionNode(i);
                    String name = ofn.getFunctionName();
                    if (name == null || name.length() == 0) continue;
                    functionNames.put(name, ofn.getParamCount());
                }
                if (superClass == null) {
                    superClass = ScriptRuntime.ObjectClass;
                }
                byte[] mainClassBytes = JavaAdapter.createAdapterCode(functionNames, mainClassName, superClass, interfaces, scriptClassName);
                return new Object[]{mainClassName, mainClassBytes, scriptClassName, scriptClassBytes};
            }
        }
        String msg = ScriptRuntime.getMessage1("msg.got.syntax.errors", String.valueOf(syntaxErrorCount));
        throw this.compilerEnv.getErrorReporter().runtimeError(msg, sourceLocation, lineno, null, 0);
    }
}

