/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.LiveDeployment;

import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.UserException;
import com.zeroc.IceBox.ServiceManagerPrx;
import com.zeroc.IceBox.ServiceObserver;
import com.zeroc.IceBox.ServiceObserverPrx;
import com.zeroc.IceGrid.AdapterDescriptor;
import com.zeroc.IceGrid.AdapterDynamicInfo;
import com.zeroc.IceGrid.AdminPrx;
import com.zeroc.IceGrid.AdminSessionPrx;
import com.zeroc.IceGrid.ApplicationDescriptor;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGrid.DeploymentException;
import com.zeroc.IceGrid.FileIteratorPrx;
import com.zeroc.IceGrid.FileNotAvailableException;
import com.zeroc.IceGrid.IceBoxDescriptor;
import com.zeroc.IceGrid.NodeUnreachableException;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServerDescriptor;
import com.zeroc.IceGrid.ServerInstanceDescriptor;
import com.zeroc.IceGrid.ServerNotExistException;
import com.zeroc.IceGrid.ServerState;
import com.zeroc.IceGrid.ServiceDescriptor;
import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.ApplicationPane;
import com.zeroc.IceGridGUI.LiveActions;
import com.zeroc.IceGridGUI.LiveDeployment.Adapter;
import com.zeroc.IceGridGUI.LiveDeployment.Communicator;
import com.zeroc.IceGridGUI.LiveDeployment.DbEnv;
import com.zeroc.IceGridGUI.LiveDeployment.Editor;
import com.zeroc.IceGridGUI.LiveDeployment.MetricsView;
import com.zeroc.IceGridGUI.LiveDeployment.Node;
import com.zeroc.IceGridGUI.LiveDeployment.ServerEditor;
import com.zeroc.IceGridGUI.LiveDeployment.Service;
import com.zeroc.IceGridGUI.LiveDeployment.ShowLogFileDialog;
import com.zeroc.IceGridGUI.LiveDeployment.TreeNode;
import com.zeroc.IceGridGUI.LiveDeployment.WriteMessageDialog;
import com.zeroc.IceGridGUI.Utils;
import java.awt.Component;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeCellRenderer;

public class Server
extends Communicator {
    private ServerInstanceDescriptor _instanceDescriptor;
    private Map<String, PropertySetDescriptor> _servicePropertySets = new HashMap<String, PropertySetDescriptor>();
    private ServerDescriptor _serverDescriptor;
    private ApplicationDescriptor _application;
    private Utils.Resolver _resolver;
    private List<Adapter> _adapters = new LinkedList<Adapter>();
    private List<DbEnv> _dbEnvs = new LinkedList<DbEnv>();
    private List<Service> _services = new LinkedList<Service>();
    private Set<String> _startedServices = new HashSet<String>();
    private ServerState _state;
    private boolean _enabled;
    private int _stateIconIndex;
    private int _pid;
    private String _toolTip;
    private ServiceObserverPrx _serviceObserver;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static Icon[][][] _icons;
    private static ServerEditor _editor;
    private static JPopupMenu _popup;
    private static JMenu _signalMenu;
    private static WriteMessageDialog _writeMessageDialog;

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[25];
        if (this._state != null) {
            Node node;
            actions[0] = this._state == ServerState.Inactive && this._enabled && !this._resolver.substitute(this._serverDescriptor.activation).equals("session");
            actions[1] = this._state != ServerState.Inactive;
            actions[2] = !this._enabled;
            actions[3] = this._enabled;
            actions[11] = this._state == ServerState.Active;
            actions[12] = this._state == ServerState.Active;
            actions[13] = true;
            actions[14] = true;
            actions[15] = this._serverDescriptor.logs.length > 0;
            boolean bl = actions[18] = !this._serverDescriptor.distrib.icepatch.equals("");
            if (this._state != ServerState.Inactive && !(node = (Node)this._parent).isRunningWindows()) {
                for (int i = 4; i <= 10; ++i) {
                    actions[i] = true;
                }
            }
        }
        actions[20] = true;
        return actions;
    }

    @Override
    public void start() {
        String prefix = "Starting server '" + this._id + "'...";
        String errorTitle = "Failed to start " + this._id;
        this.getCoordinator().getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this.getCoordinator().getAdmin();
            admin.startServerAsync(this._id).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    @Override
    public void stop() {
        String prefix = "Stopping server '" + this._id + "'...";
        String errorTitle = "Failed to stop " + this._id;
        this.getCoordinator().getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this.getCoordinator().getAdmin();
            admin.stopServerAsync(this._id).whenComplete((result, ex) -> {
                if (ex == null) {
                    this.amiSuccess(prefix);
                    SwingUtilities.invokeLater(() -> this.rebuild(this));
                } else if (ex instanceof UserException) {
                    this.amiFailure(prefix, errorTitle, (UserException)ex);
                } else {
                    this.amiFailure(prefix, errorTitle, ex.toString());
                }
            });
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    @Override
    public void enable() {
        this.enableServer(true);
    }

    @Override
    public void disable() {
        this.enableServer(false);
    }

    @Override
    public void writeMessage() {
        if (_writeMessageDialog == null) {
            _writeMessageDialog = new WriteMessageDialog(this.getRoot());
        }
        _writeMessageDialog.showDialog(this._id);
    }

    @Override
    public void retrieveOutput(final boolean stdout) {
        this.getRoot().openShowLogFileDialog(new ShowLogFileDialog.FileIteratorFactory(){

            @Override
            public FileIteratorPrx open(int count) throws FileNotAvailableException, ServerNotExistException, NodeUnreachableException, DeploymentException {
                AdminSessionPrx session = Server.this.getRoot().getCoordinator().getSession();
                FileIteratorPrx result = stdout ? session.openServerStdOut(Server.this._id, count) : session.openServerStdErr(Server.this._id, count);
                return result;
            }

            @Override
            public String getTitle() {
                return "Server " + Server.this._id + " " + (stdout ? "stdout" : "stderr");
            }

            @Override
            public String getDefaultFilename() {
                return Server.this._id + (stdout ? ".out" : ".err");
            }
        });
    }

    @Override
    public void retrieveLogFile() {
        assert (this._serverDescriptor.logs.length > 0);
        String path = null;
        if (this._serverDescriptor.logs.length == 1) {
            path = this._resolver.substitute(this._serverDescriptor.logs[0]);
        } else {
            Object[] pathArray = new Object[this._serverDescriptor.logs.length];
            int i = 0;
            for (String log : this._serverDescriptor.logs) {
                pathArray[i++] = this._resolver.substitute(log);
            }
            path = (String)JOptionPane.showInputDialog(this.getCoordinator().getMainFrame(), "Which log file do you want to retrieve?", "Retrieve Log File", 3, null, pathArray, pathArray[0]);
        }
        if (path != null) {
            final String fPath = path;
            this.getRoot().openShowLogFileDialog(new ShowLogFileDialog.FileIteratorFactory(){

                @Override
                public FileIteratorPrx open(int count) throws FileNotAvailableException, ServerNotExistException, NodeUnreachableException, DeploymentException {
                    AdminSessionPrx session = Server.this.getRoot().getCoordinator().getSession();
                    return session.openServerLog(Server.this._id, fPath, count);
                }

                @Override
                public String getTitle() {
                    return "Server " + Server.this._id + " " + new File(fPath).getName();
                }

                @Override
                public String getDefaultFilename() {
                    return new File(fPath).getName();
                }
            });
        }
    }

    @Override
    public void signal(String s) {
        String prefix = "Sending '" + s + "' to server '" + this._id + "'...";
        String errorTitle = "Failed to deliver signal " + s + " to " + this._id;
        this.getCoordinator().getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this.getCoordinator().getAdmin();
            admin.sendSignalAsync(this._id, s).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    @Override
    public void patchServer() {
        String message = this._serverDescriptor.applicationDistrib ? "You are about to install or refresh your server distribution and your application distribution onto this node.\nDo you want shut down all servers affected by this update?" : "You are about to install or refresh the distribution for this server.\nDo you want to shut down the server for this update?";
        int shutdown = JOptionPane.showConfirmDialog(this.getCoordinator().getMainFrame(), message, "Patch Confirmation", 1);
        if (shutdown == 2) {
            return;
        }
        String prefix = "Patching server '" + this._id + "'...";
        String errorTitle = "Failed to patch " + this._id;
        this.getCoordinator().getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this.getCoordinator().getAdmin();
            admin.patchServerAsync(this._id, shutdown == 0).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    private void enableServer(boolean enable) {
        String prefix = (enable ? "Enabling" : "Disabling") + " server '" + this._id + "'...";
        String errorTitle = "Failed to " + (enable ? "enable" : "disable") + " " + this._id;
        this.getCoordinator().getStatusBar().setText(prefix);
        try {
            AdminPrx admin = this.getCoordinator().getAdmin();
            admin.enableServerAsync(this._id, enable).whenComplete((result, ex) -> this.amiComplete(prefix, errorTitle, (Throwable)ex));
        }
        catch (LocalException ex2) {
            this.failure(prefix, errorTitle, ex2.toString());
        }
    }

    @Override
    public void openDefinition() {
        ApplicationPane app = this.getCoordinator().openLiveApplication(this._application.name);
        if (app != null) {
            app.getRoot().selectServer(((Node)this._parent).getId(), this._id);
        }
    }

    @Override
    public JPopupMenu getPopupMenu() {
        LiveActions la = this.getCoordinator().getLiveActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(la.get(0));
            _popup.add(la.get(1));
            _popup.addSeparator();
            _popup.add(la.get(2));
            _popup.add(la.get(3));
            _popup.addSeparator();
            _popup.add(la.get(18));
            _popup.addSeparator();
            _popup.add(la.get(11));
            _popup.add(la.get(12));
            _popup.add(la.get(13));
            _popup.add(la.get(14));
            _popup.add(la.get(15));
            _popup.addSeparator();
            _signalMenu = new JMenu("Send Signal");
            _popup.add(_signalMenu);
            _signalMenu.add(la.get(4));
            _signalMenu.add(la.get(5));
            _signalMenu.add(la.get(6));
            _signalMenu.add(la.get(7));
            _signalMenu.add(la.get(8));
            _signalMenu.add(la.get(9));
            _signalMenu.add(la.get(10));
            _popup.addSeparator();
            _popup.add(la.get(20));
        }
        la.setTarget(this);
        _signalMenu.setEnabled(la.get(4).isEnabled());
        return _popup;
    }

    @Override
    public Editor getEditor() {
        if (_editor == null) {
            _editor = new ServerEditor(this.getCoordinator());
        }
        _editor.show(this);
        return _editor;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        int disabled;
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _icons = new Icon[8][2][2];
            Server._icons[0][0][0] = Utils.getIcon("/icons/16x16/server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_activating.png");
            Server._icons[ServerState.ActivationTimedOut.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_activating.png");
            Server._icons[ServerState.Active.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][0][0] = Utils.getIcon("/icons/16x16/server_destroyed.png");
            Server._icons[0][1][0] = Utils.getIcon("/icons/16x16/icebox_server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_activating.png");
            Server._icons[ServerState.ActivationTimedOut.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_activating.png");
            Server._icons[ServerState.Active.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][1][0] = Utils.getIcon("/icons/16x16/icebox_server_destroyed.png");
            Server._icons[0][0][1] = Utils.getIcon("/icons/16x16/server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_activating.png");
            Server._icons[ServerState.ActivationTimedOut.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_activating.png");
            Server._icons[ServerState.Active.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][0][1] = Utils.getIcon("/icons/16x16/server_disabled_destroyed.png");
            Server._icons[0][1][1] = Utils.getIcon("/icons/16x16/icebox_server_unknown.png");
            Server._icons[ServerState.Inactive.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_inactive.png");
            Server._icons[ServerState.Activating.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_activating.png");
            Server._icons[ServerState.ActivationTimedOut.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_activating.png");
            Server._icons[ServerState.Active.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_active.png");
            Server._icons[ServerState.Deactivating.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_deactivating.png");
            Server._icons[ServerState.Destroying.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_destroying.png");
            Server._icons[ServerState.Destroyed.value() + 1][1][1] = Utils.getIcon("/icons/16x16/icebox_server_disabled_destroyed.png");
        }
        int icebox = this._serverDescriptor instanceof IceBoxDescriptor ? 1 : 0;
        int n = disabled = this._enabled ? 0 : 1;
        if (expanded) {
            _cellRenderer.setOpenIcon(_icons[this._stateIconIndex][icebox][disabled]);
        } else {
            _cellRenderer.setClosedIcon(_icons[this._stateIconIndex][icebox][disabled]);
        }
        _cellRenderer.setToolTipText(this._toolTip);
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    Server(Node parent, String serverId, Utils.Resolver resolver, ServerInstanceDescriptor instanceDescriptor, ServerDescriptor serverDescriptor, ApplicationDescriptor application, ServerState state, int pid, boolean enabled) {
        super(parent, serverId, 4);
        this._resolver = resolver;
        this._instanceDescriptor = instanceDescriptor;
        this._serverDescriptor = serverDescriptor;
        this._application = application;
        this._childrenArray[0] = this._metrics;
        this._childrenArray[1] = this._adapters;
        this._childrenArray[2] = this._dbEnvs;
        this._childrenArray[3] = this._services;
        this.update(state, pid, enabled, false);
        this.createAdapters();
        this.createDbEnvs();
        this.createServices();
    }

    ApplicationDescriptor getApplication() {
        return this._application;
    }

    ServerInstanceDescriptor getInstanceDescriptor() {
        return this._instanceDescriptor;
    }

    ServerDescriptor getServerDescriptor() {
        return this._serverDescriptor;
    }

    ServerState getState() {
        return this._state;
    }

    boolean hasServiceObserver() {
        return this._serviceObserver != null;
    }

    int getPid() {
        return this._pid;
    }

    boolean isEnabled() {
        return this._enabled;
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    void removeCallbacks() {
        if (this._serviceObserver != null) {
            this.getCoordinator().removeCallback(this._serviceObserver.ice_getIdentity().name, this._serviceObserver.ice_getFacet());
            this._serviceObserver = null;
        }
    }

    void updateServices() {
        for (Service service : this._services) {
            if (this._startedServices.contains(service.getId())) {
                service.started();
                continue;
            }
            service.stopped();
        }
    }

    void rebuild(Server server) {
        this._resolver = server._resolver;
        this._instanceDescriptor = server._instanceDescriptor;
        this._serverDescriptor = server._serverDescriptor;
        this._application = server._application;
        this._metrics = server._metrics;
        this._adapters = server._adapters;
        this._dbEnvs = server._dbEnvs;
        this._services = server._services;
        this._childrenArray[0] = this._metrics;
        this._childrenArray[1] = this._adapters;
        this._childrenArray[2] = this._dbEnvs;
        this._childrenArray[3] = this._services;
        for (Adapter adapter : this._adapters) {
            adapter.reparent(this);
        }
        for (DbEnv dbEnv : this._dbEnvs) {
            dbEnv.reparent(this);
        }
        for (Service service : this._services) {
            service.reparent(this);
        }
        for (MetricsView metrics : this._metrics) {
            metrics.reparent(this);
        }
        this.updateServices();
        this.getRoot().getTreeModel().nodeStructureChanged(this);
    }

    void rebuild(Utils.Resolver resolver, boolean variablesChanged, Set<String> serviceTemplates, Set<String> serverTemplates) {
        if (variablesChanged || this._instanceDescriptor != null && serverTemplates != null && serverTemplates.contains(this._instanceDescriptor.template)) {
            if (this._instanceDescriptor != null) {
                TemplateDescriptor templateDescriptor = this._application.serverTemplates.get(this._instanceDescriptor.template);
                assert (templateDescriptor != null);
                this._resolver.reset(resolver, this._instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
                this._resolver.put("server", this._id);
                this._serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
            } else {
                this._resolver.reset(resolver);
                this._resolver.put("server", this._id);
            }
            this._adapters.clear();
            this.createAdapters();
            this._dbEnvs.clear();
            this.createDbEnvs();
            this._services.clear();
            this._servicePropertySets.clear();
            this.createServices();
            this.updateServices();
            this._metrics.clear();
            this.getRoot().getTreeModel().nodeStructureChanged(this);
            this.updateMetrics();
        } else if (serviceTemplates != null && serviceTemplates.size() > 0 && this._serverDescriptor instanceof IceBoxDescriptor) {
            this._metrics.clear();
            this._services.clear();
            this._servicePropertySets.clear();
            this.createServices();
            this.updateServices();
            this.getRoot().getTreeModel().nodeStructureChanged(this);
            this.updateMetrics();
        }
    }

    void update(ServerState state, int pid, boolean enabled, boolean fireEvent) {
        if (state != this._state || pid != this._pid || enabled != this._enabled) {
            this._state = state;
            this._pid = pid;
            this._enabled = enabled;
            this._toolTip = Server.toolTip(this._state, this._pid, this._enabled);
            this._stateIconIndex = this._state == null ? 0 : this._state.value() + 1;
            if (this._state == ServerState.Active && this.getRoot().getTree().isExpanded(this.getPath())) {
                this.fetchMetricsViewNames();
            } else {
                this._metricsRetrieved = false;
                if (!this._metrics.isEmpty()) {
                    this._metrics.clear();
                    this.rebuild(this);
                }
            }
            if (this._state == ServerState.Inactive && this._showIceLogDialog != null) {
                this._showIceLogDialog.stopped();
            }
            if (this._serverDescriptor instanceof IceBoxDescriptor) {
                if (this._state == ServerState.Active) {
                    ServiceManagerPrx serviceManager;
                    if (this._serviceObserver == null) {
                        this._serviceObserver = ServiceObserverPrx.uncheckedCast(this.getCoordinator().retrieveCallback(this._id, "IceBox.ServiceManager"));
                        if (this._serviceObserver == null) {
                            ServiceObserver servant = new ServiceObserver(){

                                @Override
                                public void servicesStarted(String[] services, Current current) {
                                    HashSet<String> serviceSet = new HashSet<String>(Arrays.asList(services));
                                    SwingUtilities.invokeLater(() -> {
                                        for (Service service : Server.this._services) {
                                            if (!serviceSet.contains(service.getId())) continue;
                                            service.started();
                                        }
                                        Server.this._startedServices.addAll(serviceSet);
                                        Server.this.getCoordinator().getLiveDeploymentPane().refresh();
                                    });
                                }

                                @Override
                                public void servicesStopped(String[] services, Current current) {
                                    HashSet<String> serviceSet = new HashSet<String>(Arrays.asList(services));
                                    SwingUtilities.invokeLater(() -> {
                                        for (Service service : Server.this._services) {
                                            if (!serviceSet.contains(service.getId())) continue;
                                            service.stopped();
                                        }
                                        Server.this._startedServices.removeAll(serviceSet);
                                        Server.this.getCoordinator().getLiveDeploymentPane().refresh();
                                    });
                                }
                            };
                            this._serviceObserver = ServiceObserverPrx.uncheckedCast(this.getCoordinator().addCallback(servant, this._id, "IceBox.ServiceManager"));
                            if (this._serviceObserver == null) {
                                JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "Could not create servant for service-manager observer", "Observer creation error", 0);
                            }
                        }
                    }
                    if (this._serviceObserver != null && (serviceManager = ServiceManagerPrx.uncheckedCast(this.getAdminFacet("IceBox.ServiceManager"))) != null) {
                        try {
                            serviceManager.addObserverAsync(this._serviceObserver);
                        }
                        catch (LocalException localException) {}
                    }
                } else if (this._state == ServerState.Inactive) {
                    for (Service service : this._services) {
                        service.stopShowIceLogDialog();
                        service.stopped();
                    }
                }
            }
            if (fireEvent) {
                this.getRoot().getTreeModel().nodeChanged(this);
            }
        }
    }

    boolean updateAdapter(AdapterDynamicInfo info) {
        for (Adapter adapter : this._adapters) {
            if (!adapter.update(info)) continue;
            return true;
        }
        for (Service service : this._services) {
            if (!service.updateAdapter(info)) continue;
            return true;
        }
        return false;
    }

    int updateAdapters(List<AdapterDynamicInfo> infoList) {
        int result = 0;
        Iterator<TreeNode> p = this._adapters.iterator();
        while (p.hasNext() && result < infoList.size()) {
            Adapter adapter = (Adapter)p.next();
            if (!adapter.update(infoList)) continue;
            ++result;
        }
        p = this._services.iterator();
        while (p.hasNext() && result < infoList.size()) {
            Service service = (Service)p.next();
            result += service.updateAdapters(infoList);
        }
        return result;
    }

    void nodeDown() {
        this.update(null, 0, true, true);
        for (Adapter adapter : this._adapters) {
            adapter.update((AdapterDynamicInfo)null);
        }
        for (Service service : this._services) {
            service.nodeDown();
        }
    }

    SortedMap<String, String> getProperties() {
        LinkedList<Utils.ExpandedPropertySet> psList = new LinkedList<Utils.ExpandedPropertySet>();
        Node node = (Node)this._parent;
        psList.add(node.expand(this._serverDescriptor.propertySet, this._application.name, this._resolver));
        if (this._instanceDescriptor != null) {
            psList.add(node.expand(this._instanceDescriptor.propertySet, this._application.name, this._resolver));
        }
        return Utils.propertySetsToMap(psList, this._resolver);
    }

    int getIceVersion() {
        return Utils.getIntVersion(Utils.substitute(this._serverDescriptor.iceVersion, this._resolver));
    }

    private void createAdapters() {
        for (AdapterDescriptor p : this._serverDescriptor.adapters) {
            String adapterName = Utils.substitute(p.name, this._resolver);
            String adapterId = Utils.substitute(p.id, this._resolver);
            ObjectPrx proxy = null;
            if (adapterId.length() > 0) {
                proxy = ((Node)this._parent).getProxy(adapterId);
            }
            this.insertSortedChild(new Adapter(this, adapterName, this._resolver, adapterId, p, proxy), this._adapters, null);
        }
    }

    private void createDbEnvs() {
        for (DbEnvDescriptor p : this._serverDescriptor.dbEnvs) {
            String dbEnvName = Utils.substitute(p.name, this._resolver);
            this.insertSortedChild(new DbEnv(this, dbEnvName, this._resolver, p), this._dbEnvs, null);
        }
    }

    private void createServices() {
        if (this._serverDescriptor instanceof IceBoxDescriptor) {
            if (this._instanceDescriptor != null) {
                for (Map.Entry<String, PropertySetDescriptor> p : this._instanceDescriptor.servicePropertySets.entrySet()) {
                    this._servicePropertySets.put(this._resolver.substitute(p.getKey()), p.getValue());
                }
            }
            IceBoxDescriptor iceBoxDescriptor = (IceBoxDescriptor)this._serverDescriptor;
            for (ServiceInstanceDescriptor p : iceBoxDescriptor.services) {
                this.createService(p);
            }
        }
    }

    private void createService(ServiceInstanceDescriptor descriptor) {
        ServiceDescriptor serviceDescriptor = null;
        String serviceName = null;
        Utils.Resolver serviceResolver = null;
        if (descriptor.template.length() > 0) {
            TemplateDescriptor templateDescriptor = this._application.serviceTemplates.get(descriptor.template);
            assert (templateDescriptor != null);
            serviceDescriptor = (ServiceDescriptor)templateDescriptor.descriptor;
            assert (serviceDescriptor != null);
            serviceResolver = new Utils.Resolver(this._resolver, descriptor.parameterValues, templateDescriptor.parameterDefaults);
            serviceName = serviceResolver.substitute(serviceDescriptor.name);
            serviceResolver.put("service", serviceName);
        } else {
            serviceDescriptor = descriptor.descriptor;
            assert (serviceDescriptor != null);
            serviceResolver = new Utils.Resolver(this._resolver);
            serviceName = this._resolver.substitute(serviceDescriptor.name);
            serviceResolver.put("service", serviceName);
        }
        PropertySetDescriptor serverInstancePSDescriptor = this._servicePropertySets.get(serviceName);
        this._services.add(new Service(this, serviceName, serviceResolver, descriptor, serviceDescriptor, serverInstancePSDescriptor));
    }

    @Override
    protected CompletableFuture<ObjectPrx> getAdminAsync() {
        return CompletableFuture.completedFuture(this.getAdmin());
    }

    @Override
    protected String getDisplayName() {
        return "Server " + this._id;
    }

    @Override
    protected String getDefaultFileName() {
        return this._id;
    }

    ObjectPrx getAdmin() {
        AdminPrx gridAdmin;
        if (this._state == ServerState.Active && (gridAdmin = this.getCoordinator().getAdmin()) != null) {
            return gridAdmin.ice_identity(new Identity(this._id, this.getCoordinator().getServerAdminCategory()));
        }
        return null;
    }

    ObjectPrx getAdminFacet(String facet) {
        ObjectPrx admin = this.getAdmin();
        if (admin != null) {
            return admin.ice_facet(facet);
        }
        return null;
    }

    private static String toolTip(ServerState state, int pid, boolean enabled) {
        String result;
        String string = result = state == null ? "Unknown" : state.toString();
        if (!enabled) {
            result = result + ", disabled";
        }
        if (pid != 0) {
            result = result + ", pid: " + pid;
        }
        return result;
    }
}

