/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegetingHandler;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class P2CompositeParser
implements XMLInputParser {
    private Set childLocations = new LinkedHashSet();

    public Set getChildLocations() {
        return this.childLocations;
    }

    @Override
    public void parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        RepositoryHandler repositoryHandler = new RepositoryHandler();
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)repositoryHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
        this.childLocations.addAll(repositoryHandler.childLocations);
    }

    static class ChildHandler
    extends DelegetingHandler {
        private static final String CHILD = "child";
        private static final String LOCATION = "location";
        String location;

        public ChildHandler() {
            super(CHILD);
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            this.location = attributes.getValue(LOCATION);
        }
    }

    static class ChildrenHandler
    extends DelegetingHandler {
        private static final String CHILDREN = "children";
        private static final String SIZE = "size";
        List childLocations;

        public ChildrenHandler() {
            super(CHILDREN);
            this.addChild(new ChildHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    ChildrenHandler.this.childLocations.add(((ChildHandler)delegetingHandler).location);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.childLocations = new ArrayList(n);
        }
    }

    static class RepositoryHandler
    extends DelegetingHandler {
        private static final String REPOSITORY = "repository";
        List childLocations;

        public RepositoryHandler() {
            super(REPOSITORY);
            this.addChild(new ChildrenHandler(), new DelegetingHandler.ChildElementHandler(){

                @Override
                public void childHanlded(DelegetingHandler delegetingHandler) {
                    RepositoryHandler.this.childLocations = ((ChildrenHandler)delegetingHandler).childLocations;
                }
            });
        }
    }
}

