/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInfo {
    @Nullable
    private final JsonSchemaFileProvider myProvider;
    @Nullable
    private final String myUrl;
    @Nullable
    private String myName;
    @Nullable
    private String myDocumentation;
    @NotNull
    private static final Set<String> myDumbNames = ContainerUtil.set((Object[])new String[]{"schema", "lib", "cli", "packages", "master", "format", "angular", "config"});
    @NotNull
    private static final Map<String, String> myWeirdNames = ContainerUtil.stringMap((String[])new String[]{"http://json.schemastore.org/config", "asp.net config", "https://schemastore.azurewebsites.net/schemas/json/config.json", "asp.net config", "http://json.schemastore.org/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10", "https://schemastore.azurewebsites.net/schemas/json/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10"});

    public JsonSchemaInfo(@NotNull JsonSchemaFileProvider provider) {
        if (provider == null) {
            JsonSchemaInfo.$$$reportNull$$$0(0);
        }
        this.myName = null;
        this.myDocumentation = null;
        this.myProvider = provider;
        this.myUrl = null;
    }

    public JsonSchemaInfo(@NotNull String url) {
        if (url == null) {
            JsonSchemaInfo.$$$reportNull$$$0(1);
        }
        this.myName = null;
        this.myDocumentation = null;
        this.myUrl = url;
        this.myProvider = null;
    }

    @Nullable
    public JsonSchemaFileProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public String getUrl(Project project) {
        if (this.myProvider != null) {
            String remoteSource = this.myProvider.getRemoteSource();
            if (remoteSource != null) {
                String string = remoteSource;
                if (string == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(2);
                }
                return string;
            }
            VirtualFile schemaFile = this.myProvider.getSchemaFile();
            if (schemaFile == null) {
                if ("" == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(3);
                }
                return "";
            }
            if (schemaFile instanceof HttpVirtualFile) {
                String string = schemaFile.getUrl();
                if (string == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = JsonSchemaInfo.getRelativePath(project, schemaFile.getPath());
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(5);
            }
            return string;
        }
        assert (this.myUrl != null);
        String string = this.myUrl;
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        if (this.myProvider != null) {
            String providerName = this.myProvider.getPresentableName();
            String string = JsonSchemaInfo.sanitizeName(providerName);
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(7);
            }
            return string;
        }
        assert (this.myUrl != null);
        if (myWeirdNames.containsKey(this.myUrl)) {
            String string = myWeirdNames.get(this.myUrl);
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(8);
            }
            return string;
        }
        String url = this.myUrl.replace('\\', '/');
        String string = ContainerUtil.reverse((List)StringUtil.split((String)url, (String)"/")).stream().map(p -> JsonSchemaInfo.sanitizeName(p)).filter(p -> !JsonSchemaInfo.isVeryDumbName(p)).findFirst().orElse(JsonSchemaInfo.sanitizeName(this.myUrl));
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public String getDocumentation() {
        return this.myDocumentation;
    }

    public void setDocumentation(@Nullable String documentation) {
        this.myDocumentation = documentation;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public void setName(@Nullable String name) {
        this.myName = name;
    }

    public static boolean isVeryDumbName(@Nullable String possibleName) {
        if (StringUtil.isEmptyOrSpaces((String)possibleName) || myDumbNames.contains(possibleName)) {
            return true;
        }
        return StringUtil.split((String)possibleName, (String)".").stream().allMatch(s -> JsonSchemaType.isInteger(s));
    }

    @NotNull
    private static String sanitizeName(@NotNull String providerName) {
        if (providerName == null) {
            JsonSchemaInfo.$$$reportNull$$$0(10);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema"), (String)".schema");
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public JsonSchemaVersion getSchemaVersion() {
        JsonSchemaVersion jsonSchemaVersion = this.myProvider != null ? this.myProvider.getSchemaVersion() : JsonSchemaVersion.SCHEMA_4;
        if (jsonSchemaVersion == null) {
            JsonSchemaInfo.$$$reportNull$$$0(12);
        }
        return jsonSchemaVersion;
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull String text) {
        String path;
        if (project == null) {
            JsonSchemaInfo.$$$reportNull$$$0(13);
        }
        if (text == null) {
            JsonSchemaInfo.$$$reportNull$$$0(14);
        }
        text = text.trim();
        if (project.isDefault() || project.getBasePath() == null) {
            String string = text;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(15);
            }
            return string;
        }
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            String string = text;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(16);
            }
            return string;
        }
        File ioFile = new File(text);
        if (!ioFile.isAbsolute()) {
            String string = text;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(17);
            }
            return string;
        }
        VirtualFile file = VfsUtil.findFileByIoFile((File)ioFile, (boolean)false);
        if (file == null) {
            String string = text;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(18);
            }
            return string;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)project.getBaseDir());
        if (relativePath != null) {
            String string = relativePath;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(19);
            }
            return string;
        }
        if (JsonSchemaInfo.isMeaningfulAncestor(VfsUtilCore.getCommonAncestor((VirtualFile)file, (VirtualFile)project.getBaseDir())) && (path = VfsUtilCore.findRelativePath((VirtualFile)project.getBaseDir(), (VirtualFile)file, (char)File.separatorChar)) != null) {
            String string = path;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(20);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static boolean isMeaningfulAncestor(@Nullable VirtualFile ancestor) {
        if (ancestor == null) {
            return false;
        }
        VirtualFile homeDir = VfsUtil.getUserHomeDir();
        return homeDir != null && VfsUtilCore.isAncestor((VirtualFile)homeDir, (VirtualFile)ancestor, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaInfo";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaVersion";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

