/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.surroundWith.SurroundDescriptor;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.surroundWith.GroupSurrounder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleSurroundDescriptor
implements SurroundDescriptor {
    private static final Surrounder[] SURROUNDERS = new Surrounder[]{new GroupSurrounder("Capturing Group (pattern)", "("), new GroupSurrounder("Non-Capturing Group (?:pattern)", "(?:"), new GroupSurrounder("Atomic Group (?:pattern)", "(?:"), new GroupSurrounder("Positive Lookbehind (?<=pattern)", "(?<="), new GroupSurrounder("Negative Lookbehind (?<!pattern)", "(?<!"), new GroupSurrounder("Positive Lookahead (?=pattern)", "(?="), new GroupSurrounder("Negative Lookahead (?!pattern)", "(?!")};

    @NotNull
    public PsiElement[] getElementsToSurround(PsiFile file2, int startOffset, int endOffset) {
        RegExpPattern pattern;
        PsiElement element1 = file2.findElementAt(startOffset);
        PsiElement element2 = file2.findElementAt(endOffset - 1);
        if (element1 instanceof PsiWhiteSpace) {
            startOffset = element1.getTextRange().getEndOffset();
        }
        if (element2 instanceof PsiWhiteSpace) {
            endOffset = element2.getTextRange().getStartOffset();
        }
        if ((pattern = SimpleSurroundDescriptor.findElementAtStrict(file2, startOffset, endOffset, RegExpPattern.class)) != null) {
            PsiElement[] psiElementArray = new RegExpElement[]{pattern};
            if (psiElementArray == null) {
                SimpleSurroundDescriptor.$$$reportNull$$$0(0);
            }
            return psiElementArray;
        }
        RegExpBranch branch = SimpleSurroundDescriptor.findElementAtStrict(file2, startOffset, endOffset, RegExpBranch.class);
        if (branch != null) {
            PsiElement[] psiElementArray = new RegExpElement[]{branch};
            if (psiElementArray == null) {
                SimpleSurroundDescriptor.$$$reportNull$$$0(1);
            }
            return psiElementArray;
        }
        ArrayList<PsiElement> atoms = new ArrayList<PsiElement>();
        RegExpAtom atom = (RegExpAtom)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, RegExpAtom.class);
        while (atom != null) {
            atoms.add(atom);
            startOffset = atom.getTextRange().getEndOffset();
            element1 = file2.findElementAt(startOffset);
            if (element1 instanceof PsiWhiteSpace) {
                startOffset = element1.getTextRange().getEndOffset();
                atoms.add(element1);
            }
            atom = (RegExpAtom)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, RegExpAtom.class);
        }
        if (startOffset == endOffset && atoms.size() > 0) {
            PsiElement[] elements2 = PsiUtilCore.toPsiElementArray(atoms);
            if (atoms.size() == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements2) == elements2[0].getParent()) {
                if (elements2 == null) {
                    SimpleSurroundDescriptor.$$$reportNull$$$0(2);
                }
                return elements2;
            }
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            SimpleSurroundDescriptor.$$$reportNull$$$0(3);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public Surrounder[] getSurrounders() {
        if (SURROUNDERS == null) {
            SimpleSurroundDescriptor.$$$reportNull$$$0(4);
        }
        return SURROUNDERS;
    }

    public boolean isExclusive() {
        return false;
    }

    @Nullable
    private static <T extends RegExpElement> T findElementAtStrict(PsiFile file2, int startOffset, int endOffset, Class<T> clazz) {
        RegExpElement element = (RegExpElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)startOffset, (int)endOffset, clazz);
        if (element == null || element.getTextRange().getEndOffset() < endOffset) {
            return null;
        }
        return (T)element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/lang/regexp/surroundWith/SimpleSurroundDescriptor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToSurround";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurrounders";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

