/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.TBItemButton;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TBItemAnActionButton
extends TBItemButton {
    private static final int ourRunConfigurationPopoverWidth = 143;
    public static final int SHOWMODE_IMAGE_ONLY = 0;
    public static final int SHOWMODE_TEXT_ONLY = 1;
    public static final int SHOWMODE_IMAGE_TEXT = 2;
    public static final int SHOWMODE_IMAGE_ONLY_IF_PRESENTED = 3;
    private static final Logger LOG = Logger.getInstance(TBItemAnActionButton.class);
    @NotNull
    private AnAction myAnAction;
    @Nullable
    private String myActionId;
    private int myShowMode;
    private boolean myAutoVisibility;
    private boolean myHiddenWhenDisabled;
    @Nullable
    private Component myComponent;
    @Nullable
    private List<? extends TBItemAnActionButton> myLinkedButtons;

    TBItemAnActionButton(@NotNull String uid, @Nullable ItemListener listener2, @NotNull AnAction action2) {
        if (uid == null) {
            TBItemAnActionButton.$$$reportNull$$$0(0);
        }
        if (action2 == null) {
            TBItemAnActionButton.$$$reportNull$$$0(1);
        }
        super(uid, listener2);
        this.myShowMode = 3;
        this.myAutoVisibility = true;
        this.myHiddenWhenDisabled = false;
        this.setAnAction(action2);
        this.setModality(null);
        if (action2 instanceof Toggleable) {
            this.myFlags |= 8;
        }
    }

    @Override
    public String toString() {
        return String.format("%s [%s]", this.myActionId, this.myUid);
    }

    TBItemAnActionButton setComponent(Component component) {
        this.myComponent = component;
        return this;
    }

    TBItemAnActionButton setModality(ModalityState modality) {
        this.setAction(this::_performAction, true, modality);
        return this;
    }

    TBItemAnActionButton setShowMode(int showMode) {
        this.myShowMode = showMode;
        return this;
    }

    void setLinkedButtons(@Nullable List<? extends TBItemAnActionButton> linkedButtons) {
        this.myLinkedButtons = linkedButtons;
    }

    @NotNull
    Presentation updateAnAction(boolean forceUseCached) {
        Presentation presentation = this.myAnAction.getTemplatePresentation().clone();
        if (ApplicationManager.getApplication() == null) {
            if (this.myComponent instanceof JButton) {
                presentation.setEnabled(this.myComponent.isEnabled());
                presentation.setText((String)DialogWrapper.extractMnemonic((String)((JButton)this.myComponent).getText()).second);
            }
            Presentation presentation2 = presentation;
            if (presentation2 == null) {
                TBItemAnActionButton.$$$reportNull$$$0(2);
            }
            return presentation2;
        }
        DataContext dctx = DataManager.getInstance().getDataContext(this._getComponent());
        ActionManagerEx am = ActionManagerEx.getInstanceEx();
        AnActionEvent e = new AnActionEvent(null, dctx, "TouchBarGeneral", presentation, (ActionManager)am, 0);
        try {
            ActionUtil.performFastUpdate((boolean)false, (AnAction)this.myAnAction, (AnActionEvent)e, (boolean)forceUseCached);
        }
        catch (IndexNotReadyException e1) {
            presentation.setEnabledAndVisible(false);
        }
        Presentation presentation3 = presentation;
        if (presentation3 == null) {
            TBItemAnActionButton.$$$reportNull$$$0(3);
        }
        return presentation3;
    }

    boolean isAutoVisibility() {
        return this.myAutoVisibility;
    }

    void setAutoVisibility(boolean autoVisibility) {
        this.myAutoVisibility = autoVisibility;
    }

    void setHiddenWhenDisabled(boolean hiddenWhenDisabled) {
        this.myHiddenWhenDisabled = hiddenWhenDisabled;
    }

    @NotNull
    AnAction getAnAction() {
        AnAction anAction = this.myAnAction;
        if (anAction == null) {
            TBItemAnActionButton.$$$reportNull$$$0(4);
        }
        return anAction;
    }

    void setAnAction(@NotNull AnAction newAction) {
        if (newAction == null) {
            TBItemAnActionButton.$$$reportNull$$$0(5);
        }
        this.myAnAction = newAction;
        this.myActionId = ApplicationManager.getApplication() == null ? newAction.toString() : ActionManager.getInstance().getId(newAction);
    }

    boolean updateVisibility(Presentation presentation) {
        boolean visibilityChanged;
        if (!this.myAutoVisibility) {
            return false;
        }
        boolean isVisible = presentation.isVisible() && (presentation.isEnabled() || !this.myHiddenWhenDisabled);
        boolean bl = visibilityChanged = isVisible != this.myIsVisible;
        if (visibilityChanged) {
            this.myIsVisible = isVisible;
        }
        if ("RunConfiguration".equals(this.myActionId)) {
            visibilityChanged = visibilityChanged || this._setLinkedVisibility(presentation.getIcon() != AllIcons.General.Add);
        }
        return visibilityChanged;
    }

    void updateView(Presentation presentation) {
        if (!this.myIsVisible) {
            return;
        }
        Icon icon = null;
        if (this.myShowMode != 1) {
            if (presentation.isEnabled()) {
                icon = presentation.getIcon();
            } else {
                icon = presentation.getDisabledIcon();
                if (icon == null) {
                    icon = IconLoader.getDisabledIcon((Icon)presentation.getIcon());
                }
            }
        }
        boolean isSelected = false;
        if (this.myAnAction instanceof Toggleable) {
            Object selectedProp = presentation.getClientProperty("selected");
            boolean bl = isSelected = selectedProp == Boolean.TRUE;
            if (this.myNativePeer != ID.NIL && this.myActionId != null && this.myActionId.startsWith("Console.Jdbc.Execute")) {
                this.myUpdateOptions |= 2;
            }
        }
        if ("RunConfiguration".equals(this.myActionId)) {
            if (presentation.getIcon() != AllIcons.General.Add) {
                this.setHasArrowIcon(true);
                this.setLayout(143, 0, 5, 8);
            } else {
                this.setHasArrowIcon(false);
                this.setLayout(0, 0, 5, 8);
            }
        }
        boolean hideText = this.myShowMode == 0 || this.myShowMode == 3 && icon != null;
        String text2 = hideText ? null : presentation.getText();
        this.update(icon, text2, isSelected, !presentation.isEnabled());
    }

    private boolean _setLinkedVisibility(boolean visible) {
        if (this.myLinkedButtons == null) {
            return false;
        }
        boolean visibilityChanged = false;
        for (TBItemAnActionButton tBItemAnActionButton : this.myLinkedButtons) {
            if (tBItemAnActionButton.myAutoVisibility != visible) {
                visibilityChanged = true;
            }
            tBItemAnActionButton.setAutoVisibility(visible);
            tBItemAnActionButton.myIsVisible = visible;
        }
        return visibilityChanged;
    }

    private void _performAction() {
        if (ApplicationManager.getApplication() == null) {
            if (this.myComponent instanceof JButton) {
                ((JButton)this.myComponent).doClick();
            }
            return;
        }
        ActionManagerEx actionManagerEx = ActionManagerEx.getInstanceEx();
        Component src = this._getComponent();
        if (src == null) {
            return;
        }
        KeyEvent ie = new KeyEvent(src, 100, System.currentTimeMillis(), 0, 0, '\u0000');
        actionManagerEx.tryToExecute(this.myAnAction, (InputEvent)ie, src, "TouchBarGeneral", true);
        if (this.myAnAction instanceof Toggleable) {
            this.myUpdateOptions |= 2;
        }
    }

    private Component _getComponent() {
        return this.myComponent != null ? this.myComponent : TBItemAnActionButton._getCurrentFocusComponent();
    }

    private static Component _getCurrentFocusComponent() {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = focusManager.getPermanentFocusOwner();
        }
        if (focusOwner == null) {
            return focusManager.getFocusedWindow();
        }
        return focusOwner;
    }

    private static String _printPresentation(Presentation presentation) {
        Icon disabledIcon;
        Icon icon;
        StringBuilder sb = new StringBuilder();
        if (presentation.getText() != null && !presentation.getText().isEmpty()) {
            sb.append(String.format("text='%s'", presentation.getText()));
        }
        if ((icon = presentation.getIcon()) != null) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(String.format("icon: %dx%d", icon.getIconWidth(), icon.getIconHeight()));
        }
        if ((disabledIcon = presentation.getDisabledIcon()) != null) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(String.format("dis-icon: %dx%d", disabledIcon.getIconWidth(), disabledIcon.getIconHeight()));
        }
        if (sb.length() != 0) {
            sb.append(", ");
        }
        sb.append(presentation.isVisible() ? "visible" : "hidden");
        sb.append(presentation.isEnabled() ? ", enabled" : ", disabled");
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/mac/touchbar/TBItemAnActionButton";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/mac/touchbar/TBItemAnActionButton";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "updateAnAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAnAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

