/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameBuilderCacheKey = Key.create((String)"project's.short.file.name.builder");
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameOpenedBuilderCacheKey = Key.create((String)"project's.short.file.name.opened.builder");
    private static final UniqueNameBuilder<VirtualFile> ourEmptyBuilder = new UniqueNameBuilder(null, null, -1);

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(2);
        }
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, file2, false, scope);
        if (string == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(4);
        }
        if (vFile == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(5);
        }
        String string = this.getUniqueVirtualFilePath(project, vFile, GlobalSearchScope.projectScope((Project)project));
        if (string == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(@NotNull Project project, @NotNull VirtualFile vFile) {
        if (project == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(7);
        }
        if (vFile == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(8);
        }
        String string = UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, vFile, true, GlobalSearchScope.projectScope((Project)project));
        if (string == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean hasFilesWithSameName(@NotNull Project project, @NotNull VirtualFile vFile) {
        UniqueNameBuilder<VirtualFile> builder2;
        if (project == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(10);
        }
        if (vFile == null) {
            UniqueVFilePathBuilderImpl.$$$reportNull$$$0(11);
        }
        return (builder2 = UniqueVFilePathBuilderImpl.getUniqueVirtualFileNameBuilder(project, vFile, false, GlobalSearchScope.projectScope((Project)project))) != null && builder2.size() > 1;
    }

    private static String getUniqueVirtualFilePath(Project project, VirtualFile file2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        UniqueNameBuilder<VirtualFile> builder2 = UniqueVFilePathBuilderImpl.getUniqueVirtualFileNameBuilder(project, file2, skipNonOpenedFiles, scope);
        if (builder2 != null) {
            return builder2.getShortPath((Object)file2);
        }
        return file2 instanceof VirtualFilePathWrapper ? file2.getPresentableName() : file2.getName();
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> getUniqueVirtualFileNameBuilder(Project project, VirtualFile file2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        String fileName2;
        UniqueNameBuilder<VirtualFile> uniqueNameBuilderForShortName;
        ConcurrentMap scope2ValueMap;
        Map valueMap;
        Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> key = skipNonOpenedFiles ? ourShortNameOpenedBuilderCacheKey : ourShortNameBuilderCacheKey;
        CachedValue data = (CachedValue)project.getUserData(key);
        if (data == null) {
            data = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result(new ConcurrentHashMap(2), new Object[]{PsiModificationTracker.MODIFICATION_COUNT, FileEditorManagerImpl.OPEN_FILE_SET_MODIFICATION_COUNT}), false);
            project.putUserData(key, (Object)data);
        }
        if ((valueMap = (Map)(scope2ValueMap = (ConcurrentMap)data.getValue()).get(scope)) == null) {
            valueMap = (Map)ConcurrencyUtil.cacheOrGet((ConcurrentMap)scope2ValueMap, (Object)scope, (Object)ContainerUtil.createConcurrentSoftValueMap());
        }
        if ((uniqueNameBuilderForShortName = (UniqueNameBuilder<VirtualFile>)valueMap.get(fileName2 = file2.getName())) == null) {
            UniqueNameBuilder<VirtualFile> builder2 = UniqueVFilePathBuilderImpl.filesWithTheSameName(fileName2, project, skipNonOpenedFiles, scope);
            valueMap.put(fileName2, builder2 != null ? builder2 : ourEmptyBuilder);
            uniqueNameBuilderForShortName = builder2;
        } else if (uniqueNameBuilderForShortName == ourEmptyBuilder) {
            uniqueNameBuilderForShortName = null;
        }
        if (uniqueNameBuilderForShortName != null && uniqueNameBuilderForShortName.contains((Object)file2)) {
            return uniqueNameBuilderForShortName;
        }
        return null;
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> filesWithTheSameName(String fileName2, Project project, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        THashSet filesWithSameName = skipNonOpenedFiles ? Collections.emptySet() : FilenameIndex.getVirtualFilesByName(project, fileName2, scope);
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile2 : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            if (!openFile2.getName().equals(fileName2)) continue;
            setOfFilesWithTheSameName.add((Object)openFile2);
        }
        if (!skipNonOpenedFiles) {
            for (VirtualFile recentlyEditedFile : EditorHistoryManager.getInstance(project).getFileList()) {
                if (!recentlyEditedFile.getName().equals(fileName2)) continue;
                setOfFilesWithTheSameName.add((Object)recentlyEditedFile);
            }
        }
        if ((filesWithSameName = setOfFilesWithTheSameName).size() > 1) {
            String path = project.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder2 = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                String presentablePath = virtualFile instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)virtualFile).getPresentablePath() : virtualFile.getPath();
                builder2.addPath((Object)virtualFile, presentablePath);
            }
            return builder2;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/UniqueVFilePathBuilderImpl";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueVirtualFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUniqueVirtualFilePathWithinOpenedFileEditors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueVirtualFilePath";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueVirtualFilePathWithinOpenedFileEditors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasFilesWithSameName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

