/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.view;

import com.intellij.openapi.editor.richcopy.model.ColorRegistry;
import com.intellij.openapi.editor.richcopy.model.FontNameRegistry;
import com.intellij.openapi.editor.richcopy.model.MarkupHandler;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.view.AbstractSyntaxAwareReader;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntObjectHashMap;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class HtmlSyntaxInfoReader
extends AbstractSyntaxAwareReader
implements MarkupHandler {
    private final int myTabSize;
    protected StringBuilder myResultBuffer;
    private ColorRegistry myColorRegistry;
    private FontNameRegistry myFontNameRegistry;
    private int myMaxLength;
    private int myDefaultForeground;
    private int myDefaultBackground;
    private int myDefaultFontFamily;
    private int myForeground;
    private int myBackground;
    private int myFontFamily;
    private boolean myBold;
    private boolean myItalic;
    private int myCurrentColumn;
    private final TIntObjectHashMap<String> myColors;

    public HtmlSyntaxInfoReader(@NotNull SyntaxInfo syntaxInfo, int tabSize) {
        if (syntaxInfo == null) {
            HtmlSyntaxInfoReader.$$$reportNull$$$0(0);
        }
        super(syntaxInfo);
        this.myColors = new TIntObjectHashMap();
        this.myTabSize = tabSize;
    }

    @Override
    protected void build(@NotNull StringBuilder holder, int maxLength) {
        if (holder == null) {
            HtmlSyntaxInfoReader.$$$reportNull$$$0(1);
        }
        this.myResultBuffer = holder;
        this.myColorRegistry = this.mySyntaxInfo.getColorRegistry();
        this.myFontNameRegistry = this.mySyntaxInfo.getFontNameRegistry();
        this.myDefaultForeground = this.myForeground = this.mySyntaxInfo.getDefaultForeground();
        this.myDefaultBackground = this.myBackground = this.mySyntaxInfo.getDefaultBackground();
        this.myItalic = false;
        this.myBold = false;
        this.myCurrentColumn = 0;
        this.myMaxLength = maxLength;
        try {
            this.buildColorMap();
            this.appendStartTags();
            this.mySyntaxInfo.processOutputInfo(this);
            this.appendCloseTags();
        }
        finally {
            this.myResultBuffer = null;
            this.myColorRegistry = null;
            this.myFontNameRegistry = null;
            this.myColors.clear();
        }
    }

    protected void appendCloseTags() {
        this.myResultBuffer.append("</pre></body></html>");
    }

    protected void appendStartTags() {
        this.myResultBuffer.append("<html><head><meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\"></head><body>").append("<pre style=\"background-color:");
        this.appendColor(this.myResultBuffer, this.myDefaultBackground);
        this.myResultBuffer.append(";color:");
        this.appendColor(this.myResultBuffer, this.myDefaultForeground);
        this.myResultBuffer.append(';');
        int[] fontIds = this.myFontNameRegistry.getAllIds();
        if (fontIds.length > 0) {
            this.myFontFamily = this.myDefaultFontFamily = fontIds[0];
            this.appendFontFamilyRule(this.myResultBuffer, this.myDefaultFontFamily);
        } else {
            this.myDefaultFontFamily = -1;
            this.myFontFamily = -1;
        }
        float fontSize = this.mySyntaxInfo.getFontSize();
        if (SystemInfo.isMac) {
            fontSize *= 0.75f;
        }
        this.myResultBuffer.append(String.format("font-size:%.1fpt;\">", Float.valueOf(fontSize)));
    }

    protected void appendFontFamilyRule(@NotNull StringBuilder styleBuffer, int fontFamilyId) {
        if (styleBuffer == null) {
            HtmlSyntaxInfoReader.$$$reportNull$$$0(2);
        }
        styleBuffer.append("font-family:'").append((String)this.myFontNameRegistry.dataById(fontFamilyId)).append("';");
    }

    private static void defineBold(@NotNull StringBuilder styleBuffer) {
        if (styleBuffer == null) {
            HtmlSyntaxInfoReader.$$$reportNull$$$0(3);
        }
        styleBuffer.append("font-weight:bold;");
    }

    private static void defineItalic(@NotNull StringBuilder styleBuffer) {
        if (styleBuffer == null) {
            HtmlSyntaxInfoReader.$$$reportNull$$$0(4);
        }
        styleBuffer.append("font-style:italic;");
    }

    private void defineForeground(int id, @NotNull StringBuilder styleBuffer) {
        if (styleBuffer == null) {
            HtmlSyntaxInfoReader.$$$reportNull$$$0(5);
        }
        styleBuffer.append("color:");
        this.appendColor(styleBuffer, id);
        styleBuffer.append(";");
    }

    protected void defineBackground(int id, @NotNull StringBuilder styleBuffer) {
        if (styleBuffer == null) {
            HtmlSyntaxInfoReader.$$$reportNull$$$0(6);
        }
        styleBuffer.append("background-color:");
        this.appendColor(styleBuffer, id);
        styleBuffer.append(";");
    }

    private void appendColor(StringBuilder builder2, int id) {
        builder2.append((String)this.myColors.get(id));
    }

    private void buildColorMap() {
        for (int id : this.myColorRegistry.getAllIds()) {
            StringBuilder b = new StringBuilder("#");
            UIUtil.appendColor((Color)((Color)this.myColorRegistry.dataById(id)), (StringBuilder)b);
            this.myColors.put(id, (Object)b.toString());
        }
    }

    @Override
    public void handleText(int startOffset, int endOffset) {
        boolean formattedText;
        boolean bl = formattedText = this.myForeground != this.myDefaultForeground || this.myBackground != this.myDefaultBackground || this.myFontFamily != this.myDefaultFontFamily || this.myBold || this.myItalic;
        if (!formattedText) {
            this.escapeAndAdd(startOffset, endOffset);
            return;
        }
        this.myResultBuffer.append("<span style=\"");
        if (this.myForeground != this.myDefaultForeground) {
            this.defineForeground(this.myForeground, this.myResultBuffer);
        }
        if (this.myBackground != this.myDefaultBackground) {
            this.defineBackground(this.myBackground, this.myResultBuffer);
        }
        if (this.myBold) {
            HtmlSyntaxInfoReader.defineBold(this.myResultBuffer);
        }
        if (this.myItalic) {
            HtmlSyntaxInfoReader.defineItalic(this.myResultBuffer);
        }
        if (this.myFontFamily != this.myDefaultFontFamily) {
            this.appendFontFamilyRule(this.myResultBuffer, this.myFontFamily);
        }
        this.myResultBuffer.append("\">");
        this.escapeAndAdd(startOffset, endOffset);
        this.myResultBuffer.append("</span>");
    }

    private void escapeAndAdd(int start2, int end) {
        for (int i = start2; i < end; ++i) {
            char c2 = this.myRawText.charAt(i);
            switch (c2) {
                case '<': {
                    this.myResultBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    this.myResultBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    this.myResultBuffer.append("&amp;");
                    break;
                }
                case ' ': {
                    this.myResultBuffer.append("&#32;");
                    break;
                }
                case '\n': {
                    this.myResultBuffer.append("<br>");
                    this.myCurrentColumn = 0;
                    break;
                }
                case '\t': {
                    int newColumn = (this.myCurrentColumn / this.myTabSize + 1) * this.myTabSize;
                    while (this.myCurrentColumn < newColumn) {
                        this.myResultBuffer.append("&#32;");
                        ++this.myCurrentColumn;
                    }
                    break;
                }
                default: {
                    this.myResultBuffer.append(c2);
                }
            }
            ++this.myCurrentColumn;
        }
    }

    @Override
    public void handleForeground(int foregroundId) throws Exception {
        this.myForeground = foregroundId;
    }

    @Override
    public void handleBackground(int backgroundId) throws Exception {
        this.myBackground = backgroundId;
    }

    @Override
    public void handleFont(int fontNameId) throws Exception {
        this.myFontFamily = fontNameId;
    }

    @Override
    public void handleStyle(int style) throws Exception {
        this.myBold = (1 & style) != 0;
        this.myItalic = (2 & style) != 0;
    }

    @Override
    public boolean canHandleMore() {
        if (this.myResultBuffer.length() > this.myMaxLength) {
            this.myResultBuffer.append("... truncated ...");
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleBuffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/richcopy/view/HtmlSyntaxInfoReader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "appendFontFamilyRule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "defineBold";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "defineItalic";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "defineForeground";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "defineBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

